#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2004 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:all);
use strict;

#
#  Write header of page for admin
#
sub print_top {

   my (@contents);

open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);
}


#
#  Write header of page for admin
#
sub print_bottom {

   my (@contents);

open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);
}

#
#  Begin of main section
#

my ($time,  $line, @tracesettings, $tcp_trace, $cfg_trace,
    $fmapi_trace, $nof_trace, $check_count, $label, $trace_none);

print header;

# output top of template page
print_top();

$time=localtime;

$ENV{LD_LIBRARY_PATH}='/opt/ibm/sna/lib:/usr/lib';
$ENV{SNATBLG}='/opt/ibm/sna/samples/luatblg.dat';
#! Get CSLINKS output
@tracesettings=`sudo -u snauser /opt/ibm/sna/bin/snaadmin query_tn_server_trace`;

print "<font face=\"Courier, Helvetica\">";
print "<br><b> Select TN3270 Trace Options: $time</b>";
print "<br><br>  Current TN3270 Trace status:<br>\n";
print "<form action= \"/cscbin/actcstn32trace.cgi\" method=\"post\">\n";

#
# display current tn3270 trace options
#
$check_count = 0;
foreach $line (@tracesettings) {
   next if $line=~m/^-------/;       # skip border
   if ($line=~m/^trace_flags/) {     # start reading traces
        print $line."<br>\n";
        if ($line=~m/ NONE/) {  #  If trace is off, mark it and go to next line
            $trace_none = 1;
            next;
        }
  #  Test for each flag on line
        if ($line=~m/ TCP/) {
           $tcp_trace = 1;
           $check_count++;
        } # TCP msg trace
        if ($line=~m/ CFG/) {
           $cfg_trace = 1;
           $check_count++;
        } # Config trace
        if ($line=~m/ FMAPI/) {
           $fmapi_trace = 1;
           $check_count++;
        } # FMAPI trace
        if ($line=~m/ NOF/) {
           $nof_trace = 1;
           $check_count++;
        } # NOF trace
        next;
   }
}
#  Print seperator line
print " <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\">\n";
print "<td colspan=\"2\" width=\"100%\">\n";
print "<hr size=\"1\" align=\"left\" width=\"100%\" color=\"#000000\" noshade=\"noshade\">\n";
print "</td></table> <table>\n";
#
#   Process lines read for action to set up
#

if ($trace_none) {  # Set ALL flag and skip rest
   print "<table><tr><td> Select <b>ALL</b> to turn on all trace flags: ";
   print "<b>ALL </b><input type=\"checkbox\" name=\"traceopt\" value=\"all\"/>";
} elsif ($check_count == 4) {  # ALL flag is set
   print "<table><tr><td> Select <b>NONE</b> to turn off trace flags: ";
   print "<b>NONE</b><input type=\"checkbox\" name=\"traceopt\" value=\"none\"/>";
} else {
   print "<table><tr><td> Select <b>NONE</b> to turn off traces, <b>ALL</b> to enable all traces:<br>";
   print "<b> NONE </b><input type=\"radio\" name=\"traceopt\" value=\"none\"/>";
   print "<b> ALL </b><input type=\"radio\" name=\"traceopt\" value=\"all\"/>";
}
print "<br><br><b> -OR- </b> \"check\" specific TN3270 trace flags to enable:&nbsp;&nbsp;&nbsp;&nbsp;<br>";
print "</td></tr>";

# Print check boxes
print "<table><tr><td><br>     ";
#  set Node checkbox
print "<b>TCP</b><input type=\"checkbox\" name=\"tcp\" value=\"yes\"";
if ($tcp_trace) { print " checked />"; }
else {print " />"; }
#  set CFG checkbox
print "<b>  CFG</b><input type=\"checkbox\" name=\"cfg\" value=\"yes\"";
if ($cfg_trace) { print " checked />"; }
else {print " />"; }
#  set FMAPI checkbox
print "<b>  FMAPI</b><input type=\"checkbox\" name=\"fmapi\" value=\"yes\"";
if ($fmapi_trace) { print " checked />"; }
else {print " />"; }
#  set NOF checkbox
print "<b>  NOF</b><input type=\"checkbox\" name=\"nof\" value=\"yes\"";
if ($nof_trace) { print " checked />"; }
else {print " />"; }
#
#
print "</td></tr></tbody></table></table>";
print "<br>";

print "<input type=\"submit\" name=\"action\" value=\"Submit\"/>";
print "   <input type=\"reset\" name=\"reset\" value=\"Reset\"/>";

print "</p></form></font>";

#   output the bottom of the template
print_bottom();
