#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2004 All rights reserved. #
#                                                     #
#######################################################
use CGI qw(:standard);
use strict;

my ($arg, $action, $puname, $time, @result, $line, @contents);

print header('text/html');
open (SOURCE,"../cscdoc/CSLTMPL1.HTM") or die "Cannot open CS LINUX web template 1 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

$time=localtime;

print "<b> Communication Server Web Admin Manage PU Results: $time</b>";
print "<font face=\"Courier, Helvetica\">";
print "<p>\n";

if (! param) {
     print "Invalid invocation of PU management!";
} else {
     $arg=param('pulist');
     ($action,$puname) = (split(/_/,$arg) )[0,1];
     print"<br> Action: $action, PU Name: $puname<br>";
     if ($action=~m/^start/) {
        @result=`sudo -u snauser /opt/ibm/sna/bin/snaadmin start_internal_pu,pu_name=$puname `
     } elsif ($action=~m/^stop/) {
         @result=`sudo -u snauser /opt/ibm/sna/bin/snaadmin stop_internal_pu,pu_name=$puname `
     } else {
         print " Invalid action on PU management!";
         exit 1;
     }       
}
print "<b>";
foreach(@result) {
   chomp;
   next if (/^------/);
   print $_; 
}
print "</b><br>";
print "<br><b> PU Status: </b><br>";

@contents=`../cscbin/dpustat.pl`;     # Command to get PU status

foreach $line (@contents) {
   $line=~s/ /&nbsp;/g;
   print "<br>$line";
}

print "</font></p>";
open (SOURCE,"../cscdoc/CSLTMPL2.HTM") or die "Cannot open CS Linux web template 2 $!\n";
@contents=<SOURCE>;
print @contents;
close (SOURCE);

exit 0; 

