#!/usr/bin/perl -w
#######################################################
#                                                     #
# Copyright IBM Corporation 2004 All rights reserved. #
#                                                     #
#######################################################

#  Purpose of the script is to call snaadmin query_rtp_connections and display
#  in a terse format the information.


use strict;

 my ( $rtpname, $lsname, $nodename, $conntype, $cosname,
      $localtcid, $remotetcid, $route, $numsessions, @data, @status );

#  Initialize for scalar declaration
$rtpname = " ";

if ($#ARGV < 0)    # Check for input argument on line
{
  @status=`sudo -u snauser /opt/ibm/sna/bin/snaadmin -d query_rtp_connection`;             # Get detailed Link Station information
} else {
  @status=`sudo -u snauser /opt/ibm/sna/bin/snaadmin -n $ARGV[0] -d query_rtp_connection` or die "Node $ARGV[0] not recognized $!\n";
}

#   Print header line


print "RTP Name   Link     Partner Node     Conn. Type   CoS Name #Ses    Local TCID          Remote TCID      Route \n";
print "======== ======== ================= ============= ======== ==== ================   ================  ========== \n";


foreach(@status) {
   chomp;
   if (/^query_rtp_connection/) {
     print " Cannot process node $ARGV[0]\n";
     exit -1;
   }

  #  Skip headers
   next if (/^------/);
   next if (/^list_option/);

   next if (/^\n/);

   @data = split(/=/,$_);   #Break NAU, LU, Type, Status

   next if (@data == 0);        # on blank line, skip

# debug   print "line: $line:", @data;

   if ($data[0]=~m/^rtp_name/) {       # get rtp connection name
     $rtpname = $data[1];
     $rtpname=~s/ //g;
     next;
   } elsif ($data[0]=~m/^first_hop_ls_name/) {  # link name
     $lsname = $data[1];
     $lsname=~s/ //g;
     next;
   } elsif ($data[0]=~m/^dest_node_name/) { # partner node
     $nodename = $data[1];
     $nodename=~s/ //g;
     next;
   } elsif ($data[0]=~m/^connection_type/) { # type of session
     $conntype = $data[1];
     $conntype=~s/ //g;
     next;
   } elsif ($data[0]=~m/^cos_name/) { # Cost of service
     $cosname = $data[1];
     $cosname=~s/ //g;
     next;
   } elsif ($data[0]=~m/^num_sess_active/) { # active session count
     $numsessions = $data[1];
     $numsessions=~s/ //g;
     next;
   } elsif ($data[0]=~m/^local_tcid/) { # TCID local
     $data[1]=~s/</{/g;     # convert less-then because html fails
     $data[1]=~s/>/}/g;     # convert gtr-then because html fails
     $localtcid = $data[1];
     $localtcid=~s/ //g;
     next;
   } elsif ($data[0]=~m/^remote_tcid/) { # TCID remote
     $data[1]=~s/</{/g;     # convert less-then because html fails
     $data[1]=~s/>/}/g;     # convert gtr-then because html fails
     $remotetcid = $data[1];
     $remotetcid=~s/ //g;
     next;
   } elsif ($data[0]=~m/^route/) { # ANR Route
     $route = $data[1];
     $route=~s/ //g;
     printf("%8s %8s %17s %13s %8s %3d %s %s %s \n\n",
               $rtpname, $lsname, $nodename, $conntype, $cosname,
               $numsessions, $localtcid, $remotetcid, $route);
   }
}
print "\n------------------------------------------------\n";

