/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs;

import java.io.IOException;
import java.security.IdentityScope;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.ParsingException;
import sun.security.util.BigInt;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X500Name;
import sun.security.x509.X509Cert;

public class SignerInfo {
    BigInt version;
    X500Name issuerName;
    BigInt certificateSerialNumber;
    AlgorithmId digestAlgorithmId;
    AlgorithmId digestEncryptionAlgorithmId;
    byte[] encryptedDigest;

    public SignerInfo(X500Name x500Name, BigInt bigInt, AlgorithmId algorithmId, AlgorithmId algorithmId2, byte[] byArray) {
        this.version = new BigInt(1);
        this.issuerName = x500Name;
        this.certificateSerialNumber = bigInt;
        this.digestAlgorithmId = algorithmId;
        this.digestEncryptionAlgorithmId = algorithmId2;
        this.encryptedDigest = byArray;
    }

    public SignerInfo(DerInputStream derInputStream) throws IOException, ParsingException {
        this.version = derInputStream.getInteger();
        DerValue[] derValueArray = derInputStream.getSequence(2);
        byte[] byArray = derValueArray[0].toByteArray();
        this.issuerName = new X500Name(new DerValue(48, byArray));
        this.certificateSerialNumber = derValueArray[1].getInteger();
        DerValue derValue = derInputStream.getDerValue();
        this.digestAlgorithmId = AlgorithmId.parse(derValue);
        derInputStream.getSet(0);
        derValue = derInputStream.getDerValue();
        this.digestEncryptionAlgorithmId = AlgorithmId.parse(derValue);
        this.encryptedDigest = derInputStream.getOctetString();
        derInputStream.getSet(0);
        if (derInputStream.available() != 0) {
            throw new ParsingException("extra data at the end");
        }
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(this.version);
        DerOutputStream derOutputStream3 = new DerOutputStream();
        this.issuerName.emit(derOutputStream3);
        derOutputStream3.putInteger(this.certificateSerialNumber);
        derOutputStream2.write((byte)48, derOutputStream3);
        this.digestAlgorithmId.encode(derOutputStream2);
        DerOutputStream derOutputStream4 = new DerOutputStream();
        derOutputStream2.write((byte)49, derOutputStream4);
        this.digestEncryptionAlgorithmId.encode(derOutputStream2);
        derOutputStream2.putOctetString(this.encryptedDigest);
        derOutputStream2.write((byte)49, derOutputStream4);
        derOutputStream.write((byte)48, derOutputStream2);
    }

    public X509Cert getCertificate(PKCS7 pKCS7) {
        return pKCS7.getCertificate(this.certificateSerialNumber, this.issuerName);
    }

    SignerInfo verify(PKCS7 pKCS7, byte[] byArray) throws NoSuchAlgorithmException, SignatureException {
        IdentityScope.getSystemScope();
        try {
            Object object;
            if (byArray == null) {
                object = pKCS7.getContentInfo();
                byArray = ((ContentInfo)object).getContentBytes();
            }
            object = this.getDigestEncryptionAlgorithmId().getName();
            Signature signature = Signature.getInstance((String)object);
            X509Cert x509Cert = this.getCertificate(pKCS7);
            if (x509Cert == null) {
                throw new SignatureException("No cert for " + this.issuerName);
            }
            PublicKey publicKey = x509Cert.getPublicKey();
            signature.initVerify(publicKey);
            signature.update(byArray);
            if (signature.verify(this.encryptedDigest)) {
                return this;
            }
        }
        catch (IOException iOException) {
            throw new SignatureException("IO error verifying signature:\n" + iOException.getMessage());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SignatureException("InvalidKey: " + invalidKeyException.getMessage());
        }
        return null;
    }

    SignerInfo verify(PKCS7 pKCS7) throws NoSuchAlgorithmException, SignatureException {
        return this.verify(pKCS7, null);
    }

    public BigInt getVersion() {
        return this.version;
    }

    public X500Name getIssuerName() {
        return this.issuerName;
    }

    public BigInt getCertificateSerialNumber() {
        return this.certificateSerialNumber;
    }

    public AlgorithmId getDigestAlgorithmId() {
        return this.digestAlgorithmId;
    }

    public AlgorithmId getDigestEncryptionAlgorithmId() {
        return this.digestEncryptionAlgorithmId;
    }

    public byte[] getEncryptedDigest() {
        return this.encryptedDigest;
    }

    public String toString() {
        String string = "";
        string = String.valueOf(string) + "Signer Info for (issuer): " + this.issuerName + "\n";
        string = String.valueOf(string) + "\tversion: " + this.version + "\n";
        string = String.valueOf(string) + "\tcertificateSerialNumber: " + this.certificateSerialNumber + "\n";
        string = String.valueOf(string) + "\tdigestAlgorithmId: " + this.digestAlgorithmId + "\n";
        string = String.valueOf(string) + "\tdigestEncryptionAlgorithmId: " + this.digestEncryptionAlgorithmId + "\n";
        string = String.valueOf(string) + "\tencryptedDigest: " + this.encryptedDigest + "\n";
        return string;
    }
}

