/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.rmi.dgc.DGC;
import java.rmi.dgc.Lease;
import java.rmi.dgc.VMID;
import java.rmi.server.LogStream;
import java.rmi.server.ObjID;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import sun.rmi.transport.DGCImpl;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.LiveRef;
import sun.rmi.transport.LocateDGC;
import sun.rmi.transport.RMIThread;
import sun.rmi.transport.Utils;

final class DGCClient
implements Runnable {
    private static final long leaseValue = DGCClient.getLong("java.rmi.dgc.leaseValue", 600000L);
    private static VMID vmid = VMID.isUnique() ? new VMID() : null;
    private static long nextSequenceNum = Long.MIN_VALUE;
    EndpointEntry my_entry;

    private static long getLong(String string, long l) {
        return Utils.getLong(string, l);
    }

    private DGCClient() {
    }

    private DGCClient(EndpointEntry endpointEntry) {
        this.my_entry = endpointEntry;
    }

    static void referenced(LiveRef[] liveRefArray) throws RemoteException {
        Endpoint endpoint = liveRefArray[0].getEndpoint();
        EndpointEntry endpointEntry = EndpointEntry.lookup(endpoint);
        Object object = endpointEntry.lock;
        synchronized (object) {
            Object object2;
            Object object3;
            Hashtable hashtable = endpointEntry.countTable;
            if (DGCImpl.logLevel >= 20) {
                LogStream.log("dgc").println("DGCClient.referenced:endpoint =" + endpoint);
            }
            if (endpointEntry.leaseEntry == null) {
                endpointEntry.leaseEntry = new LeaseTableEntry(endpoint);
                if (DGCImpl.logLevel >= 20) {
                    LogStream.log("dgc").println("DGCClient.referenced: added Endpoint =" + endpoint + "to the leaseTable" + "LeaseTableEntry =" + endpointEntry.leaseEntry);
                }
                if (endpointEntry.leasee == null) {
                    endpointEntry.leasee = RMIThread.newThread(new LeaseRenewer(endpointEntry), "LeaseRenewer: " + endpointEntry.ep.toString(), true);
                    endpointEntry.leasee.start();
                }
                if (endpointEntry.cleaner == null) {
                    endpointEntry.cleaner = RMIThread.newThread(new DGCClient(endpointEntry), "Cleaner: " + endpointEntry.ep.toString(), true);
                    endpointEntry.cleaner.start();
                }
            }
            LeaseTableEntry leaseTableEntry = endpointEntry.leaseEntry;
            if (DGCImpl.logLevel >= 20) {
                LogStream.log("dgc").println("DGCClient.referenced: leaseTableEntry" + leaseTableEntry);
            }
            Vector vector = new Vector();
            int n = 0;
            while (n < liveRefArray.length) {
                ObjID objID;
                object3 = (CountTableEntry)hashtable.get(liveRefArray[n]);
                if (object3 == null) {
                    object2 = liveRefArray[n].copy();
                    objID = ((LiveRef)object2).getObjID();
                    object3 = new CountTableEntry();
                    hashtable.put(object2, object3);
                    if (DGCImpl.logLevel >= 20) {
                        LogStream.log("dgc").println("DGCClient.referenced:  Added LiveRef = " + liveRefArray[n] + "ObjID = " + objID + " to the countTable. " + "CountTableEntry = " + object3);
                    }
                } else {
                    objID = liveRefArray[n].getObjID();
                }
                if (!leaseTableEntry.objIdList.contains(objID)) {
                    leaseTableEntry.objIdList.addElement(objID);
                    vector.addElement(liveRefArray[n]);
                    if (DGCImpl.logLevel >= 20) {
                        LogStream.log("dgc").println("DGCClient.referenced: added ref = " + liveRefArray[n] + " to the dirtyRefList" + " and added ObjID = " + objID + " to objIdList");
                    }
                }
                liveRefArray[n].counted();
                ++object3.refCount;
                if (DGCImpl.logLevel >= 20) {
                    LogStream.log("dgc").println("DGCClient.referenced: leaseTableEntry" + leaseTableEntry);
                }
                ++n;
            }
            if (vector.isEmpty()) {
                if (DGCImpl.logLevel >= 20) {
                    LogStream.log("dgc").println("DGCClient.referenced: No dirty calls necessary -- returning.");
                }
                Object var4_11 = null;
                return;
            }
            object3 = DGCClient.getObjIdArray(vector);
            object2 = null;
            try {
                object2 = LocateDGC.getDGC(endpoint);
            }
            catch (RemoteException remoteException) {}
            try {
                if (DGCImpl.logLevel >= 20) {
                    LogStream.log("dgc").println("DGCClient.referenced: making dirty call...");
                }
                Lease lease = object2.dirty((ObjID[])object3, DGCClient.getNextSequenceNum(), new Lease(vmid, leaseValue));
                long l = System.currentTimeMillis();
                vmid = lease.getVMID();
                if (DGCImpl.logLevel >= 20) {
                    LogStream.log("dgc").println("DGCClient.referenced: New lease -- vmid = " + lease.getVMID() + "duration = " + lease.getValue());
                }
                DGCClient.setUpLeasing(endpointEntry, leaseTableEntry, l, lease);
            }
            catch (RemoteException remoteException) {
                if (DGCImpl.logLevel >= 10) {
                    LogStream.log("dgc").println("DGCClient.referenced: dirty call failed");
                }
                throw remoteException;
            }
            return;
        }
    }

    private static void setUpLeasing(EndpointEntry endpointEntry, LeaseTableEntry leaseTableEntry, long l, Lease lease) {
        long l2 = leaseTableEntry.renewTime == 0L ? 0L : leaseTableEntry.lease.getValue();
        long l3 = lease.getValue();
        long l4 = l + DGCClient.getRenewTime(l3);
        leaseTableEntry.lease = lease;
        if (DGCImpl.logLevel >= 20) {
            LogStream.log("dgc").println("DGCClient.setUpLeasing: old lease length = " + l2 + " new lease length = " + l3 + " current time = " + l);
        }
        if (l3 < l2 || leaseTableEntry.renewTime == 0L) {
            leaseTableEntry.renewTime = l4;
            endpointEntry.leaseTableModified = true;
            endpointEntry.lock.notifyAll();
            if (DGCImpl.logLevel >= 20) {
                LogStream.log("dgc").println("DGCClient.setUpLeasing: notifyAll called on leasing thread.");
                return;
            }
        } else {
            leaseTableEntry.renewTime = l4;
        }
    }

    private static long getRenewTime(long l) {
        return (long)(0.5 * (double)l);
    }

    static void referenced(LiveRef liveRef) throws RemoteException {
        LiveRef[] liveRefArray = new LiveRef[]{liveRef};
        DGCClient.referenced(liveRefArray);
    }

    private static void cleanUpCountTable(EndpointEntry endpointEntry, Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            endpointEntry.countTable.remove((LiveRef)vector.elementAt(n));
            ++n;
        }
    }

    static void unreferenced(LiveRef liveRef) {
        Endpoint endpoint = liveRef.getEndpoint();
        EndpointEntry endpointEntry = EndpointEntry.lookup(endpoint);
        Vector vector = endpointEntry.unrefList;
        synchronized (vector) {
            endpointEntry.unrefList.addElement(liveRef);
            endpointEntry.unrefList.notifyAll();
            return;
        }
    }

    private static synchronized long getNextSequenceNum() {
        return nextSequenceNum++;
    }

    private static void handleDecrements(EndpointEntry endpointEntry) {
        int n;
        int n2 = 128;
        Object object = null;
        Object[] objectArray = new LiveRef[n2];
        int n3 = 0;
        Object object2 = endpointEntry.unrefList;
        synchronized (object2) {
            n3 = endpointEntry.unrefList.size();
            if (n3 == 0) {
                Object var6_6 = null;
                return;
            }
            if (n3 <= n2) {
                endpointEntry.unrefList.copyInto(objectArray);
                endpointEntry.unrefList.removeAllElements();
            } else {
                n3 = n2;
                n = 0;
                n = 0;
                while (n < n2) {
                    objectArray[n] = (LiveRef)endpointEntry.unrefList.elementAt(n);
                    ++n;
                }
                n = 0;
                while (n < n2) {
                    endpointEntry.unrefList.removeElementAt(0);
                    ++n;
                }
            }
        }
        object2 = endpointEntry.lock;
        synchronized (object2) {
            n = 0;
            while (n < n3) {
                object = objectArray[n];
                CountTableEntry countTableEntry = (CountTableEntry)endpointEntry.countTable.get(object);
                if (countTableEntry != null) {
                    Endpoint endpoint = ((LiveRef)object).getEndpoint();
                    ObjID objID = ((LiveRef)object).getObjID();
                    --countTableEntry.refCount;
                    if (countTableEntry.refCount == 0) {
                        LeaseTableEntry leaseTableEntry;
                        if (DGCImpl.logLevel >= 20) {
                            LogStream.log("dgc").println("DGCClient.handleDecrements: ObjID = " + ((LiveRef)object).getObjID() + " refCount == 0");
                        }
                        if ((leaseTableEntry = endpointEntry.leaseEntry) != null) {
                            leaseTableEntry.objIdList.removeElement(objID);
                            if (leaseTableEntry.objIdList.isEmpty()) {
                                endpointEntry.leaseEntry = null;
                                endpointEntry.leaseTableModified = true;
                                if (DGCImpl.logLevel >= 20) {
                                    LogStream.log("dgc").println("DGCClient.handleDecrement: Removing ep = " + endpoint + " from the leaseTable.");
                                }
                            }
                        }
                        DGCClient.scheduleClean((LiveRef)object, false);
                        endpointEntry.countTable.remove(object);
                    }
                }
                ++n;
            }
            return;
        }
    }

    private static void scheduleClean(ObjID[] objIDArray, Endpoint endpoint, boolean bl) {
        long l = DGCClient.getNextSequenceNum();
        if (objIDArray == null) {
            return;
        }
        EndpointEntry endpointEntry = EndpointEntry.lookup(endpoint);
        CleanRequest cleanRequest = endpointEntry.cleanRequest;
        if (cleanRequest == null) {
            cleanRequest = new CleanRequest(objIDArray, endpoint, l, bl);
            endpointEntry.cleanRequest = cleanRequest;
            return;
        }
        cleanRequest.objIdArray = DGCClient.mergeObjIdArrays(cleanRequest.objIdArray, objIDArray);
        cleanRequest.strong = bl;
    }

    private static ObjID[] mergeObjIdArrays(ObjID[] objIDArray, ObjID[] objIDArray2) {
        ObjID[] objIDArray3;
        if (objIDArray.length == 0 && objIDArray2.length == 0) {
            objIDArray3 = null;
        } else if (objIDArray.length == 0) {
            objIDArray3 = objIDArray2;
        } else if (objIDArray2.length == 0) {
            objIDArray3 = objIDArray;
        } else {
            int n = objIDArray.length + objIDArray2.length;
            objIDArray3 = new ObjID[n];
            System.arraycopy(objIDArray, 0, objIDArray3, 0, objIDArray.length);
            System.arraycopy(objIDArray2, 0, objIDArray3, objIDArray.length, objIDArray2.length);
        }
        return objIDArray3;
    }

    private static void scheduleClean(LiveRef liveRef, boolean bl) {
        Endpoint endpoint = liveRef.getEndpoint();
        ObjID objID = liveRef.getObjID();
        ObjID[] objIDArray = new ObjID[]{objID};
        DGCClient.scheduleClean(objIDArray, endpoint, bl);
    }

    private static void sendCleans(EndpointEntry endpointEntry) {
        try {
            CleanRequest cleanRequest = endpointEntry.cleanRequest;
            if (cleanRequest == null) {
                return;
            }
            Endpoint endpoint = cleanRequest.ep;
            DGC dGC = null;
            try {
                dGC = LocateDGC.getDGC(endpoint);
            }
            catch (RemoteException remoteException) {}
            try {
                if (vmid != null) {
                    if (DGCImpl.logLevel >= 20) {
                        LogStream.log("dgc").println("DGCClient.sendCleans: making " + cleanRequest.objIdArray.length + " clean call(s) for Endpoint = " + endpoint);
                        int n = 0;
                        while (n < cleanRequest.objIdArray.length) {
                            LogStream.log("dgc").println("\tObjID = " + cleanRequest.objIdArray[n]);
                            ++n;
                        }
                    }
                    dGC.clean(cleanRequest.objIdArray, cleanRequest.sequenceNum, vmid, cleanRequest.strong);
                    endpointEntry.cleanRequest = null;
                    return;
                }
            }
            catch (ConnectException connectException) {
                endpointEntry.cleanRequest = null;
                return;
            }
            catch (RemoteException remoteException) {
                if (DGCImpl.logLevel >= 20) {
                    LogStream.log("dgc").println("DGCClient.sendCleans: clean call failed");
                    return;
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {}
    }

    public void run() {
        boolean bl = true;
        do {
            long l = DGCClient.getLong("sun.rmi.transport.cleanInterval", 180000L);
            System.runFinalization();
            Object object = this.my_entry.unrefList;
            synchronized (object) {
                if (this.my_entry.unrefList.isEmpty()) {
                    try {
                        this.my_entry.unrefList.wait(l);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            DGCClient.handleDecrements(this.my_entry);
            DGCClient.sendCleans(this.my_entry);
            object = this.my_entry.lock;
            synchronized (object) {
                if (this.my_entry.countTable.isEmpty()) {
                    bl = false;
                    EndpointEntry.remove(this.my_entry);
                }
            }
        } while (bl);
        this.my_entry.cleaner = null;
        EndpointEntry.remove(this.my_entry);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean doRenewal(EndpointEntry endpointEntry) {
        LeaseTableEntry leaseTableEntry = null;
        boolean bl = true;
        Object object = endpointEntry.lock;
        synchronized (object) {
            do {
                if ((leaseTableEntry = endpointEntry.leaseEntry) == null) {
                    endpointEntry.leasee = null;
                    return false;
                }
                if (DGCImpl.logLevel >= 10) {
                    LogStream.log("dgc").println("DGCClient.doRenewal: next lease to renew has Endpoint = " + leaseTableEntry.ep + "renewTime = " + leaseTableEntry.renewTime);
                }
                while (true) {
                    long l = System.currentTimeMillis();
                    long l2 = leaseTableEntry.renewTime - l;
                    long l3 = l + l2;
                    if (l2 > 0L) {
                        if (DGCImpl.logLevel >= 10) {
                            LogStream.log("dgc").println("DGCClient.doRenewal:  Waiting for " + l2 + "milliseconds");
                        }
                        try {
                            endpointEntry.lock.wait(l2);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    l = System.currentTimeMillis();
                    if (endpointEntry.leaseTableModified) {
                        leaseTableEntry = endpointEntry.leaseEntry;
                        endpointEntry.leaseTableModified = false;
                        if (leaseTableEntry == null) {
                            endpointEntry.leasee = null;
                            return false;
                        }
                        if (DGCImpl.logLevel < 10) continue;
                        LogStream.log("dgc").println("DGCClient.doRenewal: next lease to renew has Endpoint = " + leaseTableEntry.ep + "renewTime = " + leaseTableEntry.renewTime);
                        continue;
                    }
                    if (l >= l3) break;
                }
                if (leaseTableEntry == null) continue;
                bl = DGCClient.renewLeases(endpointEntry, leaseTableEntry);
            } while (bl);
            return bl;
        }
    }

    /*
     * Unable to fully structure code
     */
    static boolean renewLeases(EndpointEntry var0, LeaseTableEntry var1_1) {
        block15: {
            var2_2 = var1_1.ep;
            var3_3 = null;
            var4_4 = null;
            var5_5 = 0;
            try {
                try {
                    var3_3 = LocateDGC.getDGC(var2_2);
                }
                catch (RemoteException v0) {}
                if (var1_1 == null) {
                    Thread.currentThread().getName();
                }
                var6_6 = var1_1.objIdList;
                synchronized (var6_6) {
                    var5_5 = var1_1.objIdList.size();
                    var4_4 = new ObjID[var5_5];
                    var1_1.objIdList.copyInto(var4_4);
                }
                if (DGCImpl.logLevel >= 10) {
                    LogStream.log("dgc").println("DGCClient.renewLeases: Renewing " + var5_5 + " leases for Endpoint = " + var2_2);
                }
                var6_6 = var3_3.dirty((ObjID[])var4_4, DGCClient.getNextSequenceNum(), new Lease(DGCClient.vmid, DGCClient.leaseValue));
                DGCClient.vmid = var6_6.getVMID();
                var7_8 = System.currentTimeMillis();
                if (DGCImpl.logLevel >= 20) {
                    LogStream.log("dgc").println("DGCClient.renew:eases: New lease -- vmid = " + var6_6.getVMID() + "duration = " + var6_6.getValue());
                    LogStream.log("dgc").println("DGCClient.renewLeases: *Renewed the leases for the following ObjID's*");
                    var9_10 = 0;
                    while (var9_10 < var5_5) {
                        LogStream.log("dgc").println("DGCClient.renewLeases: ObjID #" + var9_10 + " = " + var4_4[var9_10]);
                        ++var9_10;
                    }
                }
                DGCClient.setUpLeasing(var0, var1_1, var7_8, (Lease)var6_6);
                break block15;
            }
            catch (RemoteException v2) {
                EndpointEntry.access$3(var0, null);
                var6_7 = EndpointEntry.access$1(var0).keys();
                var7_9 = new Vector();
                ** while (var6_7.hasMoreElements())
            }
lbl-1000:
            // 1 sources

            {
                var8_12 = 0;
                while (var8_12 < var5_5) {
                    var9_11 = (LiveRef)var6_7.nextElement();
                    if (var4_4[var8_12] == var9_11.getObjID()) {
                        var7_9.addElement(var9_11);
                    }
                    ++var8_12;
                }
                continue;
            }
lbl50:
            // 1 sources

            DGCClient.cleanUpCountTable(var0, var7_9);
        }
        if (EndpointEntry.access$2(var0) == null) {
            EndpointEntry.access$6(var0, null);
            return false;
        }
        return true;
    }

    private static ObjID[] getObjIdArray(Vector vector) {
        ObjID[] objIDArray = null;
        objIDArray = new ObjID[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            objIDArray[n] = ((LiveRef)vector.elementAt(n)).getObjID();
            ++n;
        }
        return objIDArray;
    }

    private static class EndpointEntry {
        private Endpoint ep;
        private Hashtable countTable;
        private LeaseTableEntry leaseEntry;
        private CleanRequest cleanRequest;
        private Object lock;
        private Vector unrefList;
        private boolean leaseTableModified = false;
        private Thread cleaner;
        private Thread leasee;
        private static Hashtable endpointTable = new Hashtable();

        EndpointEntry(Endpoint endpoint) {
            this.ep = endpoint;
            this.countTable = new Hashtable();
            this.lock = new Object();
            this.unrefList = new Vector();
        }

        public static EndpointEntry lookup(Endpoint endpoint) {
            Hashtable hashtable = endpointTable;
            synchronized (hashtable) {
                EndpointEntry endpointEntry = (EndpointEntry)endpointTable.get(endpoint);
                if (endpointEntry == null) {
                    endpointEntry = new EndpointEntry(endpoint);
                    endpointTable.put(endpoint, endpointEntry);
                }
                EndpointEntry endpointEntry2 = endpointEntry;
                Object var3_4 = null;
                return endpointEntry2;
            }
        }

        public static void remove(EndpointEntry endpointEntry) {
            Hashtable hashtable = endpointTable;
            synchronized (hashtable) {
                endpointTable.remove(endpointEntry.ep);
                return;
            }
        }
    }

    private static final class CountTableEntry {
        int refCount;

        CountTableEntry() {
        }
    }

    private static final class CleanRequest {
        ObjID[] objIdArray;
        Endpoint ep;
        long sequenceNum;
        boolean strong;

        public CleanRequest(LiveRef liveRef, long l, boolean bl) {
            this.ep = liveRef.getEndpoint();
            this.strong = bl;
            this.sequenceNum = l;
            ObjID[] objIDArray = new ObjID[]{liveRef.getObjID()};
            this.objIdArray = objIDArray;
        }

        public CleanRequest(ObjID[] objIDArray, Endpoint endpoint, long l, boolean bl) {
            this.sequenceNum = l;
            this.objIdArray = objIDArray;
            this.strong = bl;
            this.ep = endpoint;
        }

        public boolean equals(Object object) {
            if (object != null && object instanceof CleanRequest) {
                CleanRequest cleanRequest = (CleanRequest)object;
                if (cleanRequest.objIdArray.length != this.objIdArray.length) {
                    return false;
                }
                if (this.sequenceNum != cleanRequest.sequenceNum || this.strong != cleanRequest.strong || !cleanRequest.ep.equals(this.ep)) {
                    return false;
                }
                int n = 0;
                while (n < this.objIdArray.length) {
                    if (!this.objIdArray[n].equals(cleanRequest.objIdArray[n])) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }
            return false;
        }
    }

    private static final class LeaseTableEntry {
        public long renewTime;
        public Endpoint ep;
        public Vector objIdList = new Vector();
        public Lease lease;

        public LeaseTableEntry(Endpoint endpoint) {
            this.ep = endpoint;
        }
    }

    private static class LeaseRenewer
    implements Runnable {
        private EndpointEntry my_entry;

        LeaseRenewer(EndpointEntry endpointEntry) {
            this.my_entry = endpointEntry;
        }

        public void run() {
            boolean bl;
            if (DGCImpl.logLevel >= 10) {
                LogStream.log("dgc").println("LeaseRenewer.run: Lease renewing thread starting up.");
            }
            while (bl = DGCClient.doRenewal(this.my_entry)) {
            }
            this.my_entry.leasee = null;
        }
    }
}

