/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.peer.FontPeer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import sun.awt.CharsetString;
import sun.awt.FontDescriptor;
import sun.io.CharToByteConverter;
import sun.io.CharacterEncoding;

public abstract class PlatformFont
implements FontPeer {
    protected FontDescriptor[] componentFonts;
    protected char defaultChar;
    protected Properties props;
    protected FontDescriptor defaultFont;
    protected static Hashtable charsetRegistry = new Hashtable(5);
    protected String aliasName;
    protected String styleString;
    private static Properties fprops;

    public PlatformFont(String string, int n) {
        int n2;
        if (fprops == null) {
            this.props = null;
            return;
        }
        this.props = fprops;
        this.aliasName = this.props.getProperty("alias." + string.toLowerCase());
        if (this.aliasName == null) {
            this.aliasName = string.toLowerCase();
        }
        if (this.props.getProperty(String.valueOf(this.aliasName) + ".0") == null && this.props.getProperty(String.valueOf(this.aliasName) + ".plain.0") == null) {
            this.aliasName = "sansserif";
        }
        this.styleString = PlatformFont.styleStr(n);
        Vector vector = new Vector(5);
        int n3 = 0;
        while (true) {
            int[] nArray;
            String string2 = String.valueOf(n3);
            String string3 = this.props.getProperty(String.valueOf(this.aliasName) + "." + this.styleString + "." + string2);
            if (string3 == null && (string3 = this.props.getProperty(String.valueOf(this.aliasName) + "." + string2)) == null) break;
            String string4 = this.props.getProperty("fontcharset." + this.aliasName + "." + this.styleString + "." + string2);
            if (string4 == null && (string4 = this.props.getProperty("fontcharset." + this.aliasName + "." + string2)) == null) {
                string4 = "default";
            }
            CharToByteConverter charToByteConverter = this.getFontCharset(string4.trim(), string3);
            String string5 = this.props.getProperty("exclusion." + this.aliasName + "." + this.styleString + "." + string2);
            if (string5 == null && (string5 = this.props.getProperty("exclusion." + this.aliasName + "." + string2)) == null) {
                string5 = "none";
            }
            if (string5.equals("none")) {
                nArray = new int[]{};
            } else {
                int n4 = 1;
                int n5 = 0;
                while ((n5 = string5.indexOf(44, n5)) != -1) {
                    ++n5;
                    ++n4;
                }
                nArray = new int[n4];
                int n6 = 0;
                while (n6 < n4) {
                    String string6;
                    String string7;
                    int n7 = 0;
                    int n8 = 0;
                    try {
                        string7 = string5.substring(n6 * 10, n6 * 10 + 4);
                        string6 = string5.substring(n6 * 10 + 5, n6 * 10 + 9);
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        nArray = new int[]{};
                        break;
                    }
                    try {
                        n7 = Integer.parseInt(string7, 16);
                        n8 = Integer.parseInt(string6, 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        nArray = new int[]{};
                        break;
                    }
                    nArray[n6] = n7 << 16 | n8;
                    ++n6;
                }
            }
            vector.addElement(new FontDescriptor(string3, charToByteConverter, nArray));
            ++n3;
        }
        this.componentFonts = new FontDescriptor[n3];
        int n9 = 0;
        while (n9 < n3) {
            this.componentFonts[n9] = (FontDescriptor)vector.elementAt(n9);
            ++n9;
        }
        try {
            n2 = Integer.parseInt(this.props.getProperty("default.char", "003f"), 16);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = 63;
        }
        this.defaultChar = (char)63;
        if (this.componentFonts.length > 0) {
            this.defaultFont = this.componentFonts[0];
        }
        int n10 = 0;
        while (n10 < this.componentFonts.length) {
            if (!this.componentFonts[n10].isExcluded((char)n2) && this.componentFonts[n10].fontCharset.canConvert((char)n2)) {
                this.defaultFont = this.componentFonts[n10];
                this.defaultChar = (char)n2;
                return;
            }
            ++n10;
        }
    }

    public boolean mightHaveMultiFontMetrics() {
        return this.props != null;
    }

    private static File tryOpeningFontProp(File file, String string, String string2, String string3) {
        File file2;
        if (file != null) {
            return file;
        }
        String string4 = String.valueOf(string) + File.separator + "lib" + File.separator + "font.properties";
        if (string2 != null) {
            string4 = String.valueOf(string4) + "." + string2;
            if (string3 != null) {
                string4 = String.valueOf(string4) + "_" + string3;
            }
        }
        if ((file2 = new File(string4)) != null && file2.canRead()) {
            return file2;
        }
        return null;
    }

    public CharsetString[] makeMultiCharsetString(String string) {
        return this.makeMultiCharsetString(string.toCharArray(), 0, string.length());
    }

    public CharsetString[] makeMultiCharsetString(char[] cArray, int n, int n2) {
        CharsetString[] charsetStringArray;
        int n3;
        Object object;
        if (n2 < 1) {
            return new CharsetString[0];
        }
        Vector vector = null;
        char[] cArray2 = new char[n2];
        char c = this.defaultChar;
        Object object2 = this.defaultFont;
        int n4 = 0;
        while (n4 < this.componentFonts.length) {
            if (!this.componentFonts[n4].isExcluded(cArray[n]) && this.componentFonts[n4].fontCharset.canConvert(cArray[n])) {
                object2 = this.componentFonts[n4];
                c = cArray[n];
                break;
            }
            ++n4;
        }
        cArray2[0] = c;
        int n5 = 0;
        int n6 = 1;
        while (n6 < n2) {
            char c2 = cArray[n + n6];
            object = this.defaultFont;
            c = this.defaultChar;
            n3 = 0;
            while (n3 < this.componentFonts.length) {
                if (!this.componentFonts[n3].isExcluded(c2) && this.componentFonts[n3].fontCharset.canConvert(c2)) {
                    object = this.componentFonts[n3];
                    c = c2;
                    break;
                }
                ++n3;
            }
            cArray2[n6] = c;
            if (object2 != object) {
                if (vector == null) {
                    vector = new Vector(3);
                }
                vector.addElement(new CharsetString(cArray2, n5, n6 - n5, (FontDescriptor)object2));
                object2 = object;
                object = this.defaultFont;
                n5 = n6;
            }
            ++n6;
        }
        object = new CharsetString(cArray2, n5, n2 - n5, (FontDescriptor)object2);
        if (vector == null) {
            charsetStringArray = new CharsetString[]{object};
        } else {
            vector.addElement(object);
            charsetStringArray = new CharsetString[vector.size()];
            n3 = 0;
            while (n3 < vector.size()) {
                charsetStringArray[n3] = (CharsetString)vector.elementAt(n3);
                ++n3;
            }
        }
        return charsetStringArray;
    }

    protected abstract CharToByteConverter getFontCharset(String var1, String var2);

    public static String styleStr(int n) {
        switch (n) {
            case 1: {
                return "bold";
            }
            case 2: {
                return "italic";
            }
            case 3: {
                return "bolditalic";
            }
        }
        return "plain";
    }

    static {
        String string = System.getProperty("java.home");
        String string2 = System.getProperty("user.home");
        if (string == null) {
            throw new Error("java.home property not set");
        }
        String string3 = System.getProperty("user.language", "en");
        String string4 = System.getProperty("user.region");
        String string5 = System.getProperty("file.encoding");
        String string6 = CharacterEncoding.aliasName(string5);
        if (string6 == null) {
            string6 = string5;
        }
        try {
            File file = null;
            if (string4 != null) {
                file = PlatformFont.tryOpeningFontProp(file, string2, string3, String.valueOf(string4) + "_" + string6);
                file = PlatformFont.tryOpeningFontProp(file, string, string3, String.valueOf(string4) + "_" + string6);
                file = PlatformFont.tryOpeningFontProp(file, string2, string3, string4);
                file = PlatformFont.tryOpeningFontProp(file, string, string3, string4);
            }
            file = PlatformFont.tryOpeningFontProp(file, string2, string3, string6);
            file = PlatformFont.tryOpeningFontProp(file, string, string3, string6);
            file = PlatformFont.tryOpeningFontProp(file, string2, string3, null);
            file = PlatformFont.tryOpeningFontProp(file, string, string3, null);
            file = PlatformFont.tryOpeningFontProp(file, string2, string6, null);
            file = PlatformFont.tryOpeningFontProp(file, string, string6, null);
            file = PlatformFont.tryOpeningFontProp(file, string2, null, null);
            file = PlatformFont.tryOpeningFontProp(file, string, null, null);
            Properties properties = new Properties();
            properties.put("serif.0", "unknown");
            properties.put("sansserif.0", "unknown");
            properties.put("monospaced.0", "unknown");
            properties.put("dialog.0", "unknown");
            properties.put("dialoginput.0", "unknown");
            fprops = new Properties(properties);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file.getPath()));
            fprops.load(bufferedInputStream);
            ((InputStream)bufferedInputStream).close();
        }
        catch (Exception exception) {}
    }
}

