/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.SystemClassLoader;
import java.util.Vector;

public abstract class ResourceBundle {
    private static SystemClassLoader systemClassLoader = new SystemClassLoader();
    private static boolean debugFlag;
    protected ResourceBundle parent;
    private static final Integer NOTFOUND;
    private static Hashtable cacheList;

    public final String getString(String string) throws MissingResourceException {
        return (String)this.getObject(string);
    }

    public final String[] getStringArray(String string) throws MissingResourceException {
        return (String[])this.getObject(string);
    }

    public final Object getObject(String string) throws MissingResourceException {
        Object object = this.handleGetObject(string);
        if (object == null) {
            if (this.parent != null) {
                object = this.parent.getObject(string);
            }
            if (object == null) {
                throw new MissingResourceException("Can't find resource", this.getClass().getName(), string);
            }
        }
        return object;
    }

    public static final ResourceBundle getBundle(String string) throws MissingResourceException {
        return ResourceBundle.getBundle(string, Locale.getDefault(), ResourceBundle.getLoader());
    }

    public static final ResourceBundle getBundle(String string, Locale locale) {
        return ResourceBundle.getBundle(string, locale, ResourceBundle.getLoader());
    }

    private static ClassLoader getLoader() {
        ClassLoader classLoader;
        Class[] classArray = ResourceBundle.getClassContext();
        Class clazz = classArray[2];
        ClassLoader classLoader2 = classLoader = clazz == null ? null : clazz.getClassLoader();
        if (classLoader == null) {
            return systemClassLoader;
        }
        return classLoader;
    }

    private static native Class[] getClassContext();

    private static synchronized ResourceBundle getBundle(String string, Locale locale, ClassLoader classLoader) throws MissingResourceException {
        ResourceBundle resourceBundle;
        StringBuffer stringBuffer = new StringBuffer("_").append(locale.toString());
        if (locale.toString().equals("")) {
            stringBuffer.setLength(0);
        }
        if ((resourceBundle = ResourceBundle.findBundle(string, stringBuffer, classLoader, false)) == null) {
            stringBuffer.setLength(0);
            stringBuffer.append("_").append(Locale.getDefault().toString());
            resourceBundle = ResourceBundle.findBundle(string, stringBuffer, classLoader, true);
            if (resourceBundle == null) {
                throw new MissingResourceException("can't find resource for " + string + "_" + locale, String.valueOf(string) + "_" + locale, "");
            }
        }
        ResourceBundle resourceBundle2 = resourceBundle;
        while (resourceBundle2 != null && resourceBundle2.parent == null) {
            int n = stringBuffer.toString().lastIndexOf(95);
            if (n != -1) {
                stringBuffer.setLength(n);
                resourceBundle2.setParent(ResourceBundle.findBundle(string, stringBuffer, classLoader, true));
            }
            resourceBundle2 = resourceBundle2.parent;
        }
        return resourceBundle;
    }

    protected void setParent(ResourceBundle resourceBundle) {
        this.parent = resourceBundle;
    }

    private static ResourceBundle findBundle(String string, StringBuffer stringBuffer, ClassLoader classLoader, boolean bl) {
        String string2 = stringBuffer.toString();
        String string3 = string.replace('.', '/');
        Object object = null;
        Vector vector = new Vector();
        while (true) {
            String string4 = String.valueOf(string) + string2;
            String string5 = "[" + Integer.toString(classLoader.hashCode()) + "]" + string4;
            object = cacheList.get(string5);
            if (object == NOTFOUND) {
                stringBuffer.setLength(0);
                break;
            }
            if (object != null) {
                stringBuffer.setLength(0);
                break;
            }
            vector.addElement(string5);
            try {
                object = (ResourceBundle)classLoader.loadClass(string4).newInstance();
            }
            catch (Exception exception) {
                int n;
                string4 = String.valueOf(string3) + string2 + ".properties";
                InputStream inputStream = classLoader.getResourceAsStream(string4);
                if (inputStream != null) {
                    inputStream = new BufferedInputStream(inputStream);
                    try {
                        object = new PropertyResourceBundle(inputStream);
                        break;
                    }
                    catch (Exception exception2) {}
                }
                if ((n = string2.lastIndexOf(95)) == 0 && !bl || n == -1) break;
                string2 = string2.substring(0, n);
                stringBuffer.setLength(n);
                continue;
            }
            break;
        }
        if (object != null) {
            int n = 0;
            while (n < vector.size()) {
                cacheList.put(vector.elementAt(n), object);
                ++n;
            }
        } else if (bl) {
            int n = 0;
            while (n < vector.size()) {
                cacheList.put(vector.elementAt(n), NOTFOUND);
                ++n;
            }
        }
        if (object == NOTFOUND || object == null) {
            return null;
        }
        return (ResourceBundle)object;
    }

    protected abstract Object handleGetObject(String var1) throws MissingResourceException;

    public abstract Enumeration getKeys();

    private static void debug(String string) {
        if (debugFlag) {
            System.out.println("ResourceBundle: " + string);
        }
    }

    static {
        NOTFOUND = new Integer(-1);
        cacheList = new Hashtable();
    }
}

