/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log.ui.util;

import java.awt.Color;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class PropertyHelper {
    private static final String kCBIBMCopyright = "\n\nLicensed Materials - Property of IBM\n5639-D57\n(c) Copyright IBM Corp. 1998. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public static void setPropertyValue(Properties properties, String string, int n) {
        ((Hashtable)properties).put(string, Integer.toString(n));
    }

    public static void setPropertyValue(Properties properties, String string, boolean bl) {
        ((Hashtable)properties).put(string, bl ? "true" : "false");
    }

    public static void setPropertyValue(Properties properties, String string, String string2) {
        ((Hashtable)properties).put(string, string2);
    }

    public static void setPropertyValue(Properties properties, String string, Color color) {
        ((Hashtable)properties).put(string, String.valueOf(color.getRed()) + " " + color.getGreen() + " " + color.getBlue());
    }

    public static boolean hasProperty(Properties properties, String string) {
        String string2 = properties.getProperty(string);
        return string2 != null;
    }

    public static int getPropertyInteger(Properties properties, String string) {
        int n = 0;
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            return n;
        }
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {}
        return n;
    }

    public static boolean getPropertyBoolean(Properties properties, String string) {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            return false;
        }
        return string2.equals("true");
    }

    public static String getPropertyString(Properties properties, String string) {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    public static Color getPropertyColor(Properties properties, String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            return new Color(n, n2, n3);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        String string5 = stringTokenizer.nextToken();
        try {
            n = Integer.parseInt(string3);
            n2 = Integer.parseInt(string4);
            n3 = Integer.parseInt(string5);
        }
        catch (NumberFormatException numberFormatException) {}
        return new Color(n, n2, n3);
    }

    public static void main(String[] stringArray) {
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream("UtilityPropertyTest.ini");
            properties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            return;
        }
        properties.list(System.out);
        int n = PropertyHelper.getPropertyInteger(properties, "AnInteger");
        System.out.println(Integer.toString(n));
        boolean bl = PropertyHelper.getPropertyBoolean(properties, "ABoolean");
        System.out.println(bl ? "True" : "False");
        String string = PropertyHelper.getPropertyString(properties, "AString");
        System.out.println(string);
        Color color = PropertyHelper.getPropertyColor(properties, "AColor");
        System.out.println(color.toString());
        PropertyHelper.setPropertyValue(properties, "AnInteger", 32);
        PropertyHelper.setPropertyValue(properties, "ABoolean", true);
        PropertyHelper.setPropertyValue(properties, "AString", "A string of text");
        PropertyHelper.setPropertyValue(properties, "AColor", new Color(64, 128, 255));
        try {
            FileOutputStream fileOutputStream = new FileOutputStream("UtilityPropertyTest.ini");
            properties.save(fileOutputStream, "Utility - Property Test ");
            fileOutputStream.close();
            return;
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            return;
        }
    }
}

