/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log.ui;

import com.ibm.ivb.log.tree.RecordNode;
import com.ibm.ivb.log.ui.AdvAnalyzeSelectedAction;
import com.ibm.ivb.log.ui.AnalyzeSelectedAction;
import com.ibm.ivb.log.ui.FindAndReplaceDialog;
import com.ibm.ivb.log.ui.InformationPanel;
import com.ibm.ivb.log.ui.LBUtilities;
import com.ibm.ivb.log.ui.LogBrowser;
import com.ibm.ivb.log.ui.MenuItemAction;
import com.ibm.ivb.log.ui.SaveSelectedAction;
import com.ibm.ivb.log.ui.TextSelectionManager;
import com.ibm.ivb.log.ui.TranslatableConstants;
import com.ibm.ivb.log.ui.util.FindAndReplace;
import com.sun.java.swing.Action;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JPopupMenu;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JSeparator;
import com.sun.java.swing.JTextArea;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.text.JTextComponent;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class InfoTextPanel
extends JScrollPane
implements InformationPanel,
TranslatableConstants {
    private static final String kCBIBMCopyright = "\n\nLicensed Materials - Property of IBM\n5639-D57\n(c) Copyright IBM Corp. 1998. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private JTextArea textArea = new JTextArea();
    private RecordNode node;
    private boolean wrapMode = true;
    private JPopupMenu popup;
    private static AnalyzeSelectedAction actAnalyze;
    private static AdvAnalyzeSelectedAction actAdvAnalyze;
    private static SaveSelectedAction actSave;
    private static CutAction actCut;
    private static CopyAction actCopy;
    private static PasteAction actPaste;
    private static FindAction actFind;
    private static FindAgainAction actFindAgain;
    private static SelectAllAction actSelectAll;

    public InfoTextPanel(boolean bl) {
        super(20, 30);
        this.wrapMode = bl;
        this.textArea.setLineWrap(bl);
        this.getViewport().add((Component)this.textArea);
        this.textArea.addMouseListener(new MouseHandler());
    }

    public InfoTextPanel() {
        this(false);
    }

    public int search(String string, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return FindAndReplace.find(this.getText(), string, n, bl, bl2, bl3, bl4);
    }

    public void processSearchResult(int n, String string) {
        if (n == -1) {
            FindAndReplaceDialog.handleNoMatch((Component)((Object)this));
            return;
        }
        this.select(n, n + string.length());
    }

    public int getSearchStart(boolean bl) {
        if (bl) {
            return this.getSelectionEnd();
        }
        return this.getSelectionStart();
    }

    public int getReplaceStart() {
        return this.getSelectionEnd();
    }

    public void processRepeatSearchResult(int n, String string) {
        if (n == -1) {
            FindAndReplaceDialog.handleNoMatch();
            return;
        }
        this.select(n, n + string.length());
    }

    public void searchAndReplace(String string, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string2) {
        int n2 = this.search(string, n, bl, bl2, bl3, bl4);
        this.processReplace(n2, string.length(), string2);
    }

    public void processReplace(int n, int n2, String string) {
        if (n == -1) {
            FindAndReplaceDialog.handleNoMatch((Component)this.textArea);
            return;
        }
        String string2 = this.getText();
        this.textArea.setText(String.valueOf(string2.substring(0, n)) + string + string2.substring(n + n2));
        this.select(n, n + string.length());
    }

    public boolean isEditable() {
        return this.textArea.isEditable();
    }

    public boolean hasSelection() {
        return this.textArea.getSelectionEnd() > this.textArea.getSelectionStart();
    }

    public String getSelection() {
        return this.textArea.getSelectedText();
    }

    public RecordNode getNode() {
        return this.node;
    }

    public void setNode(RecordNode recordNode) {
        this.node = recordNode;
    }

    public JTextComponent getTextComponent() {
        return this.textArea;
    }

    public void requestFocus() {
        this.textArea.requestFocus();
    }

    public void cut() {
        this.textArea.cut();
    }

    public void copy() {
        this.textArea.copy();
    }

    public void paste() {
        this.textArea.paste();
    }

    public void find() {
        new FindAndReplaceDialog((JFrame)LBUtilities.getBrowserFrame((Component)((Object)this)), this, false);
    }

    public void findAgain() {
        FindAndReplaceDialog.findAgain(this);
    }

    public void replace() {
        new FindAndReplaceDialog((JFrame)LBUtilities.getBrowserFrame((Component)((Object)this)), this, true);
    }

    public void selectAll() {
        this.textArea.selectAll();
    }

    public void setEditable(boolean bl) {
        this.textArea.setEditable(bl);
    }

    public void setWrapMode(boolean bl) {
        if (this.wrapMode != bl) {
            this.textArea.setLineWrap(bl);
            this.wrapMode = bl;
        }
    }

    public void setText(String string) {
        this.textArea.setText(string);
        this.textArea.setCaretPosition(0);
    }

    private String getText() {
        return this.textArea.getText();
    }

    private void select(int n, int n2) {
        this.textArea.setCaretPosition(n);
        this.textArea.moveCaretPosition(n2);
    }

    private int getSelectionStart() {
        return this.textArea.getSelectionStart();
    }

    private int getSelectionEnd() {
        return this.textArea.getSelectionEnd();
    }

    private boolean handlePopup(JPopupMenu jPopupMenu) {
        boolean bl;
        if (this.node == null) {
            return false;
        }
        actAnalyze = new AnalyzeSelectedAction((Component)this.textArea, this.node);
        actAdvAnalyze = new AdvAnalyzeSelectedAction((Component)this.textArea, this.node);
        actSave = new SaveSelectedAction((Component)this.textArea, this.node);
        actCut = new CutAction();
        actCopy = new CopyAction();
        actPaste = new PasteAction();
        actFind = new FindAction();
        actFindAgain = new FindAgainAction();
        actSelectAll = new SelectAllAction();
        jPopupMenu.add((Action)actAnalyze);
        jPopupMenu.add((Action)actAdvAnalyze);
        jPopupMenu.add((Component)new JSeparator());
        jPopupMenu.add((Action)actSave);
        jPopupMenu.add((Component)new JSeparator());
        jPopupMenu.add((Action)actCut);
        jPopupMenu.add((Action)actCopy);
        jPopupMenu.add((Action)actPaste);
        jPopupMenu.add((Component)new JSeparator());
        jPopupMenu.add((Action)actFind);
        jPopupMenu.add((Action)actFindAgain);
        jPopupMenu.add((Component)new JSeparator());
        jPopupMenu.add((Action)actSelectAll);
        boolean bl2 = bl = !TextSelectionManager.hasSelection();
        if (this.node.isAnalysisDone()) {
            actAnalyze.setEnabled(false);
        }
        if (this.node.isAdvanceAnalysisDone()) {
            actAdvAnalyze.setEnabled(false);
        }
        if (!this.isEditable() || bl) {
            actCut.setEnabled(false);
        }
        if (bl) {
            actCopy.setEnabled(false);
        }
        if (!this.isEditable() || LBUtilities.isClipboardEmpty()) {
            actPaste.setEnabled(false);
        }
        if (!FindAndReplaceDialog.canFindAgain()) {
            actFindAgain.setEnabled(false);
        }
        return true;
    }

    class MouseHandler
    extends MouseAdapter
    implements Runnable {
        private Point location;

        public void mousePressed(MouseEvent mouseEvent) {
            if (InfoTextPanel.this.textArea.getCursor().getType() != 3 && mouseEvent.isPopupTrigger()) {
                this.createPopup(mouseEvent.getPoint());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (InfoTextPanel.this.textArea.getCursor().getType() != 3 && mouseEvent.isPopupTrigger()) {
                this.createPopup(mouseEvent.getPoint());
            }
        }

        private void createPopup(Point point) {
            if (InfoTextPanel.this.popup == null) {
                InfoTextPanel.this.popup = new JPopupMenu();
            }
            InfoTextPanel.this.popup.removeAll();
            if (InfoTextPanel.this.handlePopup(InfoTextPanel.this.popup)) {
                this.location = point;
                SwingUtilities.invokeLater((Runnable)this);
            }
        }

        public synchronized void run() {
            InfoTextPanel.this.select(TextSelectionManager.getSelectionStart(), TextSelectionManager.getSelectionEnd());
            InfoTextPanel.this.popup.show((Component)((Object)InfoTextPanel.this), this.location.x, this.location.y);
        }

        MouseHandler() {
            InfoTextPanel.this = InfoTextPanel.this;
        }
    }

    class CutAction
    extends MenuItemAction
    implements TranslatableConstants {
        CutAction() {
            super(LogBrowser.getLBString("ComIbmIvbLogUiPopupCut"));
            InfoTextPanel.this = InfoTextPanel.this;
        }

        public synchronized void run() {
            InfoTextPanel.this.cut();
        }
    }

    class CopyAction
    extends MenuItemAction
    implements TranslatableConstants {
        CopyAction() {
            super(LogBrowser.getLBString("ComIbmIvbLogUiPopupCopy"));
            InfoTextPanel.this = InfoTextPanel.this;
        }

        public synchronized void run() {
            InfoTextPanel.this.copy();
        }
    }

    class PasteAction
    extends MenuItemAction
    implements TranslatableConstants {
        PasteAction() {
            super(LogBrowser.getLBString("ComIbmIvbLogUiPopupPaste"));
            InfoTextPanel.this = InfoTextPanel.this;
        }

        public synchronized void run() {
            InfoTextPanel.this.paste();
        }
    }

    class FindAction
    extends MenuItemAction
    implements TranslatableConstants {
        FindAction() {
            super(LogBrowser.getLBString("ComIbmIvbLogUiPopupFind"));
            InfoTextPanel.this = InfoTextPanel.this;
        }

        public synchronized void run() {
            InfoTextPanel.this.find();
        }
    }

    class FindAgainAction
    extends MenuItemAction
    implements TranslatableConstants {
        FindAgainAction() {
            super(LogBrowser.getLBString("ComIbmIvbLogUiPopupFindAgain"));
            InfoTextPanel.this = InfoTextPanel.this;
        }

        public synchronized void run() {
            InfoTextPanel.this.findAgain();
        }
    }

    class SelectAllAction
    extends MenuItemAction
    implements TranslatableConstants {
        SelectAllAction() {
            super(LogBrowser.getLBString("ComIbmIvbLogUiPopupSelectAll"));
            InfoTextPanel.this = InfoTextPanel.this;
        }

        public synchronized void run() {
            InfoTextPanel.this.selectAll();
        }
    }
}

