/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log.tree;

import com.ibm.ivb.log.LogFile;
import com.ibm.ivb.log.Record;
import com.ibm.ivb.log.tree.Node;
import com.ibm.ivb.log.tree.ParentNode;
import com.ibm.ivb.log.tree.RecordNode;
import com.ibm.ivb.log.tree.Severity;
import com.ibm.ivb.log.tree.Visitor;
import java.io.IOException;

public class RecordFilterNode
extends ParentNode
implements Severity {
    private String filterValue;
    private int severity = 3;
    private String timeStampString = "";
    private boolean analysisDone = false;
    private boolean advanceAnalysisDone = false;

    public String getFilterValue() {
        return this.filterValue;
    }

    public String getTimeStampString() {
        return this.timeStampString;
    }

    public void setTimeStampString(String string) {
        this.timeStampString = string;
    }

    public String toString() {
        return String.valueOf(this.timeStampString) + " (" + this.getChildCount() + ") " + this.filterValue;
    }

    public RecordFilterNode(String string, long l, String string2) {
        this.filterValue = string;
        this.setTimeStamp(l);
        this.timeStampString = string2;
    }

    public void addRecordNode(RecordNode recordNode) {
        this.addChild(recordNode);
    }

    public void insertRecordNode(RecordNode recordNode) {
        this.insertChild(recordNode);
    }

    public void addRecord(Record record) {
        if (record.getTimeStamp() > this.getTimeStamp()) {
            this.setTimeStamp(record.getTimeStamp());
            this.timeStampString = record.getTimeStampString();
        }
        if (record.getSeverity() < this.severity) {
            this.severity = record.getSeverity();
        }
        RecordNode recordNode = new RecordNode(record);
        this.insertChild(recordNode);
    }

    public boolean isSortLower(Node node) {
        return this.getTimeStamp() > node.getTimeStamp();
    }

    public int getSeverity() {
        return this.severity;
    }

    public void setSeverity(int n) {
        this.severity = n;
    }

    public void analyze() {
        int n = this.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            Node node = this.getChild(n2);
            node.analyze();
            ++n2;
        }
        this.analysisDone = true;
    }

    public void advanceAnalyze(String string, String string2) {
        int n = this.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            Node node = this.getChild(n2);
            node.advanceAnalyze(string, string2);
            ++n2;
        }
        this.advanceAnalysisDone = true;
    }

    public void resetAnalyze() {
        int n = this.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            Node node = this.getChild(n2);
            node.resetAnalyze();
            ++n2;
        }
        this.analysisDone = false;
    }

    public void resetAdvanceAnalyze() {
        int n = this.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            Node node = this.getChild(n2);
            node.resetAdvanceAnalyze();
            ++n2;
        }
        this.advanceAnalysisDone = false;
    }

    public boolean isAnalysisDone() {
        return this.analysisDone;
    }

    public boolean isAdvanceAnalysisDone() {
        return this.advanceAnalysisDone;
    }

    public void analyze(String string, String string2) {
    }

    public String getAnalysisResult(String string) {
        return null;
    }

    public String getText() {
        return String.valueOf(this.filterValue) + "(" + this.getChildCount() + ")";
    }

    public void save(String string, String string2) throws IOException {
        LogFile logFile = new LogFile(this);
        if (string2.equals("xml")) {
            logFile.saveAsXML(string);
            return;
        }
        logFile.saveAsText(string);
    }

    public void visit(Visitor visitor) {
        visitor.visitRecordFilterNode(this);
    }
}

