/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log.tree;

import com.ibm.ivb.log.Analyzer;
import com.ibm.ivb.log.AppModel;
import com.ibm.ivb.log.LogFile;
import com.ibm.ivb.log.Record;
import com.ibm.ivb.log.tree.Node;
import com.ibm.ivb.log.tree.RootNode;
import com.ibm.ivb.log.tree.Visitor;
import com.sun.java.swing.event.EventListenerList;
import com.sun.java.swing.event.TreeModelEvent;
import com.sun.java.swing.event.TreeModelListener;
import com.sun.java.swing.tree.TreeModel;
import com.sun.java.swing.tree.TreePath;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;

public class LogTreeModel
implements TreeModel {
    private EventListenerList listeners = new EventListenerList();
    private static Hashtable analyzers = new Hashtable();
    private static Hashtable advanceAnalyzers = new Hashtable();
    private RootNode root = new RootNode();
    static /* synthetic */ Class class$com$sun$java$swing$event$TreeModelListener;

    public static String[] getAnalyzerNames() {
        String[] stringArray = new String[analyzers.size()];
        int n = 0;
        Enumeration enumeration = analyzers.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public static String[] getAdvanceAnalyzerNames() {
        String[] stringArray = new String[advanceAnalyzers.size()];
        int n = 0;
        Enumeration enumeration = advanceAnalyzers.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public static Hashtable getAnalyzers() {
        return analyzers;
    }

    public static Hashtable getAdvanceAnalyzers() {
        return advanceAnalyzers;
    }

    public static Analyzer getAnalyzer(String string) {
        return (Analyzer)analyzers.get(string);
    }

    public static Analyzer getAdvanceAnalyzer(String string) {
        return (Analyzer)advanceAnalyzers.get(string);
    }

    public static void setAnalyzers(Hashtable hashtable) {
        analyzers = hashtable;
    }

    public static void setAdvanceAnalyzers(Hashtable hashtable) {
        advanceAnalyzers = hashtable;
    }

    public LogTreeModel() {
        AppModel.setRoot(this.root);
    }

    public void readLogFile(String string) throws IOException {
        try {
            try {
                LogFile logFile = new LogFile(string);
                logFile.populateTree(this.root);
                AppModel.setCurrLogFileName(new String(string));
            }
            catch (IOException iOException) {
                throw new IOException(String.valueOf(string) + ": " + iOException.getMessage());
            }
            Object var3_4 = null;
            this.fireTreeStructureChanged();
            return;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.fireTreeStructureChanged();
            throw throwable;
        }
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.add(class$com$sun$java$swing$event$TreeModelListener != null ? class$com$sun$java$swing$event$TreeModelListener : (class$com$sun$java$swing$event$TreeModelListener = LogTreeModel.class$("com.sun.java.swing.event.TreeModelListener")), (EventListener)treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.remove(class$com$sun$java$swing$event$TreeModelListener != null ? class$com$sun$java$swing$event$TreeModelListener : (class$com$sun$java$swing$event$TreeModelListener = LogTreeModel.class$("com.sun.java.swing.event.TreeModelListener")), (EventListener)treeModelListener);
    }

    private void fireTreeNodesChanged() {
        TreeModelEvent treeModelEvent = null;
        Object[] objectArray = this.listeners.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$sun$java$swing$event$TreeModelListener != null ? class$com$sun$java$swing$event$TreeModelListener : LogTreeModel.class$("com.sun.java.swing.event.TreeModelListener"))) {
                if (treeModelEvent == null) {
                    treeModelEvent = new TreeModelEvent((Object)this, new Object[]{this.root});
                }
                ((TreeModelListener)objectArray[n + 1]).treeNodesChanged(treeModelEvent);
            }
            n -= 2;
        }
    }

    private void fireTreeStructureChanged() {
        TreeModelEvent treeModelEvent = null;
        Object[] objectArray = this.listeners.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$sun$java$swing$event$TreeModelListener != null ? class$com$sun$java$swing$event$TreeModelListener : LogTreeModel.class$("com.sun.java.swing.event.TreeModelListener"))) {
                if (treeModelEvent == null) {
                    treeModelEvent = new TreeModelEvent((Object)this, new Object[]{this.root});
                }
                ((TreeModelListener)objectArray[n + 1]).treeStructureChanged(treeModelEvent);
            }
            n -= 2;
        }
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    public Object getRoot() {
        return this.root;
    }

    public int getChildCount(Object object) {
        return ((Node)object).getChildCount();
    }

    public Object getChild(Object object, int n) {
        return ((Node)object).getChild(n);
    }

    public int getIndexOfChild(Object object, Object object2) {
        return ((Node)object).getIndexOfChild(object2);
    }

    public boolean isLeaf(Object object) {
        return ((Node)object).isLeaf();
    }

    public void addRecord(Record record) {
        this.root.addRecord(record);
    }

    public void visitPaths(TreePath[] treePathArray, Visitor visitor) {
        int n = 0;
        while (n < treePathArray.length) {
            ((Node)treePathArray[n].getLastPathComponent()).visit(visitor);
            ++n;
        }
        this.fireTreeNodesChanged();
    }

    public static LogTreeModel makeModel(String[] stringArray) throws IOException {
        LogTreeModel logTreeModel = new LogTreeModel();
        String string = AppModel.getCurrDir();
        if (string == null) {
            string = new String(".");
        }
        File file = null;
        String string2 = null;
        int n = 0;
        while (n < stringArray.length) {
            file = new File(stringArray[n]);
            string2 = file.isAbsolute() ? stringArray[n] : String.valueOf(string) + File.separator + stringArray[n];
            logTreeModel.readLogFile(string2);
            ++n;
        }
        return logTreeModel;
    }

    public void merge(File file) throws IOException {
        this.readLogFile(file.getPath());
    }

    public static File getFullPath(String string) {
        String string2;
        File file = new File(string);
        if (file.isAbsolute()) {
            string2 = string;
        } else {
            String string3 = AppModel.getCurrDir();
            if (string3 == null) {
                string3 = new String(".");
            }
            string2 = String.valueOf(string3) + File.separator + string;
        }
        return new File(string2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

