/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivb.log.analyzers;

import com.ibm.ivb.log.Analyzer;
import com.ibm.ivb.log.AppModel;
import com.ibm.ivb.log.Record;
import com.ibm.ivb.log.SymFile;
import com.ibm.ivb.log.datamodel.LogRecMetadata;
import com.ibm.ivb.log.datamodel.SymFileMetadata;
import com.ibm.ivb.log.datamodel.SymRecMetadata;
import com.ibm.ivb.log.ui.LogBrowser;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Vector;

public class SymptomAnalyzer
implements Analyzer {
    private String analyzerName;
    private static String SymFilePath = null;
    private static SymFile sf = null;
    private static SymFileMetadata smd = null;

    public void setParameter(String string) {
        SymFilePath = string;
    }

    public void setAnalyzerName(String string) {
        this.analyzerName = new String(string);
    }

    public SymptomAnalyzer(String string, SymFile symFile) {
        sf = symFile;
        this.analyzerName = string;
    }

    private static boolean SymptomsMatch(SymRecMetadata symRecMetadata, String string) {
        int n;
        boolean bl = false;
        Vector vector = symRecMetadata.getMatchSymptomv();
        if (vector != null) {
            n = 0;
            while (n < vector.size()) {
                if (string.indexOf((String)vector.elementAt(n)) == -1) {
                    return false;
                }
                ++n;
            }
            bl = true;
        }
        if ((vector = symRecMetadata.getNoMatchSymptomv()) != null) {
            n = 0;
            while (n < vector.size()) {
                if (string.indexOf((String)vector.elementAt(n)) != -1) {
                    return false;
                }
                ++n;
            }
            bl = true;
        }
        return bl;
    }

    public static Vector findMatchingSymptomRecs(String string, SymFileMetadata symFileMetadata) {
        Vector<SymRecMetadata> vector = null;
        if (symFileMetadata == null) {
            return null;
        }
        Vector vector2 = symFileMetadata.getSymRecv();
        if (vector2 == null) {
            return null;
        }
        if (string == null) {
            return null;
        }
        int n = 0;
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            SymRecMetadata symRecMetadata = (SymRecMetadata)enumeration.nextElement();
            if (symRecMetadata != null && SymptomAnalyzer.SymptomsMatch(symRecMetadata, string)) {
                if (vector == null) {
                    vector = new Vector<SymRecMetadata>();
                }
                vector.addElement(symRecMetadata);
            }
            ++n;
        }
        return vector;
    }

    private static Vector findSymptoms(LogRecMetadata logRecMetadata, SymFileMetadata symFileMetadata) {
        String string;
        String string2 = logRecMetadata.getPrimaryMessage();
        if (string2 == null) {
            string2 = "";
        }
        Vector vector = null;
        vector = logRecMetadata.getPrimaryMessagev();
        if (vector != null) {
            string2 = String.valueOf(string2) + vector.toString();
        }
        if ((string = logRecMetadata.getExtendedMessage()) == null) {
            string = "";
        }
        if ((vector = logRecMetadata.getExtendedMessagev()) != null && vector.size() > 0) {
            string = String.valueOf(string) + (String)vector.elementAt(0);
        }
        string2 = String.valueOf(string2) + string;
        String string3 = Record.Status.mystery.toString();
        Vector vector2 = SymptomAnalyzer.findMatchingSymptomRecs(string2, symFileMetadata);
        if (vector2 != null) {
            Vector<String> vector3 = new Vector<String>();
            SymRecMetadata symRecMetadata = null;
            Vector vector4 = null;
            int n = 0;
            while (n < vector2.size()) {
                int n2;
                String string4;
                Object object;
                symRecMetadata = (SymRecMetadata)vector2.elementAt(n);
                string3 = symRecMetadata.getSymptomStatus();
                vector4 = symRecMetadata.getMatchSymptomv();
                if (vector4 != null) {
                    object = "Matching String(s): ";
                    string4 = "";
                    n2 = 0;
                    while (n2 < vector4.size()) {
                        object = String.valueOf(object) + string4 + "\"" + (String)vector4.elementAt(n2) + "\"";
                        string4 = "; ";
                        ++n2;
                    }
                    vector3.addElement(new String((String)object));
                }
                if ((vector4 = symRecMetadata.getNoMatchSymptomv()) != null) {
                    object = "Not Matching String(s): ";
                    string4 = "";
                    n2 = 0;
                    while (n2 < vector4.size()) {
                        object = String.valueOf(object) + string4 + "\"" + (String)vector4.elementAt(n2) + "\"";
                        string4 = "; ";
                        ++n2;
                    }
                    vector3.addElement(new String((String)object));
                }
                vector3.addElement(new String("--------------------------------------------------------------------"));
                object = symRecMetadata.getSymptomInfov();
                if (object != null) {
                    int n3 = 0;
                    while (n3 < ((Vector)object).size()) {
                        vector3.addElement((String)((Vector)object).elementAt(n3));
                        ++n3;
                    }
                }
                vector3.addElement(new String(" "));
                ++n;
            }
            logRecMetadata.setSymptomStatus(string3);
            logRecMetadata.setSymptomv(vector3);
            return vector3;
        }
        logRecMetadata.setSymptomStatus("none");
        return null;
    }

    private String stringVecToText(Vector vector) {
        String string = "";
        int n = 0;
        while (n < vector.size()) {
            string = String.valueOf(string) + vector.elementAt(n) + "\n";
            ++n;
        }
        return string;
    }

    public void analyze(Record record) {
        if (sf == null) {
            record.setAnalysisResults(this.analyzerName, "");
            return;
        }
        LogRecMetadata logRecMetadata = record.getLogRecMetadata();
        Vector vector = null;
        String string = "";
        String string2 = null;
        string2 = logRecMetadata.getSymptomStatus();
        if (string2 != null) {
            vector = logRecMetadata.getSymptomv();
            if (vector != null) {
                record.setStatus(Record.Status.fromString(string2));
            }
        } else {
            vector = SymptomAnalyzer.findSymptoms(logRecMetadata, sf.getSymFileMetadata());
            if (vector != null) {
                record.setStatus(Record.Status.fromString(logRecMetadata.getSymptomStatus()));
            }
        }
        if (vector != null) {
            string = this.stringVecToText(vector);
        }
        record.setAnalysisResults(this.analyzerName, string);
    }

    public static void main(String[] stringArray) {
        String string = System.getProperty("TimeStampFormat", "M/d/yy H:mm:ss.");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        AppModel.setTimeStampFormat(simpleDateFormat);
        System.out.println("SymptomAnalyzer:: main");
        System.out.flush();
        SymFile symFile = null;
        try {
            symFile = new SymFile(System.getProperty("com.ibm.CORBA.log.SymptomAnalyzerPath", "d:\\cbroker\\etc\\vhany\\stringMatch"));
        }
        catch (IOException iOException) {
            System.out.println("Cannot load Symptomdb file");
            System.out.flush();
        }
        System.out.println(" done ...");
        System.out.flush();
    }

    public static class Factory
    implements Analyzer.Factory {
        private SymFile sf;
        private String analyzerName;

        private void loadAnalysisFiles() {
            try {
                this.sf = new SymFile(System.getProperty("SymptomAnalyzerPath", "d:\\cbroker\\etc\\vhany\\stringMatch"));
                return;
            }
            catch (IOException iOException) {
                System.err.println(LogBrowser.getLBString("ComIbmIvbLogMsgCannotLoadSymdb"));
                System.err.flush();
                return;
            }
        }

        public Factory() {
            this.loadAnalysisFiles();
        }

        public void setAnalyzerName(String string) {
            this.analyzerName = new String(string);
        }

        public Analyzer make() {
            return new SymptomAnalyzer(this.analyzerName, this.sf);
        }
    }
}

