#ifndef _IMSWEButl_cpp
#define _IMSWEButl_cpp

#include "imswebutl.h"
#include "hwslnode.hpp"
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

// Extract info from the default transaction output object.
// The caller is responsible for freeing memory used by the
// message.
//
char *IMSWEButl::displayDefault( HWSTranOut *aLpg )
{
   HWSLNode *aNode    = NULL;
   char     *dataBuf  = NULL;
   int      szDataBuf = 0;
   char     *msg      = new char[MAX_MSG_SIZE];

   sprintf(msg, "Default Transaction Output = %s", aLpg->getClassName() );

   aNode = aLpg->genList();

   while( aNode )
   {
      strcat(msg, "\nField Name = ");
      strcat(msg, aNode->name);

      if( dataBuf )
      {
         if( aNode->length + 1 > szDataBuf )
         {
            free( dataBuf );
            dataBuf = NULL;
            szDataBuf = aNode->length + 1;
            dataBuf = (char *)malloc( szDataBuf );
         }
         memcpy( dataBuf, aNode->data, aNode->length );
         *(dataBuf + (aNode->length)) = 0;
      }
      else
      {
         szDataBuf = aNode->length + 1;
         dataBuf = (char *)malloc( szDataBuf );
         memcpy( dataBuf, aNode->data, aNode->length );
         *(dataBuf + (aNode->length)) = 0;
      }

      strcat(msg, "\nField Value = ");
      strcat(msg,  dataBuf);
      aNode = aNode->next;
   }
   free( dataBuf );
   dataBuf = NULL;

   return msg;
}


// If there is an error, return a message descibing that error.
// Return a NULL message if no error is found.  The caller is
// responsible for freeing the memory used by the message.

char *IMSWEButl::handle_error( HWSTranOut *pLpg)
{
    char * msg = new char[MAX_MSG_SIZE];

    if (!pLpg)
    {
        strcpy(msg, "Error Occured in the IMS Web generated code: A NULL HWSTranOut is returned");
    }
    else
    {
        switch( pLpg->getClassType() )
        {
            case HWS_USER:
                    delete msg;
                    msg = NULL;
                break;

            case HWS_ERROUT:
                   sprintf(msg, "ERROR: Unable to execute transaction.\n");
                   strcat(msg, "Error String: ");
                   strcat(msg,(((HWSErrOut *)pLpg)->geterrString()));
                break;

            case HWS_MO1:
                   strcpy(msg, displayDefault( pLpg ));
                break;

            case HWS_MO2:
                   strcpy(msg, displayDefault( pLpg ));
                break;

            case HWS_MO3:
                   strcpy(msg, displayDefault( pLpg ));
                break;

            case HWS_MO4:
                   strcpy(msg, displayDefault( pLpg ));
                break;

            case HWS_MO5:
                   strcpy(msg, displayDefault( pLpg ));
                break;

            case HWS_DSPO1:
                   strcpy(msg, displayDefault( pLpg ));
                break;

            default:
                   strcpy(msg, "ERROR: Unknown transaction output object type");
                break;
        }
   }
  return msg;
}
#endif /* _IMSWEButl_cpp */
