#ifndef PBEPO_CPP
#define PBEPO_CPP

#include "PBEPO.ih"
#include "imswebutl.h"
#include <hwsutil.hpp>
#include <string.h>
#include <stdlib.h>
#include <iostream.h>
#include <IBOIMException.hh>

__declspec(dllexport) PBEPO::PBEPO()
{
   tranInObj     = new HWSLPG01In();
   HWSUtil *util = new HWSUtil();
   char ruName[9];

   //  Set the requester unique name which is used as LTERM name.
   //
   tranInObj->setRUname(util->getRUname(ruName));

   tranInObj->setUser("");
   tranInObj->setGroup("");
   tranInObj->setHost("");
   tranInObj->setPort("");
   tranInObj->setIMS("");
}

__declspec(dllexport) PBEPO::~PBEPO()
{
 delete tranInObj;
}

// note that unlike the generated code, this will only handle a single
// output

void PBEPO::insert()
{
  HWSLPG00Out *tranOutObj   = NULL;
  char        *msg         = NULL;

  tranInObj->setCMD("ADD");
  tranOutObj = (HWSLPG00Out*) tranInObj->execute();
  msg = IMSWEButl::handle_error(tranOutObj);

  if ( msg )
  {
      throw IBOIMException::IDataObjectFailed("IMS/OTMA Adapter Sample",
                                               0,0,"PBEPO::insert",msg);
  }
  else
  {
     if ( tranOutObj->getMSG() )
     {
        if (!strncmp(tranOutObj->getMSG(), "ADDITION OF ENTRY HAS FAILED", 28) )
        {
           throw IBOIMException::IDataKeyAlreadyExists();
        }
     }
  }

  delete tranOutObj;
}


void PBEPO::retrieve()
{
  HWSLPG00Out *tranOutObj = NULL;
  char       *msg        = NULL;


  tranInObj->setCMD("DISPLAY");
  tranOutObj = (HWSLPG00Out*) tranInObj->execute();
  msg = IMSWEButl::handle_error(tranOutObj);

  if ( msg )
  {
      throw IBOIMException::IDataObjectFailed("IMS/OTMA Adapter Sample",
                                               0,0,"PBEPO::retrieve",msg);
  }
  else if ( tranOutObj->getMSG() )
    {
      if (!strncmp(tranOutObj->getMSG(), "SPECIFIED PERSON WAS NOT FOUND", 30))
      {
        throw IBOIMException::IDataKeyNotFound();
      }
    }

  tranInObj->setNAME2(tranOutObj->getNAME2());
  tranInObj->setEXT_(tranOutObj->getEXT_());
  tranInObj->setZIP(tranOutObj->getZIP());

  delete tranOutObj;
}


void PBEPO::update()
{
  HWSLPG00Out *tranOutObj = NULL;
  char       *msg        = NULL;

  tranInObj->setCMD("UPDATE");
  tranOutObj = (HWSLPG00Out*) tranInObj->execute();
  msg = IMSWEButl::handle_error(tranOutObj);

  if ( msg )
  {
      throw IBOIMException::IDataObjectFailed("IMS/OTMA Adapter Sample",
                                               0,0,"PBEPO::update",msg);
  }
  else if ( tranOutObj->getMSG() )
    {
      if (!strncmp(tranOutObj->getMSG(), "SPECIFIED PERSON WAS NOT FOUND", 30))
      {
        throw IBOIMException::IDataKeyNotFound();
      }
    }

  delete tranOutObj;
}


void PBEPO::del()
{

  HWSLPG00Out *tranOutObj = NULL;
  char        *msg = NULL;

  tranInObj->setCMD("DELETE");
  tranOutObj = (HWSLPG00Out*) tranInObj->execute();
  msg = IMSWEButl::handle_error(tranOutObj);

  if ( msg )
  {
      throw IBOIMException::IDataObjectFailed("IMS/OTMA Adapter Sample",
                                               0,0,"PBEPO::del",msg);
  }
  else if ( tranOutObj->getMSG() )
    {
      if (!strncmp(tranOutObj->getMSG(),"SPECIFIED PERSON WAS NOT FOUND", 30))
        {
          throw IBOIMException::IDataKeyNotFound();
        }
    }

  delete tranOutObj;
}

#endif
