/********************************************************************/
/*                                                                  */
/* Licensed Materials - Property of IBM                             */
/*                                                                  */
/* US Government Users Restricted Rights - Use, duplication or      */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.*/
/*                                                                  */
/* OCO Source Materials                                             */
/*                                                                  */
/* IBM IMS TCP/IP OTMA Connection, Version 2, Release 1             */
/* (C) Copyright IBM Corp. 1997, 1998.  All Rights Reserved.        */
/*                                                                  */
/* The source code for this program is not published or otherwise   */
/* divested of its trade secrets, irrespective of what has been     */
/* deposited with the U.S. Copyright Office.                        */
/*                                                                  */
/********************************************************************/

// TCPIP OTMA Adapter Client
#ifndef TCPOTMA_HPP
#define TCPOTMA_HPP

#include "hws.h"
#include "hwscnvtr.hpp"
#include <stdio.h>
#include <stdlib.h>

#ifdef HWSNT4
   #include <winsock.h>
   #define  HWSerrno  (int)WSAGetLastError()
   #define  HWSperror psock_errno
   #define  HWSCloseSocket  closesocket
#endif

#ifdef HWSOS2
   #include <types.h>
   #include <netinet\in.h>
   #include <sys\socket.h>
   #include <netdb.h>
   #define  HWSerrno  sock_errno()
   #define  HWSperror psock_errno
   #define  HWSCloseSocket  soclose
#endif

#ifdef HWSAIX
   #include <unistd.h>
   #include <sys/types.h>
   #include <sys/errno.h>
   #include <netinet/in.h>
   #include <sys/socket.h>
   #include <netdb.h>
   #define  HWSerrno  errno
   #define  HWSperror perror
   #define  HWSCloseSocket  close
#endif

#ifdef HWSSUN
   #include <unistd.h>
   #include <sys/types.h>
   #include <errno.h>
   #include <netinet/in.h>
   #include <sys/socket.h>
   #include <netdb.h>
   #define  TRUE  1
   #define  FALSE 0
   #define  HWSerrno  errno
   #define  HWSperror perror
   #define  HWSCloseSocket  close
#endif

#ifdef HWS390
   #include <unistd.h>
   #include <sys/types.h>
   #include <errno.h>
   #include <netinet/in.h>
   #include <sys/socket.h>
   #include <netdb.h>
   #include <arpa/inet.h>
   #define  TRUE  1
   #define  FALSE 0
   #define  HWSerrno  errno
   #define  HWSperror perror
   #define  HWSCloseSocket  close
#endif

class HWSError;
class Conversion;

class DllExport TcpOtma {

public:

   TcpOtma(HWSConverter * cObj);
   ~TcpOtma();
   int   openCon(HWSError *errStruc, char* hostname, char* port);
   void  closeCon();
   int   sendIn(HWSError *errStruc, char* msgtosend,unsigned short msglen);
   char* recvOut(HWSError *errStruc);

private:

   HWSConverter     * convObj;
   int sockStarted;
   int sockOpen;

 #ifdef HWSNT4
   WORD wVersionRequested;
   WSADATA wsaData;
 #endif

   struct hostent      *hostnm;
   struct sockaddr_in   server;
   int      s;

};

#endif
