/********************************************************************/
/*                                                                  */
/* Licensed Materials - Property of IBM                             */
/*                                                                  */
/* US Government Users Restricted Rights - Use, duplication or      */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.*/
/*                                                                  */
/* OCO Source Materials                                             */
/*                                                                  */
/* IBM IMS TCP/IP OTMA Connection, Version 2, Release 1             */
/* (C) Copyright IBM Corp. 1997, 1998.  All Rights Reserved.        */
/*                                                                  */
/* The source code for this program is not published or otherwise   */
/* divested of its trade secrets, irrespective of what has been     */
/* deposited with the U.S. Copyright Office.                        */
/*                                                                  */
/********************************************************************/
#ifndef HWSMSGF_HPP
#define HWSMSGF_HPP

#include "hwsmsg.hpp"

class HWSError;
class HWSLNode;
class HWSDList;
class HWSLPageFormat;
class HWSConverter;

//  The HWSMsgFormat class inherits from the HWSMsgDesc class to inherit
//  all the information about the message descriptor.
//  HWSMsgFormat enhances the parent class by providing methods to format
//  the messages.
class DllExport HWSMsgFormat : public HWSMsgDesc {

  // Public access
  public:

     // Member functions
     HWSMsgFormat(char *mName, MSGOption mOption, MSGType mType);
     ~HWSMsgFormat();               // Destructor.

     // Error code range:           1100-1199
     // Internal error code range:  9100-9199

     // This method will iterate through all the LPages using the input
     // first segment to find the right LPage to use to format the message.
     HWSLPageFormat *getLPagebyCOND( HWSError     *errStruc,
                                     HWSLNode     *segment,
                                     HWSConverter *convObj );

     HWSDList  *formatIn( HWSError *errStruc, HWSDList *fldList, HWSConverter *convObj );

     // The returned field list contains all the fields that are
     // attributes of the message output class.
     // There could be more than one set of the fields in the list.
     HWSDList  *formatOut( HWSError *errStruc, HWSDList *segList, HWSConverter *convObj );


};

#endif
