/**********************************************************************/
/*                                                                    */
/* (C) Copyright IBM Corp. 1994                                       */
/* All Rights Reserved                                                */
/* Licensed Materials - Property of IBM                               */
/*                                                                    */
/**********************************************************************/
/*--------------------------------------------------------------------*/
/*                                                                    */
/* Change History:                                                    */
/*                                                                    */
/* 08\19\97  JEH   R210 Conversational processing                     */
/*                 - added TRANType.                                  */
/*                                                                    */
/* 03/19/98  JEH   PTM2338 - added support for encryption exits.      */
/*                                                                    */
/*--------------------------------------------------------------------*/
#ifndef HWSMFS_HPP
#define HWSMFS_HPP

#include "hwsmsg.hpp"


#define HWSMFS_MULTIPLE_MIDS     1001



//  Class HWSMFSDesc is a base class which represents an MFS
//  format set associated with a given transaction.
//  It contains MIDs and MODs that are used by the transaction.

class DllExport HWSMFSDesc {

  // Public access
  public:

     // Member functions
     HWSMFSDesc();                  // Constructor.
     ~HWSMFSDesc();                 // Destructor.

     //  Add the passed input message descriptor as the
     //  MID attribute.
     int addMID( HWSMsgDesc *MID );

     //  Add the passed output message descriptor to the
     //  MOD chain.
     int addMOD( HWSMsgDesc *MOD );


     //  Finds the right MOD in the MOD chain and returns the MOD.
     //  If the MOD by the specified name does not exist, NULL is returned.
     HWSMsgDesc *getMODbyName(char *name);

     //  Finds the right MID in the MID chain and returns the MID.
     //  If the MID by the specified name does not exist, NULL is returned.
     HWSMsgDesc *getMIDbyName(char *name);

     char *getNextInLPageName(char *name);

     // Data members
     HWSMsgDesc    *firstMID;       // Message input descriptior.
     HWSMsgDesc    *firstMOD;       // First in chain of message output
                                    // descriptors.
     CONVType   convType;           // Conversion type

     IWebVers   verLevel;
     IWebFmt    forLevel;

     TRANType   tranType;           // Transaction type (conversational or not).
     SYNCLevel  syncLevel;          // Synchronization level (ACK/NACK req'd or not).
     PASSDATAType passDataType;     // Type of user authentication data. PTM2338

};
#endif
