/********************************************************************/
/*                                                                  */
/* Licensed Materials - Property of IBM                             */
/*                                                                  */
/* US Government Users Restricted Rights - Use, duplication or      */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.*/
/*                                                                  */
/* OCO Source Materials                                             */
/*                                                                  */
/* IBM IMS TCP/IP OTMA Connection, Version 2, Release 1             */
/* (C) Copyright IBM Corp. 1997, 1998.  All Rights Reserved.        */
/*                                                                  */
/* The source code for this program is not published or otherwise   */
/* divested of its trade secrets, irrespective of what has been     */
/* deposited with the U.S. Copyright Office.                        */
/*                                                                  */
/********************************************************************/
#ifndef HWSETCPE_H
#define HWSETCPE_H

/******************************************************************/
/* TcpOtma Component External Error Definition                    */
/* 2700 - 2799                                                    */
/******************************************************************/
/*--------------------------------------------------------------------*/
/* IMSClient class external error messages mapped from TCPOTMA        */
/* external error messages:                                           */
/*--------------------------------------------------------------------*/

#define HWSC_COME_TCPIP_O         2700
#define HWSC_COME_TCPIP_O_S       "The TCP/IP network has returned an error during open."
// Explanation: The method which opens a connection to IMS TCP/IP OTMA Connection received
//              an error from the TCP/IP network.
// User Action: Examine the Diagnostic Information for further information about the cause of the
//              failure.  For example, "Host not found" indicates that the TCP/IP hostname in the
//              CGI-Bin program or transaction DLL is not known to TCP/IP; "The request timed out"
//              may indicate that the hostname is valid but TCP/IP on the host has not been started.
//              If the problem persists after corrective action based on the Diagnostic Information,
//              record the Diagnostic Information and report the problem to your network administrator.

#define HWSC_COME_TCPIP_C         2701
#define HWSC_COME_TCPIP_C_S       "The TCP/IP network has returned an error during close."
// Explanation: The method which closes a connection to IMS TCP/IP OTMA Connection received
//              an error from the TCP/IP network.
// User Action: Examine the Diagnostic Information for further information about the cause of the
//              failure.  If the problem persists after corrective action based on the Diagnostic Information,
//              record the Diagnostic Information and report the problem to your network administrator.

#define HWSC_COME_TCPIP_S         2702
#define HWSC_COME_TCPIP_S_S       "The TCP/IP network has returned an error during send."
// Explanation: The method which sends a message to IMS TCP/IP OTMA Connection received
//              an error from the TCP/IP network.
// User Action: Examine the Diagnostic Information for further information about the cause of the
//              failure.  If the problem persists after corrective action based on the Diagnostic Information,
//              record the Diagnostic Information and report the problem to your network administrator.

#define HWSC_COME_TCPIP_R         2703
#define HWSC_COME_TCPIP_R_S       "The TCP/IP network has returned an error during receive."
// Explanation: The method which receives a message from IMS TCP/IP OTMA Connection received
//              an error from the TCP/IP network.
// User Action: Examine the Diagnostic Information for further information about the cause of the
//              failure.  If the problem persists after corrective action based on the Diagnostic Information,
//              record the Diagnostic Information and report the problem to your network administrator.

#endif
