/********************************************************************/
/*                                                                  */
/* Licensed Materials - Property of IBM                             */
/*                                                                  */
/* US Government Users Restricted Rights - Use, duplication or      */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.*/
/*                                                                  */
/* OCO Source Materials                                             */
/*                                                                  */
/* IBM IMS TCP/IP OTMA Connection, Version 2, Release 1             */
/* (C) Copyright IBM Corp. 1997, 1998.  All Rights Reserved.        */
/*                                                                  */
/* The source code for this program is not published or otherwise   */
/* divested of its trade secrets, irrespective of what has been     */
/* deposited with the U.S. Copyright Office.                        */
/*                                                                  */
/********************************************************************/

#ifndef HWSCSTAT_H
#define HWSCSTAT_H

/*--------------------------------------------------------------------*/
/* Defines relating to ConvState object and DAT file.                 */
/*--------------------------------------------------------------------*/
#define  MAX_CONVID           8
#define  MAX_CONVIDP1         8
#define  MAX_CONVIDP1_LEFT    10
#define  MAX_CONVIDP1_RIGHT   10
#define  MAX_CONVIDP2         8
#define  MAX_CONVIDP2_LEFT    10
#define  MAX_CONVIDP2_RIGHT   10
#define  MAX_RUNAME           HWS_MAX_RUNAME    // PTM2303 - get from imsclnt.h
#define  MAX_DATETIME         10
#define  MAX_MILLISECS        3
#define  MAX_INLPGNM          10
#define  MAX_HWSTERM          7     /* Hidden field not in DAT file.   */
#define  MAX_HOSTNAME         HWS_MAX_HOSTNAME  // PTM2303 - get from imsclnt.h
#define  MAX_PORT             HWS_MAX_PORT      // PTM2303 - get from imsclnt.h
#define  MAX_DATASTORE        HWS_MAX_IMSNAME   // PTM2303 - get from imsclnt.h

/* Each field in the .DAT file is followed by 2 bytes (NL=CR/LF (X0D0A) */
#define  MAX_BUFFLEN          MAX_CONVID          + 2 +   \
                              MAX_CONVIDP1_LEFT   + 2 +   \
                              MAX_CONVIDP1_RIGHT  + 2 +   \
                              MAX_CONVIDP2_LEFT   + 2 +   \
                              MAX_CONVIDP2_RIGHT  + 2 +   \
                              MAX_RUNAME          + 2 +   \
                              MAX_DATETIME        + 2 +   \
                              MAX_MILLISECS       + 2 +   \
                              MAX_INLPGNM         + 2 +   \
                              MAX_HOSTNAME        + 2 +   \
                              MAX_PORT            + 2 +   \
                              MAX_DATASTORE       + 2



#endif  // HWSCSTAT_H
