/********************************************************************/
/*                                                                  */
/* Licensed Materials - Property of IBM                             */
/*                                                                  */
/* US Government Users Restricted Rights - Use, duplication or      */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.*/
/*                                                                  */
/* OCO Source Materials                                             */
/*                                                                  */
/* IBM IMS TCP/IP OTMA Connection, Version 2, Release 1             */
/* (C) Copyright IBM Corp. 1997, 1998.  All Rights Reserved.        */
/*                                                                  */
/* The source code for this program is not published or otherwise   */
/* divested of its trade secrets, irrespective of what has been     */
/* deposited with the U.S. Copyright Office.                        */
/*                                                                  */
/********************************************************************/

/*--------------------------------------------------------------------*/
/* HWSCMD.H                                                           */
/*                                                                    */
/* Change History:                                                    */
/*                                                                    */
/* 09/15/97  Theresa Lai Created.                                     */
/*                                                                    */
/*--------------------------------------------------------------------*/

#ifndef HWSCMD_H
#define HWSCMD_H

/*--------------------------------------------------------------------*/
/* Text of command format errors:                                     */
/*--------------------------------------------------------------------*/
#define  BAD_HWSCMD_PARM_NO        "Incorrect number of parameters for HWSCMD.\n"
#define  BAD_HWSCMD_FMT            "Invalid command parameter for HWSCMD.\n"
#define  CMD_FMT_ARE               "Syntax of HWSCMD commands are:\n\n"
#define  TRACE_CMD_FMT_IS          "Format of TRACE command is:\n\n"
#define  DISPLAY_CMD_FMT_IS        "Formats of DISPLAY command are:\n\n"
#define  EXIT_CMD_FMT_IS           "Formats of EXIT command are:\n\n"

#define  HWSTRACE_FMT              "HWSCMD TRACE ON|OFF program_name\n\n      where:\n      ON            is a keyword parameter used to start tracing,\n      OFF           is a keyword parameter used to end tracing,\n      program_name  is the name of the CGI-BIN program or\n                    Net.Data transaction DLL being traced.\n\n\n"
#define  HWSDISPLAY_FMT            "HWSCMD DISPLAY CONV ALL,       or\nHWSCMD DISPLAY CONV convTokn,  or\nHWSCMD DISPLAY CONV GTmmm\n\n      where:\n      CONV      is a required keyword for conversations,\n      ALL       is a keyword designates all active conversations,\n      convTokn  is a parameter which identifies a specific conversation,\n      GTmmm     is a parameter that identifies conversations whose age, \n                the length of time since the last response \n                was received from the host, is greater than (GT)\n                the user specified time interval mmm in minutes.\n\n\n"
#define  HWSEXIT_FMT               "HWSCMD EXIT [CONV] convTokn,    or\nHWSCMD EXIT [CONV] GTmmm,       or\nHWSCMD EXIT convTokn,           or\nHWSCMD EXIT GTmmm\n\n      where:\n      CONV      is an optional keyword for conversational transactions,\n      convTokn  is a parameter which identifies a specific conversation,\n      GTmmm     is a parameter that identifies conversations whose age, \n                the length of time since the last response \n                was received from the host, is greater than (GT)\n                the user specified time interval mmm in minutes.\n\n\n"
#define  TRACE_SYNTAX_ERR          "HWSCMD TRACE syntax error, or invalid parameter is entered.\n"
#define  DISPLAY_SYNTAX_ERR        "HWSCMD DISPLAY syntax error, or invalid parameter is entered.\n"
#define  EXIT_SYNTAX_ERR           "HWSCMD EXIT syntax error, or invalid parameter is entered.\n"
#define  INTERNAL_ERR_FOUND        "Internal error found." 
#define  ERR_DEL_CONNECTION        "                   An error occurred while attempting to send\n                   an 'Exit Conversation' request to the host\n                   for conversation "
#define  HWSCMD_SPELL_ERR          "Invalid HWSCMD specified."

#define  HWSCMD_ERR                "Error executing HWSCMD command.\n\n"
#define  HWSTRACE_ERR              "Error executing HWSCMD TRACE.\n\n"
#define  HWSDISPLAY_ERR            "Error executing HWSCMD DISPLAY.\n\n"
#define  HWSEXIT_ERR               "Error executing HWSCMD EXIT.\n\n"

#define  HWSCMD_DONE               "Processing completed for "
#define  HWSTRACE_ON               "Trace turned on for "
#define  HWSTRACE_OFF              "Trace turned off for "


#endif



