#ifndef CONVERSN_H
#define CONVERSN_H

/*--------------------------------------------------------------------*/
/* Defines, etc. for Conversion class.                                */
/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
/* Miscellaneous defines.                                             */
/*--------------------------------------------------------------------*/


#define  ZERO                      0
#define  NUM_CHAR                  1
#define  MAX_LEN                   13
#define  RANGE_NUM                 4

#define  SO                        0x0E
#define  SI                        0x0F
#define  DBCS_LEN                  2
#define  FST_BYTE                  0
#define  SND_BYTE                  1

/* Conversion methods.                                                */
#define  PURESBCS                  1
#define  PUREDBCS                  2
#define  HOSTTOPCMIXED             3
#define  PCTOHOSTMIXED             4

/*--------------------------------------------------------------------*/
/* Structures.                                                        */
/*--------------------------------------------------------------------*/

struct TconvIDTable
{
   unsigned short fromCCSID; /* From CCSID  (source)                 */
   unsigned short toCCSID;   /* To   CCSID  (target)                 */
   unsigned short conversionMethod; /*Conversion Method indicator    */
   char dtbl[MAX_LEN];       /* DBCS Conversion Table file name      */
   unsigned long dsize;      /* DBCS Conversion Table file size      */
   char stbl[MAX_LEN];       /* SBCS Conversion Table file name      */
   unsigned long ssize;      /* SBCS Conversion Table file size      */
   char htbl[MAX_LEN];       /* Header Table file name               */
   unsigned long hsize;      /* Header Table file size               */
};

struct TconvTableInfo
{
   unsigned long cvid;   /* Conversion ID                            */
   char * PBDTbl;        /* Pointer to DBCS table buffer             */
   char * PBSTbl;        /* Pointer to SBCS table buffer             */
   char * PBHTbl;        /* Pointer to Header table buffer           */
};

typedef struct lngStructure {
   char          *langStr;          /* Language string.               */
   char          *langTbl;          /* Name of file containing        */
                                    /* conversion information.        */
   int           hostCCSID;         /* CCSID for host user data.      */
   int           servCCSID;         /* CCSID for server user data.    */
   int           ctlHostCCSID;      /* CCSID for host control data.   */
   int           ctlServCCSID;      /* CCSID for server control data. */
   char          *dbcsBlank;        /* Double byte blank.             */
}  lng;


#endif
