/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt.util;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ResourceBundle;
import symantec.itools.awt.util.ToolBarPanel;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;
import symantec.itools.resources.ErrorsBundle;

public class ToolBarSpacer
extends Canvas {
    protected int space = 10;
    protected transient ResourceBundle errors;
    private Veto veto;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public void setSpace(int value) throws PropertyVetoException {
        if (this.space != value) {
            Integer oldValue = new Integer(this.space);
            Integer newValue = new Integer(value);
            this.vetos.fireVetoableChange("Space", oldValue, newValue);
            this.space = value;
            this.changes.firePropertyChange("Space", oldValue, newValue);
        }
    }

    public int getSpace() {
        return this.space;
    }

    public synchronized Dimension getPreferredSize() {
        Container parent = this.getParent();
        if (parent != null) {
            parent = parent.getParent();
        }
        if (parent != null && parent instanceof ToolBarPanel) {
            Dimension s = new Dimension(0, 0);
            Component[] list = ((ToolBarPanel)parent).getComponents();
            switch (((ToolBarPanel)parent).getOrientation()) {
                case 0: {
                    s.width = this.space;
                    int i = 0;
                    while (i < list.length) {
                        Component c = list[i];
                        if (!(c instanceof ToolBarSpacer)) {
                            s.height = Math.max(s.height, c.size().height);
                        }
                        ++i;
                    }
                    break;
                }
                case 1: {
                    s.height = this.space;
                    int i = 0;
                    while (i < list.length) {
                        Component c = list[i];
                        if (!(c instanceof ToolBarSpacer)) {
                            s.width = Math.max(s.width, c.size().width);
                        }
                        ++i;
                    }
                    break;
                }
            }
            return s;
        }
        return new Dimension(10, 10);
    }

    public synchronized Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public synchronized Dimension getMinimumSize() {
        return this.preferredSize();
    }

    public synchronized Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public boolean isValidSpace(int spaceSize) {
        return spaceSize >= 0;
    }

    public synchronized void addNotify() {
        super.addNotify();
        try {
            this.errors = ResourceBundle.getBundle("symantec.itools.resources.ErrorsBundle");
        }
        catch (Throwable throwable) {
            this.errors = new ErrorsBundle();
        }
        if (this.veto == null) {
            this.veto = new Veto();
            this.addSpaceListener(this.veto);
        }
    }

    public synchronized void removeNotify() {
        if (this.veto != null) {
            this.removeSpaceListener(this.veto);
            this.veto = null;
        }
        super.removeNotify();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener(listener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener(listener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener(listener);
    }

    public synchronized void addSpaceListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener("Space", listener);
    }

    public synchronized void removeSpaceListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener("Space", listener);
    }

    public synchronized void addSpaceListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener("Space", listener);
    }

    public synchronized void removeSpaceListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener("Space", listener);
    }

    class Veto
    implements VetoableChangeListener {
        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            int i = (Integer)e.getNewValue();
            if (!ToolBarSpacer.this.isValidSpace(i)) {
                throw new PropertyVetoException(String.valueOf(ToolBarSpacer.this.errors.getString("InvalidSpace")) + i, e);
            }
        }

        Veto() {
            ToolBarSpacer.this = ToolBarSpacer.this;
        }
    }
}

