/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt.shape;

import java.awt.Graphics;
import symantec.itools.awt.shape.Shape;

public class Ellipse
extends Shape {
    public boolean contains(int x, int y) {
        if (!super.contains(x, y)) {
            return false;
        }
        double a = (double)this.width / 2.0;
        double b = (double)this.height / 2.0;
        double dx = ((double)x - a) * ((double)this.height / (double)this.width);
        double dy = (double)y - b;
        return this.fill ? dx * dx + dy * dy <= b * b : Math.abs(dx * dx + dy * dy + 30.0 - b * b) < 60.0;
    }

    public void paint(Graphics g) {
        super.paint(g);
        g.clipRect(0, 0, this.width, this.height);
        int w = this.width - 1;
        int h = this.height - 1;
        switch (this.style) {
            case 2: {
                if (this.fill) {
                    g.setColor(this.fillColor);
                    g.fillOval(0, 0, this.width, this.height);
                }
                g.setColor(this.getForeground());
                g.drawOval(0, 0, w, h);
                break;
            }
            case 0: {
                if (this.fill) {
                    g.setColor(this.fillColor);
                    g.fillOval(0, 0, this.width, this.height);
                }
                g.setColor(this.bevelDarkerColor);
                g.drawArc(0, 0, w, h, 45, 180);
                g.setColor(this.bevelLighterColor);
                g.drawArc(0, 0, w, h, 225, 180);
                break;
            }
            case 1: {
                if (this.fill) {
                    g.setColor(this.fillColor);
                    g.fillOval(0, 0, this.width, this.height);
                }
                g.setColor(this.bevelLighterColor);
                g.drawArc(0, 0, w, h, 45, 180);
                g.setColor(this.bevelDarkerColor);
                g.drawArc(0, 0, w, h, 225, 180);
                break;
            }
            default: {
                if (this.fill) {
                    g.setColor(this.fillColor);
                    g.fillOval(0, 0, this.width, this.height);
                    break;
                }
                g.setColor(this.getForeground());
                g.drawOval(0, 0, w, h);
            }
        }
    }
}

