/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.Component;
import java.beans.Beans;
import java.util.Vector;
import symantec.itools.awt.WizardController;
import symantec.itools.awt.WizardInterface;

public class SimpleWizardController
implements WizardController {
    protected WizardInterface wizard;
    protected Vector stack = new Vector();
    protected int previousPageIndex = -1;
    protected int nextPageIndex = -1;
    protected Component previousPage;
    protected Component nextPage;
    protected int previousEnabled = -1;
    protected int nextEnabled = -1;
    protected int finishEnabled = -1;
    protected int cancelEnabled = -1;
    protected int helpEnabled = -1;

    public SimpleWizardController(WizardInterface wizard) {
        this.wizard = wizard;
    }

    public void doPrepare() {
    }

    public void preparePage(Component comp, int action) {
        if (Beans.isDesignTime()) {
            return;
        }
        if (action == 1) {
            this.stack.addElement(comp);
        } else if (action == 0 && this.stack.size() > 0) {
            this.stack.removeElementAt(this.stack.size() - 1);
        }
    }

    public void pageShown(Component comp) {
    }

    public boolean validatePage(Component comp, Component target, int action) {
        switch (action) {
            case 1: {
                return this.isNextEnabled();
            }
            case 0: {
                return this.isPreviousEnabled();
            }
            case 2: {
                return this.isFinishEnabled();
            }
            case 3: {
                return this.isCancelEnabled();
            }
            case 4: {
                return this.isHelpEnabled();
            }
        }
        return false;
    }

    public void pageHidden(Component comp) {
    }

    public void doFinish() {
    }

    public void doCancel() {
    }

    public void doHelp() {
    }

    public boolean isPreviousEnabled() {
        if (this.previousEnabled == 0) {
            return false;
        }
        if (this.previousEnabled == 1) {
            return true;
        }
        return this.getPreviousPage() != null;
    }

    public boolean isNextEnabled() {
        if (this.nextEnabled == 0) {
            return false;
        }
        if (this.nextEnabled == 1) {
            return true;
        }
        return this.getNextPage() != null;
    }

    public boolean isFinishEnabled() {
        if (this.finishEnabled == 0) {
            return false;
        }
        if (this.finishEnabled == 1) {
            return true;
        }
        int current = this.wizard.getSelectedIndex();
        int count = this.wizard.getPageCount();
        return !Beans.isDesignTime() ? (count > 0 && current != -1 ? current == count - 1 : false) : false;
    }

    public boolean isCancelEnabled() {
        if (this.cancelEnabled == 0) {
            return false;
        }
        if (this.cancelEnabled == 1) {
            return true;
        }
        return !Beans.isDesignTime();
    }

    public boolean isHelpEnabled() {
        if (this.helpEnabled == 0) {
            return false;
        }
        if (this.helpEnabled == 1) {
            return true;
        }
        return !Beans.isDesignTime();
    }

    public Component getPreviousPage() {
        if (!Beans.isDesignTime()) {
            return this.previousPage != null ? this.previousPage : (this.previousPageIndex != -1 ? this.wizard.getComponentAt(this.previousPageIndex) : (this.stack.size() > 1 ? (Component)this.stack.elementAt(this.stack.size() - 2) : null));
        }
        int current = this.wizard.getSelectedIndex();
        int count = this.wizard.getPageCount();
        return count > 0 && current > 0 ? this.wizard.getComponentAt(current - 1) : null;
    }

    public Component getNextPage() {
        int current = this.wizard.getSelectedIndex();
        int count = this.wizard.getPageCount();
        return !Beans.isDesignTime() ? (this.nextPage != null ? this.nextPage : (this.nextPageIndex != -1 ? this.wizard.getComponentAt(this.nextPageIndex) : (count > 0 && current != -1 && current != count - 1 ? this.wizard.getComponentAt(current + 1) : (count > 0 && current == -1 ? this.wizard.getComponentAt(0) : null)))) : (count > 0 && current != -1 && current != count - 1 ? this.wizard.getComponentAt(current + 1) : null);
    }

    public void setPreviousPageIndex(int index) {
        this.previousPageIndex = index;
    }

    public void setNextPageIndex(int index) {
        this.nextPageIndex = index;
    }

    public void setPreviousPage(Component comp) {
        this.previousPage = comp;
    }

    public void setNextPage(Component comp) {
        this.nextPage = comp;
    }

    public void setPreviousEnabled(boolean status) {
        this.previousEnabled = status ? 1 : 0;
        this.wizard.updateButtonsState();
    }

    public void setNextEnabled(boolean status) {
        this.nextEnabled = status ? 1 : 0;
        this.wizard.updateButtonsState();
    }

    public void setFinishEnabled(boolean status) {
        this.finishEnabled = status ? 1 : 0;
        this.wizard.updateButtonsState();
    }

    public void setCancelEnabled(boolean status) {
        this.cancelEnabled = status ? 1 : 0;
        this.wizard.updateButtonsState();
    }

    public void setHelpEnabled(boolean status) {
        this.helpEnabled = status ? 1 : 0;
        this.wizard.updateButtonsState();
    }

    public void resetChainInfo() {
        this.previousPage = null;
        this.previousPageIndex = -1;
        this.nextPage = null;
        this.nextPageIndex = -1;
        this.previousEnabled = -1;
        this.nextEnabled = -1;
        this.finishEnabled = -1;
        this.cancelEnabled = -1;
        this.helpEnabled = -1;
    }
}

