/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Event;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import symantec.itools.awt.util.Util;

public class KeyPressManagerPanel
extends Panel
implements Serializable {
    protected Button defaultButton;
    protected Button cancelButton;
    protected A action = new A();
    protected K key = new K();

    public KeyPressManagerPanel() {
        super.setLayout(null);
        this.resetKeyManager();
    }

    public void resetKeyManager() {
        this.removeDefaultButton();
        this.removeCancelButton();
    }

    public void setDefaultButton(Button button) {
        this.removeDefaultButton();
        this.defaultButton = button;
    }

    public void removeDefaultButton() {
        this.defaultButton = null;
    }

    public void setDefaultButton(Button button, Event evt, Container deliverTo, boolean bSetFocus) {
        this.setDefaultButton(button);
    }

    public void setCancelButton(Button button) {
        this.removeCancelButton();
        this.cancelButton = button;
    }

    public void removeCancelButton() {
        this.cancelButton = null;
    }

    public void setCancelButton(Button button, Event evt, Container deliverTo, boolean bSetFocus) {
        this.setCancelButton(this.cancelButton);
    }

    protected void addImpl(Component component, Object constraints, int index) {
        this.componentAdded(component);
        super.addImpl(component, constraints, index);
    }

    public void remove(int index) {
        this.componentRemoved(this.getComponent(index));
        super.remove(index);
    }

    public void removeAll() {
        Component[] components = this.getComponents();
        int i = 0;
        while (i < components.length) {
            this.componentRemoved(components[i]);
            ++i;
        }
        super.removeAll();
    }

    protected boolean sendAction(Button button) {
        if (button != null && button.isEnabled()) {
            button.requestFocus();
            button.dispatchEvent(new ActionEvent(button, 1001, new String(button.getLabel())));
            return true;
        }
        return false;
    }

    protected boolean consumeKeyTyped(KeyEvent evt) {
        switch (evt.getKeyCode()) {
            case 10: {
                return this.sendAction(this.defaultButton);
            }
            case 27: {
                return this.sendAction(this.cancelButton);
            }
            case 9: {
                return this.handleTabEvent(evt);
            }
        }
        return false;
    }

    protected boolean handleTabEvent(KeyEvent evt) {
        Component[] ca = this.getComponents();
        Component lastTraversable = null;
        int i = ca.length - 1;
        do {
            if (ca[i].isFocusTraversable()) {
                lastTraversable = ca[i];
                continue;
            }
            --i;
        } while (!ca[i].isFocusTraversable() && i >= 0);
        if (lastTraversable == null) {
            return false;
        }
        if ((evt.getModifiers() & 2) == 2) {
            lastTraversable.transferFocus();
            return true;
        }
        if (evt.getComponent() == lastTraversable) {
            i = 0;
            while (i < ca.length) {
                if (ca[i].isFocusTraversable()) {
                    ca[i].requestFocus();
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected void componentAdded(Component component) {
        if (Util.findComponent(this, component) != -1) {
            return;
        }
        if (component instanceof TextField) {
            TextField textField = (TextField)component;
            textField.addActionListener(this.action);
        }
        if (!component.getClass().getName().equals("symantec.itools.db.awt.Grid")) {
            component.addKeyListener(this.key);
        }
    }

    protected void componentRemoved(Component component) {
        if (Util.findComponent(this, component) == -1) {
            return;
        }
        if (component instanceof TextField) {
            TextField textField = (TextField)component;
            textField.removeActionListener(this.action);
        }
        if (!component.getClass().getName().equals("symantec.itools.db.awt.Grid")) {
            component.removeKeyListener(this.key);
        }
    }

    class A
    implements ActionListener,
    Serializable {
        public void actionPerformed(ActionEvent evt) {
            KeyPressManagerPanel.this.sendAction(KeyPressManagerPanel.this.defaultButton);
        }

        A() {
            KeyPressManagerPanel.this = KeyPressManagerPanel.this;
        }
    }

    class K
    extends KeyAdapter
    implements Serializable {
        public void keyPressed(KeyEvent evt) {
            if (KeyPressManagerPanel.this.consumeKeyTyped(evt)) {
                evt.consume();
            }
        }

        K() {
            KeyPressManagerPanel.this = KeyPressManagerPanel.this;
        }
    }
}

