/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import symantec.itools.awt.ListItem;
import symantec.itools.awt.util.ColorUtils;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;
import symantec.itools.lang.OS;
import symantec.itools.resources.ErrorsBundle;
import symantec.itools.util.GeneralUtils;

public class ImageListBox
extends Panel
implements ItemSelectable {
    public static final int EVT_IMAGE_SELECT = 16388;
    public static final int BORDER_REGULAR = 0;
    public static final int BORDER_NONE = 1;
    public static final int IMAGE_WIDTH = 19;
    protected int nTopRow;
    protected int lWidth;
    protected int cellHt;
    protected int yAdj;
    protected int borderWidth = 4;
    protected int halfBorderWidth = 2;
    ActionListener actionListener;
    ItemListener itemListener;
    protected final int LINE_SLOP = 6;
    protected String ilbLabel;
    protected Scrollbar VBar;
    protected Scrollbar HBar;
    protected Vector items;
    protected Font font;
    protected transient FontMetrics fm;
    protected transient boolean bAllDirty = true;
    protected boolean bMultipleSelections = false;
    protected boolean bBlockPaint = false;
    protected boolean bVBarVisible = false;
    protected boolean bHBarVisible = false;
    protected transient boolean bInternalBlockPaint = false;
    protected int rowsToShow = -1;
    protected int colsToShow = 10;
    protected transient int visibleRows = -1;
    protected transient int visibleCols = -1;
    protected int visibleIndex = -1;
    protected transient int fontHeight;
    protected transient int fontDescent;
    protected transient int lastDownModifiers = -1;
    protected transient int lastSelected = -1;
    protected transient int lastIndex = -1;
    protected transient int lastTempIndex = -1;
    protected transient int countSelected;
    protected int borderType;
    protected int longestLineValue;
    protected transient int barSize;
    protected int xCoord;
    protected transient long prevSelectTime = -1L;
    protected transient long prevSelectRow = -1L;
    protected boolean bComboMode = false;
    protected boolean bCellBorders = false;
    protected boolean bAllowShowVBar = true;
    protected boolean bAllowShowHBar = true;
    protected Color borderLighterColor;
    protected Color borderDarkerColor;
    protected Color borderLightColor;
    protected Color borderDarkColor;
    protected Color cachedBackground;
    protected Color textHighlight = OS.isMacintosh() ? new Color(0, 0, 128) : SystemColor.textHighlight;
    protected Color textHighlightText = OS.isMacintosh() ? Color.white : SystemColor.textHighlightText;
    protected Color enabledColor = OS.isMacintosh() ? Color.black : SystemColor.textText;
    protected Color disabledColor = OS.isMacintosh() ? Color.gray : SystemColor.textInactiveText;
    protected int fastDownCount;
    protected boolean bMouseDrawHandled = false;
    protected transient ResourceBundle errors;
    private Mouse mouse;
    private MouseMotion mouseMotion;
    private Key key;
    private Adjustment adjustment;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public ImageListBox() {
        this("", -1, false);
    }

    public ImageListBox(String label) {
        this(label, -1, false);
    }

    public ImageListBox(String label, boolean bMultipleSelections) {
        this(label, -1, bMultipleSelections);
    }

    public ImageListBox(String slabel, int rows, boolean bMultipleSelections) {
        this.items = new Vector();
        this.ilbLabel = slabel;
        this.rowsToShow = rows;
        this.bMultipleSelections = bMultipleSelections;
        this.setLayout(null);
        this.VBar = new Scrollbar();
        this.VBar.setBackground(Color.lightGray);
        this.VBar.hide();
        this.add(this.VBar);
        this.HBar = new Scrollbar(0);
        this.HBar.setBackground(Color.lightGray);
        this.HBar.hide();
        this.add(this.HBar);
        this.cachedBackground = this.getBackground();
    }

    public ImageListBox(Component parent, String slabel, int rows, boolean bMultipleSelections) {
        this(slabel, rows, bMultipleSelections);
    }

    public ImageListBox(Component parent, String label) {
        this(label);
    }

    public void setComboMode(boolean cond) throws PropertyVetoException {
        if (this.bComboMode != cond) {
            Boolean oldValue = new Boolean(this.bComboMode);
            Boolean newValue = new Boolean(cond);
            this.vetos.fireVetoableChange("ComboMode", oldValue, newValue);
            this.bComboMode = cond;
            this.yAdj = 3;
            this.invalidate();
            this.changes.firePropertyChange("ComboMode", oldValue, newValue);
        }
    }

    public boolean isComboMode() {
        return this.bComboMode;
    }

    public boolean getComboMode() {
        return this.isComboMode();
    }

    public void setRowsToShow(int rows) throws PropertyVetoException {
        if (this.rowsToShow != rows) {
            Integer oldValue = new Integer(this.rowsToShow);
            Integer newValue = new Integer(rows);
            this.vetos.fireVetoableChange("RowsToShow", oldValue, newValue);
            this.rowsToShow = rows;
            this.invalidate();
            this.changes.firePropertyChange("RowsToShow", oldValue, newValue);
        }
    }

    public int getRowsToShow() {
        return this.rowsToShow;
    }

    public void setShowVerticalScroll(boolean cond) throws PropertyVetoException {
        if (this.bAllowShowVBar != cond) {
            Boolean oldValue = new Boolean(this.bAllowShowVBar);
            Boolean newValue = new Boolean(cond);
            this.vetos.fireVetoableChange("ShowVerticalScroll", oldValue, newValue);
            this.bAllowShowVBar = cond;
            this.invalidate();
            this.changes.firePropertyChange("ShowVerticalScroll", oldValue, newValue);
        }
    }

    public boolean isShowVerticalScroll() {
        return this.bAllowShowVBar;
    }

    public boolean getShowVerticalScroll() {
        return this.isShowVerticalScroll();
    }

    public void setShowHorizontalScroll(boolean cond) throws PropertyVetoException {
        if (this.bAllowShowHBar != cond) {
            Boolean oldValue = new Boolean(this.bAllowShowHBar);
            Boolean newValue = new Boolean(cond);
            this.vetos.fireVetoableChange("ShowHorizontalScroll", oldValue, newValue);
            this.bAllowShowHBar = cond;
            this.invalidate();
            this.changes.firePropertyChange("ShowHorizontalScroll", oldValue, newValue);
        }
    }

    public boolean isShowHorizontalScroll() {
        return this.bAllowShowHBar;
    }

    public boolean getShowHorizontalScroll() {
        return this.isShowHorizontalScroll();
    }

    public void setBorderType(int type) throws PropertyVetoException {
        if (this.borderType != type) {
            Integer oldValue = new Integer(this.borderType);
            Integer newValue = new Integer(type);
            this.vetos.fireVetoableChange("BorderType", oldValue, newValue);
            this.borderType = type;
            if (type == 0) {
                this.borderWidth = 4;
                this.halfBorderWidth = 2;
            } else {
                this.borderWidth = 0;
                this.halfBorderWidth = 0;
            }
            this.invalidate();
            this.changes.firePropertyChange("BorderType", oldValue, newValue);
        }
    }

    public int getBorderType() {
        return this.borderType;
    }

    public void setCellBorder(int index, boolean bOn) throws PropertyVetoException {
        if (this.validIndex(index)) {
            ListItem li = (ListItem)this.items.elementAt(index);
            if (li.bCellBorder != bOn) {
                Boolean oldValue = new Boolean(li.bCellBorder);
                Boolean newValue = new Boolean(bOn);
                this.vetos.fireVetoableChange("CellBorder", oldValue, newValue);
                li.bCellBorder = bOn;
                li.bDirty = true;
                this.invalidate();
                this.changes.firePropertyChange("CellBorder", oldValue, newValue);
            }
        }
    }

    public void setCellBorders(boolean bOn) throws PropertyVetoException {
        if (this.bCellBorders != bOn) {
            Boolean oldValue = new Boolean(this.bCellBorders);
            Boolean newValue = new Boolean(bOn);
            this.vetos.fireVetoableChange("CellBorders", oldValue, newValue);
            this.bCellBorders = bOn;
            int s = this.items.size();
            ListItem li = null;
            int x = 0;
            while (x < s) {
                li = (ListItem)this.items.elementAt(x);
                li.bCellBorder = bOn;
                ++x;
            }
            this.bAllDirty = true;
            this.invalidate();
            this.changes.firePropertyChange("CellBorders", oldValue, newValue);
        }
    }

    public boolean isCellBorders() {
        return this.bCellBorders;
    }

    public boolean getCellBorders() {
        return this.isCellBorders();
    }

    public void setEnabledTextColor(int index, Color color) throws PropertyVetoException {
        ListItem tempItem;
        if (this.validIndex(index) && !GeneralUtils.objectsEqual(tempItem = (ListItem)this.items.elementAt(index), color)) {
            Color oldValue = tempItem.color;
            this.vetos.fireVetoableChange("EnabledTextColor", oldValue, color);
            tempItem.color = color;
            this.changes.firePropertyChange("EnabledTextColor", oldValue, color);
        }
    }

    public Color getEnabledTextColor(int index) {
        if (this.validIndex(index)) {
            ListItem tempItem = (ListItem)this.items.elementAt(index);
            return tempItem.color;
        }
        return null;
    }

    public synchronized void setMultiColumnMode(boolean bCellBorders) throws PropertyVetoException {
        if (this.isCellBorders() != bCellBorders) {
            this.setComboMode(false);
            this.setBorderType(1);
            this.setCellBorders(bCellBorders);
            this.yAdj = 2;
        }
    }

    public void setListItems(String[] items) throws PropertyVetoException {
        String[] oldValue = this.getListItems();
        this.vetos.fireVetoableChange("ListItems", oldValue, items);
        this.clear();
        int i = 0;
        while (i < items.length) {
            this.addItem(items[i]);
            ++i;
        }
        this.changes.firePropertyChange("ListItems", oldValue, items);
    }

    public String[] getListItems() {
        int len = this.countItems();
        String[] items = new String[len];
        int i = 0;
        while (i < len) {
            items[i] = this.getItem(i);
            ++i;
        }
        return items;
    }

    public void setEdited(int index, boolean bCond) throws PropertyVetoException {
        if (this.validIndex(index)) {
            ListItem tempItem = (ListItem)this.items.elementAt(index);
            if (tempItem.bEdited != bCond) {
                Boolean oldValue = new Boolean(tempItem.bEdited);
                Boolean newValue = new Boolean(bCond);
                this.vetos.fireVetoableChange("Edited", oldValue, newValue);
                tempItem.bEdited = bCond;
                this.changes.firePropertyChange("Edited", oldValue, newValue);
            }
        }
    }

    public boolean isEdited(int index) {
        if (this.validIndex(index)) {
            ListItem tempItem = (ListItem)this.items.elementAt(index);
            return tempItem.bEdited;
        }
        return false;
    }

    public boolean getEdited(int index) {
        return this.isEdited(index);
    }

    public void setMultipleSelections(boolean cond) throws PropertyVetoException {
        if (this.bMultipleSelections != cond) {
            Boolean oldValue = new Boolean(this.bMultipleSelections);
            Boolean newValue = new Boolean(cond);
            this.vetos.fireVetoableChange("MultipleSelections", oldValue, newValue);
            if (!cond) {
                this.deselectAll();
            }
            this.bMultipleSelections = cond;
            this.changes.firePropertyChange("MultipleSelections", oldValue, newValue);
        }
    }

    public boolean isMultipleSelections() {
        return this.bMultipleSelections;
    }

    public void setEnabled(int index, boolean cond) throws PropertyVetoException {
        if (this.validIndex(index)) {
            ListItem tempItem = (ListItem)this.items.elementAt(index);
            if (tempItem.bEnabled != cond) {
                Boolean oldValue = new Boolean(tempItem.bEnabled);
                Boolean newValue = new Boolean(cond);
                this.vetos.fireVetoableChange("Enabled", oldValue, newValue);
                tempItem.bEnabled = cond;
                if (!cond) {
                    this.deselect(index);
                }
                tempItem.bDirty = true;
                if (!this.bInternalBlockPaint) {
                    this.repaint();
                }
                this.changes.firePropertyChange("Enabled", oldValue, newValue);
            }
        }
    }

    public boolean isEnabled(int index) {
        if (this.validIndex(index)) {
            ListItem tempItem = (ListItem)this.items.elementAt(index);
            return tempItem.bEnabled;
        }
        return false;
    }

    public void setText(int index, String text) throws PropertyVetoException {
        ListItem tempItem;
        if (this.validIndex(index) && !GeneralUtils.objectsEqual(tempItem = (ListItem)this.items.elementAt(index), text)) {
            String oldValue = tempItem.sText;
            this.vetos.fireVetoableChange("Text", oldValue, text);
            tempItem.sText = text;
            tempItem.bDirty = true;
            tempItem.updateWidth(this.fm);
            this.updateWidth(tempItem);
            if (!this.bInternalBlockPaint) {
                this.repaint();
            }
            this.changes.firePropertyChange("Text", oldValue, text);
        }
    }

    public String getText(int index) {
        if (this.validIndex(index)) {
            return ((ListItem)this.items.elementAt((int)index)).sText;
        }
        return null;
    }

    public String getItem(int index) {
        return this.getText(index);
    }

    public void setImageURL(int index, URL aUrl) throws MalformedURLException, PropertyVetoException {
        if (this.validIndex(index)) {
            ListItem tempItem = (ListItem)this.items.elementAt(index);
            URL oldValue = tempItem.url;
            Image image = this.getToolkit().getImage(aUrl);
            if (image != null) {
                this.setImage(index, image);
            }
            tempItem.url = aUrl;
            this.changes.firePropertyChange("ImageURL", oldValue, aUrl);
        }
    }

    public URL getImageURL(int index) {
        if (this.validIndex(index)) {
            return ((ListItem)this.items.elementAt((int)index)).url;
        }
        return null;
    }

    public void setImage(int index, Image image) throws PropertyVetoException {
        ListItem tempItem;
        if (this.validIndex(index) && !GeneralUtils.objectsEqual(tempItem = (ListItem)this.items.elementAt(index), image)) {
            Image oldValue = tempItem.image;
            this.vetos.fireVetoableChange("Image", oldValue, image);
            tempItem.image = image;
            tempItem.bDirty = true;
            if (!this.bInternalBlockPaint) {
                this.repaint();
            }
            this.changes.firePropertyChange("Image", oldValue, image);
        }
    }

    public Image getImage(int index) {
        if (this.validIndex(index)) {
            return ((ListItem)this.items.elementAt((int)index)).image;
        }
        return null;
    }

    public synchronized void setSelectedItem(String str, boolean isSelected) throws PropertyVetoException {
        int z = this.items.size();
        int i = 0;
        while (i < z) {
            ListItem li = (ListItem)this.items.elementAt(i);
            if (GeneralUtils.objectsEqual(li.sText, str)) {
                String[] oldValue = this.getSelectedItems();
                Vector<String> tempVect = new Vector<String>(oldValue.length);
                int count = 0;
                while (count < oldValue.length) {
                    tempVect.insertElementAt(oldValue[count], count);
                    ++count;
                }
                if (isSelected) {
                    tempVect.addElement(li.sText);
                } else {
                    tempVect.removeElement(li.sText);
                }
                Object[] newValue = new String[tempVect.size()];
                tempVect.copyInto(newValue);
                this.vetos.fireVetoableChange("SelectedItems", oldValue, newValue);
                this.setSelectedIndex(i, isSelected);
                if (!this.bInternalBlockPaint) {
                    this.repaint();
                }
                this.changes.firePropertyChange("SelectedItems", oldValue, this.getSelectedItems());
                return;
            }
            ++i;
        }
    }

    public synchronized String getSelectedItem() {
        return this.lastSelected < 0 ? null : this.getItem(this.lastSelected);
    }

    public synchronized void setSelectedIndex(int index, boolean isSelected) throws PropertyVetoException {
        ListItem listItem = null;
        if (this.bMultipleSelections) {
            listItem = (ListItem)this.items.elementAt(index);
            int[] oldValue = this.getSelectedIndexes();
            Vector<Integer> tempVect = new Vector<Integer>(oldValue.length);
            int count = 0;
            while (count < oldValue.length) {
                tempVect.insertElementAt(new Integer(oldValue[count]), count);
                ++count;
            }
            if (isSelected) {
                tempVect.addElement(new Integer(index));
            } else {
                tempVect.removeElement(new Integer(index));
            }
            int[] newValue = new int[tempVect.size()];
            int count2 = 0;
            while (count2 < tempVect.size()) {
                newValue[count2] = (Integer)tempVect.elementAt(count2);
                ++count2;
            }
            this.vetos.fireVetoableChange("SelectedIndex", oldValue, newValue);
            if (isSelected) {
                try {
                    this.deselectAll();
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
            listItem.bSelected = isSelected;
            listItem.bDirty = true;
            if (isSelected) {
                ++this.countSelected;
            }
            this.changes.firePropertyChange("SelectedIndex", oldValue, this.getSelectedIndexes());
        } else {
            int s = this.items.size();
            if (index < s && index > -1) {
                int[] oldValue = this.getSelectedIndexes();
                int[] newValue = new int[]{};
                if (isSelected) {
                    newValue = new int[]{index};
                }
                this.vetos.fireVetoableChange("SelectedIndexes", oldValue, newValue);
                listItem = (ListItem)this.items.elementAt(index);
                boolean wasSelected = listItem.bSelected;
                if (isSelected) {
                    int i = 0;
                    while (i < s) {
                        listItem = (ListItem)this.items.elementAt(i);
                        if (listItem.bSelected) {
                            listItem.bSelected = false;
                            listItem.bDirty = true;
                        }
                        ++i;
                    }
                    listItem = (ListItem)this.items.elementAt(index);
                    listItem.bSelected = true;
                    if (wasSelected) {
                        listItem.bDirty = false;
                    }
                    this.countSelected = 1;
                } else {
                    listItem.bSelected = false;
                    if (wasSelected) {
                        listItem.bDirty = true;
                        --this.countSelected;
                    }
                }
                this.changes.firePropertyChange("SelectedIndexes", oldValue, this.getSelectedIndexes());
            }
        }
        this.lastSelected = index;
        this.setVisibleIndex(index);
        if (!this.bInternalBlockPaint) {
            this.repaint();
        }
    }

    public synchronized int getSelectedIndex() {
        return this.lastSelected;
    }

    public synchronized int[] getSelectedIndexes() {
        int[] sel = new int[this.countSelected];
        if (this.countSelected == 1) {
            sel[0] = this.lastSelected;
        } else if (this.countSelected > 1) {
            int x = 0;
            int s = this.items.size();
            int i = 0;
            while (i < s) {
                ListItem tempItem = (ListItem)this.items.elementAt(i);
                if (tempItem.bSelected) {
                    sel[x++] = i;
                    if (x == this.countSelected) break;
                }
                ++i;
            }
        }
        return sel;
    }

    public synchronized String[] getSelectedItems() {
        String[] str = new String[Math.max(1, this.countSelected)];
        if (!this.bMultipleSelections) {
            if (this.lastSelected != -1) {
                ListItem tempItem = (ListItem)this.items.elementAt(this.lastSelected);
                str[0] = tempItem.sText;
            }
        } else if (this.countSelected > 0) {
            int x = 0;
            int s = this.items.size();
            int i = 0;
            while (i < s) {
                ListItem tempItem = (ListItem)this.items.elementAt(i);
                if (tempItem.bSelected) {
                    str[x] = tempItem.sText;
                    if (++x == this.countSelected) break;
                }
                ++i;
            }
        }
        return str;
    }

    public Object[] getSelectedObjects() {
        return this.getSelectedItems();
    }

    public synchronized boolean isSelected(int index) {
        if (this.validIndex(index)) {
            ListItem listItem = (ListItem)this.items.elementAt(index);
            return listItem.bSelected;
        }
        return false;
    }

    public synchronized void setLabel(String label) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.ilbLabel, label)) {
            String oldValue = this.ilbLabel;
            this.vetos.fireVetoableChange("Label", oldValue, label);
            this.ilbLabel = label;
            this.changes.firePropertyChange("Label", oldValue, label);
        }
    }

    public synchronized String getLabel() {
        return new String(this.ilbLabel);
    }

    public synchronized void setVisibleIndex(int index) throws PropertyVetoException {
        if (this.visibleIndex != index) {
            Integer oldValue = new Integer(this.visibleIndex);
            Integer newValue = new Integer(index);
            this.vetos.fireVetoableChange("VisibleIndex", oldValue, newValue);
            this.visibleIndex = index;
            if (this.nTopRow > index) {
                this.scrollVertical(index, true);
            } else if (index >= this.nTopRow + this.visibleRows) {
                this.scrollVertical(index - this.visibleRows + 1, true);
            }
            this.changes.firePropertyChange("VisibleIndex", oldValue, newValue);
        }
    }

    public int getVisibleIndex() {
        return this.visibleIndex;
    }

    public void setTopRow(int index) throws PropertyVetoException {
        int s = this.items.size();
        if (s < this.visibleRows) {
            index = 0;
        } else if (index > s - this.visibleRows) {
            index = s - this.visibleRows;
        }
        if (this.nTopRow != index) {
            Integer oldValue = new Integer(this.nTopRow);
            Integer newValue = new Integer(index);
            this.vetos.fireVetoableChange("TopRow", oldValue, newValue);
            this.nTopRow = index;
            this.bAllDirty = true;
            this.invalidate();
            this.changes.firePropertyChange("TopRow", oldValue, newValue);
        }
    }

    public synchronized int getTopRow() {
        return this.nTopRow;
    }

    public synchronized void setColumns(int columns) throws PropertyVetoException {
        if (this.colsToShow != columns) {
            Integer oldValue = new Integer(this.colsToShow);
            Integer newValue = new Integer(columns);
            this.vetos.fireVetoableChange("Columns", oldValue, newValue);
            this.colsToShow = columns;
            this.invalidate();
            this.changes.firePropertyChange("Columns", oldValue, newValue);
        }
    }

    public synchronized int getColumns() {
        return this.colsToShow;
    }

    public int getRows() {
        return this.visibleRows;
    }

    public synchronized void setFont(Font f) {
        super.setFont(f);
        f = this.getFont();
        if (f != null) {
            this.fm = this.getFontMetrics(f);
            this.updateWidths(this.fm);
            this.xCoord = 0;
            this.bAllDirty = true;
            this.invalidate();
        }
    }

    public synchronized void setDirty(boolean isDirty) throws PropertyVetoException {
        Boolean oldValue = new Boolean(this.bAllDirty);
        Boolean newValue = new Boolean(isDirty);
        this.vetos.fireVetoableChange("Dirty", oldValue, newValue);
        this.bAllDirty = isDirty;
        this.changes.firePropertyChange("Dirty", oldValue, newValue);
    }

    public synchronized boolean isDirty() {
        return this.bAllDirty;
    }

    public synchronized void setDirty() throws PropertyVetoException {
        this.setDirty(true);
    }

    public boolean isAllSelected() {
        return this.countSelected == this.items.size();
    }

    public boolean allSelected() {
        return this.isAllSelected();
    }

    public synchronized void addItem(String item) throws PropertyVetoException {
        this.addItem(new ListItem(null, item, true, this.fm, this.bCellBorders));
    }

    public synchronized void addItem(String item, boolean bEnabled) throws PropertyVetoException {
        this.addItem(new ListItem(null, item, bEnabled, this.fm, this.bCellBorders));
    }

    public synchronized void addItem(Image image, String item) throws PropertyVetoException {
        this.addItem(new ListItem(image, item, true, this.fm, this.bCellBorders));
    }

    public synchronized void addItem(Image image, String item, boolean bEnabled) throws PropertyVetoException {
        this.addItem(new ListItem(image, item, bEnabled, this.fm, this.bCellBorders));
    }

    public synchronized void addItem(Image image, String item, boolean bEnabled, Color color) throws PropertyVetoException {
        ListItem li = new ListItem(image, item, bEnabled, this.fm, this.bCellBorders);
        li.color = color;
        this.addItem(li);
    }

    public synchronized void insertItem(int index, Image image, String item, boolean bEnabled) {
        ListItem li = null;
        if (this.validIndex(index)) {
            li = new ListItem(image, item, bEnabled, this.fm, this.bCellBorders);
            this.items.insertElementAt(li, index);
            this.bAllDirty = true;
            if (this.lastSelected >= index) {
                ++this.lastSelected;
            }
        } else {
            li = new ListItem(image, item, bEnabled, this.fm, this.bCellBorders);
            this.items.addElement(li);
        }
        this.updateWidth(li);
        if (!this.bInternalBlockPaint) {
            this.repaint();
        }
    }

    public synchronized void insertItems(int index, Vector itemVector, Image image, boolean bEnabled) throws PropertyVetoException {
        int s = itemVector.size();
        int x = 0;
        int idx = index;
        if (this.validIndex(index)) {
            x = 0;
            while (x < s) {
                this.items.insertElementAt(new ListItem(image, (String)itemVector.elementAt(x), bEnabled, this.fm, this.bCellBorders), index++);
                ++x;
            }
        } else {
            x = 0;
            while (x < s) {
                this.items.addElement(new ListItem(image, (String)itemVector.elementAt(x), bEnabled, this.fm, this.bCellBorders));
                ++x;
            }
        }
        this.deselectAll();
        this.bAllDirty = true;
        this.updateWidths(this.fm);
        if (!this.bInternalBlockPaint) {
            this.repaint();
        }
    }

    public int countItems() {
        return this.items.size();
    }

    public void changeImage(int index, Image image) throws PropertyVetoException {
        this.setImage(index, image);
    }

    public void changeText(int index, String text) throws PropertyVetoException {
        this.setText(index, text);
    }

    public boolean allowsMultipleSelections() {
        return this.isMultipleSelections();
    }

    public void enable(int index, boolean cond) throws PropertyVetoException {
        this.setEnabled(index, cond);
    }

    public void enable(int index) throws PropertyVetoException {
        this.setEnabled(index, true);
    }

    public void disable(int index) throws PropertyVetoException {
        this.setEnabled(index, false);
    }

    public synchronized void clear() {
        this.items = new Vector();
        this.nTopRow = 0;
        this.visibleIndex = -1;
        this.lastDownModifiers = -1;
        this.lastSelected = -1;
        this.lastIndex = -1;
        this.lastTempIndex = -1;
        this.countSelected = 0;
        this.prevSelectTime = -1L;
        this.prevSelectRow = -1L;
        this.VBar.setValues(1, 1, 0, 2);
        this.VBar.hide();
        this.bVBarVisible = false;
        this.HBar.setValues(1, 1, 0, 2);
        this.HBar.hide();
        this.bHBarVisible = false;
        this.bAllDirty = true;
        this.bInternalBlockPaint = false;
        this.bBlockPaint = false;
        this.longestLineValue = 0;
        this.xCoord = 0;
        this.repaint();
    }

    public synchronized void delItem(int index) throws PropertyVetoException {
        if (this.validIndex(index)) {
            String[] oldValue = this.getListItems();
            String[] newValue = new String[oldValue.length - 1];
            Vector<String> tempVect = new Vector<String>(oldValue.length);
            int count = 0;
            while (count < oldValue.length) {
                tempVect.insertElementAt(new String(oldValue[count]), count);
                ++count;
            }
            tempVect.removeElementAt(index);
            int count2 = 0;
            while (count2 < tempVect.size()) {
                newValue[count2] = new String((String)tempVect.elementAt(count2));
                ++count2;
            }
            this.vetos.fireVetoableChange("ListItems", oldValue, newValue);
            this.setSelectedIndex(index, false);
            if (!this.bInternalBlockPaint) {
                this.repaint();
            }
            this.items.removeElementAt(index);
            this.bAllDirty = true;
            this.scrollVertical(this.nTopRow, true);
            this.updateWidths(null);
            if (!this.bInternalBlockPaint) {
                this.repaint();
            }
            this.changes.firePropertyChange("ListItems", oldValue, this.getListItems());
        }
    }

    public synchronized void delItems(int start, int end) throws PropertyVetoException {
        int s = this.items.size();
        if (s > 0) {
            if (end >= s) {
                end = s - 1;
            }
            if (start < 0) {
                start = 0;
            }
            if (start <= end) {
                String[] oldValue = this.getListItems();
                String[] newValue = new String[oldValue.length - (end - start) - 1];
                Vector<Object> tempVect = new Vector<Object>(newValue.length);
                int count = 0;
                while (count < start) {
                    tempVect.insertElementAt(new Integer(oldValue[count]), count);
                    ++count;
                }
                int count2 = end + 1;
                while (count2 < oldValue.length) {
                    tempVect.insertElementAt(new String(oldValue[count2]), start + (count2 - (end + 1)));
                    ++count2;
                }
                int count3 = 0;
                while (count3 < tempVect.size()) {
                    newValue[count3] = new String((String)tempVect.elementAt(count3));
                    ++count3;
                }
                this.vetos.fireVetoableChange("ListItems", oldValue, newValue);
                this.bInternalBlockPaint = true;
                int i = end;
                while (i >= start) {
                    this.setSelectedIndex(i, false);
                    this.items.removeElementAt(i);
                    --i;
                }
                this.bInternalBlockPaint = false;
                this.bAllDirty = true;
                this.scrollVertical(this.nTopRow, true);
                this.updateWidths(null);
                this.repaint();
                this.changes.firePropertyChange("ListItems", oldValue, this.getListItems());
            }
        }
    }

    public synchronized void delSelectedItems() throws PropertyVetoException {
        int s = this.items.size();
        this.bInternalBlockPaint = true;
        int x = 0;
        while (x < s) {
            ListItem tempItem = (ListItem)this.items.elementAt(x);
            if (tempItem.bSelected) {
                this.delItem(x);
                --s;
                continue;
            }
            ++x;
        }
        this.bAllDirty = true;
        this.scrollVertical(this.nTopRow, true);
        this.updateWidths(null);
        this.bInternalBlockPaint = false;
        this.repaint();
    }

    public synchronized void select(int index) throws PropertyVetoException {
        this.setSelectedIndex(index, true);
    }

    public synchronized void select(String str) throws PropertyVetoException {
        this.setSelectedItem(str, true);
    }

    public synchronized void selectMultiple(int index, boolean bShift, boolean bControl) throws PropertyVetoException {
        if (!this.bMultipleSelections) {
            bShift = false;
            bControl = false;
        }
        if (bShift) {
            this.shiftSelect(index, bControl);
        } else if (bControl) {
            this.ctrlSelect(index);
        } else {
            this.setSelectedIndex(index, true);
        }
    }

    public synchronized void selectAll() {
        if (!this.bMultipleSelections) {
            return;
        }
        int s = this.items.size();
        int i = 0;
        while (i < s) {
            ListItem li = (ListItem)this.items.elementAt(i);
            if (li.bEnabled) {
                li.bSelected = true;
            }
            ++i;
        }
        this.countSelected = s;
        this.lastSelected = s - 1;
        this.repaint();
    }

    public synchronized void deselect(int index) throws PropertyVetoException {
        if (this.validIndex(index)) {
            this.setSelectedIndex(index, false);
            if (!this.bInternalBlockPaint) {
                this.repaint();
            }
        }
    }

    public synchronized void deselectAll() throws PropertyVetoException {
        int[] oldValue = this.getSelectedIndexes();
        int[] newValue = new int[]{};
        this.vetos.fireVetoableChange("SelectedIndexes", oldValue, newValue);
        if (!this.bMultipleSelections) {
            if (this.lastSelected != -1) {
                ListItem li = (ListItem)this.items.elementAt(this.lastSelected);
                li.bSelected = false;
                li.bDirty = true;
            }
        } else {
            int s = this.items.size();
            int i = 0;
            while (i < s) {
                ListItem li = (ListItem)this.items.elementAt(i);
                if (li.bSelected) {
                    li.bSelected = false;
                    li.bDirty = true;
                }
                ++i;
            }
        }
        this.lastSelected = -1;
        this.countSelected = 0;
        this.repaint();
        this.changes.firePropertyChange("SelectedIndexes", oldValue, this.getSelectedIndexes());
    }

    public synchronized void makeVisible(int index) throws PropertyVetoException {
        this.setVisibleIndex(index);
    }

    public int getCellHeight() {
        return this.cellHt;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public Dimension getPreferredSize(int rows) {
        Dimension d = this.getMinimumSize(rows);
        Dimension s = this.size();
        return new Dimension(Math.max(d.width, s.width), Math.max(d.height, s.height));
    }

    public Dimension getPreferredSize() {
        if (this.rowsToShow > 0) {
            return this.getPreferredSize(this.rowsToShow);
        }
        return this.getPreferredSize(this.items.size());
    }

    public Dimension getMinimumSize(int rows) {
        this.font = this.getFont();
        if (this.font != null) {
            this.fm = this.getFontMetrics(this.font);
            if (this.fm != null) {
                this.fontHeight = this.fm.getHeight();
                this.cellHt = this.bCellBorders ? this.fontHeight + 5 : this.fontHeight + 1;
                return new Dimension(this.fm.stringWidth("WN") * this.colsToShow / 2 + 6, rows * this.cellHt + this.borderWidth);
            }
        }
        return new Dimension(this.borderWidth + 6, this.borderWidth);
    }

    public Dimension getMinimumSize() {
        if (this.rowsToShow > 0) {
            return this.getMinimumSize(this.rowsToShow);
        }
        return this.getMinimumSize(this.items.size());
    }

    public Dimension preferredSize(int rows) {
        return this.getPreferredSize(rows);
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public Dimension minimumSize(int rows) {
        return this.getMinimumSize(rows);
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public synchronized void addNotify() {
        super.addNotify();
        try {
            this.errors = ResourceBundle.getBundle("symantec.itools.resources.ErrorsBundle");
        }
        catch (Throwable throwable) {
            this.errors = new ErrorsBundle();
        }
        this.barSize = this.VBar.getPreferredSize().width;
        if (this.mouse == null) {
            this.mouse = new Mouse();
            this.addMouseListener(this.mouse);
        }
        if (this.mouseMotion == null) {
            this.mouseMotion = new MouseMotion();
            this.addMouseMotionListener(this.mouseMotion);
        }
        if (this.key == null) {
            this.key = new Key();
            this.addKeyListener(this.key);
        }
        if (this.adjustment == null) {
            this.adjustment = new Adjustment();
            this.VBar.addAdjustmentListener(this.adjustment);
            this.HBar.addAdjustmentListener(this.adjustment);
        }
        this.font = this.getFont();
        this.fm = this.getFontMetrics(this.font);
        this.fontHeight = this.fm.getHeight();
        this.updateWidths(this.fm);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public synchronized void removeNotify() {
        if (this.mouse != null) {
            this.removeMouseListener(this.mouse);
            this.mouse = null;
        }
        if (this.mouseMotion != null) {
            this.removeMouseMotionListener(this.mouseMotion);
            this.mouseMotion = null;
        }
        if (this.key != null) {
            this.removeKeyListener(this.key);
            this.key = null;
        }
        if (this.adjustment != null) {
            this.VBar.removeAdjustmentListener(this.adjustment);
            this.HBar.removeAdjustmentListener(this.adjustment);
            this.adjustment = null;
        }
        super.removeNotify();
    }

    public synchronized void blockPaint(boolean cond) {
        this.bBlockPaint = cond;
        if (!this.bBlockPaint) {
            this.repaint();
        }
    }

    public synchronized void scrollVertical(int info, boolean bAbsolute) {
        int temp = this.nTopRow;
        if (this.visibleRows == 0) {
            temp = 0;
        } else {
            if (bAbsolute) {
                temp = info;
            } else {
                switch (info) {
                    case 3: {
                        temp -= this.visibleRows;
                        break;
                    }
                    case 4: {
                        temp += this.visibleRows;
                        break;
                    }
                    case 2: {
                        --temp;
                        break;
                    }
                    case 1: {
                        ++temp;
                        break;
                    }
                }
            }
            if (temp < 0) {
                temp = 0;
            } else if (temp > this.items.size() - this.visibleRows && (temp = this.items.size() - this.visibleRows) < 0) {
                temp = 0;
            }
        }
        if (this.nTopRow != temp) {
            this.nTopRow = temp;
            this.VBar.setValue(temp);
            this.bAllDirty = true;
            if (!this.bInternalBlockPaint) {
                this.repaint();
            }
        }
    }

    public synchronized void scrollHorizontal(int info, boolean bAbsolute) {
        int temp = this.xCoord;
        if (bAbsolute) {
            temp = -info;
        } else {
            switch (info) {
                case 3: {
                    temp += this.lWidth;
                    break;
                }
                case 4: {
                    temp -= this.lWidth;
                    break;
                }
                case 2: {
                    ++temp;
                    break;
                }
                case 1: {
                    --temp;
                    break;
                }
            }
        }
        if (temp > 0) {
            temp = 0;
        } else if (-temp > this.HBar.getMaximum() - this.lWidth) {
            temp = -(this.HBar.getMaximum() - this.lWidth);
        }
        if (this.xCoord != temp) {
            this.xCoord = temp;
            this.HBar.setValue(-temp);
            this.bAllDirty = true;
            if (!this.bInternalBlockPaint) {
                this.repaint();
            }
        }
    }

    public synchronized void update(Graphics g) {
        if (!this.bBlockPaint && !this.bInternalBlockPaint) {
            this.paint(g);
        }
    }

    public synchronized void paint(Graphics g) {
        int vWid = 0;
        int hHt = 0;
        int gridAdj = 0;
        int yLoc = 0;
        int ySLoc = 0;
        boolean bShowV = false;
        boolean bShowH = false;
        Color curBackground = this.getBackground();
        if (!GeneralUtils.objectsEqual(curBackground, this.cachedBackground)) {
            this.cachedBackground = curBackground;
            this.calculateBorderColors(curBackground);
        }
        Rectangle rect = this.bounds();
        this.font = g.getFont();
        this.fm = g.getFontMetrics(this.font);
        this.fontHeight = this.fm.getHeight();
        this.fontDescent = this.fm.getDescent();
        int nItems = this.items.size();
        this.cellHt = this.bCellBorders ? this.fontHeight + 5 : this.fontHeight + 1;
        if (nItems == 0) {
            this.nTopRow = 0;
            this.visibleRows = 0;
            bShowH = false;
            bShowV = false;
            this.xCoord = 0;
        } else {
            if (this.bAllowShowHBar && this.longestLineValue > rect.width - this.borderWidth) {
                bShowH = true;
                hHt = this.barSize;
            } else {
                bShowH = false;
                hHt = 0;
            }
            int rows = (rect.height - hHt - this.borderWidth) / this.cellHt;
            if (this.bAllowShowVBar && nItems > rows) {
                bShowV = true;
                vWid = this.barSize;
                if (!bShowH && this.bAllowShowHBar && this.longestLineValue > rect.width - this.borderWidth - vWid) {
                    bShowH = true;
                    hHt = this.barSize;
                    rows = (rect.height - hHt - this.borderWidth) / this.cellHt;
                }
            } else {
                bShowV = false;
                vWid = 0;
            }
            if (this.visibleRows != rows) {
                this.visibleRows = rows;
                this.bAllDirty = true;
            }
            if (bShowV) {
                this.VBar.reshape(rect.width - this.barSize - this.halfBorderWidth, this.halfBorderWidth, this.barSize, rect.height - this.borderWidth - hHt);
                this.VBar.setValues(this.nTopRow, this.visibleRows, 0, nItems);
                this.VBar.setPageIncrement(this.visibleRows);
                this.lWidth = rect.width - vWid - this.borderWidth;
                if (!this.bVBarVisible) {
                    this.bVBarVisible = true;
                    this.VBar.show();
                }
            } else {
                this.lWidth = rect.width - this.borderWidth;
                if (this.bVBarVisible) {
                    this.bVBarVisible = false;
                    this.VBar.hide();
                }
            }
            if (bShowH) {
                this.HBar.reshape(this.halfBorderWidth, rect.height - this.barSize - this.halfBorderWidth, rect.width - this.borderWidth - vWid, this.barSize);
                this.HBar.setValues(-this.xCoord, this.lWidth, 0, this.longestLineValue);
                this.HBar.setPageIncrement(this.lWidth);
                if (!this.bHBarVisible) {
                    this.bHBarVisible = true;
                    this.HBar.show();
                }
            } else if (this.bHBarVisible) {
                this.bHBarVisible = false;
                this.HBar.hide();
            }
        }
        if (nItems == 0 || this.bAllDirty) {
            g.clearRect(this.halfBorderWidth, this.halfBorderWidth, rect.width - this.borderWidth - 1, rect.height - this.borderWidth - 1);
        }
        if (this.borderType == 0) {
            g.setColor(this.borderDarkerColor);
            g.drawLine(0, 0, rect.width - 1, 0);
            g.drawLine(0, 0, 0, rect.height - 1);
            g.setColor(this.borderDarkColor);
            g.drawLine(1, 1, rect.width - 2, 1);
            g.drawLine(1, 1, 1, rect.height - 2);
            g.setColor(this.borderLightColor);
            g.drawLine(1, rect.height - 2, rect.width - 2, rect.height - 2);
            g.drawLine(rect.width - 2, 1, rect.width - 2, rect.height - 2);
            g.setColor(this.borderLighterColor);
            g.drawLine(0, rect.height - 1, rect.width - 1, rect.height - 1);
            g.drawLine(rect.width - 1, 0, rect.width - 1, rect.height - 1);
        }
        g.clipRect(this.halfBorderWidth, this.halfBorderWidth, this.lWidth, rect.height - this.borderWidth);
        if (this.nTopRow >= nItems) {
            this.nTopRow -= this.visibleRows + 1;
        }
        int i = this.nTopRow;
        int j = Math.min(this.nTopRow + this.visibleRows, nItems);
        int dp = 0;
        while (i < j && this.items.size() > 0) {
            yLoc = dp * this.cellHt + this.halfBorderWidth;
            ySLoc = (dp + 1) * this.cellHt + this.halfBorderWidth;
            ListItem item = (ListItem)this.items.elementAt(i);
            if (item.bDirty || this.bAllDirty) {
                item.bDirty = false;
                g.clearRect(this.halfBorderWidth, yLoc, this.lWidth, this.cellHt);
            }
            int xSelectStartLoc = item.image != null ? this.halfBorderWidth + 19 + 2 : this.halfBorderWidth;
            gridAdj = item.bCellBorder ? 2 : 0;
            if (item.bSelected) {
                g.setColor(this.textHighlight);
                g.fillRect(this.xCoord + xSelectStartLoc + gridAdj, yLoc, this.lWidth - this.xCoord, this.cellHt);
                g.setColor(this.textHighlightText);
            } else if (item.bEnabled) {
                if (item.color == null) {
                    g.setColor(this.enabledColor);
                } else {
                    g.setColor(item.color);
                }
            } else {
                g.setColor(this.disabledColor);
            }
            g.drawString(item.sText, this.xCoord + xSelectStartLoc + gridAdj + 2, ySLoc - this.fontDescent);
            if (item.image != null) {
                g.drawImage(item.image, this.xCoord + this.halfBorderWidth + gridAdj + 2, yLoc + 2, 19, this.cellHt - 3, this);
            }
            if (item.bCellBorder) {
                g.setColor(item.cellBorderColor);
                g.drawRect(this.halfBorderWidth, yLoc, this.lWidth, this.cellHt);
            }
            ++i;
            ++dp;
        }
        this.extraPaint(g, rect);
        this.bAllDirty = false;
    }

    public void extraPaint(Graphics g, Rectangle rect) {
    }

    public synchronized void show() {
        this.bAllDirty = true;
        super.show();
    }

    public synchronized void reshape(int x, int y, int width, int height) {
        this.bAllDirty = true;
        super.reshape(x, y, width, height);
    }

    public synchronized void addItemListener(ItemListener l) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, l);
    }

    public synchronized void removeItemListener(ItemListener l) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, l);
    }

    public synchronized void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener(listener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.addVetoableChangeListener(listener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetos.removeVetoableChangeListener(listener);
    }

    protected void sourceItemEvent() {
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(new ItemEvent(this, 701, this, 1));
        }
    }

    protected void sourceActionEvent(String command) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, command));
        }
    }

    protected boolean validIndex(int index) {
        return index >= 0 && index < this.items.size();
    }

    protected boolean isVisibleIndex(int index) {
        return index >= this.nTopRow && index < this.nTopRow + this.visibleRows;
    }

    protected String paramString() {
        return String.valueOf(super.paramString()) + ", selected=" + this.getSelectedItem();
    }

    protected void shiftSelect(int index, boolean bControl) throws PropertyVetoException {
        int i = 0;
        int s = 0;
        if (this.lastSelected == -1) {
            this.setSelectedIndex(index, true);
        } else if (this.lastSelected == index) {
            if (!bControl) {
                this.bInternalBlockPaint = true;
                this.setSelectedIndex(index, true);
                this.bInternalBlockPaint = false;
            }
        } else if (this.lastSelected < index) {
            if (!this.isEnabled(index)) {
                return;
            }
            if (bControl) {
                i = this.lastSelected + 1;
                s = Math.min(this.items.size(), index + 1);
            } else {
                i = 0;
                s = this.items.size();
            }
            while (i < s) {
                ListItem li = (ListItem)this.items.elementAt(i);
                if (i < this.lastSelected || i > index) {
                    if (li.bSelected) {
                        li.bDirty = true;
                        li.bSelected = false;
                        --this.countSelected;
                    }
                } else if (!li.bSelected) {
                    li.bDirty = true;
                    li.bSelected = true;
                    ++this.countSelected;
                }
                ++i;
            }
        } else if (this.lastSelected > index) {
            if (!this.isEnabled(index)) {
                return;
            }
            if (bControl) {
                i = index;
                s = Math.min(this.items.size(), this.lastSelected);
            } else {
                i = 0;
                s = this.items.size();
            }
            i = 0;
            while (i < s) {
                ListItem li = (ListItem)this.items.elementAt(i);
                if (i < index || i > this.lastSelected) {
                    if (li.bSelected) {
                        li.bDirty = true;
                        li.bSelected = false;
                        --this.countSelected;
                    }
                } else if (!li.bSelected) {
                    li.bDirty = true;
                    li.bSelected = true;
                    ++this.countSelected;
                }
                ++i;
            }
        }
        if (!this.bInternalBlockPaint) {
            this.repaint();
        }
    }

    protected void ctrlSelect(int index) {
        ListItem listItem = (ListItem)this.items.elementAt(index);
        if (!listItem.bEnabled) {
            return;
        }
        if (listItem.bSelected) {
            listItem.bSelected = false;
            --this.countSelected;
            this.lastSelected = -1;
        } else {
            listItem.bSelected = true;
            ++this.countSelected;
            this.lastSelected = index;
        }
        listItem.bDirty = true;
        if (!this.bInternalBlockPaint) {
            this.repaint();
        }
    }

    protected int mouseCalcIndex(int y) {
        int mci = y < this.yAdj ? this.nTopRow - 1 : (y - this.yAdj) / this.cellHt + this.nTopRow;
        if (mci >= this.items.size()) {
            mci = -1;
        } else if (mci < 0) {
            mci = 0;
        }
        return mci;
    }

    protected void addItem(ListItem li) throws PropertyVetoException {
        if (li != null) {
            String[] oldValue = this.getListItems();
            String[] newValue = new String[oldValue.length + 1];
            int count = 0;
            while (count < oldValue.length) {
                newValue[count] = new String(oldValue[count]);
                ++count;
            }
            newValue[oldValue.length] = new String(li.sText);
            this.vetos.fireVetoableChange("ListItems", oldValue, newValue);
            if (this.nTopRow < 0) {
                this.nTopRow = 0;
            }
            this.items.addElement(li);
            this.updateWidth(li);
            if (!this.bInternalBlockPaint) {
                this.repaint();
            }
            this.changes.firePropertyChange("ListItems", oldValue, this.getListItems());
        }
    }

    private void updateWidth(ListItem li) {
        int lineWidth = li.lineWidth + 6;
        if (li.image != null) {
            lineWidth += 19;
        }
        if (lineWidth > this.longestLineValue) {
            this.longestLineValue = lineWidth;
        }
    }

    private void updateWidths(FontMetrics fm) {
        this.longestLineValue = 0;
        int s = this.items.size();
        int lineWidth = 0;
        int x = 0;
        while (x < s) {
            ListItem li = (ListItem)this.items.elementAt(x);
            li.updateWidth(fm);
            lineWidth = li.lineWidth + 6;
            if (li.image != null) {
                lineWidth += 19;
            }
            if (lineWidth > this.longestLineValue) {
                this.longestLineValue = lineWidth;
            }
            ++x;
        }
    }

    protected void notifyHelper(int x, int y, int index, boolean bDoubleClick) {
        if (bDoubleClick) {
            this.sourceActionEvent("DoubleClicked");
        } else {
            if (x >= 0 && x - this.xCoord < 19) {
                ListItem listItem = (ListItem)this.items.elementAt(index);
                if (listItem.image != null) {
                    this.sourceActionEvent("ImageSelected");
                }
            }
            this.sourceItemEvent();
        }
    }

    protected void calculateBorderColors(Color c) {
        this.borderLighterColor = ColorUtils.calculateHilightColor(c);
        this.borderDarkerColor = ColorUtils.calculateShadowColor(c);
        this.borderLightColor = ColorUtils.darken(this.borderLighterColor, 0.2);
        this.borderDarkColor = ColorUtils.darken(this.borderDarkerColor, 0.2);
    }

    protected int keyCalcIndex(int offset, boolean bAbsolute) {
        this.lastIndex = bAbsolute ? offset : (this.lastIndex += offset);
        if (this.lastIndex >= this.items.size()) {
            this.lastIndex = this.items.size() - 1;
        } else if (this.lastIndex < 0) {
            this.lastIndex = 0;
        }
        return this.lastIndex;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        ListItem li = null;
        int i = 0;
        while (i < this.items.size()) {
            li = (ListItem)this.items.elementAt(i);
            if (li.url != null) {
                li.image = this.getToolkit().getImage(li.url);
                MediaTracker tracker = new MediaTracker(this);
                tracker.addImage(li.image, 0);
                try {
                    tracker.waitForAll();
                }
                catch (InterruptedException interruptedException) {
                    Object[] args = new Object[]{li.url};
                    throw new IOException(MessageFormat.format(this.errors.getString("ErrorLoadingImageForURL"), args));
                }
            }
            ++i;
        }
    }

    class Mouse
    extends MouseAdapter
    implements Serializable {
        public void mousePressed(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            int index = -1;
            ImageListBox.this.requestFocus();
            ++ImageListBox.this.fastDownCount;
            ImageListBox.this.bMouseDrawHandled = false;
            if (x > -1 && x < ImageListBox.this.lWidth) {
                index = ImageListBox.this.mouseCalcIndex(y);
                if (index == -1) {
                    return;
                }
                if (ImageListBox.this.bMultipleSelections) {
                    if (e.isShiftDown() && e.isControlDown()) {
                        ImageListBox.this.bMouseDrawHandled = true;
                        try {
                            ImageListBox.this.shiftSelect(index, true);
                        }
                        catch (PropertyVetoException propertyVetoException) {}
                    } else if (e.isShiftDown()) {
                        ImageListBox.this.bMouseDrawHandled = true;
                        try {
                            ImageListBox.this.shiftSelect(index, false);
                        }
                        catch (PropertyVetoException propertyVetoException) {}
                    } else if (e.isControlDown()) {
                        ImageListBox.this.bMouseDrawHandled = true;
                        ImageListBox.this.ctrlSelect(index);
                    } else {
                        try {
                            ImageListBox.this.setSelectedIndex(index, true);
                        }
                        catch (PropertyVetoException propertyVetoException) {}
                    }
                } else {
                    ImageListBox.this.lastTempIndex = index;
                    try {
                        ImageListBox.this.setSelectedIndex(index, true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                }
                ImageListBox.this.repaint();
            }
        }

        public void mouseReleased(MouseEvent e) {
            boolean bDoubleClick;
            int x = e.getX();
            int y = e.getY();
            int index = -1;
            --ImageListBox.this.fastDownCount;
            if (ImageListBox.this.bMouseDrawHandled) {
                ImageListBox.this.notifyHelper(-1, y, -1, false);
                return;
            }
            index = ImageListBox.this.mouseCalcIndex(y);
            if (index == -1 || x < 0 || x >= ImageListBox.this.lWidth) {
                ImageListBox.this.fastDownCount = 0;
                index = ImageListBox.this.lastTempIndex;
                if (index == -1) {
                    return;
                }
            }
            if (ImageListBox.this.bComboMode) {
                ImageListBox.this.fastDownCount = 0;
                bDoubleClick = false;
            } else if (ImageListBox.this.fastDownCount > 0) {
                ImageListBox.this.fastDownCount = 0;
                bDoubleClick = true;
                ImageListBox.this.prevSelectTime = -1L;
                ImageListBox.this.prevSelectRow = -1L;
            } else {
                long selectTime = System.currentTimeMillis();
                if (ImageListBox.this.prevSelectTime != -1L && ImageListBox.this.prevSelectRow == (long)index && ImageListBox.this.prevSelectTime + 250L > selectTime) {
                    bDoubleClick = true;
                    ImageListBox.this.prevSelectTime = -1L;
                    ImageListBox.this.prevSelectRow = -1L;
                } else {
                    bDoubleClick = false;
                    ImageListBox.this.prevSelectTime = selectTime;
                    ImageListBox.this.prevSelectRow = index;
                }
            }
            if (ImageListBox.this.lastSelected != index) {
                try {
                    ImageListBox.this.setSelectedIndex(index, true);
                }
                catch (PropertyVetoException propertyVetoException) {}
                ImageListBox.this.repaint();
            }
            if (ImageListBox.this.bMultipleSelections) {
                ImageListBox.this.notifyHelper(x, y, ImageListBox.this.lastSelected, bDoubleClick);
                ImageListBox.this.lastIndex = ImageListBox.this.lastSelected;
            } else {
                ImageListBox.this.notifyHelper(x, y, index, bDoubleClick);
                ImageListBox.this.lastIndex = index;
            }
            ImageListBox.this.lastTempIndex = -1;
            ImageListBox.this.lastDownModifiers = -1;
        }

        public void mouseExited(MouseEvent e) {
            if (!ImageListBox.this.bMultipleSelections && ImageListBox.this.bComboMode) {
                ImageListBox.this.lastIndex = -1;
            }
        }

        Mouse() {
            ImageListBox.this = ImageListBox.this;
        }
    }

    class MouseMotion
    implements MouseMotionListener,
    Serializable {
        public void mouseMoved(MouseEvent e) {
            if (!ImageListBox.this.bMultipleSelections) {
                int x = e.getX();
                int y = e.getY();
                int index = -1;
                if (x > -1 && x < ImageListBox.this.lWidth && ImageListBox.this.bComboMode) {
                    index = ImageListBox.this.mouseCalcIndex(y);
                    if (index == -1 || index == ImageListBox.this.lastIndex) {
                        return;
                    }
                    ImageListBox.this.lastIndex = index;
                    try {
                        ImageListBox.this.setSelectedIndex(index, true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                    ImageListBox.this.repaint();
                }
            }
        }

        public void mouseDragged(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            int index = -1;
            if (x > -1 && x < ImageListBox.this.lWidth) {
                if (ImageListBox.this.bComboMode) {
                    index = ImageListBox.this.mouseCalcIndex(y);
                    if (index == -1 || index == ImageListBox.this.lastIndex) {
                        return;
                    }
                    ImageListBox.this.lastIndex = index;
                    try {
                        ImageListBox.this.setSelectedIndex(index, true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                    ImageListBox.this.repaint();
                } else {
                    index = ImageListBox.this.mouseCalcIndex(y);
                    if (index != -1 && index != ImageListBox.this.lastIndex) {
                        if (ImageListBox.this.bMultipleSelections) {
                            if (e.getModifiers() != 0) {
                                return;
                            }
                            ImageListBox.this.bInternalBlockPaint = true;
                            try {
                                ImageListBox.this.setVisibleIndex(index);
                            }
                            catch (PropertyVetoException propertyVetoException) {}
                            ImageListBox.this.bInternalBlockPaint = false;
                            try {
                                ImageListBox.this.shiftSelect(index, false);
                            }
                            catch (PropertyVetoException propertyVetoException) {}
                        } else {
                            try {
                                ImageListBox.this.setSelectedIndex(index, true);
                            }
                            catch (PropertyVetoException propertyVetoException) {}
                        }
                        ImageListBox.this.lastIndex = index;
                    }
                }
            }
        }

        MouseMotion() {
            ImageListBox.this = ImageListBox.this;
        }
    }

    class Key
    extends KeyAdapter
    implements Serializable {
        public void keyPressed(KeyEvent e) {
            if (e.isControlDown() || e.isMetaDown() || e.isAltDown()) {
                return;
            }
            int index = -1;
            switch (e.getKeyCode()) {
                case 36: {
                    index = ImageListBox.this.keyCalcIndex(0, true);
                    break;
                }
                case 35: {
                    index = ImageListBox.this.keyCalcIndex(ImageListBox.this.items.size() - 1, true);
                    break;
                }
                case 33: {
                    index = ImageListBox.this.keyCalcIndex(-ImageListBox.this.visibleRows, false);
                    break;
                }
                case 34: {
                    index = ImageListBox.this.keyCalcIndex(ImageListBox.this.visibleRows, false);
                    break;
                }
                case 38: {
                    index = ImageListBox.this.keyCalcIndex(-1, false);
                    break;
                }
                case 40: {
                    index = ImageListBox.this.keyCalcIndex(1, false);
                    break;
                }
            }
            if (index == -1) {
                return;
            }
            if (ImageListBox.this.bMultipleSelections && e.isShiftDown()) {
                try {
                    ImageListBox.this.setVisibleIndex(index);
                }
                catch (PropertyVetoException propertyVetoException) {}
                try {
                    ImageListBox.this.shiftSelect(index, false);
                }
                catch (PropertyVetoException propertyVetoException) {}
                return;
            }
            try {
                ImageListBox.this.setSelectedIndex(index, true);
            }
            catch (PropertyVetoException propertyVetoException) {}
            ImageListBox.this.repaint();
            ImageListBox.this.notifyHelper(-1, -1, index, false);
            ImageListBox.this.prevSelectTime = -1L;
            ImageListBox.this.prevSelectRow = -1L;
        }

        Key() {
            ImageListBox.this = ImageListBox.this;
        }
    }

    class Adjustment
    implements AdjustmentListener,
    Serializable {
        public void adjustmentValueChanged(AdjustmentEvent e) {
            if (e.getSource() == ImageListBox.this.VBar) {
                if (e.getAdjustmentType() == 5) {
                    ImageListBox.this.scrollVertical(e.getValue(), true);
                } else {
                    ImageListBox.this.scrollVertical(e.getAdjustmentType(), false);
                }
            } else if (e.getSource() == ImageListBox.this.HBar) {
                if (e.getAdjustmentType() == 5) {
                    ImageListBox.this.scrollHorizontal(e.getValue(), true);
                } else {
                    ImageListBox.this.scrollHorizontal(e.getAdjustmentType(), false);
                }
            }
        }

        Adjustment() {
            ImageListBox.this = ImageListBox.this;
        }
    }
}

