/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.staff;

import com.ibm.bpe.plugins.DeployedStaffQuery;
import com.ibm.bpe.plugins.ProcessDeploymentException;
import com.ibm.bpe.plugins.StaffPluginEmptyAttributeValueException;
import com.ibm.bpe.plugins.StaffPluginInvalidAttributeValueException;
import com.ibm.bpe.staff.StaffPluginUtil;
import com.ibm.task.util.TraceLog;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wmm.datatype.impl.AttributeSearchConditionsData;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

public final class DeployedWMMStaffQuery
implements DeployedStaffQuery {
    private static final String NEWLINE = System.getProperty("line.separator");
    public static final String COPYRIGHT = "(C) Copyright IBM Corporation 2001, 2006.";
    private static final long serialVersionUID = 2002103100001000L;
    static final String STRING_OPERATOR = "operator";
    static final String STRING_RETURNTYPE = "returnType";
    static final String STRING_SEARCHATTRIBUTE = "searchAttribute";
    static final String STRING_SEARCHBASE = "searchBase";
    private String[] _contextSignature;
    private volatile int _hashCode = 0;
    private WMMQuery[] _queries;
    private int _threshold;
    private int _type;

    DeployedWMMStaffQuery(List list, List list2, String string) throws ProcessDeploymentException {
        if (TraceLog.isTracing) {
            TraceLog.entry((Object[])new Object[]{list, list2, string});
        }
        this._contextSignature = list.toArray(new String[list.size()]);
        this._queries = list2.toArray(new WMMQuery[list2.size()]);
        this._threshold = StaffPluginUtil.computeThreshold((String)string, (String)"staffQueries");
        this._type = 3;
    }

    DeployedWMMStaffQuery(List list, GroupIDQuery groupIDQuery) {
        if (TraceLog.isTracing) {
            TraceLog.entry((Object[])new Object[]{list, groupIDQuery});
        }
        this._contextSignature = list.toArray(new String[list.size()]);
        this._queries = new WMMQuery[]{groupIDQuery};
        this._threshold = 1;
        this._type = 4;
    }

    DeployedWMMStaffQuery(int n) throws ProcessDeploymentException {
        if (TraceLog.isTracing) {
            TraceLog.entry((Object[])new Object[]{new Integer(n)});
        }
        this._contextSignature = new String[0];
        this._queries = new WMMQuery[0];
        this._threshold = Integer.MAX_VALUE;
        if (n == 0) {
            this._type = 0;
        } else if (n == 1) {
            this._type = 1;
        } else {
            throw new IllegalArgumentException("type != QUERY_TYPE_EVERYBODY && type != QUERY_TYPE_NOBODY");
        }
    }

    public boolean equals(Object object) {
        int n;
        if (TraceLog.isTracing) {
            TraceLog.entry((Object)object, (Object)this);
        }
        if (object == this) {
            if (TraceLog.isTracing) {
                TraceLog.exit((Object)Boolean.TRUE);
            }
            return true;
        }
        if (!(object instanceof DeployedWMMStaffQuery)) {
            return false;
        }
        DeployedWMMStaffQuery deployedWMMStaffQuery = (DeployedWMMStaffQuery)object;
        if (deployedWMMStaffQuery._threshold != this._threshold) {
            return false;
        }
        if (deployedWMMStaffQuery._type != this._type) {
            return false;
        }
        if (deployedWMMStaffQuery._contextSignature.length != this._contextSignature.length) {
            return false;
        }
        for (n = 0; n < this._contextSignature.length; ++n) {
            if (this._contextSignature[n].equals(deployedWMMStaffQuery._contextSignature[n])) continue;
            return false;
        }
        if (deployedWMMStaffQuery._queries.length != this._queries.length) {
            return false;
        }
        for (n = 0; n < this._queries.length; ++n) {
            if (this._queries[n].equals(deployedWMMStaffQuery._queries[n])) continue;
            return false;
        }
        if (TraceLog.isTracing) {
            TraceLog.exit((Object)Boolean.TRUE);
        }
        return true;
    }

    public String[] getContextSignature() {
        return this._contextSignature;
    }

    public WMMQuery[] getQueries() {
        return this._queries;
    }

    public String getPluginType() {
        return "MemberManager";
    }

    int getThreshold() {
        return this._threshold;
    }

    int getType() {
        return this._type;
    }

    public int hashCode() {
        if (this._hashCode == 0) {
            int n;
            int n2 = 17;
            for (n = 0; n < this._contextSignature.length; ++n) {
                n2 = 37 * n2 + this._contextSignature[n].hashCode();
            }
            n2 = 37 * n2;
            for (n = 0; n < this._queries.length; ++n) {
                n2 = 37 * n2 + this._queries[n].hashCode();
            }
            n2 = 37 * n2;
            n2 = 37 * n2 + this._threshold;
            this._hashCode = n2 = 37 * n2 + this._type;
        }
        if (TraceLog.isTracing) {
            TraceLog.exit((Object)new Integer(this._hashCode));
        }
        return this._hashCode;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(NEWLINE + "DeployedWMMStaffQuery object content:" + NEWLINE);
        if (this._contextSignature == null) {
            stringBuffer.append("Context signature: null" + NEWLINE);
        } else {
            stringBuffer.append("Context signature (").append(this._contextSignature.length).append("):" + NEWLINE);
            for (n = 0; n < this._contextSignature.length; ++n) {
                stringBuffer.append(n + 1).append(": ");
                stringBuffer.append(this._contextSignature[n]).append(NEWLINE);
            }
        }
        if (this._queries == null) {
            stringBuffer.append("Queries: null" + NEWLINE);
        } else {
            stringBuffer.append("Queries (").append(this._queries.length).append("):" + NEWLINE);
            for (n = 0; n < this._queries.length; ++n) {
                stringBuffer.append(n + 1).append(": ");
                stringBuffer.append(this._queries[n]);
            }
        }
        stringBuffer.append("Threshold: ").append(this._threshold).append(NEWLINE);
        stringBuffer.append("Type: ");
        switch (this._type) {
            case 3: {
                stringBuffer.append("RESULT_TYPE_USERIDS" + NEWLINE);
                break;
            }
            case 0: {
                stringBuffer.append("RESULT_TYPE_NOBODY" + NEWLINE);
                break;
            }
            case 1: {
                stringBuffer.append("RESULT_TYPE_EVERYBODY" + NEWLINE);
                break;
            }
            case 4: {
                stringBuffer.append("RESULT_TYPE_GROUPIDS" + NEWLINE);
                break;
            }
            default: {
                stringBuffer.append("Illegal value!!!" + NEWLINE);
            }
        }
        stringBuffer.append("End DeployedWMMStaffQuery object content." + NEWLINE);
        return stringBuffer.toString();
    }

    static final class RemoveQuery
    extends ReusableQuery {
        public static final String COPYRIGHT = "(C) Copyright IBM Corporation 2001, 2006.";
        private static final long serialVersionUID = 2002110600004000L;
        private volatile int _hashCode = 0;
        private String _value;

        RemoveQuery(String string, boolean bl, String string2, String string3, List list) throws ProcessDeploymentException {
            super(bl, string3, string2, list);
            if (TraceLog.isTracing) {
                TraceLog.entry((Object[])new Object[]{string, bl ? Boolean.TRUE : Boolean.FALSE, string2, string3, list});
            }
            if (string == null || string.length() == 0) {
                throw new StaffPluginEmptyAttributeValueException(new Object[]{"value", "remove"});
            }
            this._value = string;
        }

        public boolean equals(Object object) {
            if (TraceLog.isTracing) {
                TraceLog.entry((Object)object, (Object)this);
            }
            if (object == this) {
                if (TraceLog.isTracing) {
                    TraceLog.exit((Object)Boolean.TRUE);
                }
                return true;
            }
            if (!(object instanceof RemoveQuery)) {
                return false;
            }
            RemoveQuery removeQuery = (RemoveQuery)object;
            if (this._value != removeQuery._value) {
                return false;
            }
            if (!super.equals(removeQuery)) {
                return false;
            }
            if (TraceLog.isTracing) {
                TraceLog.exit((Object)Boolean.TRUE);
            }
            return true;
        }

        String getValue() {
            return this._value;
        }

        public int hashCode() {
            if (this._hashCode == 0) {
                int n = 13;
                n = 37 * super.hashCode();
                this._hashCode = n = 37 * n + this._value.hashCode();
            }
            if (TraceLog.isTracing) {
                TraceLog.exit((Object)new Integer(this._hashCode));
            }
            return this._hashCode;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(NEWLINE + "  RemoveQuery object content:" + NEWLINE);
            stringBuffer.append("  Is intermediate Result: ").append(((ReusableQuery)this)._intermediateResult).append(NEWLINE);
            stringBuffer.append("  Intermediate Result Threshold: ").append(((ReusableQuery)this)._intermediateResultThreshold).append(NEWLINE);
            stringBuffer.append("  Intermediate Result Name: ").append(((ReusableQuery)this)._resultName).append(NEWLINE);
            stringBuffer.append("  Return Types (").append(((ReusableQuery)this)._returnTypes.length).append("):" + NEWLINE);
            for (int i = 0; i < ((ReusableQuery)this)._returnTypes.length; ++i) {
                stringBuffer.append("  ").append(i + 1).append(": ");
                stringBuffer.append(((ReusableQuery)this)._returnTypes[i]);
            }
            stringBuffer.append("  Value: ").append(this._value).append(NEWLINE);
            stringBuffer.append("  End RemoveQuery object content." + NEWLINE);
            return stringBuffer.toString();
        }
    }

    static final class UsersOfGroupQuery
    extends ReusableQuery {
        public static final String COPYRIGHT = "(C) Copyright IBM Corporation 2001, 2006.";
        private static final long serialVersionUID = 2002110600002000L;
        public static final int QUERY_TYPE_MEMBERS_OF_GROUP = 10003;
        static final String STRING_ELEMENT_MEMBERSOFGROUP = "membersOfGroup";
        private volatile int _hashCode = 0;
        private String _groupID;
        private int _idType;
        private boolean _recursive;

        UsersOfGroupQuery(String string, String string2, String string3, boolean bl, String string4, String string5, List list) throws ProcessDeploymentException {
            super(bl, string5, string4, list);
            if (TraceLog.isTracing) {
                TraceLog.entry((Object[])new Object[]{string, string2, string3, bl ? Boolean.TRUE : Boolean.FALSE, string4, string5, list});
            }
            if (string == null || string.length() == 0) {
                throw new StaffPluginEmptyAttributeValueException(new Object[]{"id", "usersOfGroup"});
            }
            this._groupID = string;
            if (string2 == null || string2.length() == 0) {
                throw new IllegalArgumentException("idType == null || idType.length() == 0");
            }
            if (string2.equals("memberDN")) {
                this._idType = 1;
            } else if (string2.equals("uniqueID")) {
                this._idType = 3;
            } else if (string2.equals("WASUserID")) {
                this._idType = 4;
            } else {
                throw new StaffPluginInvalidAttributeValueException(new Object[]{"idType", "'memberDN', 'uniqueID', 'WASUserID'", string2});
            }
            if (string3 == null || string3.length() == 0) {
                throw new IllegalArgumentException("recursive == null || recursive.length() == 0");
            }
            if (string3.equals("yes")) {
                this._recursive = true;
            } else if (string3.equals("no")) {
                this._recursive = false;
            } else {
                throw new StaffPluginInvalidAttributeValueException(new Object[]{"recursive", "'yes, 'yes'", string3});
            }
        }

        public boolean equals(Object object) {
            if (TraceLog.isTracing) {
                TraceLog.entry((Object)object, (Object)this);
            }
            if (object == this) {
                if (TraceLog.isTracing) {
                    TraceLog.exit((Object)Boolean.TRUE);
                }
                return true;
            }
            if (!(object instanceof UsersOfGroupQuery)) {
                return false;
            }
            UsersOfGroupQuery usersOfGroupQuery = (UsersOfGroupQuery)object;
            if (this._idType != usersOfGroupQuery._idType) {
                return false;
            }
            if (this._recursive != usersOfGroupQuery._recursive) {
                return false;
            }
            if (!this._groupID.equals(usersOfGroupQuery._groupID)) {
                return false;
            }
            if (!super.equals(usersOfGroupQuery)) {
                return false;
            }
            if (TraceLog.isTracing) {
                TraceLog.exit((Object)Boolean.TRUE);
            }
            return true;
        }

        String getGroupID() {
            return this._groupID;
        }

        int getIDType() {
            return this._idType;
        }

        public int hashCode() {
            if (this._hashCode == 0) {
                int n = 13;
                n = 37 * super.hashCode();
                n = 37 * n + this._groupID.hashCode();
                n = 37 * n + this._idType;
                this._hashCode = n = 37 * n + (this._recursive ? 0 : 1);
            }
            if (TraceLog.isTracing) {
                TraceLog.exit((Object)new Integer(this._hashCode));
            }
            return this._hashCode;
        }

        boolean isRecursive() {
            return this._recursive;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(NEWLINE + "  UsersOfGroupQuery object content:" + NEWLINE);
            stringBuffer.append("  Is Recursive: ").append(this._recursive).append(NEWLINE);
            stringBuffer.append("  Is intermediate Result: ").append(((ReusableQuery)this)._intermediateResult).append(NEWLINE);
            stringBuffer.append("  Intermediate Result Threshold: ").append(((ReusableQuery)this)._intermediateResultThreshold).append(NEWLINE);
            stringBuffer.append("  Intermediate Result Name: ").append(((ReusableQuery)this)._resultName).append(NEWLINE);
            stringBuffer.append("  Return Types (").append(((ReusableQuery)this)._returnTypes.length).append("):" + NEWLINE);
            for (int i = 0; i < ((ReusableQuery)this)._returnTypes.length; ++i) {
                stringBuffer.append("  ").append(i + 1).append(": ");
                stringBuffer.append(((ReusableQuery)this)._returnTypes[i]);
            }
            stringBuffer.append("  Group ID: ").append(this._groupID).append(NEWLINE);
            stringBuffer.append("  Group ID Type: ").append(this._idType).append(NEWLINE);
            stringBuffer.append("  End UsersOfGroupQuery object content." + NEWLINE);
            return stringBuffer.toString();
        }
    }

    static final class UserQuery
    extends ReusableQuery {
        public static final String COPYRIGHT = "(C) Copyright IBM Corporation 2001, 2006.";
        private static final long serialVersionUID = 2002110300002000L;
        static final String STRING_ATTRIBUTE_REALM = "realm";
        private volatile int _hashCode = 0;
        private String _id;
        private String _realm;
        private int _idType;

        UserQuery(String string, String string2, String string3, boolean bl, String string4, String string5, List list) throws ProcessDeploymentException {
            super(bl, string5, string4, list);
            if (TraceLog.isTracing) {
                TraceLog.entry((Object[])new Object[]{string, string2, bl ? Boolean.TRUE : Boolean.FALSE, string4, string5, list});
            }
            if (list.size() != 1) {
                throw new IllegalArgumentException("returnTypes.size() != 1");
            }
            if (string == null || string.length() == 0) {
                throw new StaffPluginEmptyAttributeValueException(new Object[]{"id", "userID"});
            }
            this._id = string;
            if (string2 == null || string2.length() == 0) {
                throw new IllegalArgumentException("idType == null || idType.length() == 0");
            }
            if (string2.equals("memberDN")) {
                this._idType = 1;
            } else if (string2.equals("uniqueID")) {
                this._idType = 3;
            } else if (string2.equals("WASUserID")) {
                this._idType = 4;
            } else {
                throw new StaffPluginInvalidAttributeValueException(new Object[]{"idType", "'memberDN', 'uniqueID', 'WASUserID'", string2});
            }
            this._realm = string3;
        }

        public boolean equals(Object object) {
            if (TraceLog.isTracing) {
                TraceLog.entry((Object)object, (Object)this);
            }
            if (object == this) {
                if (TraceLog.isTracing) {
                    TraceLog.exit((Object)Boolean.TRUE);
                }
                return true;
            }
            if (!(object instanceof UserQuery)) {
                return false;
            }
            UserQuery userQuery = (UserQuery)object;
            if (this._idType != userQuery._idType) {
                return false;
            }
            if (!this._id.equals(userQuery._id)) {
                return false;
            }
            if (this._realm != null) {
                if (userQuery._realm != null) {
                    return false;
                }
                if (!this._realm.equals(userQuery._realm)) {
                    return false;
                }
            } else if (userQuery._realm == null) {
                return false;
            }
            if (!super.equals(userQuery)) {
                return false;
            }
            if (TraceLog.isTracing) {
                TraceLog.exit((Object)Boolean.TRUE);
            }
            return true;
        }

        String getID() {
            return this._id;
        }

        int getIDType() {
            return this._idType;
        }

        String getRealm() {
            return this._realm;
        }

        public int hashCode() {
            if (this._hashCode == 0) {
                int n = 19;
                n = 37 * super.hashCode();
                n = 37 * n + this._id.hashCode();
                n = 37 * n + this._idType;
                n = this._realm == null ? 37 * n : 37 * n + this._realm.hashCode();
                this._hashCode = n;
            }
            if (TraceLog.isTracing) {
                TraceLog.exit((Object)new Integer(this._hashCode));
            }
            return this._hashCode;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(NEWLINE + "  UserQuery object content:" + NEWLINE);
            stringBuffer.append("  Is intermediate Result: ").append(((ReusableQuery)this)._intermediateResult).append(NEWLINE);
            stringBuffer.append("  Intermediate Result Threshold: ").append(((ReusableQuery)this)._intermediateResultThreshold).append(NEWLINE);
            stringBuffer.append("  Intermediate Result Name: ").append(((ReusableQuery)this)._resultName).append(NEWLINE);
            stringBuffer.append("  Return Types (").append(((ReusableQuery)this)._returnTypes.length).append("):" + NEWLINE);
            for (int i = 0; i < ((ReusableQuery)this)._returnTypes.length; ++i) {
                stringBuffer.append("  ").append(i + 1).append(": ");
                stringBuffer.append(((ReusableQuery)this)._returnTypes[i]);
            }
            stringBuffer.append("  User ID: ").append(this._id).append(NEWLINE);
            stringBuffer.append("  User ID Type: ").append(this._idType).append(NEWLINE);
            stringBuffer.append("  UserRegistry realm: ").append(this._realm).append(NEWLINE);
            stringBuffer.append("  End UserQuery object content." + NEWLINE);
            return stringBuffer.toString();
        }
    }

    static final class UserIDQuery
    implements WMMQuery {
        public static final String COPYRIGHT = "(C) Copyright IBM Corporation 2001, 2006.";
        private static final long serialVersionUID = 2002102100001000L;
        private volatile int _hashCode = 0;
        private String _userID;

        UserIDQuery(String string) throws ProcessDeploymentException {
            if (TraceLog.isTracing) {
                TraceLog.entry((Object)string);
            }
            if (string == null || string.length() == 0) {
                throw new StaffPluginEmptyAttributeValueException(new Object[]{"name", "userID"});
            }
            this._userID = string;
        }

        public boolean equals(Object object) {
            if (TraceLog.isTracing) {
                TraceLog.entry((Object)object, (Object)this);
            }
            if (object == this) {
                if (TraceLog.isTracing) {
                    TraceLog.exit((Object)Boolean.TRUE);
                }
                return true;
            }
            if (!(object instanceof UserIDQuery)) {
                return false;
            }
            UserIDQuery userIDQuery = (UserIDQuery)object;
            if (!this._userID.equals(userIDQuery._userID)) {
                return false;
            }
            if (TraceLog.isTracing) {
                TraceLog.exit((Object)Boolean.TRUE);
            }
            return true;
        }

        String getUserID() {
            return this._userID;
        }

        public int hashCode() {
            if (this._hashCode == 0) {
                int n = 11;
                this._hashCode = n = 37 * n + this._userID.hashCode();
            }
            if (TraceLog.isTracing) {
                TraceLog.exit((Object)new Integer(this._hashCode));
            }
            return this._hashCode;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(NEWLINE + "  UserIDQuery object content:" + NEWLINE);
            stringBuffer.append("  UserID: ").append(this._userID).append(NEWLINE);
            stringBuffer.append("  End UserIDQuery object content." + NEWLINE);
            return stringBuffer.toString();
        }
    }

    static final class SearchQuery
    extends ReusableQuery {
        public static final String COPYRIGHT = "(C) Copyright IBM Corporation 2001, 2006.";
        private static final long serialVersionUID = 2002110600003000L;
        public static final int QUERY_TYPE_ADVANCED_SEARCH = 10002;
        static final String STRING_ATTRIBUTE_RETURNATTRIBUTE = "returnAttribute";
        static final String STRING_ATTRIBUTE_TIMEOUT = "timeout";
        static final String STRING_ELEMENT_ADVANCEDSEARCH = "advancedSearch";
        private volatile int _hashCode = 0;
        private SearchAttribute[] _searchAttributes;
        private int _timeout;
        private String _searchBase;

        SearchQuery(List list, String string, boolean bl, String string2, String string3, List list2, String string4) throws ProcessDeploymentException {
            super(bl, string3, string2, list2);
            if (TraceLog.isTracing) {
                TraceLog.entry((Object[])new Object[]{list, string, bl ? Boolean.TRUE : Boolean.FALSE, string2, string3, list2});
            }
            if (list2.size() != 1) {
                throw new IllegalArgumentException("returnTypes.size() != 1");
            }
            if (list == null) {
                throw new IllegalArgumentException("searchAttributes == null");
            }
            if (list.size() < 1) {
                throw new IllegalArgumentException("searchAttributes.size() < 1");
            }
            this._searchAttributes = list.toArray(new SearchAttribute[list.size()]);
            if (string == null) {
                this._timeout = -1;
            } else {
                try {
                    if (string.length() == 0) {
                        throw new StaffPluginEmptyAttributeValueException(new Object[]{STRING_ATTRIBUTE_TIMEOUT, STRING_ELEMENT_ADVANCEDSEARCH});
                    }
                    this._timeout = Integer.parseInt(string);
                    if (this._timeout <= 0) {
                        throw new StaffPluginInvalidAttributeValueException(new Object[]{STRING_ATTRIBUTE_TIMEOUT, "1 ... 2147483647"});
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.bpe.staff.DeployedWMMStaffQuery", (String)"SearchQuery_1");
                    throw new StaffPluginInvalidAttributeValueException(new Object[]{STRING_ATTRIBUTE_TIMEOUT, "1 ... 2147483647"}, (Throwable)numberFormatException);
                }
            }
            this._searchBase = string4;
        }

        public boolean equals(Object object) {
            if (TraceLog.isTracing) {
                TraceLog.entry((Object)object, (Object)this);
            }
            if (object == this) {
                if (TraceLog.isTracing) {
                    TraceLog.exit((Object)Boolean.TRUE);
                }
                return true;
            }
            if (!(object instanceof SearchQuery)) {
                return false;
            }
            SearchQuery searchQuery = (SearchQuery)object;
            if (searchQuery._searchAttributes.length != this._searchAttributes.length) {
                return false;
            }
            for (int i = 0; i < this._searchAttributes.length; ++i) {
                if (this._searchAttributes[i].equals(searchQuery._searchAttributes[i])) continue;
                return false;
            }
            if (this._timeout != searchQuery._timeout) {
                return false;
            }
            if (this._searchBase != searchQuery._searchBase) {
                return false;
            }
            if (!super.equals(searchQuery)) {
                return false;
            }
            if (TraceLog.isTracing) {
                TraceLog.exit((Object)Boolean.TRUE);
            }
            return true;
        }

        SearchAttribute[] getSearchAttributes() {
            return this._searchAttributes;
        }

        int getTimeout() {
            return this._timeout;
        }

        String getSearchBase() {
            return this._searchBase;
        }

        public int hashCode() {
            if (this._hashCode == 0) {
                int n = 17;
                n = 37 * super.hashCode();
                for (int i = 0; i < this._searchAttributes.length; ++i) {
                    n = 37 * n + this._searchAttributes[i].hashCode();
                }
                n = 37 * n + this._timeout;
                if (this._searchBase != null) {
                    n = 37 * n + this._searchBase.hashCode();
                }
                this._hashCode = n;
            }
            if (TraceLog.isTracing) {
                TraceLog.exit((Object)new Integer(this._hashCode));
            }
            return this._hashCode;
        }

        public String toString() {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(NEWLINE + "  SearchQuery object content:" + NEWLINE);
            stringBuffer.append("  Is intermediate Result: ").append(((ReusableQuery)this)._intermediateResult).append(NEWLINE);
            stringBuffer.append("  Intermediate Result Threshold: ").append(((ReusableQuery)this)._intermediateResultThreshold).append(NEWLINE);
            stringBuffer.append("  Intermediate Result Name: ").append(((ReusableQuery)this)._resultName).append(NEWLINE);
            stringBuffer.append("  Return Types (").append(((ReusableQuery)this)._returnTypes.length).append("):" + NEWLINE);
            for (n = 0; n < ((ReusableQuery)this)._returnTypes.length; ++n) {
                stringBuffer.append("  ").append(n + 1).append(": ");
                stringBuffer.append(((ReusableQuery)this)._returnTypes[n]);
            }
            stringBuffer.append("  Search Attributes (").append(this._searchAttributes.length).append("):" + NEWLINE);
            for (n = 0; n < this._searchAttributes.length; ++n) {
                stringBuffer.append("  ").append(n + 1).append(": ");
                stringBuffer.append(this._searchAttributes[n]);
            }
            stringBuffer.append("  Search Timeout: ").append(this._timeout).append(NEWLINE);
            stringBuffer.append("  Search base: ").append(this._searchBase).append(NEWLINE);
            stringBuffer.append("  End SearchQuery object content." + NEWLINE);
            return stringBuffer.toString();
        }
    }

    static final class SearchAttribute
    implements Serializable {
        public static final String COPYRIGHT = "(C) Copyright IBM Corporation 2001, 2006.";
        private static final long serialVersionUID = 2002110600001000L;
        static final String STRING_ATTRIBUTE_NAME = "name";
        static final String STRING_OPERATOR_AND = "and";
        static final String STRING_OPERATOR_OR = "or";
        private volatile int _hashCode = 0;
        private String _name;
        private Object[] _conditionSequence;

        SearchAttribute(String string, List list) throws ProcessDeploymentException {
            if (TraceLog.isTracing) {
                TraceLog.entry((Object)string, (Object)list);
            }
            if (string == null || string.length() == 0) {
                throw new StaffPluginEmptyAttributeValueException(new Object[]{STRING_ATTRIBUTE_NAME, DeployedWMMStaffQuery.STRING_SEARCHATTRIBUTE});
            }
            this._name = string;
            if (list == null) {
                throw new IllegalArgumentException("conditionSequence == null");
            }
            if (list.size() < 1) {
                throw new IllegalArgumentException("conditionSequence.size() < 1");
            }
            this._conditionSequence = list.toArray(new Object[list.size()]);
        }

        public boolean equals(Object object) {
            if (TraceLog.isTracing) {
                TraceLog.entry((Object)object, (Object)this);
            }
            if (object == this) {
                if (TraceLog.isTracing) {
                    TraceLog.exit((Object)Boolean.TRUE);
                }
                return true;
            }
            if (!(object instanceof SearchAttribute)) {
                return false;
            }
            SearchAttribute searchAttribute = (SearchAttribute)object;
            if (!this._name.equals(searchAttribute._name)) {
                return false;
            }
            if (searchAttribute._conditionSequence.length != this._conditionSequence.length) {
                return false;
            }
            for (int i = 0; i < this._conditionSequence.length; ++i) {
                if (this._conditionSequence[i].equals(searchAttribute._conditionSequence[i])) continue;
                return false;
            }
            if (TraceLog.isTracing) {
                TraceLog.exit((Object)Boolean.TRUE);
            }
            return true;
        }

        String getName() {
            return this._name;
        }

        Object[] getConditionSequence() {
            return this._conditionSequence;
        }

        public int hashCode() {
            if (this._hashCode == 0) {
                int n = 11;
                n = 37 * n + this._name.hashCode();
                for (int i = 0; i < this._conditionSequence.length; ++i) {
                    n = 37 * n + this._conditionSequence[i].hashCode();
                }
                this._hashCode = n;
            }
            if (TraceLog.isTracing) {
                TraceLog.exit((Object)new Integer(this._hashCode));
            }
            return this._hashCode;
        }

        public boolean isRegistered(List list) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                SearchAttribute searchAttribute = (SearchAttribute)iterator.next();
                if (searchAttribute._name != this._name) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(NEWLINE + "    SearchAttribute object content:" + NEWLINE);
            stringBuffer.append("    Name: ").append(this._name).append(NEWLINE);
            stringBuffer.append("    Condition Sequence (").append(this._conditionSequence.length).append("):" + NEWLINE);
            for (int i = 0; i < this._conditionSequence.length; ++i) {
                stringBuffer.append("    ").append(i + 1).append(": ");
                if (this._conditionSequence[i] instanceof Condition) {
                    stringBuffer.append(this._conditionSequence[i]);
                    continue;
                }
                if (this._conditionSequence[i] instanceof Short) {
                    if (((Short)this._conditionSequence[i]).equals(AttributeSearchConditionsData.OPERATOR_AND)) {
                        stringBuffer.append("      ").append(STRING_OPERATOR_AND).append(NEWLINE);
                        continue;
                    }
                    if (((Short)this._conditionSequence[i]).equals(AttributeSearchConditionsData.OPERATOR_OR)) {
                        stringBuffer.append("      ").append(STRING_OPERATOR_OR).append(NEWLINE);
                        continue;
                    }
                    stringBuffer.append("      Illegal value!!!" + NEWLINE);
                    continue;
                }
                stringBuffer.append("      Illegal object class!!!" + NEWLINE);
            }
            stringBuffer.append("    End SearchAttribute object content." + NEWLINE);
            return stringBuffer.toString();
        }
    }

    protected static abstract class ReusableQuery
    implements WMMQuery {
        public static final String COPYRIGHT = "(C) Copyright IBM Corporation 2001, 2006.";
        private static final long serialVersionUID = 2002103100001000L;
        public static final int INTERMEDIATE_RESULT = 10001;
        static final String STRING_ELEMENT_INTERMEDIATERESULT = "intermediateResult";
        static final String STRING_ATTRIBUTE_NAME = "name";
        private boolean _intermediateResult;
        private int _intermediateResultThreshold;
        private String _resultName;
        private ReturnType[] _returnTypes;

        protected ReusableQuery(boolean bl, String string, String string2, List list) throws ProcessDeploymentException {
            if (TraceLog.isTracing) {
                TraceLog.entry((Object[])new Object[]{string, string2});
            }
            this._intermediateResult = bl;
            if (this._intermediateResult) {
                if (string2 == null || string2.length() == 0) {
                    throw new StaffPluginEmptyAttributeValueException(new Object[]{STRING_ATTRIBUTE_NAME, STRING_ELEMENT_INTERMEDIATERESULT});
                }
                this._resultName = string2;
            } else {
                this._resultName = null;
            }
            this._intermediateResultThreshold = this._intermediateResult ? (string == null ? -1 : StaffPluginUtil.computeThreshold((String)string, (String)STRING_ELEMENT_INTERMEDIATERESULT)) : -1;
            if (list.size() < 1) {
                throw new IllegalArgumentException("returnTypes.size() < 1");
            }
            this._returnTypes = list.toArray(new ReturnType[list.size()]);
        }

        public boolean equals(Object object) {
            if (TraceLog.isTracing) {
                TraceLog.entry((Object)object, (Object)this);
            }
            if (object == this) {
                if (TraceLog.isTracing) {
                    TraceLog.exit((Object)Boolean.TRUE);
                }
                return true;
            }
            if (!(object instanceof ReusableQuery)) {
                return false;
            }
            ReusableQuery reusableQuery = (ReusableQuery)object;
            if (reusableQuery._intermediateResult != this._intermediateResult) {
                return false;
            }
            if (reusableQuery._intermediateResultThreshold != this._intermediateResultThreshold) {
                return false;
            }
            if (this._resultName != null) {
                if (reusableQuery._resultName != null) {
                    return false;
                }
                if (!this._resultName.equals(reusableQuery._resultName)) {
                    return false;
                }
            } else if (reusableQuery._resultName == null) {
                return false;
            }
            if (reusableQuery._returnTypes.length != this._returnTypes.length) {
                return false;
            }
            for (int i = 0; i < this._returnTypes.length; ++i) {
                if (this._returnTypes[i].equals(reusableQuery._returnTypes[i])) continue;
                return false;
            }
            if (TraceLog.isTracing) {
                TraceLog.exit((Object)Boolean.TRUE);
            }
            return true;
        }

        int getIntermediateResultThreshold() {
            return this._intermediateResultThreshold;
        }

        String getResultName() {
            return this._resultName;
        }

        ReturnType[] getReturnTypes() {
            return this._returnTypes;
        }

        public int hashCode() {
            int n = 17;
            n = 37 * n + (this._intermediateResult ? 0 : 1);
            n = 37 * n + this._intermediateResultThreshold;
            n = this._resultName == null ? 37 * n : 37 * n + this._resultName.hashCode();
            for (int i = 0; i < this._returnTypes.length; ++i) {
                n = 37 * n + this._returnTypes[i].hashCode();
            }
            if (TraceLog.isTracing) {
                TraceLog.exit((Object)new Integer(n));
            }
            return n;
        }

        boolean isIntermediateResult() {
            return this._intermediateResult;
        }
    }

    static final class GroupIDQuery
    implements WMMQuery {
        public static final String COPYRIGHT = DeployedWMMStaffQuery.access$000() + DeployedWMMStaffQuery.access$000() + "(C) Copyright IBM Corporation 2006." + DeployedWMMStaffQuery.access$000() + DeployedWMMStaffQuery.access$000();
        private static final long serialVersionUID = 2006106060001000L;
        private volatile int _hashCode = 0;
        private String _groupID;

        GroupIDQuery(String string) throws ProcessDeploymentException {
            if (TraceLog.isTracing) {
                TraceLog.entry((Object)string);
            }
            if (string == null || string.length() == 0) {
                throw new StaffPluginEmptyAttributeValueException(new Object[]{"name", "groupID"});
            }
            this._groupID = string;
        }

        public boolean equals(Object object) {
            if (TraceLog.isTracing) {
                TraceLog.entry((Object)object, (Object)this);
            }
            if (object == this) {
                if (TraceLog.isTracing) {
                    TraceLog.exit((Object)Boolean.TRUE);
                }
                return true;
            }
            if (!(object instanceof GroupIDQuery)) {
                return false;
            }
            GroupIDQuery groupIDQuery = (GroupIDQuery)object;
            if (!this._groupID.equals(groupIDQuery._groupID)) {
                return false;
            }
            if (TraceLog.isTracing) {
                TraceLog.exit((Object)Boolean.TRUE);
            }
            return true;
        }

        String getGroupID() {
            return this._groupID;
        }

        public int hashCode() {
            if (this._hashCode == 0) {
                int n = 17;
                this._hashCode = n = 37 * n + this._groupID.hashCode();
            }
            if (TraceLog.isTracing) {
                TraceLog.exit((Object)new Integer(this._hashCode));
            }
            return this._hashCode;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(NEWLINE + "  GroupIDQuery object content:" + NEWLINE);
            stringBuffer.append("  GroupID: ").append(this._groupID).append(NEWLINE);
            stringBuffer.append("  End GroupIDQuery object content." + NEWLINE);
            return stringBuffer.toString();
        }
    }

    static final class ReturnType
    implements Serializable {
        public static final String COPYRIGHT = "(C) Copyright IBM Corporation 2001, 2006.";
        private static final long serialVersionUID = 2002110500001000L;
        static final String STRING_ATTRIBUTE_ATTRIBUTE = "attribute";
        static final String STRING_ATTRIBUTE_NAME = "name";
        static final String STRING_RETURN_TYPE_GROUP = "group";
        static final String STRING_RETURN_TYPE_GROUP_RECURSIVE = "groupRecursive";
        static final String STRING_RETURN_TYPE_PERSON = "person";
        static final String STRING_RETURN_TYPE_ORGANIZATION = "organization";
        static final String STRING_RETURN_TYPE_ORGANIZATIONAL_UNIT = "organizationalUnit";
        private volatile int _hashCode = 0;
        private String _attribute;
        private short _type;

        ReturnType(String string, String string2) throws ProcessDeploymentException {
            if (TraceLog.isTracing) {
                TraceLog.entry((Object)string, (Object)string2);
            }
            if (string == null || string.length() == 0) {
                throw new StaffPluginEmptyAttributeValueException(new Object[]{STRING_ATTRIBUTE_ATTRIBUTE, DeployedWMMStaffQuery.STRING_RETURNTYPE});
            }
            this._attribute = string;
            if (string2 == null || string2.length() == 0) {
                throw new StaffPluginEmptyAttributeValueException(new Object[]{STRING_ATTRIBUTE_NAME, DeployedWMMStaffQuery.STRING_RETURNTYPE});
            }
            if (string2.equals(STRING_RETURN_TYPE_GROUP)) {
                this._type = 1;
            } else if (string2.equals(STRING_RETURN_TYPE_GROUP_RECURSIVE)) {
                this._type = (short)2000;
            } else if (string2.equals(STRING_RETURN_TYPE_PERSON)) {
                this._type = 0;
            } else if (string2.equals(STRING_RETURN_TYPE_ORGANIZATION)) {
                this._type = (short)2;
            } else if (string2.equals(STRING_RETURN_TYPE_ORGANIZATIONAL_UNIT)) {
                this._type = (short)3;
            } else {
                throw new StaffPluginInvalidAttributeValueException(new Object[]{STRING_ATTRIBUTE_NAME, "'group', 'groupRecursive', 'organization', 'organizationalUnit', 'person'", string2});
            }
        }

        public boolean equals(Object object) {
            if (TraceLog.isTracing) {
                TraceLog.entry((Object)object, (Object)this);
            }
            if (object == this) {
                if (TraceLog.isTracing) {
                    TraceLog.exit((Object)Boolean.TRUE);
                }
                return true;
            }
            if (!(object instanceof ReturnType)) {
                return false;
            }
            ReturnType returnType = (ReturnType)object;
            if (!this._attribute.equals(returnType._attribute)) {
                return false;
            }
            if (this._type != returnType._type) {
                return false;
            }
            if (TraceLog.isTracing) {
                TraceLog.exit((Object)Boolean.TRUE);
            }
            return true;
        }

        String getAttribute() {
            return this._attribute;
        }

        short getType() {
            return this._type;
        }

        public int hashCode() {
            if (this._hashCode == 0) {
                int n = 11;
                n = 37 * n + this._attribute.hashCode();
                this._hashCode = n = 37 * n + this._type;
            }
            if (TraceLog.isTracing) {
                TraceLog.exit((Object)new Integer(this._hashCode));
            }
            return this._hashCode;
        }

        public boolean isRegistered(List list) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ReturnType returnType = (ReturnType)iterator.next();
                if (returnType._type != this._type) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(NEWLINE + "    ReturnType object content:" + NEWLINE);
            stringBuffer.append("    Attribute: ").append(this._attribute).append(NEWLINE);
            stringBuffer.append("    Type: ");
            switch (this._type) {
                case 1: {
                    stringBuffer.append(STRING_RETURN_TYPE_GROUP).append(NEWLINE);
                    break;
                }
                case 2000: {
                    stringBuffer.append(STRING_RETURN_TYPE_GROUP_RECURSIVE).append(NEWLINE);
                    break;
                }
                case 0: {
                    stringBuffer.append(STRING_RETURN_TYPE_PERSON).append(NEWLINE);
                    break;
                }
                case 2: {
                    stringBuffer.append(STRING_RETURN_TYPE_ORGANIZATION).append(NEWLINE);
                    break;
                }
                case 3: {
                    stringBuffer.append(STRING_RETURN_TYPE_ORGANIZATIONAL_UNIT).append(NEWLINE);
                    break;
                }
                default: {
                    stringBuffer.append("Illegal value!!!" + NEWLINE);
                }
            }
            stringBuffer.append("    End ReturnType object content." + NEWLINE);
            return stringBuffer.toString();
        }
    }

    static interface WMMQuery
    extends Serializable {
        public static final int ID_TYPE_MEMBER_DN = 1;
        public static final int ID_TYPE_UNIQUEID = 3;
        public static final int ID_TYPE_WAS_USERID = 4;
        public static final short RETURN_TYPE_GROUP_RECURSIVE = 2000;
        public static final String STRING_ATTRIBUTE_ID = "id";
        public static final String STRING_ATTRIBUTE_IDTYPE = "idType";
        public static final String STRING_ATTRIBUTE_RECURSIVE = "recursive";
        public static final String STRING_ATTRIBUTE_VALUE = "value";
        public static final String STRING_ID_TYPE_MEMBERDN = "memberDN";
        public static final String STRING_ID_TYPE_UNIQUEID = "uniqueID";
        public static final String STRING_ID_TYPE_WASUSERID = "WASUserID";
        public static final String STRING_RECURSIVE_YES = "yes";
        public static final String STRING_RECURSIVE_NO = "no";
        public static final String DEFAULT_WAS_ATTRIBUTE = "accountName";
        public static final String DEFAULT_ID_TYPE = "memberDN";
    }

    static final class Condition
    implements Serializable {
        public static final String COPYRIGHT = "(C) Copyright IBM Corporation 2001, 2006.";
        private static final long serialVersionUID = 2002110600001000L;
        static final String STRING_ATTRIBUTE_REFERENCETYPE = "referenceType";
        static final String STRING_ATTRIBUTE_REFERENCEVALUE = "referenceValue";
        static final String STRING_ELEMENT_COMPLEXCONDITION = "complexCondition";
        static final String STRING_ELEMENT_SIMPLECONDITION = "simpleCondition";
        static final String STRING_OPERATOR_EQ = "equal";
        static final String STRING_OPERATOR_GT = "greaterThan";
        static final String STRING_OPERATOR_GE = "greaterOrEqual";
        static final String STRING_OPERATOR_LE = "lessOrEqual";
        static final String STRING_OPERATOR_LIKE = "like";
        static final String STRING_OPERATOR_LT = "lessThan";
        static final String STRING_OPERATOR_NE = "notEqual";
        static final String STRING_OPERATOR_NOT_NULL = "notNULL";
        static final String STRING_TYPE_STRING = "String";
        static final String STRING_TYPE_TIMESTAMP = "Timestamp";
        static final String STRING_TYPE_LONG = "Long";
        static final String STRING_TYPE_INTEGER = "Integer";
        static final String STRING_TYPE_DOUBLE = "Double";
        static final String STRING_TYPE_MEMBER_IDENTIFIER = "MemberIdentifier";
        static final int TYPE_STRING = 1;
        static final int TYPE_TIMESTAMP = 2;
        static final int TYPE_LONG = 3;
        static final int TYPE_INTEGER = 4;
        static final int TYPE_DOUBLE = 5;
        static final int TYPE_MEMBER_IDENTIFIER = 6;
        private volatile int _hashCode = 0;
        private short _operator;
        private String _referenceValue;
        private int _referenceType;

        Condition(String string, String string2, String string3, String string4) throws ProcessDeploymentException {
            if (TraceLog.isTracing) {
                TraceLog.entry((Object[])new Object[]{string, string2, string3});
            }
            if (string == null || string.length() == 0) {
                throw new StaffPluginEmptyAttributeValueException(new Object[]{DeployedWMMStaffQuery.STRING_OPERATOR, string4});
            }
            if (string.equals(STRING_OPERATOR_EQ)) {
                this._operator = 0;
            } else if (string.equals(STRING_OPERATOR_GT)) {
                this._operator = (short)2;
            } else if (string.equals(STRING_OPERATOR_GE)) {
                this._operator = (short)4;
            } else if (string.equals(STRING_OPERATOR_LE)) {
                this._operator = (short)5;
            } else if (string.equals(STRING_OPERATOR_LIKE)) {
                this._operator = (short)6;
            } else if (string.equals(STRING_OPERATOR_LT)) {
                this._operator = (short)3;
            } else if (string.equals(STRING_OPERATOR_NE)) {
                this._operator = 1;
            } else if (string.equals(STRING_OPERATOR_NOT_NULL)) {
                this._operator = (short)7;
            } else {
                throw new StaffPluginInvalidAttributeValueException(new Object[]{DeployedWMMStaffQuery.STRING_OPERATOR, "'equal', 'greaterThan', 'greaterOrEqual', 'lessOrEqual', 'like', 'lessThan', 'notEqual', 'notNULL'", string});
            }
            if (string2 == null || string2.length() == 0) {
                throw new StaffPluginEmptyAttributeValueException(new Object[]{STRING_ATTRIBUTE_REFERENCEVALUE, string4});
            }
            this._referenceValue = string2;
            if (string3 == null || string3.length() == 0) {
                throw new StaffPluginEmptyAttributeValueException(new Object[]{STRING_ATTRIBUTE_REFERENCETYPE, string4});
            }
            if (string3.equals(STRING_TYPE_STRING)) {
                this._referenceType = 1;
            } else if (string3.equals(STRING_TYPE_TIMESTAMP)) {
                this._referenceType = 2;
            } else if (string3.equals(STRING_TYPE_LONG)) {
                this._referenceType = 3;
            } else if (string3.equals(STRING_TYPE_INTEGER)) {
                this._referenceType = 4;
            } else if (string3.equals(STRING_TYPE_DOUBLE)) {
                this._referenceType = 5;
            } else if (string3.equals(STRING_TYPE_MEMBER_IDENTIFIER)) {
                this._referenceType = 6;
            } else {
                throw new StaffPluginInvalidAttributeValueException(new Object[]{STRING_ATTRIBUTE_REFERENCETYPE, "'String', 'Timestamp', 'Double', 'Integer', 'Long'", "MemberIdentifier'", string3});
            }
        }

        public boolean equals(Object object) {
            if (TraceLog.isTracing) {
                TraceLog.entry((Object)object, (Object)this);
            }
            if (object == this) {
                if (TraceLog.isTracing) {
                    TraceLog.exit((Object)Boolean.TRUE);
                }
                return true;
            }
            if (!(object instanceof Condition)) {
                return false;
            }
            Condition condition = (Condition)object;
            if (condition._operator != this._operator) {
                return false;
            }
            if (condition._referenceType != this._referenceType) {
                return false;
            }
            if (!this._referenceValue.equals(condition._referenceValue)) {
                return false;
            }
            if (TraceLog.isTracing) {
                TraceLog.exit((Object)Boolean.TRUE);
            }
            return true;
        }

        short getOperator() {
            return this._operator;
        }

        int getReferenceType() {
            return this._referenceType;
        }

        String getReferenceValue() {
            return this._referenceValue;
        }

        public int hashCode() {
            if (this._hashCode == 0) {
                int n = 11;
                n = 37 * n + this._operator;
                n = 37 * n + this._referenceType;
                this._hashCode = n = 37 * n + this._referenceValue.hashCode();
            }
            if (TraceLog.isTracing) {
                TraceLog.exit((Object)new Integer(this._hashCode));
            }
            return this._hashCode;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(NEWLINE + "      Condition object content:" + NEWLINE);
            stringBuffer.append("      Operator: ");
            switch (this._operator) {
                case 0: {
                    stringBuffer.append(STRING_OPERATOR_EQ).append(NEWLINE);
                    break;
                }
                case 2: {
                    stringBuffer.append(STRING_OPERATOR_GT).append(NEWLINE);
                    break;
                }
                case 4: {
                    stringBuffer.append(STRING_OPERATOR_GE).append(NEWLINE);
                    break;
                }
                case 5: {
                    stringBuffer.append(STRING_OPERATOR_LE).append(NEWLINE);
                    break;
                }
                case 6: {
                    stringBuffer.append(STRING_OPERATOR_LIKE).append(NEWLINE);
                    break;
                }
                case 3: {
                    stringBuffer.append(STRING_OPERATOR_LT).append(NEWLINE);
                    break;
                }
                case 1: {
                    stringBuffer.append(STRING_OPERATOR_NE).append(NEWLINE);
                    break;
                }
                case 7: {
                    stringBuffer.append(STRING_OPERATOR_NOT_NULL).append(NEWLINE);
                    break;
                }
                default: {
                    stringBuffer.append("Illegal value!!!" + NEWLINE);
                }
            }
            stringBuffer.append("      Reference Value: ").append(this._referenceValue).append(NEWLINE);
            stringBuffer.append("      Reference Type: ");
            switch (this._referenceType) {
                case 1: {
                    stringBuffer.append(STRING_TYPE_STRING).append(NEWLINE);
                    break;
                }
                case 2: {
                    stringBuffer.append(STRING_TYPE_TIMESTAMP).append(NEWLINE);
                    break;
                }
                case 3: {
                    stringBuffer.append(STRING_TYPE_LONG).append(NEWLINE);
                    break;
                }
                case 4: {
                    stringBuffer.append(STRING_TYPE_INTEGER).append(NEWLINE);
                    break;
                }
                case 5: {
                    stringBuffer.append(STRING_TYPE_DOUBLE).append(NEWLINE);
                    break;
                }
                case 6: {
                    stringBuffer.append(STRING_TYPE_MEMBER_IDENTIFIER).append(NEWLINE);
                    break;
                }
                default: {
                    stringBuffer.append("Illegal value!!!" + NEWLINE);
                }
            }
            stringBuffer.append("      End Condition object content." + NEWLINE);
            return stringBuffer.toString();
        }
    }
}

