/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.RepaintManager;
import javax.swing.Scrollable;
import javax.swing.text.View;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

class hlcpEditorPane
extends JEditorPane
implements Scrollable,
Printable,
Pageable,
Serializable {
    int lineheight;
    int lineascent;
    int linesPerPage;
    View nbv;
    Pager pg;
    PageFormat tbPageFormat = new PageFormat();
    hlcPrintStatus printProgress;
    String footerLeft = new String();
    String footerRight = new String();

    public hlcpEditorPane() {
        this.setEditable(false);
        this.setContentType("text/html");
        HTMLEditorKit kit = new HTMLEditorKit();
        HTMLDocument doc = (HTMLDocument)kit.createDefaultDocument();
        this.setEditorKit(kit);
        this.setDocument(doc);
    }

    public void scrollTo(String target) {
        this.scrollToReference(target);
    }

    public void scrollRectToVisible(Rectangle r) {
        if (r.y < 0) {
            r.y = 0;
        }
        super.scrollRectToVisible(r);
    }

    public void turnOnDoubleBuffering() {
        RepaintManager.currentManager(this).setDoubleBufferingEnabled(true);
    }

    public Printable getPrintable(int pi) {
        return this;
    }

    public PageFormat getPageFormat(int pi) {
        return this.tbPageFormat;
    }

    public int getNumberOfPages() {
        Dimension d = this.getSize();
        double paneWidth = d.width;
        double paneHeight = d.height;
        double pageHeight = this.tbPageFormat.getImageableHeight();
        double pageWidth = this.tbPageFormat.getImageableWidth();
        double printscale = pageWidth / paneWidth;
        int wpage = (int)(pageWidth / printscale);
        int hfpage = (int)(pageHeight / printscale);
        int hpage = hfpage - (int)(0.06 * (double)hfpage);
        if (this.nbv == null) {
            View root;
            this.nbv = root = this.getUI().getRootView(this);
            this.pg = new Pager(this.nbv, wpage, hpage);
            this.pg.paginate();
        }
        return this.pg.pageCount();
    }

    public void openPrintStatus(hlcPrintStatus ps) {
        this.printProgress = ps;
    }

    public int print(Graphics g1d, PageFormat pf, int pi) throws PrinterException {
        Graphics2D g = (Graphics2D)g1d;
        this.printProgress.updateStatus(pi + 1);
        RepaintManager rpm = RepaintManager.currentManager(this);
        rpm.setDoubleBufferingEnabled(false);
        Dimension d = this.getSize();
        double paneWidth = d.width;
        double paneHeight = d.height;
        double pageHeight = pf.getImageableHeight();
        double pageWidth = pf.getImageableWidth();
        double printscale = pageWidth / paneWidth;
        g.translate((int)pf.getImageableX(), (int)pf.getImageableY());
        int wpage = (int)(pageWidth / printscale);
        int hfpage = (int)(pageHeight / printscale);
        int hpage = hfpage - (int)(0.06 * (double)hfpage);
        g.scale(printscale, printscale);
        if (this.nbv == null) {
            View root;
            this.nbv = root = this.getUI().getRootView(this);
            this.pg = new Pager(this.nbv, wpage, hpage);
            this.pg.paginate();
        }
        Rectangle pcr = new Rectangle(0, 0, wpage, hfpage);
        g.setClip(pcr);
        g.translate(0, -this.pg.getPageStart(pi));
        this.paint(g);
        g.setColor(Color.white);
        g.drawRect(0, this.pg.getPageStart(pi) + this.pg.getPageHeight(pi) + 1, wpage, hfpage - this.pg.getPageHeight(pi));
        g.fillRect(0, this.pg.getPageStart(pi) + this.pg.getPageHeight(pi) + 1, wpage, hfpage - this.pg.getPageHeight(pi));
        Font pageFont = new Font("SansSerif", 0, 10);
        g.setFont(pageFont);
        int oPageFont = g.getFontMetrics().getMaxDescent();
        int hPageFont = g.getFontMetrics().getMaxAscent() + oPageFont;
        g.setColor(Color.black);
        String footerPage = new String("Page " + (pi + 1));
        int fpwid = g.getFontMetrics().stringWidth(footerPage);
        int flwid = g.getFontMetrics().stringWidth(this.footerLeft);
        int frwid = g.getFontMetrics().stringWidth(this.footerRight);
        g.drawString(footerPage, (int)((double)wpage / 2.0 - (double)fpwid / 2.0), this.pg.getPageStart(pi) + hfpage - oPageFont - 1);
        g.drawString(this.footerLeft, 0, this.pg.getPageStart(pi) + hfpage - oPageFont - 1);
        g.drawString(this.footerRight, wpage - frwid - 1, this.pg.getPageStart(pi) + hfpage - oPageFont - 1);
        if (this.pg.exists(pi)) {
            return 0;
        }
        this.nbv = null;
        this.printProgress.dispose();
        return 1;
    }

    public void setFooters(String fLeft, String fRight) {
        this.footerLeft = fLeft;
        this.footerRight = fRight;
    }

    class Pager {
        Vector pageBreaks;
        Rectangle pagerRect;
        View rootView;

        public Pager(View root, int w, int h) {
            this.rootView = root;
            this.pageBreaks = new Vector();
            this.pagerRect = new Rectangle(0, 0, w, h);
        }

        private boolean recurseView(View v, Rectangle pr, Rectangle pgr) {
            Rectangle ppr = new Rectangle(pr);
            boolean found = false;
            for (int i = 0; i < v.getViewCount(); ++i) {
                Rectangle cr = (Rectangle)v.getChildAllocation(i, ppr);
                if (cr.y >= pgr.y && cr.y + cr.height < pgr.y + pgr.height) {
                    if (cr.width == 0 || cr.height == 0) continue;
                    found = true;
                    continue;
                }
                if (cr.y >= pgr.y && cr.y < pgr.y + pgr.height) {
                    int j = v.getView(i).getViewCount();
                    if (j > 0) {
                        found |= this.recurseView(v.getView(i), cr, pgr);
                        continue;
                    }
                    pgr.height = cr.y - pgr.y + 1;
                    continue;
                }
                found |= this.recurseView(v.getView(i), cr, pgr);
            }
            return found;
        }

        public void paginate() {
            Rectangle onePageRect = new Rectangle(this.pagerRect);
            while (this.recurseView(this.rootView, this.pagerRect, onePageRect)) {
                int oneBreak = onePageRect.y + onePageRect.height;
                this.pageBreaks.addElement(new Integer(oneBreak));
                onePageRect.setBounds(this.pagerRect);
                onePageRect.y = oneBreak;
            }
        }

        public int getPageStart(int page) {
            if (page == 0) {
                return 0;
            }
            if (page < this.pageBreaks.size()) {
                return (Integer)this.pageBreaks.elementAt(page - 1) + 1;
            }
            return -1;
        }

        public int getPageHeight(int page) {
            if (page < this.pageBreaks.size()) {
                if (page == 0) {
                    return (Integer)this.pageBreaks.elementAt(page);
                }
                return (Integer)this.pageBreaks.elementAt(page) - (Integer)this.pageBreaks.elementAt(page - 1);
            }
            return -1;
        }

        public int pageCount() {
            return this.pageBreaks.size() + 1;
        }

        public boolean exists(int page) {
            return page < this.pageBreaks.size();
        }
    }
}

