/*-- REXX --------------------------------------------------------------------*/
/*                                                                            */
/* Module:      test.rex                                                      */
/*                                                                            */
/* Version:     1.00.01                                                       */
/*                                                                            */
/* Author:      W. David Ashley                                               */
/*                                                                            */
/* Description: Test page ICAPI program.                                      */
/*                                                                            */
/* (C) Copyright IBM Corp. 1998. All rights reserved.                         */
/*                                                                            */
/* US Government Users Restricted Rights Use, duplication or disclosure       */
/* restricted by GSA ADP Schedule Contract with IBM Corp.                     */
/*                                                                            */
/* The program is provided "as is" without any warranty express or implied,   */
/* including the warranty of non-infringement and the implied warranties of   */
/* merchantibility and fitness for a particular purpose. IBM will not be      */
/* liable for any damages suffered by you as a result of using the Program.   */
/* In no event will IBM be liable for any special, indirect or consequential  */
/* damages or lost profits even if IBM has been advised of the possibility of */
/* their occurrence. IBM will not be liable for any third party claims        */
/* against you.                                                               */
/*                                                                            */
/* This program outputs a sample test page via the ICAPI interface.           */
/*                                                                            */
/* Modifications:                                                             */
/*                                                                            */
/* Date     Author      Description                                           */
/* -------- ----------- ----------------------------------------------------- */
/* 12/01/98 WD Ashley   Initial Release                                       */
/*                                                                            */
/*----------------------------------------------------------------------------*/


handle = arg(1)
lf = x2c('0a')
call httpd_set handle, "Content-type", "text/html"
call write "<HTML>"
call write "<HEAD>"
call write "<TITLE>Sample HTML Page From Rexx</TITLE>"
call write "</HEAD>"
call write "<BODY>"
call write "<H1>Sample HTML Page From Rexx</H1>"
call write "<p>Hello from Rexx"

file = "c:\config.sys"
call write "<br><h3>Test HTTPD_attributes</h3>"
attrib = ""
call httpd_attributes handle, file, "attrib"
call write "The attributes of <b>"file"</b> are <b>"attrib"</b>"

call write "<br><h3>Test HTTPD_extract</h3>"
call write "The following are some common values of variables"
call write "<ul>"
var = "ACCEPT_RANGES"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "ALL_VARIABLES"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "AUTH_TYPE"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "CLIENT_HOST"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "CLIENT_METHOD"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "CLIENT_PROTOCOL"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "CONTENT_ENCODING"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "CONTENT_TYPE"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "DOCUMENT_NAME"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "DOCUMENT_URI"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "GATEWAY_INTERFACE"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "HTTP_ACCEPT"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "HTTP_COOKIE"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "HTTP_LOCATION"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "HTTP_REASON"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "HTTP_RESPONSE"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "HTTP_USER_AGENT"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "INIT_STRING"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "LOCAL_VARIABLES"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "PASSWORD"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "PATH"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "PATH_INFO"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "PATH_TRANSLATED"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "PPATH"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "PROXY_CONTENT_LENGTH"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "PROXY_CONTENT_TYPE"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "PROXY_METHOD"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "QUERY_STRING"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "QUERY_STRING_UNESCAPED"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "REFERER_URL"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "REMOTE_ADDR"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "REMOTE_HOST"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "REMOTE_USER"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "REQHDR"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "REQUEST_METHOD"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "SCRIPT_NAME"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "SERVER_ADDR"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "SERVER_NAME"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "SERVER_PORT"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "SERVER_PROTOCOL"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "SERVER_ROOT"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "SERVER_SOFTWARE"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "SSI_DIR"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "SSI_FILE"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "SSI_GLOBAL_VARIABLES"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "SSI_INCLUDE"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "SSI_PARENT"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "SSI_ROOT"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "URL"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "USERID"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
var = "USERNAME"
value = ""
call httpd_extract handle, var, "value"
call write "<li>"var "=" value
call write "</ul>"

call write "</body>"
call write "</html>"
return

/*-- write --*/
write: procedure expose handle lf
call httpd_write handle, arg(1) || lf
return
