/*---------------------------------------------------------------------------*/
/*                                                                           */
/*  NetCentric Computing with Object Rexx                                    */
/*  Programming Example                                                      */
/*                                                                           */
/*  (c) Copyright IBM Corporation 1999                                       */
/*                                                                           */
/*  myHtml.cls - My Personal HTML Class for dynamic HTML generation          */
/*                                                                           */
/*  Requirements:                                                            */
/*    html.frm  - HTML Support Framework  (the base HTML Support Class)      */
/*                                                                           */
/*  This code is sample code, provided "AS IS", without warranty of any kind */
/*                                                                           */
/*---------------------------------------------------------------------------*/

::REQUIRES "html.frm"                  /* setup html framework               */

/*****************************************************************************/
::CLASS myHtml PUBLIC subclass htmldoc /* My personel Html Class             */

/*---------------------------------------------------------------------------*/
::METHOD home                          /* home page reference                */
  return self~aref('/main.htm', "<br>- Home Page -", '/orxok.gif')
--return self~aref('/orxwww/main.htm', "<br>- Home Page -", '/orxwww/orxok.gif')

/*---------------------------------------------------------------------------*/
::METHOD myAddress                     /* my home address                    */
  p = self~p~align('center')~font('color=black')~b('Object REXX Development')
  p~br('IBM SWSD Boeblingen, Germany')
  p~br~i('rexxhelp@de.ibm.com')~efont
  return self

/*---------------------------------------------------------------------------*/
::METHOD signature                     /* signature and address              */
  self~img('/orxok.gif')~align('center')
  return self~myAddress

/*---------------------------------------------------------------------------*/
::METHOD footing                       /* footing([codefile])                */
                                       /* table with 2 or 3 cells            */
  tab = self~table~width('100%')~border(5)~cellpadding(5)~cellspacing(1)~bgcolor('silver')
  tr = tab~tr                          /* this is the table row              */
  tr~td~align('center')~aref('/main.htm', , '/orxok.gif')
  tr~td(.myhtml~new~myAddress)
  if arg(1, 'e') then                  /* optional "display code" cell       */
    tr~td~align('center')~aref(arg(1), '<b>Download<br>CGI<br>Program</b>')
  return self                          /* return footing                     */

/*---------------------------------------------------------------------------*/
::METHOD errormsg                      /* generate an error message          */
  use arg text

  if self~items = 0 then               /* if it is the first entry           */
    self~title('Error Message')        /* put in a title                     */
  else
    self~h2('Error Message')           /* or a header otherwise              */
  p = self~p(text)                     /* error message text                 */
  if arg(2, e) then
  do line over arg(2)                  /* additional error information       */
    p~br(line)
  end
  self~footing                         /* home reference and address         */
  return self                          /* return the error document          */


/*---------------------------------------------------------------------------*/
::CLASS center

/*---------------------------------------------------------------------------*/
::method makeHtml
  string = '<center'self~coreattrs
  if self~align \= '' then string = string 'align="'self~align'"'
  return string'>'self~text'</center>'
