/*****************************************************************************/
/* A Simple Form with Various Inputs                               form4.cmd */ 
/*                                                                           */
/* (C) Copyright IBM Corporation 1999.                                       */
/*                                                                           */
/* This code is sample code, provided "AS IS", without warranty of any kind  */
/*****************************************************************************/

use arg type, list, address            /* get the arguments                  */

parm = .parmdir~new(list)              /* create parameter directory         */

html = .myHtml~new                     /* create an html object              */ 
html~title('A Form with Object REXX')
html~h1('A Simple' green('Form') 'with various Inputs')

if parm['submit'] = 'Process' then do   
  html~p("You entered:")
  html~p("Date =" Brown(parm['date']) '--> (hidden field)')
  html~br("Address =" Brown(parm['address']) '--> (hidden field)')
  html~p("Name =" brown(parm['name']))
  html~br("Profession =" brown(parm['profession']))
  html~br("Password =" brown(parm['passw']))
  html~br("File =" brown(parm['file']))
  html~p("text:")
  html~br(brown(breaks(parm['text'])))

  html~form("/cgi-bin/orxwww/form4")   /* cgi-form with 'Again' button       */ 
  html~submit("submit", "Again")
  html~eform
end
else do
  html~p('Enter the values and press "Process" to continue.')

  html~form("/cgi-bin/orxwww/form4")   /* cgi-form with 'Process' button     */
  html~iHidden('date','['date('L')']')~t(green("[Todays's date]"))
  html~iHidden('address', address)~t(green("[My address]"))~img('/orxwww/new')
  html~t("Two hidden fields!")
  html~p("Name:")~iText("name", "")
  html~p("Profession:")~iText("profession", "")
  html~p("Password:")~ipassw("passw", "")
  html~p("Input file:")~iFile("file",'filename' , 'size=40')~img('/orxwww/new')
  html~p("Input image:")
  html~iImage("image", '/orxwww/orxokw', 'align=center', 'Clicking the image reads the form!') 
  html~p("Text area:")
  html~input("textarea", "text",'Hallo guys!', 'size=40', 'with some text to follow.')
  html~p("Button:")
  html~button("button", "Execute",'onClick src="/cgi-bin/orxwww/beeper"', 'Push me baby!')
  html~img('/orxwww/orx_att', 'align=center')
  html~p~submit("submit", "Process")~reset('reset', 'Reset')~img('/orxwww/new') 
  html~eform
end   

html~footing("/orxwww/form4")          /* footing with code reference        */
return html~end                        /* end HTML document and return it    */

::requires "myhtml.cls"                /* load myHtml class                  */
