/**********************************************************************/
/*                                                                    */
/* SAMP03.REX: OLE Automation with Object REXX - Sample 3             */
/*                                                                    */
/* Show some features of the Windows Scripting Host Network object:   */
/*  - Query computer name, user name                                  */
/*  - List network connections for drives and printers                */
/*                                                                    */
/* This sample requires the Windows Scripting Host to be installed on */
/* the system. See http://msdn.microsoft.com/scripting/ for details.  */
/*                                                                    */
/* ------------------------------------------------------------------ */
/* (C) Copyright IBM Corp. 1998 - All Rights Reserved.                */
/*                                                                    */
/* DISCLAIMER OF WARRANTIES.  The following [enclosed] code is sample */
/* code created by IBM Corporation. This sample code is not part of   */
/* any standard or IBM product and is provided to you solely for the  */
/* purpose of assisting you in the development of your applications.  */
/* The code is provided "AS IS", without warranty of any kind.  IBM   */
/* shall not be liable for any damages arising out of your use of the */
/* sample code,  even if they have been advised of the possibility of */
/* such damages.                                                      */
/*                                                                    */
/**********************************************************************/

WshNetObj = .OLEObject~New("WScript.Network")

Say "Computer Name:" WshNetObj~ComputerName
Say "User Domain:" WshNetObj~UserDomain
Say "User Name:" WshNetObj~UserName

Say "The following network drives are currently mapped:"
MappedDrives = WshNetObj~EnumNetworkDrives
Do i=0 To MappedDrives~Count/2 - 1
  Say "   Drive" MappedDrives[i*2] "is mapped to" MappedDrives[i*2 + 1]
End

Say "The following network printers are currently connected:"
Printers = WshNetObj~EnumPrinterConnections
Do i=0 To Printers~Count/2 - 1
  Say "   Port" Printers[i*2] "is connected to" Printers[i*2 + 1]
End

::REQUIRES OREXXOLE.CLS
