/******************************************************************************/
/*  month                    Object REXX Samples                              */
/*                                                                            */
/*  Display the days of the month for January 1994                            */
/*                                                                            */
/*                                                                            */
/*  Licensed Materials - Property of IBM                                      */
/*  IBM Object REXX for AIX                                                   */
/*  (C) Copyright IBM Corp. 1998,  2004                                       */
/*                                                                            */
/* -------------------------------------------------------------------------- */
/* DISCLAIMER OF WARRANTIES.  The following [enclosed]                        */
/* code is sample code created by IBM Corporation. This                       */
/* sample code is not part of any standard or IBM                             */
/* product and is provided to you solely for the                              */
/* purpose of assisting you in the development of your                        */
/* applications.  The code is provided "AS IS", without                       */
/* warranty of any kind.  IBM shall not be liable for                         */
/* any damages arising out of your use of the sample                          */
/* code,  even if they have been advised of the                               */
/* possibility of such damages.                                               */
/* -------------------------------------------------------------------------- */
/*                                                                            */
/*  Description:                                                              */
/*  This program is similar to the month1.cmd exec found in the OS/2 2.0      */
/*  REXX User's Guide.  This version demonstrates the use of arrays to        */
/*  replace stems.                                                            */
/******************************************************************************/

/* First, create an array initialized to the days of the week                 */
days = .array~of("Sunday",    "Monday",   "Tuesday", ,
                 "Wednesday", "Thursday", "Friday",  ,
                 "Saturday" )
month = .array~new(31)                      /* Another way to create an array */
startday = 7                                /* First day of month is Saturday */

Do dayofmonth = 1 to 31
  dayofweek = (dayofmonth+startday+days~size-2) // days~size + 1
  Select
    When right(dayofmonth,1) = 1 & dayofmonth <> 11 then th = "st"
    When right(dayofmonth,1) = 2 & dayofmonth <> 12 then th = "nd"
    When right(dayofmonth,1) = 3 & dayofmonth <> 13 then th = "rd"
    Otherwise th = "th"
  end
  /* Store text in the month array, using names in the days array             */
  month[dayofmonth] = days[dayofweek] 'the' dayofmonth||th "of January"
end

month~put( month[1]', New Years day', 1 )   /* Another way to set an array    */
                                            /* element                        */
Do dayofmonth = 1 to 31
  Say month~at(dayofmonth)                  /* Another way to access array    */
                                            /* elements                       */
end
