#-------------------------------------------------------------------------
# rexxasp2.mak : makefile to build librexxasp2.so
#-------------------------------------------------------------------------

# -----------------------  Path Definitions  ----------------------------
BLD_PATH = .
INC_PATH = -I. -I/opt/orexx
LIB_PATH = -L. -L/opt/orexx/lib 
#
# Compiler macros
#
cc = g++ -fPIC
link = gcc
DEL_CMD	 = rm -f
#
CFLAGS	   = -c	-ggdb -D__cplusplus
link_lib_flags_librxasp1 = -shared -rdynamic -lpthread -lrexxapi -lc  -lm  
 
RXAPI_OBJ  = rexxasp2.o

# *************************************************************************** #
# Rules									      #
# *************************************************************************** #
.c.o:
	$(cc) $(CFLAGS) -o$*.o $(INC_PATH) $(LIB_PATH) $*.c

#---------------------------------------------------------- Generate library

librexxasp2.so: $(RXAPI_OBJ)
	rm -f $(BLD_PATH)/$@
	$(link) -Wl,-soname,$@ -o $(BLD_PATH)/$@ $(RXAPI_OBJ) \
	$(LIB_PATH) $(link_lib_flags_librxasp1)

#----------------------------------------------------------
all: librexxasp2.so

#---------------------------------------------------------- END	section
clean:
	- $(DEL_CMD) $(RXAPI_OBJ)
	- $(DEL_CMD) $(BLD_PATH)/librexxasp2.so

