/*--------------------------------------------------------------------------*/
/*                                                                          */
/* Router services for local processing                                     */
/*                                                                          */
/*   contains service routines that are intercepting special output         */       
/*   services and routes them to the client. This command file has to be    */
/*   included in transient or resident agents with:                         */
/*                                                                          */
/*   ::REQUIRES Router                                                      */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/*
/*--------------------------------------------------------------------------*/
/* BEEP services for local processing                                       */
/*--------------------------------------------------------------------------*/
::ROUTINE beep PUBLIC
  parse arg tone duration .                                                             
--reply                                                                                 
    rc = beep(tone, duration)                                                           
*/
/*--------------------------------------------------------------------------*/
/* PLAY services for local processing                                       */
/*--------------------------------------------------------------------------*/
::ROUTINE play PUBLIC
  parse arg playFile playMode .
                                       /* does playFile exist locally?      */
  fullname = .stream~new(playFile)~query('EXISTS')
  if fullname \= '' then do            /* if yes, invoke proper play funct  */
    parse source system .                                                        
    if system = 'AIX' | system = 'LINUX' then                                           
      say "No MultiMedia function available"                                            
    else do                                                                             
      say "Playing...."                                                                 
--    if playMode = '' then            /* if nothing else specified...      */        
--      reply                          /* play the file concurrently        */        
      if system = 'OS/2' then          /* OS/2 play function (cmd file)     */        
        call "play.cmd" 'file="'playfile'"'                                           
      else                             /* Windows play routine (OODialog)   */        
        call playsoundfile playfile, 'NO'                                               
    end                                                                                 
  end
  else 
    say 'Playfile' playFile 'not found'

return 0
