/*--------------------------------------------------------------------------*/
/* Utility for system setup  (works for Unix and non-Unix systems)          */
/*--------------------------------------------------------------------------*/
rc = RxFuncAdd("sysGetKey", "rexxutil", "SysGetKey")     

/*--------------------------------------------------------------------------*/
/*                                                                          */
/*  prompt input from user                                                  */
/*                                                                          */
/*   invocations:                                                           */
/*                                                                          */
/*     string = promptInput(message)                                        */
/*                                                                          */
/*     password = promptInput(message, echo)                                */
/*                                                                          */
/*   where                                                                  */
/*     string  - the returned string                                        */
/*     message - prompt message being displayed (optional)                  */
/*     echo    - echo character or string (optional) - used for passwords   */
/*                                                                          */
/*   requires: Rexx utility functions sysGetKey and sysCurPos               */
/*                                                                          */
/*  History:                                                                */
/*    09/02/97  initial version  (OS/2 and Windows)                         */
/*    11/07/97  modified for Unix based systems                             */
/*                                                                          */
/*--------------------------------------------------------------------------*/
::ROUTINE promptInput PUBLIC

  if arg() > 0 then
    say arg(1) 

  input = ''                          /* initialize input string            */
  len = arg(2)~length~max(1)
  parse source system rest            /* find out system environment        */

  /* Unix environments ---------------------------------------------------- */ 

  if system = 'LINUX' | system = 'AIX' then do
    NL = '0a'x                        
    do forever        
      key = sysGetKey('noecho')
      if key = '0a'x then leave       /* terminate with CR                  */ 
                  
      if key~verify('7F1B'x) then do
        if arg(2) = '' then           /* is there any echo defined          */
          rc = charout(, key)         /* no, echo key                       */
        else
          rc = charout(, arg(2))      /* echo echo string otherwise         */
  
        input = input || key          /* concatenete the key to input       */
      end
      else do                         /* kill other bytes still in buffer   */
        if key = '1B'x then        
          if sysGetKey('noecho') = '5B'x then                
            if sysGetKey('noecho') < '40'x then 
              do until sysGetKey('noecho') = '7E'x 
              end 
      end 
    end 
  end 

  /* Non-Unix environments ------------------------------------------------ */ 

  else do                               
    NL = '0d0a'x                      
    rc = RxFuncAdd("sysCurPos", "rexxutil", "sysCurPos")     
    do forever                          
      key = sysGetKey('noecho')
      if key = '0d'x then leave       /* terminate with CR                  */ 
                  
      if key~verify('0008E0'x) then do
        if arg(2) = '' then           /* is there any echo defined          */
          rc = charout(, key)         /* no, echo key                       */
        else
          rc = charout(, arg(2))      /* echo echo string otherwise         */
  
        input = input || key          /* concatenete the key to input       */
      end
      else do                         /* destructive backspace handling     */
        if key = '08'x & input~length > 0 then do          
          rowcol = sysCurPos()        /* backspace cursor                   */
          rc = sysCurPos(rowcol~word(1), rowcol~word(2)-len)
          rc = charout(,' '~copies(len)) 
          rc = sysCurPos(rowcol~word(1), rowcol~word(2)-len)
          input = input~delstr(input~length) /* remove character from input */
        end 
        else if key = 'E0'x then      /* extended key handling              */
          key = sysGetKey('noecho')   /* read the next byte and discard it  */
      end
    end
  end
                             
  rc = charout(, NL)                  /* echo the input characters          */
  return input                        /* return the input string            */
