/********************************************************/
/*                                                      */
/* AIRCRFT4.CMD - IBM Object REXX Sample Program        */
/*                                                      */
/* ---------------------------------------------------- */
/* (C) Copyright IBM Corp. 1996 - All Rights Reserved.  */
/*                                                      */
/* DISCLAIMER OF WARRANTIES.  The following [enclosed]  */
/* code is sample code created by IBM Corporation. This */
/* sample code is not part of any standard or IBM       */
/* product and is provided to you solely for the        */
/* purpose of assisting you in the development of your  */
/* applications.  The code is provided "AS IS", without */
/* warranty of any kind.  IBM shall not be liable for   */
/* any damages arising out of your use of the sample    */
/* code,  even if they have been advised of the         */
/* possibility of such damages.                         */
/*                                                      */
/********************************************************/

/* create a new balloon */
myBalloon = .Balloon~New("N6148R", "Cameron", 120000,,
                         "yellow")
say myBalloon

/*******************************************************/
/* Declare the aircraft class                          */
/*******************************************************/
::CLASS Aircraft

/*******************************************************/
/* Declare the INIT method for all new aircrafts. The  */
/* INIT method will be invoked for every new object of */
/* the aircraft class. It is invoked as a result of    */
/* the NEW message to the aircraft class.              */
/* Three arguments will be processed and stored in the */
/* object's instance variables:                        */
/*      1. Registration of aircraft                    */
/*      2. Type of aircraft                            */
/*      3. Size (wingspan)                             */
/*******************************************************/
::METHOD Init
  Expose Registration Type Size
  Use Arg Registration, Type, Size

/*******************************************************/
/* Declare the STRING method for the aircraft class.   */
/* Return a string using the object's instance         */
/* variables.                                          */
/*******************************************************/
::METHOD String
  /* get access to the following instance variables */
  Expose Registration Type

  Return "A" Type "(" || Registration,
         || ") with" Self~SizeString

/*******************************************************/
/* Declare the SIZESTRING method for the aircraft      */
/* class. It will return the aircrafts size formatted  */
/* as a string.                                        */
/*******************************************************/
::METHOD SizeString
  Return "a wingspan of" Self~Size "feet"

/*******************************************************/
/* Declare the SIZE method. It will return the size    */
/* attribute of the aircraft (regardless of the        */
/* measurement).                                       */
/*******************************************************/
::METHOD Size
  Expose Size
  Return Size


/*******************************************************/
/* Declare the balloon class as a subclass of aircraft.*/
/*******************************************************/
::CLASS Balloon SUBCLASS Aircraft

/*******************************************************/
/* Declare the INIT method for new balloons.           */
/* Four arguments will be processed and stored in the  */
/* object's instance variables:                        */
/*      1. Registration of aircraft                    */
/*      2. Type of aircraft                            */
/*      3. Size (volume)                               */
/*      4. Color                                       */
/*******************************************************/
::METHOD INIT
  /* get access to instance variables */
  Expose Color

  /* read parameters into variables */
  Use Arg Registration, Type, Volume, Color

  /* forward parameters to parent initialization */
  Forward Class(Super) Array(Registration, Type, Volume)

/*******************************************************/
/* Declare the SIZESTRING method for the balloon       */
/* class. It will return the balloon's volume          */
/* formatted as a string                               */
/*******************************************************/
::METHOD SizeString
  /* format the string using the size method of the    */
  /* parent class                                      */
  Return "a volume of" Self~Size "cubic ft"

/*******************************************************/
/* Declare the STRING method for the balloon class.    */
/* Return a string using the object's instance         */
/* variables.                                          */
/*******************************************************/
::METHOD String
  Expose Color

  /* reuse the string generated by the super class and */
  /* append the color of the balloon                   */
  Return Self~String:Super || ", color" Color
