         TITLE 'EAG   3.0 * EAGSTCR stub'
***********************************************************************
*
* Module name:       EAGSTC
*
* Descriptive name:
*
* Author:            Thorsten Schaper, IBM
*                    thorsten.schaper@de.ibm.com
*
* Created:           11/15/2000
* Last modfication: 11/30/2000
*
* Function:
*    Provides a secure way to get rid of EVALBLOCK memory blocks that
*    have been allocated by EAGSTC or EAGSTCR for returning a result
*    from an external REXX function.
*    The stubs receive the EVALBLOCKs from IRXRLT and mark these blocks
*    with the message 'REXX IS COOL' - so the EVALFREE module can check
*    whether a given pointer is really one that has been returned by
*    one of these stubs.
*
* Returns:
*    0 = success
*    1 = failure
*
***********************************************************************
                                                                SPACE 1
EVALFREE AMODE 31
EVALFREE RMODE ANY
EVALFREE CSECT
         ENTRY EVALFREE
                                                                SPACE 1
         STM   R14,R12,12(R13)      Save regs in caller's save area
         LR    R12,R15              Set base reg to entry point address
         USING EVALFREE,R12         CSECT EVALFREE addressability
                                                                SPACE 1
         L     R5,0(,R1)            get pointer to mem to be freed
         N     R5,=x'7FFFFFFF'      make sure HOB is OFF
         LA    R6,15
         SR    R5,R6
         CLC   0(4,R5),COOLY1
         BNE   NOTFREED
         CLC   8(7,R5),COOLY2
         BNE   NOTFREED
         L     R6,4(,R5)
         SLL   R6,3
         FREEMAIN RC,LV=(6),A=(5)   Free storage
         B     TIDYUP
                                                                SPACE 1
NOTFREED DS   0H
         LA    R15,1
                                                                SPACE 1
TIDYUP   DS   0H
         ST    R15,16(,R13)         Store return code in caller's SA
         DROP  R12
         LM    R14,R12,12(R13)      Restore registers from caller's SA
         BR    R14                  Return to caller
                                                                SPACE 1
COOLY1   DC    CL4'REXX'
COOLY2   DC    CL7'IS COOL'

R0       EQU   0
R1       EQU   1
R2       EQU   2
R3       EQU   3
R4       EQU   4
R5       EQU   5
R6       EQU   6
R7       EQU   7
R8       EQU   8
R9       EQU   9
R10      EQU   10
R11      EQU   11
R12      EQU   12
R13      EQU   13
R14      EQU   14
R15      EQU   15
                                                                SPACE 1
EVALFREE CSECT
         END
