;
;	Generator Intel Hex of PC110-BIOS code
;		by GarakutaEn 2019.08-
;
;		2019.08.28	Start
;		2019.08.31	Finish
;		2019.11.06	Repair (check sum miss)
;		2019.11.07	Add gap-space mode
;
code	segment
	assume	cs:code,ds:code,es:code,ss:code
;----------------------------------------------
;ASCII
BEL	equ	07h
bs	equ	08h
cr	equ	0dh
lf	equ	0ah
ESK	equ	1bh
;DOS int
rdky	equ	01h		;al
wrch	equ	02h		;dl
rdch	equ	08h		;al
wrln	equ	09h		;ds:dx
rdln	equ	0ah		;ds:dx | Enter for end
crfl	equ	3ch		;create file
opfl	equ	3dh		;open file
clfl	equ	3eh		;close file
rdfl	equ	3fh		;read file
wrfl	equ	40h		;write file
drtn	equ	4ch
;
DOS	macro	cmd
	mov	ah,cmd
	int	21h
	endm
;-----------------------------------------------
	org	100h
start:	jmp	init

sbuf	db	10h,0,10h dup(?)
ebuf	db	10h,0,10h dup(?)
wbuf	db	100h dup(?)
fbuf	db	':00000001FF',cr,lf,'$'
hndl	dw	0
sghld	dw	0f000h
ofhld	dw	00000h
enhld	dw	0fff0h
sphld	db	BEL
cksum	db	0

;head message
hmsg	db	cr,lf,'+++ Intel_Hex generator  2019.8- +++',cr,lf,'$'
qmsg	db	cr,lf,' no command ! ',cr,lf,'$'
sloc	db	cr,lf,'Change ? start Segment F000 = $'
oloc	db	cr,lf,'Change ? start Offset  0000 = $'
eloc	db	cr,lf,'Change ? end Point     FFF0 = $'
smsg	db	cr,lf,'Insert " " between codes ?  = $'
okmg	db	'Date saved to the [intel.hex]',cr,lf,'$'
flnm	db	'intel.hex',0
ermg	db	cr,lf,'Error !',cr,lf,'$'

;program start point
init:	mov	ax,cs
	mov	es,ax
	mov	ds,ax
	mov	ss,ax
	mov	sp,offset stack
	lea	dx,hmsg
	DOS	wrln
	mov	si,offset 80h
rdcml:	mov	al,byte ptr [si]
	and	al,al		;option exist ?
	jz	gtloc
rdcm0:	inc	si
	mov	al,byte ptr [si]
	cmp	al,0dh
	je	gtloc
	cmp	al,2fh		;=/
	jne	rdcm0
	mov	al,byte ptr [si+1]
	and	al,0dfh		;upper to lower
	cmp	al,'?'
	jne	rdcm0
;
qsdsp:	lea	dx,qmsg		;show commands
	DOS	wrln
	xor	al,al
	DOS	drtn		;finish !
;
gtloc:	lea 	dx,sloc		;seg message
	lea	di,sghld	;segment holder
	call	rdloc
;
gtlo1:	lea	dx,oloc		;off message
	lea	di,ofhld	;offset holder
	call	rdloc
;
gtlo2:	lea	dx,eloc		;end message
	lea	di,enhld	;end holder
	call	rdloc
;
gtlo3:	lea	dx,smsg		;spacer message
	DOS	wrln
	DOS	rdky
	mov	[sphld],al	;spacer holder
;
fopen:	call	crlf
	mov	cx,00h
	lea	dx,flnm
	DOS	crfl		;create file
	jnc	fopn1

;error return !
errtn:	lea	dx,ermg
	DOS	wrln
	DOS	drtn

fopn1:	mov	[hndl],ax	;save file handle
;--------------------------------------
;initial record
inirc:	xor 	al,al
	mov	[cksum],al
	lea	di,wbuf		;set top of wbuf

	mov	ax,':'
	mov	[di],al		;save recode mark
	inc	di
	mov	al,02h
	add	[cksum],al
	call	cv2hx		;save recode length

	call	setgp
	xor	ax,ax
	add	[cksum],al
	call	cv4hx		;save offset 0000h

	call	setgp
	mov	al,04h
	add	[cksum],al
	call	cv2hx		;save recode type

	call	setgp
	mov	ax,word ptr [sghld]
	add	[cksum],al
	call	cv2hx		;save segment

	call	setgp
	mov	al,ah
	add	[cksum],al
	call	cv2hx		;save offset

	call	setgp
	mov	al,[cksum]
	neg	al
	call	cv2hx		;save check sum
	mov	al,cr
	mov	[di],al
	inc	di
	mov	al,lf
	mov	[di],al
	inc	di
	mov	al,'$'
	mov	[di],al
;display 1st contents
	lea	dx,wbuf
	DOS	wrln
;save data to file
	mov	bx,word ptr [hndl]
	call	cksiz
	lea	dx,wbuf
	DOS	wrfl
	jc	err00		;error return
;--------------------------------------
;main records
rmain:	mov	es,[sghld]	;set segment
	mov	bp,[ofhld]	;set offset
rmai0:	lea	di,wbuf
	call	oneln
	mov	al,cr
	mov	[di],al
	inc	di
	mov	al,lf
	mov	[di],al
	inc	di
	mov	byte ptr [di],'$'
	lea	dx,wbuf
	DOS	wrln
;save data to the file after initial data
	mov	bx,word ptr [hndl]
	lea	dx,wbuf
	call	cksiz		;cx = string length
	DOS	wrfl
;check error
	jnc	rmai1
;if error exist
err00:	mov	dl,al		;error code 06h = bad handle
	call	dshx
	lea	dx,ermg
	DOS	wrln
	DOS	drtn

rmai1:	cmp	bp,word ptr [enhld]
	jc	rmai0
;--------------------------------------
;final recode
finrc:	xor 	al,al
	mov	[cksum],al
	lea	di,wbuf		;set top of wbuf

	mov	ax,':'
	mov	[di],al		;save recode mark
	inc	di
	mov	al,00h
	add	[cksum],al
	call	cv2hx		;save recode length

	call	setgp
	xor	ax,ax
	add	[cksum],al
	call	cv4hx		;save offset 0000h

	call	setgp
	mov	al,01h
	add	[cksum],al
	call	cv2hx		;save recode type

	call	setgp
	mov	al,[cksum]
	neg	al
	call	cv2hx		;save check sum

	mov	al,cr
	mov	[di],al
	inc	di
	mov	al,lf
	mov	[di],al
	inc	di
	mov	al,'$'
	mov	[di],al
;display last contents
	lea	dx,wbuf
	DOS	wrln
;save data to file
	mov	bx,word ptr [hndl]
	call	cksiz
	lea	dx,wbuf
	DOS	wrfl
	jnc	pgend
	jmp	err00		;error return
;final massege
pgend:	lea	dx,okmg
	DOS	wrln
	xor	ax,ax
	DOS	drtn
;--------------------------------------
;display and write file with one line
oneln:	mov	al,':'
	mov	[di],al
	inc	di
	xor	al,al		;clear [cksum]
	mov	[cksum],al
	mov	al,10h		;16d count
	call	sbacv

	call	setgp
	mov	ax,bp		;start address
	push	ax
	mov	al,ah		;(upper)
	call	sbacv
	pop	ax		;(lower)
	call	sbacv

	call	setgp
	xor	al,al		;record type
	call	sbacv
	mov	cl,10h		;16d count
onel0:	call	setgp
	mov	al,byte ptr es:[bp]
	inc	bp
	call	sbacv		;(conv & save to [di++])
	loop	onel0		;repeat 10h

	call	setgp
	mov	al,[cksum]	;check sum it self
	neg	al
	call	sbacv		;(last sum not use)
	ret
;--------------------------------------
;check size
cksiz:	push	bp
	mov	bp,dx
	xor	cx,cx
	dec	bp
cksir:	inc	bp
	inc	cx
	cmp	byte ptr [bp],lf
	jne	cksir
	pop	bp
	ret
;----------------------------
;read segment | offset | end on sbuf 0Dh for "CR"
rdloc:	DOS	wrln
	lea	dx,sbuf
	mov	si,dx
	DOS	rdln
	cmp	byte ptr [si+2],ESK	;check after "Enter"
	jne	rdlo0
	DOS	drtn
rdlo0:	cmp	byte ptr [si+1],0
	je	rdloe
	mov	word ptr [di],0000h
rdlox:	inc	si
	mov	al,byte ptr [si+1]
	cmp	al,0dh		;terminator
	je	rdloe
	call	abcnv
	push	bx
	mov	bx,word ptr [di]
	shl	bx,1
	shl	bx,1
	shl	bx,1
	shl	bx,1
	add	bl,al
	mov	word ptr [di],bx
	pop	bx
	jmp	rdlox
rdloe:	ret
;----------------------------
;convert 1 byte to 2 hex on AL
; and save to [di]
sbacv:	add	[cksum],al
	push	ax
	shr	al,1
	shr	al,1
	shr	al,1
	shr	al,1
	and	al,0fh
	add	al,'0'
	cmp	al,'9'+1
	jc	sbac0
	add	al,7
sbac0:	mov	ds:[di],al
	inc	di
	pop	ax
	and	al,0fh
	add	al,'0'
	cmp	al,'9'+1
	jc	sbac1
	add	al,7
sbac1:	mov	ds:[di],al
	inc	di
	ret
;----------------------------
;convert binary to 4 hex chars on AX
cv4hx:	push	ax
	push	ax
	mov	al,ah
	call	cv2hx
	pop	ax
	call	cv2hx
	pop	ax
	ret
;
cv2hx:	push	ax
	shr	al,1
	shr	al,1
	shr	al,1
	shr	al,1
	and	al,0fh
	add	al,'0'
	cmp	al,'9'+1
	jc	cv2h1
	add	al,7
cv2h1:	mov	[di],al
	inc	di
	pop	ax
	and	al,0fh
	add	al,'0'
	cmp	al,'9'+1
	jc	cv2h2
	add	al,7
cv2h2:	mov	[di],al
	inc	di
	ret
;----------------------------
;convert 1 asc chr(0-F) to bin on AL
abcnv:	cmp	al,40h
	jc	abcn0
	and	al,4fh
abcn0:	sub	al,'0'
	jnc	abcn1
	mov	al,0		;force to zero
	ret
abcn1:	cmp	al,11
	jc	abcn3
	sub	al,7
abcn2:	cmp	al,16
	jc	abcn3
	mov	al,0		;force to zero
abcn3:	cmc
	ret
;----------------------------
;display hex on AX
dsax:	push	ax
	push	ax
	mov	al,ah
	call	dshx
	pop	ax
	call	dshx
	pop	ax
	ret
;----------------------------
;display hex on al
dshx:	push	dx
	push	ax
	push	ax
	and	al,0f0h
	shr	al,1
	shr	al,1
	shr	al,1
	shr	al,1
	add	al,'0'
	cmp	al,'9'+1
	jc	dsh1
	add	al,7
dsh1:	mov	dl,al
	DOS	wrch
	pop	ax
	and	al,0fh
	add	al,'0'
	cmp	al,'9'+1
	jc	dsh2
	add	al,7
dsh2:	mov	dl,al
	DOS	wrch
	pop	ax
	pop	dx
	ret
;
dssp:	push	dx
	mov	dl,' '
	DOS	wrch
	pop	dx
	ret
;----------------------------
crlf:	push	ax
	push	dx
	mov	dl,cr
	DOS	wrch
	mov	dl,lf
	DOS	wrch
	pop	dx
	pop	ax
	ret
crcr:	push	ax
	push	dx
	mov	dl,cr
	DOS	wrch
	pop	dx
	pop	ax
	ret
;----------------------------
;set gap
setgp:	cmp	byte ptr [sphld]," "-1
	jnc	setg0
	ret
setg0:	push	ax
	mov	al,[sphld]
	mov	ds:[di],al
	inc	di
	pop	ax
	ret

;----------------------------

	db	256 dup(?)
stack:
;
code	ends
	end	start
;____________________________