#ifndef TESTLOG_H
#define TESTLOG_H

#include <QWidget>
#include <QTreeWidget>

class TestLog : public QWidget
{
    Q_OBJECT
public:
    explicit TestLog(QTreeWidget * component, QWidget *parent = 0);

    void setNoRefresh(bool value);

    enum MessageState{
        DeviceHandling = 1,
        DeviceError = 2,
        Informative = 3,
        PowerSet = 4,
        IOSet = 5,
        DataSend = 6,
        DataRead = 7,
        ChipBad = 8,
        TestFailed = 9,
        TestPassed = 10
    };

    void AddMessage(int messageType, QString message, int stepNo = -1);

signals:

public slots:

private:
    QTreeWidget * logObject;
    bool noRefresh;
};

#endif // TESTLOG_H
