/*
 *  linux/drivers/video/geodefb.h 
 *
 *
 *  This file is subject to the terms and conditions of the GNU General Public
 *  License. See the file COPYING in the main directory of this archive for
 *  more details.
 */

#ifndef GEODEFB_H
#define GEODEFB_H

#define DEBUGMSG(_Cond, _Printf_Exp)\
	((_Cond)?(printk _Printf_Exp),1:0)


    /*
     *  This structure describes the board.
     */

struct geodefb_info {
    /* Use the generic framebuffer ops */
    struct fb_info_gen gen;

    /* Device dependent information */
    int geode_type;					/* geode type: {8plane, 24plane, 24plusZ} */
    unsigned int geode_mem_base;
    unsigned long geode_fb_base;
    unsigned long geode_regs_base;
    struct fb_var_screeninfo default_var;		/* default video mode */
};


    /*
     *  This structure uniquely defines a video mode.
     */

struct geodefb_par {
    int xres, yres;					/* resolution in pixels */
    unsigned int htimings;				/* horizontal timing register */
    unsigned int vtimings;				/* vertical timing register */
    unsigned int pll_freq;				/* pixclock in mhz */
    unsigned int bits_per_pixel;			/* bits per pixel */
};

#endif /* GEODEFB_H */
