// io.c

#include <stdio.h>
#include <conio.h>
#include "test.h"


static BYTE bTmpxContents = 0;

VOID _far IODelay(VOID)
    {
    _asm
        {
        pusha
        popa
        pusha
        popa
        pusha
        popa
        pusha
        popa
        pusha
        popa
        pusha
        popa
        }
    }

// --------------------------------------------------------------------------    
#pragma optimize("", off)    
VOID  delay (VOID)
/*
    Unbelievably crude delay mechanism.  We need a delay which is less
    than a millisecond, but more than...

    Use the pragma to avoid problems if the compiler gets too smart.
*/
    {
    long                I;
    long                A;

    for ( I = 0L; I < 50L; I++ )
        A |= 0xFFFFFFFF;
    }
#pragma optimize("", on)    

// --------------------------------------------------------------------------

VOID  OutIndirect (WORD wBase, WORD wOffset,  BYTE  bValue)
/*
    Assuming the address register is at <base> and the data register is
    at <base+1>, write <v> to the indirect register.  
*/
    {
    IODelay();          // Guard time in case there was a previous I/O operation
    _outp( wBase, wOffset );
    _outp( wBase + 1, bValue );
    }


// --------------------------------------------------------------------------

BYTE  InIndirect (WORD  wBase, WORD wOffset)
/*
    Assuming the address register is at <base> and the data register is
    at <base+1>, read the value of the indirect register.  If <wait> is true,
    waste some time before and after the operation.
*/
    {
    IODelay();              // Guard time in case there was a previous I/O operation
    _outp( wBase, wOffset);
    return (BYTE) _inp(wBase + 1);
    } 
    
// --------------------------------------------------------------------------
BOOL TestIndirect(WORD wBase, WORD wOffset, BYTE wMask)
    {
    WORD    wBit;
    BYTE    bOut, bIn;
    BOOL    Failed = FALSE;
    
    // Test each bit
    for (wBit=1; wBit < 0x100; wBit <<= 1)
        {
        bOut = (BYTE)(wBit & wMask);
        if (bOut)
            {
            // Try a 1 
            OutIndirect(wBase, wOffset, bOut);
            bIn = InIndirect(wBase, wOffset);
            if ((bOut & wMask) != (bIn & wMask))
                {
                Failed = TRUE; 
                printf("Port %04X, indirect reg %02X failed 1 test! out=%02X, in=%02X\n",
                       wBase, wOffset, bOut, bIn);
                }
            // Try a 0
            bOut = ~bOut;
            OutIndirect(wBase, wOffset, bOut);
            bIn = InIndirect(wBase, wOffset);
            if ((bOut & wMask) != (bIn & wMask))
                {
                Failed = TRUE; 
                printf("Port %04X, indirect reg %02X failed 0 test! out=%02X, in=%02X\n",
                       wBase, wOffset, bOut, bIn);              
                } 
            }
        }
        
    return Failed;
    }




// --------------------------------------------------------------------------  

VOID OutTmpx(BYTE bValue)
    {
    bTmpxContents = bValue;
    _outp(TMPX_REG, bValue);    
    }

// -------------------------------------------------------------------------- 
BYTE InTmpx(VOID)
    {
    return bTmpxContents;
    }
    
// --------------------------------------------------------------------------
VOID SetTmpxPlay(VOID)
    {
    bTmpxContents |= TMPX_PLAY;
    _outp(TMPX_REG, bTmpxContents); 
    }
    
// --------------------------------------------------------------------------
VOID SetTmpxRecord(VOID)
    {
    bTmpxContents &= ~TMPX_PLAY;
    _outp(TMPX_REG, bTmpxContents);  
    }                        
    
// -------------------------------------------------------------------------- 
VOID ResetFifo(VOID)
    {
    _outp(TMPX_REG, bTmpxContents & ~TMPX_AGEN_RESET);
    _outp(TMPX_REG, bTmpxContents);
    } 
    
// --------------------------------------------------------------------------
VOID MReset(VOID)
    {
    _outp(TMPX_REG, bTmpxContents & ~TMPX_MRESET);  
    delay();
    _outp(TMPX_REG, bTmpxContents); 
    }

// -------------------------------------------------------------------------- 
VOID  MixPlayMMAMax(VOID)
    { 
    OutIndirect(MIX_REG, MIX_MODE, MIX_MODE_SELECT_L | MIX_MODE_SELECT_R);    
    OutIndirect(MIX_REG, MIX_SELECT, 0);    // Playback mode       
    OutIndirect(MIX_REG, MIX_MMA_L, 0xff);  
    OutIndirect(MIX_REG, MIX_MMA_R, 0xff);
    OutIndirect(MIX_REG, MIX_FM_L, 0x00);
    OutIndirect(MIX_REG, MIX_FM_R, 0x00); 
    OutIndirect(MIX_REG, MIX_MIC_LINEIN_L, 0x00);
    OutIndirect(MIX_REG, MIX_MIC_LINEIN_R, 0x00); 
    OutIndirect(MIX_REG, MIX_LINEOUT_L, 0xff);
    OutIndirect(MIX_REG, MIX_LINEOUT_R, 0xff);
    }

// -------------------------------------------------------------------------- 
VOID MixPlayFMMax(VOID)
    {
    OutIndirect(MIX_REG, MIX_MODE, MIX_MODE_SELECT_L | MIX_MODE_SELECT_R);    
    OutIndirect(MIX_REG, MIX_SELECT, 0);    // Playback mode       
    OutIndirect(MIX_REG, MIX_MMA_L, 0x00);
    OutIndirect(MIX_REG, MIX_MMA_R, 0x00);
    OutIndirect(MIX_REG, MIX_FM_L, 0xff);
    OutIndirect(MIX_REG, MIX_FM_R, 0xff); 
    OutIndirect(MIX_REG, MIX_MIC_LINEIN_L, 0x00);
    OutIndirect(MIX_REG, MIX_MIC_LINEIN_R, 0x00); 
    OutIndirect(MIX_REG, MIX_LINEOUT_L, 0xff);
    OutIndirect(MIX_REG, MIX_LINEOUT_R, 0xff);       
    } 
 
// --------------------------------------------------------------------------
VOID ResetMMA(VOID)
    {    
    // Wave audio config reg... strobe reset bit (D7)
    MMA_OUT( MMA_PCM_CONTROL, MMA_PCM_CONTROL_ADPRST ); 
    MMA_OUT2(MMA_PCM_CONTROL, MMA_PCM_CONTROL_ADPRST );
    delay();
    MMA_OUT( MMA_PCM_CONTROL, 0 );
    MMA_OUT2(MMA_PCM_CONTROL, 0);
    }           