//--------------------------------------------------------------------------;
//
//  File: DSND.H
//
//  Description:
//     Include file used by DirectSound compoents for DREAM driver
//
//
//  THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
//  KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
//  IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR
//  PURPOSE.
//
//---------------------------------------------------------------------------
//
//  Copyright (c) 1994 - 1995 Microsoft Corporation.  All Rights Reserved.
//
//---------------------------------------------------------------------------

#ifndef ASSERT
#define ASSERT(exp) {Debug_OutC((!(exp)), "DREAM_DSND: Failed ASSERT(" #exp ")\n");}
#endif
#define DP(arg) {Trace_Out("DREAM_DSND: "); Trace_Out##arg; }

#define Multimedia_OEM_ID   0x0440      // MS Reserved OEM #34
#define Dream_Device_ID  0x6969   //(Multimedia_OEM_ID + 31)

// DREAM mod constant
#define BUF_OPEN	0x52
#define BUF_START	0x54
#define BUF_STOP	0x55
#define BUF_CLOSE	0x53


// Function in dsound.asm
void bufCommand(LPVOID pBufferObjContext,BYTE Command);
void bufSetFreq(LPVOID pBufferObjContext, DWORD freq);
void bufSetVol(LPVOID pBufferObjContext, DWORD MasterVol);
void bufDefineMem(LPVOID pBufferObjContext, DWORD Format,DWORD Start,DWORD Loop,DWORD End);
WORD	bufGetVoicesNb(DEVNODE devnode);
ULONG	bufGetPos(LPVOID pBufferObjContext);
void	bufSetPos(LPVOID pBufferObjContext, DWORD PageOffset, DWORD Offset);
void	modChangeParam(LPVOID pBufferObjContext, DWORD Command, DWORD Param);

#define DS_DRIVER_STATE_ACTIVATED          0x0001
#define DS_DRIVER_STATE_BUFFER_ALLOCED     0x0002

#define DS_DAC_STATE_STOPPED            0x0000
#define DS_DAC_STATE_PLAYING            0x0001
#define DS_DAC_STATE_LOOPING            0x0002



typedef struct tDSDRIVER {
    const IDSDRIVERVTBL *pDriverVTable;

    DEVNODE         DevNode;             // devnode associated with this driver
    PDEVICEINFO     pdiDSound;      // ptr to DSOUND.VXD device info

    ULONG           ReferenceCount;
    ULONG           ObjRefCount;
	void			*pPrimaryBuffer;		// to be cast in PDSDRIVERBUFFER
}  DSDRIVER, *PDSDRIVER;


// WARNING! WARNING! WARNING! WARNING! WARNING! WARNING!
//
// Do NOT chnage DSDRIVERBUFFER structure without updating dsnd.inc
//
// WARNING! WARNING! WARNING! WARNING! WARNING! WARNING!
typedef struct tDSDRIVERBUFFER {
    const IDSDRIVERBUFFERVTBL *lpVtbl;
	
	DWORD			IRQHandle;

    PDSDRIVER       pDriverContext;
    DWORD           DacState;

	//0x10
	DWORD			PcLinAddr;
	DWORD			BoardAddr;		//on board address of the buffer
	DWORD			BoardAddr2;		//on board address of the snd channel buffer (for stereo)
	unsigned short	wBufferNb;
	unsigned short	wBufferNb2;

	//0x20
    DWORD           BufferSize;
    DWORD           PCBufferSize;
	DWORD			CurrentPos;
	DWORD			BufferWritePosition;

	//0x30
    DWORD           ReferenceCounter;
    DWORD           wBitsPerSample;
    DWORD           nChannels;
	DWORD			nSamplesPerSec;

	//0x40
	DWORD			MainVol;
	DWORD			RVol;
	DWORD			LVol;

    unsigned short  HardwareOptions;
    unsigned short  BaseAddress;

	//0x50
    unsigned short  Primary;
	unsigned short	PhysBufferNb;
	DWORD			VmNb;			// number in the voices manager

	void	*p3DProperty;			//pointer on DS3DLISTENER or DS3DBUFFER structure (according to the Primary Flag)
									// To be allocated when openning a 3D buffer (Flag DBSCAPS_CTRL3D) or when QuerySupport
	ULONG	Instance3DId;

	//0x60
	DWORD	Enabled3D;				// TRUE if 3D positionned is actived
	DWORD	LoopPoint;			// set by the Dream property DSPROPERTY_DREAMBUFFER_LOOPPOINT
	DWORD	VFront;				// memorize the front volume
	DWORD	VBack;				// memorize back volume

	//0x70
	DWORD	VolMaster;			// memorize the master volume of the voice		
	DWORD	SamPitch;			// memorize the actual pitch
	float	Doppler;

} DSDRIVERBUFFER, *PDSDRIVERBUFFER;

//  Voices Manager structure
typedef struct tVMAN
{
	PDSDRIVERBUFFER pDsDriverBuffer;
	BOOL			Alloc;
} VOICESMAN;

typedef struct DIOCParams       {
        DWORD   Internal1;              // ptr to client regs
        DWORD   VMHandle;               // VM handle
        DWORD   Internal2;              // DDB
        DWORD   dwIoControlCode;
        PVOID   lpvInBuffer;
        DWORD   cbInBuffer;
        PVOID   lpvOutBuffer;
        DWORD   cbOutBuffer;
        PVOID   lpcbBytesReturned;
        DWORD   lpoOverlapped;
        DWORD   hDevice;
        DWORD   tagProcess;
} DIOCPARAMETERS;
 
typedef DIOCPARAMETERS *PDIOCPARAMETERS;

//in bufobj.c
BOOL TransferBlock(PDSDRIVERBUFFER pBufferObjContext,DWORD BoardBuffOffset, LPVOID PcSrcAddress, DWORD Size);
BOOL FreeRessources(PDSDRIVERBUFFER pBufferObjContext);
BOOL FreeBoardRessources(PDSDRIVERBUFFER pBufferObjContext);
BOOL AllocateSAMVoices(PDSDRIVERBUFFER pBufferObjContext);
BOOL StartPlay(PDSDRIVERBUFFER pBufferObjContext, BOOL DsStart);
BOOL DSvxdFree(PDSDRIVERBUFFER pBufferObjContext, DWORD BufferStartAddr);

//in drvobj
BOOL AllocateBoardRessources(PDSDRIVERBUFFER pBufferObjContext, DWORD RequestedSize);


extern PDIOCPARAMETERS gpdiocp;

extern const IDSDRIVERBUFFERVTBL vtDsDriverBuffer;
extern const IDSDRIVERPROPERTYSETVTBL vtDsPropertySet;

// in DSOUND.ASM
extern char *   __cdecl GetDsDesc();
extern void     __cdecl FillInDsBufferStruct( PDSDRIVERBUFFER pBufferObjContext, DWORD DevNode );
extern void     __cdecl ReleaseDS( DEVNODE DevNode );
extern DWORD    __cdecl AcquireDS( DEVNODE DevNode );

// in BUFOBJ.C
BOOL AllocatePcBuffer( IN PDSDRIVERBUFFER pBufferObjContext, IN OUT LPBYTE *ppBuffer, IN OUT LPDWORD pRequestedSize);

// in dreamvxd.ASM
extern void      __cdecl DREAM_Set_pDSDriver( DEVNODE dn, PDSDRIVER pDSDriver );
extern PDSDRIVER __cdecl DREAM_Get_pDSDriver( DEVNODE dn );
extern DWORD     __cdecl DREAM_Get_Version();
extern WORD     __cdecl DREAM_Get_BasePort(DEVNODE dn);
 


// CS4231 specific registers

#define REGISTER_CAP_DATAFORMAT (0x1C)
#define REGISTER_CAP_UPPERBASE  (0x1E)
#define REGISTER_CAP_LOWERBASE  (0x1F)

#define AD1848_CONFIG_PEN       0x01            // Playback Enable
#define AD1848_CONFIG_CEN       0x02            // Capture Enable
#define AD1848_CONFIG_SDC       0x04            // Single DMA Channel
#define AD1848_CONFIG_ACAL      0x08            // Auto-Calibrate
#define AD1848_CONFIG_RESERVED  0x30            // Reserved
#define AD1848_CONFIG_PPIO      0x40            // Playback PIO Enable
#define AD1848_CONFIG_CPIO      0x80            // Capture PIO Enable

#define AD1848_MODE_TRD         0x20            // transfer request disable
#define AD1848_MODE_MCE         0x40            // mode change enable

#define CS4231_MISC_MODE2       0x40            // MODE 2 select/detect

#define VER_AD1848J             0x09            // version marker of CODEC
#define VER_AD1848K             0x0A

#define VER_CSPROTO             0x81            // prototype, treat as 'J'
#define VER_CS4248              0x8A

#define CODEC_J_CLASS           0x00            // AD1848J
#define CODEC_K_CLASS           0x01            // AD1848K & CS4248
#define CODEC_KPLUS_CLASS       0x02            // CS4231


#define DAK_MSFTHARDWARE   0x0001      // obsolete
#define DAK_MSFTSUPPORT    0x0002      // obsolete
#define DAK_AUTOSELECT     0x0004      // PAL? (Auto-Options?)
#define DAK_FMSYNTH        0x0008      // synth on board?
#define DAK_COMPAQBA       0x0010      // Compaq Business Audio detected
#define DAK_COMPAQI        0x0020      // Compaq BA without AGA -
                                       //   requires COMPAQBA flag.
#define DAK_DUALDMA        0x0040      // Set when using sim. rec/play



//Property Set
typedef struct tDSPROPSET 
{
    const IDSDRIVERPROPERTYSETVTBL *lpVtbl;
	
    DWORD           ReferenceCounter;
	PDSDRIVERBUFFER pIBuffer;

} DSPROPERTYSET, *PDSPROPERTYSET;


// Structure for a linked List of 3D buffer
typedef struct tDS3DLIST
{
	PDSDRIVERBUFFER		pBuffer3D;
	struct tDS3DLIST	*pNext;
} DS3DLIST,*PDS3DLIST;

//  function in propset.c
void AddBufferInList(PDSDRIVERBUFFER pBufferCtx);
BOOL PosSound(LPDS3DLISTENER pListener, PDSDRIVERBUFFER pBufferSource);
void RemoveBufferFromList(PDSDRIVERBUFFER pBufferCtx);
long FloatToLong(float fl);

// in bufobj.c
void UpdateAll3DSound(PDSDRIVERBUFFER pBufferObjContext, DWORD MainVol);


//
//		*****  Mathematical function   ********
//in dsound.asm
extern	float	fInX;
extern	float	fInY;
extern	float	fOut;
void dsACos();
void dsSqrt();
void dsPow();


// other function
//in dsound.asm
BOOL SetConfig(WORD wPort, DWORD Device,DWORD Config);

#define C_REVERB	0x6c
#define C_CHORUS	0x6d
#define C_AUDIO		0x6f
#define C_ECHO		0x68
#define C_EQUA		0x6b
#define C_SURROUND		0x6e

#define	C_ON		0x7f
#define C_OFF		0


//in dreampro.cpp
BOOL RestoreMidi();
BOOL DeleteSoundBank(char *BankName);
BOOL ResetMemory();
BOOL RestartDSWave();

// in drvobj.c
BOOL CheckFreeSize(WORD BaseAddress);




