//--------------------------------------------------------------------------;
//
//  File: DRVOBJ.C
//
//  Description:
//      The C implemtation of the DirectSound Driver object.
//      This code is responsible for creating and maintaing the
//      status of the Driver object. It also creates Buffer objects
//      (NOTE: Only 1 buffer object for the MSSNDSYS card)
//
//
//  THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
//  KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
//  IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR
//  PURPOSE.
//
//---------------------------------------------------------------------------
//
//  Copyright (c) 1994 - 1995 Microsoft Corporation.  All Rights Reserved.
//
//---------------------------------------------------------------------------
#define  WANTVXDWRAPS
#define  INITGUID

#include <windows.h>
#include "vmm.h"
#include <vmmreg.h>
#include <vxdldr.h>
#include <vxdwraps.h>

#include <configmg.h>
#include <dsound.h>
#include "dsdriver.h"
#include <debug.h>
#include <conio.h>
#include <memory.h>

#include "dsnd.h"
#include "Dos_xfer.h"

#undef CURSEG
#define CURSEG() PCODE

#pragma VxD_PAGEABLE_CODE_SEG
#pragma VxD_PAGEABLE_DATA_SEG

#define STR_DSOUNDVXD "dsound.vxd"


PDSDRIVERBUFFER pPrimaryBufCtx=NULL;
MemBlDefTyp MemoryBlock[256];

//########
int ncr=0; ndu=0;
//DWORD BDeb[200];

BOOL NoMidiFlag=FALSE;;

// voices manager variables
VOICESMAN VoicesManager[64];

WORD nVoices;		// Number of static voices that can be played

extern	int BlockNb;
extern WORD gwBaseMPU401;		// Base Address 9407
DWORD dwSizeAlloc=0;		// size of memory allocated for buffers
DWORD dwMemorySize; // total memory size in Word (16 bits)

extern NBlocks;				// number of mini blocks (filled by CreateMiniBlockMapping)

DWORD	dwBufferOpenned=0;	// Number of buffer openned in memory
DWORD dwVoiceAllocated=0;	// Number of SAM 9407 voices allocated (1 for each static audio) 
							//			(2 for each mono wave, 3 each for stereo wave)
DWORD dwStaticMem=0;	// Allocated memory for static audio voices pcm

ULONG DeviceNum=0;		// first, let's use the device number 0

WORD ModNumber=256;		//  Number of static buffer allowed (to be dynamically computed 
						// when openning direct sound
BOOL VoiceFree[64]={1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,		// True if the voice is not allocated
	1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1};

WORD FreqNom=37500;
long MemMapAdd;

// A physical buffer can be use by several logical buffer (due to duplication)
// The folowing table give the number of logical buffer using a physical buffer.
// Ressources must be freed only when this number is 0.
short int BufferRef[256];

//--------------------------------------------------------------------------
//
//  IDsDriver_QueryInterface    
//  Description:
//      Here because we want to be COM objects
//  
//  Parameters:
//      pIDsDriver: Pointer to our internal context data
//  Return:
//      None
//  
//  
//--------------------------------------------------------------------------
HRESULT __stdcall
IDsDriver_QueryInterface(
    IN PIDSDRIVER pIDsDriver,
    OUT REFIID riid,
    OUT LPLPVOID ppv
    )
{          
    DP(("IDsDriver_QueryInterface\n"));

    *ppv = NULL;


    if( !IsEqualGUID(riid,&IID_IDsDriver)  &&
            !IsEqualGUID(riid,&IID_IUnknown)  )
    {
        return DSERR_NOINTERFACE;
    }

    *ppv = pIDsDriver;
    ((LPUNKNOWN)*ppv)->lpVtbl->AddRef(*ppv);

    return DS_OK;
}

//--------------------------------------------------------------------------
//
//  IDsDriver_AddRef
//  Description:
//      Used to keep track of the number of "references" to the driver "object"
//      NOTE: When you open the driver object, the reference count is
//      incremented.
//  Parameters:
//      pIDsDriver: Pointer to our driver context data      
//  Return:
//      None
//  
//  
//--------------------------------------------------------------------------
ULONG __stdcall
IDsDriver_AddRef(
    IN PIDSDRIVER pIDsDriver
    )
{
    PDSDRIVER pDriverContext = (PDSDRIVER)pIDsDriver;
    DP(("IDsDriver_AddRef\n"));
    pDriverContext->ReferenceCount++;
    return pDriverContext->ReferenceCount;
}

//--------------------------------------------------------------------------
//
//  IDsDriver_Release
//  Description:
//      Used when removing a reference to the object
//      NOTE: When the driver is closed, the ref count
//      decrements
//  Parameters:
//      pIDsDriver: Pointer to our driver context data      
//  Return:
//      None
//  
//  
//--------------------------------------------------------------------------
ULONG __stdcall
IDsDriver_Release(
    IN PIDSDRIVER pIDsDriver
    )
{
    PDSDRIVER pDriverContext = (PDSDRIVER)pIDsDriver;
    DP(("IDsDriver_Release\n"));

    pDriverContext->ReferenceCount--;
    return pDriverContext->ReferenceCount;
}

//--------------------------------------------------------------------------
//
//  IDsDriver_GetDesc
//  Description:
//      HACK! Used to get the name of the current VxD
//      and a nice text message for the name of the VxD
//      for the user to read
//  Parameters:
//      pIDsDriver: Pointer to our driver context data.
//      pDesc: Structure to fill in.
//  Return:
//      None (filled in PDSDRIVERDESC)
//  
//  
//--------------------------------------------------------------------------
HRESULT __stdcall
IDsDriver_GetDesc(
    IN PIDSDRIVER pIDsDriver,
    IN PDSDRIVERDESC pDesc
    )
{
    char * pszDsDesc;

    PDSDRIVER pDriverContext = (PDSDRIVER)pIDsDriver;
    DP(("IDsDriver_GetDesc\n"));


    ASSERT( pDriverContext );
    ASSERT( pDesc );

    pDesc->dwFlags = DSDDESC_DOMMSYSTEMOPEN;

    pszDsDesc = GetDsDesc();
    _lstrcpyn(pDesc->szDesc, pszDsDesc, sizeof(pDesc->szDesc)-1);	//VMM service (vmm.h )

    _lstrcpyn(pDesc->szDrvname, "DREAM95.VXD", sizeof(pDesc->szDrvname)-1);

    pDesc->dwHeapType   = DSDHEAP_PRIVATEHEAP;

    pDesc->dnDevNode    = pDriverContext->DevNode;
    pDesc->wVxdId       = Dream_Device_ID;
    pDesc->ulDeviceNum  = DeviceNum;


    return DS_OK;
}

//--------------------------------------------------------------------------
//
//  IDsDriver_Open
//  Description:
//      This function will acquire the driver for the exclusive
//      use of DirectSound. This will shut out the rest of the
//      system to the device.
//      NOTE: For MSSNDSYS this should be done via Ring3 mmsystem
//      waveOutOpen()
//  Parameters:
//      pIDsDriver: Pointer to our driver context data.
//  Return:
//      DSSERR error code
//  
//  
//--------------------------------------------------------------------------
HRESULT __stdcall
IDsDriver_Open(
    IN PIDSDRIVER pIDsDriver
    )
{
    PDSDRIVER pDriverContext = (PDSDRIVER)pIDsDriver;
    HRESULT success = DSERR_ALLOCATED;

    DP(("IDsDriver_Open\n"));


    ASSERT( pDriverContext );
    // check our ref count (better be 0)
    ASSERT( !pDriverContext->ReferenceCount );
    if( !pDriverContext->ReferenceCount )
    {
		// acquire the device
		if( !AcquireDS( pDriverContext->DevNode ) )
		{
			if (!CheckFreeSize(DREAM_Get_BasePort(pDriverContext->DevNode)))
				ReleaseDS( pDriverContext->DevNode );
			else
			{
				// increment our ref count
				pDriverContext->ReferenceCount++;
				// it worked!
				success = DS_OK; 
			}
		}
    }

	// Reset the Voice Manager structure
	memset(VoicesManager,0,sizeof(VoicesManager));

    return success;
}

//--------------------------------------------------------------------------
//
//  IDsDriver_GetCaps
//  Description:
//      Get the configuration for this driver
//  Parameters:
//      pIDsDriver: Pointer to our driver context data.
//      pCaps: Caps structure to fill in
//  Return:
//      DSSERR error code
//  
//  
//--------------------------------------------------------------------------
HRESULT __stdcall
IDsDriver_GetCaps(
    IN PIDSDRIVER pIDsDriver,
    IN PDSDRIVERCAPS pCaps                
    )
{
	PDSDRIVER pDriverContext = (PDSDRIVER)pIDsDriver;

	DP(("IDsDriver_GetCaps\n"));


    pCaps->dwFlags = DSCAPS_CONTINUOUSRATE | DSCAPS_PRIMARYMONO | DSCAPS_PRIMARYSTEREO |
                  DSCAPS_PRIMARY8BIT | DSCAPS_PRIMARY16BIT | DSCAPS_SECONDARYMONO | 
				  DSCAPS_SECONDARYSTEREO | DSCAPS_SECONDARY8BIT | DSCAPS_SECONDARY16BIT;
    pCaps->dwPrimaryBuffers = 1;
    pCaps->dwMinSecondarySampleRate = 0;
    pCaps->dwMaxSecondarySampleRate = 0xffff;
    pCaps->dwMaxHwMixingAllBuffers = 256;	
    pCaps->dwMaxHwMixingStaticBuffers = 248;
    pCaps->dwMaxHwMixingStreamingBuffers = 8;
    pCaps->dwFreeHwMixingAllBuffers = 256 - dwBufferOpenned;
    pCaps->dwFreeHwMixingStaticBuffers = 248 - dwBufferOpenned;
    pCaps->dwFreeHwMixingStreamingBuffers = 8;
	pCaps->dwMaxHw3DAllBuffers = 256;
    pCaps->dwMaxHw3DStaticBuffers = 248;
    pCaps->dwMaxHw3DStreamingBuffers = 8;
    pCaps->dwFreeHw3DAllBuffers = 256 - dwBufferOpenned;
    pCaps->dwFreeHw3DStaticBuffers = 248 - dwBufferOpenned;
    pCaps->dwFreeHw3DStreamingBuffers = 8;
    pCaps->dwTotalHwMemBytes = dwMemorySize*2;
    pCaps->dwFreeHwMemBytes = dwMemorySize*2-dwSizeAlloc;

    return DS_OK;
}

//--------------------------------------------------------------------------
//
//  IDsDriver_CreateSoundBuffer
//  Description:
//      This function creates an instance of a buffer object.
//      It sets up the buffer for the requested size.
//      This code also Registers the BufferObject V-Table with
//      DirectSound.
//      NOTE: only 1 buffer for MSSNDSYS. This is also where
//      DirectSound would call to create hardware secondary buffers
//
//		2 case :
//		Primary buffer : I don't need primary buffer, I implement them as secondary buffers
//		Secondary buffers : I receive address in *ppBuffer
//
//  Parameters:
//      pIDsDriver: Pointer to our device context
//      pRequestedFormat: Requested format for buffer
//          NOTE: For primary buffers (which is all this driver supports),
//              we will change the size depending on the amount
//              of dma memory that was allocated at start up.
//              Please note the return values.
//      dwFlags: Flags specifying requested options for the buffer.
//      dwCardAddress: Address of on-card memory to use for buffer.  This
//          is only used when the card supports on-card memory buffers and it
//          is using dsound to manage such memory (i.e., the driver object
//          supports the IDsDriverHeap interface).
//      pRequestedSize: The size of the buffer the user wants
//      ppBuffer: A pointer to the resulting buffer
//      ppBufferContext: A pointer to the buffer object we just created
//          In our case, this is a pointer to the buffer device
//          conext
//  Return:
//      DSSERR error code
//  
//  
//--------------------------------------------------------------------------
HRESULT __stdcall
IDsDriver_CreateSoundBuffer(
    IN PIDSDRIVER pIDsDriver,
    IN LPWAVEFORMATEX pRequestedFormat,
    IN DWORD dwFlags,
    IN DWORD dwCardAddress,
    IN OUT LPDWORD pRequestedSize,
    IN OUT LPBYTE *ppBuffer,
    OUT LPVOID *ppBufferContext
    )
{
    PDSDRIVER pDriverContext = (PDSDRIVER)pIDsDriver;
    HRESULT success = DSERR_OUTOFMEMORY;
    PDSDRIVERBUFFER pBufferObjContext = NULL;

    DP(("IDsDriver_CreateSoundBuffer\n"));

	if (pRequestedFormat->nSamplesPerSec>0xffff)
		return DSERR_BADFORMAT;

    // NULL out return pointer.
    *ppBufferContext = NULL;

    // We better not have any objects created yet.
    // NOTE: If your sound card supports hardware soundbuffers remove this check
    //if( !pDriverContext->ObjRefCount )
    //{
        // allocate new buffer
        pBufferObjContext = _HeapAllocate(sizeof(*pBufferObjContext), HEAPZEROINIT | HEAPSWAP);
        if( pBufferObjContext )
        {
			if (dwFlags & DSBCAPS_PRIMARYBUFFER)
			{
				pBufferObjContext->Primary=1;
				pPrimaryBufCtx=((PDSDRIVERBUFFER) (pDriverContext->pPrimaryBuffer))=pBufferObjContext;		//set primary buffer pointer
			}

            // setup our V-table
            pBufferObjContext->lpVtbl = &vtDsDriverBuffer;
            // Remember a pointer to our parent (the device)
            pBufferObjContext->pDriverContext = pDriverContext;
            // get some data we need from the Win95 driver
            FillInDsBufferStruct( pBufferObjContext, pDriverContext->DevNode );		

			// remember the relvant data about this format
			pBufferObjContext->wBitsPerSample = pRequestedFormat->wBitsPerSample;
			pBufferObjContext->nChannels = pRequestedFormat->nChannels;

			if (AllocateBoardRessources(pBufferObjContext,*pRequestedSize))
			{
				//#######	
				/*BDeb[2*ncr]=pBufferObjContext->BoardAddr;
				BDeb[2*ncr+1]=pBufferObjContext->BufferSize;*/
				ncr++;


				// allocate the buffer on the pc side
				if (AllocatePcBuffer( pBufferObjContext, ppBuffer, pRequestedSize))
				{
					success = DS_OK;
					// set the state of this buffer
					pBufferObjContext->DacState = DS_DAC_STATE_STOPPED;
					//initialize the relative position
					pBufferObjContext->CurrentPos=0;
					// inc our ref count on this buffer object
					pBufferObjContext->ReferenceCounter++;
					// Set the Pitch
					pBufferObjContext->nSamplesPerSec=(DWORD) (pRequestedFormat->nSamplesPerSec*0x400/FreqNom);
					//Set Volume
					pBufferObjContext->MainVol=0xff;
					pBufferObjContext->RVol=0xff;
					pBufferObjContext->LVol=0xff;
				}
				else
				{
					FreeBoardRessources(pBufferObjContext);
				}
			}
			else
			{
				success = DSERR_OUTOFMEMORY;
			}
        } 
		else {
            // HelpAlloc failure
            success = DSERR_OUTOFMEMORY;
        }

    // if there were any error
    if( success != DS_OK )
    {
        // make sure we clean up our memory
        if( pBufferObjContext ) { _HeapFree( pBufferObjContext, 0 ); }
    } else 
	{
        // Set out pointer to the newly-created object.
        
		if (dwFlags & DSBCAPS_CTRL3D)
		{			// ask a 3D buffer, allocate 3D structure
			//first, check if not stereo
			if (pBufferObjContext->nChannels==2)
			{
				dwSizeAlloc-=pBufferObjContext->BufferSize*4;
				dwBufferOpenned--;
				memorFree(MemoryBlock, pBufferObjContext->BoardAddr -8);
				memorFree(MemoryBlock, pBufferObjContext->BoardAddr2 -8);
				return DSERR_BADFORMAT;
			}
			if (dwFlags & DSBCAPS_PRIMARYBUFFER)		//should never be!
				pBufferObjContext->p3DProperty = _HeapAllocate(sizeof(DS3DLISTENER), HEAPZEROINIT | HEAPSWAP);
			else
			{
				pBufferObjContext->p3DProperty = _HeapAllocate(sizeof(DS3DBUFFER), HEAPZEROINIT | HEAPSWAP);
				//add this 3D buffer in the Buffer3DList
				pBufferObjContext->Enabled3D= 1;		// 3D buffer
			}
		}
		
		*ppBufferContext = pBufferObjContext;
        pDriverContext->ObjRefCount++;
	}

    return success;
}

//--------------------------------------------------------------------------
//
//  IDsDriver_DuplicateSoundBuffer
//  Description:
//  Parameters:
//  Return:
//      DSSERR error code
//  
//  
//--------------------------------------------------------------------------
HRESULT __stdcall
IDsDriver_DuplicateSoundBuffer(
    IN PIDSDRIVER pIDsDriver,
    IN PIDSDRIVERBUFFER pIDsDriverBuffer,                              
    OUT LPVOID *ppv
    )
{
	PDSDRIVER pDriverContext = (PDSDRIVER)pIDsDriver;
	PDSDRIVERBUFFER pNewBufferObjContext = NULL;
	PDSDRIVERBUFFER pBufferObjContext = (PDSDRIVERBUFFER)pIDsDriverBuffer;


    DP(("IDsDriver_DuplicateSoundBuffer\n"));

	ndu++;
	
    *ppv = NULL;

	if (pBufferObjContext->Primary)
		return DSERR_INVALIDCALL;

    // allocate new buffer
    pNewBufferObjContext = _HeapAllocate(sizeof(*pBufferObjContext), HEAPZEROINIT | HEAPSWAP);
    if( pNewBufferObjContext == NULL)
		return DSERR_OUTOFMEMORY;

	// Duplicate information in *pBufferObjContext
	memcpy(pNewBufferObjContext, pBufferObjContext,sizeof(*pBufferObjContext));
				
    // Set out pointer to the newly-created object.
    *ppv = pNewBufferObjContext;
    pDriverContext->ObjRefCount++;

	// inc our ref count on this buffer object
	pNewBufferObjContext->ReferenceCounter=1;
	// set the state of this buffer
	pNewBufferObjContext->DacState = DS_DAC_STATE_STOPPED;
	//initialize the relative position
	pNewBufferObjContext->CurrentPos=0;

	// increment the physical buffer refence counter
	BufferRef[pBufferObjContext->PhysBufferNb]++;	

	// If a 3D structure is allocated, let's create a new one for the new buffer
	if (pBufferObjContext->p3DProperty)
	{
		pNewBufferObjContext->p3DProperty = _HeapAllocate(sizeof(DS3DBUFFER), HEAPZEROINIT | HEAPSWAP);
		pNewBufferObjContext->Enabled3D=1;
	}

    return DS_OK;

}

//--------------------------------------------------------------------------
//
//  IDsDriver_Close
//  Description:
//      We are done with doing DirectSound stuff, and we'd like
//      to release the card back to the system.
//      NOTE: This function will dec our Ref count
//  Parameters:
//      pIDsDriver: pointer to our device context
//  Return:
//      DSSERR error code
//  
//  
//--------------------------------------------------------------------------
HRESULT __stdcall
IDsDriver_Close(
    IN PIDSDRIVER pIDsDriver
    )
{
    PDSDRIVER pDriverContext = (PDSDRIVER)pIDsDriver;
    HRESULT success = DSERR_GENERIC;

    DP(("IDsDriver_Close\n"));

    ASSERT( pDriverContext );

    // decrement our reference count
    pDriverContext->ReferenceCount--;

    // our ref count better be 0
    ASSERT( !pDriverContext->ReferenceCount );
    if( !pDriverContext->ReferenceCount )
    {
        // check the number of allocated objects
        ASSERT( !pDriverContext->ObjRefCount )
        if( !pDriverContext->ObjRefCount )
        {

            ReleaseDS( pDriverContext->DevNode );
			
			// restore the MMT
			DownLoad(gwBaseMPU401,MemoryBlock,(WORD) (MemMapAdd>>16),(WORD) (MemMapAdd & 0xffff),64*3);
			
			if (NoMidiFlag)
			{
				if (!RestoreMidi())
					return DSERR_GENERIC;
				NoMidiFlag=FALSE;
			}

			// it worked!
            success = DS_OK; 
        }
    }

    return success;

}


const IDSDRIVERVTBL DsDriverVTable = {
    IDsDriver_QueryInterface,
    IDsDriver_AddRef,
    IDsDriver_Release,
    IDsDriver_GetDesc,
    IDsDriver_Open,
    IDsDriver_Close,
    IDsDriver_GetCaps,
    IDsDriver_CreateSoundBuffer,
    IDsDriver_DuplicateSoundBuffer
};

//--------------------------------------------------------------------------
//
//  dsInitializeDriver
//  Description:
//      Called at startup by MSDNSSYS VxD. Allocates a device object and
//      stores our context with the DevNode for this device. It also
//      loads the DirectSound VxD, and registers our DeviceObject V-Table
//      with DirectSound.
//  Parameters:
//      dn: The DevNode to attach our device context too
//  Return:
//      none
//  
//  
//--------------------------------------------------------------------------
VOID
dsInitializeDriver(
    IN DEVNODE dn
    )
{
    PVMMDDB     pDDB;
    PDEVICEINFO pdi = NULL;
    PDSDRIVER   pDriverContext = NULL;
   // ULONG       cbBusInfo;
    HRESULT     success=FALSE;
    HRESULT     returnValue;
	WORD wStatus;

    DP(("dsInitializeDriver\n"));

    ASSERT( dn );

    //
    // Currently we don't support PCMCIA cards.  No real reason, just
    // not enough time to implement it.
    //
  /*  cbBusInfo = 0;
    if (CR_SUCCESS != CM_Get_Bus_Info( dn, &cmBusType, &cbBusInfo, NULL, 0 )) {
        cmBusType = BusType_None ;
    }
    if (BusType_PCMCIA == cmBusType) return;*/

    //
    // Allocate memory for a driver object and initialize the function
    // table and some other members
    //
    pDriverContext = _HeapAllocate(sizeof(*pDriverContext), HEAPZEROINIT | HEAPSWAP);
    if( pDriverContext )
    {
		Trace_Out("driver context allocate ok");
        pDriverContext->DevNode = dn;
		
        pDriverContext->pDriverVTable = &DsDriverVTable;
        ASSERT( &DsDriverVTable );
    
        //
        // Dynaload DSOUND.VXD and save ptr to device info
        //
        returnValue = VXDLDR_LoadDevice(&pDDB, &pdi, STR_DSOUNDVXD, TRUE);

		if( !returnValue )
        {
            ASSERT( pdi );
			Trace_Out("ds vxd loaded");
            pDriverContext->pdiDSound = pdi;
            //
            // Register this driver with DSOUND.VXD.  Then save a ptr to this
            // DSOUND driver object in the card instance structure.
            //
            returnValue = DSOUND_RegisterDeviceDriver((PIDSDRIVER)pDriverContext, 0);
  
			if( returnValue == DS_OK )
            {
				Trace_Out("register ok");
                DREAM_Set_pDSDriver( dn, pDriverContext );
                success = TRUE;
            }
        }
    }
    if( success == FALSE )
    { 
		Trace_Out("Error in initializing DS");
        // clean up after our mess.
        if(pdi) { VXDLDR_UnloadDevice( pdi->DI_DeviceID, pdi->DI_ModuleName ); }
        if( pDriverContext ) { _HeapFree( pDriverContext, 0 ); }
    }

	//  Let's check the nominal frequency 
	_outp(DREAM_Get_BasePort(dn)+1,0x3f);
	if (UpLoad(DREAM_Get_BasePort(dn),&wStatus,0,0x20f,1)) 	//Load the dream status byte 
	{
		return ;
	}
	_outp(DREAM_Get_BasePort(dn)+1,0xff);

	if (!(wStatus >> 15))
		return ;		//old version ->37,5kHz
	if (wStatus & 0x8)
		FreqNom=44100;

	// initialize the table BufferRef (zero init)
	memset(BufferRef,0,sizeof(BufferRef));

    return;
}

//--------------------------------------------------------------------------
//
//  dsTerminateDriver
//  Description:
//      Called with the MSSNDSYS recives a shutdown (or reconfig message).
//      De-Register with DirectSound (because we are about to go away)
//      and un-allocate our Driver Device context.
//  Parameters:
//      dn: The DevNode we attached ourselves too
//  Return:
//      none
//  
//  
//--------------------------------------------------------------------------
VOID
dsTerminateDriver(
    IN DEVNODE dn
    )
{
    PDSDRIVER   pDrv;
    HRESULT success = FALSE;
    
    //DP(("dsTerminateDriver\n"));
	Trace_Out("dsTerminateDriver\n");

    // get our context data from Win95 driver's data struct.
    pDrv = DREAM_Get_pDSDriver( dn );
    if( pDrv ) {
        // clear our context data
        DREAM_Set_pDSDriver( dn, NULL );

        // tell DirectSound we're done
        DSOUND_DeregisterDeviceDriver( (PIDSDRIVER)pDrv, 0 );
    
        ASSERT(pDrv->pdiDSound);
        // unload direct sound.
        // NOTE: The DirectSound VxD keeps it's own ref count.
        // the VxD will not unload if someone else is useing it.
        VXDLDR_UnloadDevice( pDrv->pdiDSound->DI_DeviceID,
                             pDrv->pdiDSound->DI_ModuleName );
        _HeapFree( pDrv, 0 );
    }
    
    return;
}

////////////////////////////////////////////////////////
//
//	Compute the number of available streaming wave
//	in function of memory size
//
///////////////////////////////////////////////////////

BOOL CheckFreeSize(WORD BaseAddress)
{   
long FreeSize;
int nbl, nbWave=0;
MemBlDefTyp MemoryBlock2[64];
 
    // check free size 
if ((MemMapAdd=GetMemMapAddress(BaseAddress))==0xffffffff)				//API Dream called to Get Memory Mapping Table address
	{
	return FALSE;           
	}
if (UpLoad(BaseAddress,MemoryBlock,(WORD) (MemMapAdd>>16),(WORD) (MemMapAdd & 0xffff),64*3))	//API Dream called to Get Memory block definition
	{
	return FALSE;
	}

memcpy(MemoryBlock2, MemoryBlock, 64*3);
					
FreeSize=0;
for (nbl=0; nbl<BlockNb; nbl++)
{
	if ((MemoryBlock[nbl].Type & 0xff) ==0x20)			// wave buffer!!->no DS allowed
	{
		nbWave++;
		if (nbWave==2)
			return FALSE;
	}
	if ((MemoryBlock[nbl].Type & 0xff) ==0x30)
	{
		//call only when reconfig
		MemoryBlock[nbl].Type=1;
	}
	if (MemoryBlock[nbl].Type==1)
	{
		FreeSize+=MemoryBlock[nbl+1].Address-MemoryBlock[nbl].Address;  
		MemoryBlock2[nbl].Type=0x30;
	}   
	if (MemoryBlock[nbl].Type==0xffff)		// end of table
		break;
}
dwMemorySize=(DWORD) FreeSize;   

nVoices=bufGetVoicesNb(BaseAddress);

DownLoad(BaseAddress,MemoryBlock2,(WORD) (MemMapAdd>>16),(WORD) (MemMapAdd & 0xffff),64*3); // no more free block for wave, etc...

return TRUE;
}   


BOOL AllocateBoardRessources(PDSDRIVERBUFFER pBufferObjContext, DWORD RequestedSize)
{
	WORD  Zeros[8]={0,0,0,0,0,0,0,0};
	WORD PhysBuffNb;
	// Let's allocate the buffer on board memory
	pBufferObjContext->BufferSize=RequestedSize;

	if (pBufferObjContext->wBitsPerSample==8)	//8bits
		pBufferObjContext->BufferSize*=2;

	if (pBufferObjContext->nChannels==2)	//stereo
		pBufferObjContext->BufferSize/=2;

	pBufferObjContext->BufferSize/=2;	//in word


	//  Let's choose a Buffer Number
	PhysBuffNb=0;
	while ((BufferRef[PhysBuffNb]) && (PhysBuffNb<ModNumber))
		PhysBuffNb++;
	if (PhysBuffNb==ModNumber)
	{
		Trace_Out("Too many buffers allocated");
		return FALSE;
	}

//	if (vxdAlloc(pBufferObjContext->BufferSize + 16,0x0030+(PhysBuffNb<<8) ,&(pBufferObjContext->BoardAddr)))
//		return FALSE;	

//	if (vxdAlloc(pBufferObjContext->BufferSize + 16,0x0031 ,&(pBufferObjContext->BoardAddr)))
//		return FALSE;	

	BlockNb=256;
	if (memorAlloc(MemoryBlock,(long)pBufferObjContext->BufferSize + 16,0x0030+(PhysBuffNb<<8) ,(long*) &(pBufferObjContext->BoardAddr)))
		return FALSE;

	pBufferObjContext->BoardAddr+=8;		// no datas in the first 8 samples
	dwSizeAlloc+=pBufferObjContext->BufferSize*2;
		
	if (pBufferObjContext->nChannels==2)		//stereo
	{		//								-->allocate 2nd channel
		if (pBufferObjContext->wBitsPerSample==16)	//16b stereo--->allocate Right buffer
		{
		//	if (vxdAlloc(pBufferObjContext->BufferSize + 16,0x0031+(PhysBuffNb<<8) ,&(pBufferObjContext->BoardAddr2)))
			if (memorAlloc(MemoryBlock,(long) pBufferObjContext->BufferSize + 16,0x0031+(PhysBuffNb<<8),(long*) &(pBufferObjContext->BoardAddr2)))
			{
				BlockNb=256;
				memorFree(MemoryBlock, pBufferObjContext->BoardAddr -8);
				BlockNb=64;
				//DSvxdFree(pBufferObjContext, pBufferObjContext->BoardAddr -8);
				dwSizeAlloc-=pBufferObjContext->BufferSize*2;
				return FALSE;
			}
			pBufferObjContext->BoardAddr2+=8;		// no datas in the first 8 samples
			if (DownLoad(pBufferObjContext->BaseAddress,Zeros,
				(WORD) ((pBufferObjContext->BoardAddr2+pBufferObjContext->BufferSize)>>16),
				(WORD) (pBufferObjContext->BoardAddr2+pBufferObjContext->BufferSize),
				8))
			{
				Trace_Out("erreur in download for zeros!!");
			}
			dwSizeAlloc+=pBufferObjContext->BufferSize*2;
		}
		else
		{
			pBufferObjContext->BoardAddr2=pBufferObjContext->BoardAddr;
		}
	}
	else
	{
		pBufferObjContext->BoardAddr2=0;
	}

	if (DownLoad(pBufferObjContext->BaseAddress,Zeros,
		(WORD) ((pBufferObjContext->BoardAddr+pBufferObjContext->BufferSize)>>16),
		(WORD) (pBufferObjContext->BoardAddr+pBufferObjContext->BufferSize),
		 8))
	{
		Trace_Out("erreur in download for zeros!!");
	}

	BlockNb=64;

	// set physical buffer number
	BufferRef[PhysBuffNb]++;
	pBufferObjContext->PhysBufferNb=PhysBuffNb;	

	dwBufferOpenned++;

	return TRUE;
}
