/****************************************************************************
 *
 *   waveout.c
 *
 *   Copyright (c) 1991-1992 Microsoft Corporation.  All Rights Reserved.
 *
 ***************************************************************************/

#include <windows.h>
#include <mmsystem.h>
#include <mmddk.h>
#include "dream94.h"    
#include "dream.h"        
#include <stdio.h>             

WORD Zeros[0x400];
volatile BYTE UartAc;		// modified in interrupt
WORD SizeBuffer[9];
char MsgStr[60];
BYTE IntUsed=0;                                          
BOOL FirstTime=TRUE;   
int SizeMem=0;
volatile WORD CloseChannel[8]={FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE};
long MemSize=0x7fffffff;
WAVEALLOC          pOutClient[8];	// Clients info 
PHARDWAREINSTANCE phwi; 
extern BYTE BRFlag[9];
extern gwPort;		//inita.asm
BYTE gbSize[8];        // 0=8 bits ; 1=16 bits
BYTE gbStereo[8];        //0=mono  ; 1=stereo    
WORD wFiltFc[8]={0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff};		  // current filter fc for device
WORD wFiltQ[8]={0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff};		  // current filter Q
WORD wVolAuxL[8]={0,0,0,0,0,0,0,0};    // Aux Volume Left for device id      
WORD wVolAuxR[8]={0,0,0,0,0,0,0,0};    // Aux Volume Right
DWORD gdwPitch[9];		  // current relative pitch (windows format) 
WORD PitchValue[8];			// absolute sample rate for Wave  nb
DWORD gdwVol[9]={0x7f007f00,0x7f007f00,0x7f007f00,0x7f007f00,    // current volume of device (windows format)
		0x7f007f00,0x7f007f00,0x7f007f00,0x7f007f00};          //  default volume=max/2
long WaveBufferSize=0xD00;		// size in word of wave buffer (default : 2K words)
extern long WaveBufferSizeIn;		//wavein.c
WORD WaveState[9]={FREE,FREE,FREE,FREE,FREE,
					FREE,FREE,FREE,FREE}; // current state of each wave channel
WORD NextXFCount[8]; 
WORD MemXFCount[8];
extern BYTE	OpenFmt[9];				// data format send to P16    

volatile WORD  gwModAnsNb;
BYTE gbModAnsByte;
BYTE gbModAnsLong[4];

BYTE Ack_Ok;  
MemBlDefTyp MemoryBlock[NbMemBlocks]; 
WORD ControleValue[64];                   
WORD IdNb[8]={0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff};

extern BOOL WaveOutCaps, WaveOut4;		// ApiVxd.c

/*****************************************************************************

    internal function prototypes

 ****************************************************************************/ 

static void NEAR PASCAL wodFreeQ(WORD);

/****************************************************************************
 * @doc INTERNAL
 *
 * @api void | wodFreeQ | Free all buffers.
 *
 * @rdesc There is no return value.
 ***************************************************************************/ 
static void NEAR PASCAL wodFreeQ(WORD noChannel)
{
extern void FAR PASCAL wodPostAllHeaders( WORD noChannel );
LPWAVEHDR lpH, lpN;

    /* first free the lpDeadHeads... */
    wodPostAllHeaders(noChannel);

    if (LoopStart[noChannel])
       lpH = LoopStart[noChannel];
    else
       lpH = lpWOQueue[noChannel];           /* point to top of the queue */

    lpWOQueue[noChannel] = NULL;             /* mark the queue as empty */
    LoopStart[noChannel] = NULL;
    CurData[noChannel] = NULL;
    CurCount[noChannel] = 0L;
    LoopCount[noChannel] = 0L;

    while (lpH) {
        lpN = lpH->lpNext;
        wodBlockFinished(lpH);
        lpH = lpN;
    }
}


/****************************************************************************
 * @doc INTERNAL
 *
 * @api void | wodGetDevCaps | Get the device capabilities.
 *
 * @parm LPBYTE | lpCaps | Far pointer to a WAVEOUTCAPS structure to
 *      receive the information.
 *
 * @parm WORD | wSize | Size of the WAVEOUTCAPS structure.
 *
 * @rdesc There is no return value.
 ***************************************************************************/
void FAR PASCAL wodGetDevCaps(MDEVICECAPSEX FAR * lpCaps,WORD id)
{
WAVEOUTCAPS wc;

    wc.wMid = Mid;   // not a MicroSoft driver
	if (Mid)
		wc.wPid = WoPid+id;
	else
		wc.wPid =WoPid;
    wc.vDriverVersion = DRIVER_VERSION;
    wc.dwFormats = WAVE_FORMAT_1M08 | WAVE_FORMAT_1M16 | WAVE_FORMAT_1S08 | WAVE_FORMAT_1S16
    				| WAVE_FORMAT_2M08 | WAVE_FORMAT_2M16 | WAVE_FORMAT_2S16 | WAVE_FORMAT_2S08 
    				| WAVE_FORMAT_4M08 | WAVE_FORMAT_4M16 | WAVE_FORMAT_4S16 | WAVE_FORMAT_4S08;
    wc.wChannels = 2;
    wc.dwSupport = WAVECAPS_PITCH | WAVECAPS_VOLUME | WAVECAPS_LRVOLUME;
    LoadString(ghModule, IDS_DREAMWAVE+id, wc.szPname, MAXPNAMELEN); 
  
	MemCopy(lpCaps->pCaps, &wc, min((UINT) lpCaps -> cbSize, sizeof(wc)));
}

/****************************************************************************
 * @doc INTERNAL
 *
 * @api DWORD | waveGetPos | Get the stream position in samples.
 *
 * @parm DWORD | dwUser | The DWORD passed to the driver from the open call.
 *
 * @parm LPBYTE | lpInfo | Far pointer to an MMTIME structure.
 *
 * @parm WORD | wSize | Size of the MMTIME structure.
 *		BYTE bpersamp	0--->8 bits per samples
 *						1--->16 "     "		"	
 *
 * @rdesc The return value is zero if successful.
 ***************************************************************************/
DWORD NEAR PASCAL waveGetPos(NPWAVEALLOC pClient, LPMMTIME lpmmt, WORD wSize, BYTE bpersamp,BYTE Stereo)
{

    if (wSize < sizeof(MMTIME))
        return MMSYSERR_ERROR;

    if (lpmmt->wType == TIME_BYTES) {
        lpmmt->u.cb = pClient->dwByteCount;
    }

    /* default is samples - the sndblst card only supports 8 bit mono, */
    /* so the sample count is equal to the byte count */
    else {
        lpmmt->wType = TIME_SAMPLES;
        lpmmt->u.sample = pClient->dwByteCount;
        if (bpersamp)
        	   lpmmt->u.sample=(lpmmt->u.sample) >> 1;   
       	if (Stereo)
        	   lpmmt->u.sample=(lpmmt->u.sample) >> 1;
        	
        D2("POS: #DX#AX");
    }

    return 0L;
}

/****************************************************************************

    This function conforms to the standard Wave output driver message proc

****************************************************************************/
DWORD FAR PASCAL _loadds wodMessage(WORD id, UINT msg, DWORD dwUser, DWORD dwParam1, DWORD dwParam2)
{
const WAVEFORMATEX FAR *lpFmt;      /* pointer to passed format */
static	WORD nWave=0,n,nn;
WORD	noChannel;
DWORD	MemMapAdd;  
BOOL Found;
long	StartAdd,ll, zAddress;       
DWORD  dn ;
int DivSizeBuf;

    switch (msg)
   {
      case WODM_PREPARE:
      case WODM_UNPREPARE:
		  return 0L;
      case WODM_INIT:
      {
         D1( "WODM_INIT" ) ;

         
            // dwParam2 == PnP DevNode

            return (AddDevNode( dwParam2 )) ;
      }
      break ;

      case DRVM_ENABLE:
      {
		  UINT   uVxDId ;
         ULONG  cIds ;
         D1( "WODM_ENABLE" ) ;

         // dwParam2 == PnP DevNode

         cIds = 1 ;

         if (waveOutMessage( (HMIDIOUT) dwParam1, DRV_QUERYDRIVERIDS,
                             (DWORD) (LPWORD) &uVxDId, 
                             (DWORD) (LPDWORD) &cIds ))
            return MMSYSERR_INVALPARAM ;

         return (EnableDevNode( dwParam2, uVxDId )) ;

      }
      break ;

      case DRVM_DISABLE:
      {
         D1( "WODM_DISABLE" ) ;

         // dwParam2 == PnP DevNode

         return (DisableDevNode( dwParam2 )) ;

      }
      break ;

      case DRVM_EXIT:
      {
         D1( "WODM_EXIT" ) ;

         // dwParam2 == PnP DevNode

         return (RemoveDevNode( dwParam2 )) ;

      }
      break ;
	}
	
    if (!gfEnabled) {
        D1("wodMessage called while disabled");
        return ((msg == WODM_GETNUMDEVS) ? 0L : MMSYSERR_NOTENABLED);
    }
    if (FirstTime)
    	{
		memset(Zeros,0x80,0x800);
		D1("Check free size");
    	FirstTime=FALSE;
    	if ((!CheckFreeSize()) && (msg!=WODM_GETNUMDEVS))
    		{
    		D1("error in checking free size");
    		return MMSYSERR_ALLOCATED;
    		}
    	}
    
    if (id>7)
    	return MMSYSERR_BADDEVICEID;
    	
    switch (msg) {
        case WODM_GETNUMDEVS:
            D1("WODM_GETNUMDEVS");
			if (!WaveOutCaps)		// Is the Firmware able to play wave?
				return 0;

            if (SizeMem==0)
				return 0L;
            if ((SizeMem==1) || (WaveOut4))
				return 4L;
			else
            	return 8L; 			// we support 8 devices	

        case WODM_GETDEVCAPS:
            //D1("WODM_GETDEVCAPS");
            wodGetDevCaps((MDEVICECAPSEX FAR *)dwParam1,id);  
            return 0L;

        case WODM_OPEN:
            D1("WODM_OPEN");

			if (!WaveOutCaps)		// Is the Firmware able to play wave?
				return MMSYSERR_ALLOCATED;

			/* make sure we can handle the format */
            lpFmt = ((LPWAVEOPENDESC)dwParam1)->lpFormat;		// MODIF : may 98
            if ((lpFmt->wFormatTag != WAVE_FORMAT_PCM) ||              
                (lpFmt->nBlockAlign < 1))
            {
                return WAVERR_BADFORMAT;
            }  

            if (lpFmt->nSamplesPerSec > 0xffff) 
            	 return WAVERR_BADFORMAT;

	        if (((lpFmt)->wBitsPerSample != 8) && ((lpFmt)->wBitsPerSample != 16))
            	 return WAVERR_BADFORMAT;
			
		  /* did they just want format information? */
            if (dwParam2 & WAVE_FORMAT_QUERY)
                return 0L;


            for (n=0; n<8; n++) 
            	{
            	if (IdNb[n]==id) 
            		{                   
            		return MMSYSERR_ALLOCATED;
            		}  
            		
            	}
            nWave=0;
            while ((WaveState[nWave]!=FREE) && (nWave<8))
            	nWave++;
            if (nWave==8) 
            	{              
            	return MMSYSERR_ALLOCATED;     // is there some available waves?
                } 

            if ((nWave>=4) && (WaveOut4))
            	{              
            	return MMSYSERR_ALLOCATED;     // is there some available waves?
                } 


			//  MAY98 : Modif for DCapture
			if (DirectSoundVolumeCheck(0x100, gwPort)==0)	// Is Direct Sound running?
				return MMSYSERR_ALLOCATED;					// Y, exit


            /*  dwParam1 contains a pointer to a WAVEOPENDESC
             *  dwParam2 contains wave driver specific flags in the LOWORD
             *  and generic driver flags in the HIWORD
             */ 
            
			DivSizeBuf=1;		// init size buffer = 1*WaveBufferSize
            OpenFmt[nWave]=0;
            if (lpFmt->nChannels == 1)  
			{
				gbStereo[nWave]=0;
				DivSizeBuf*=2;		// buffer twice smaller
			}
            else 
            	{
            	gbStereo[nWave]=1;    
            	OpenFmt[nWave]=0x2;
       		  	}   
            	
            if ((lpFmt)->wBitsPerSample == 8) 
            	{
            	gbSize[nWave]=0;
            	OpenFmt[nWave]+=1;
				DivSizeBuf*=2;		// buffer twice smaller
            	}
            else if ((lpFmt)->wBitsPerSample == 16) 
				gbSize[nWave]=1; 
            else return WAVERR_BADFORMAT;   
            

            if (lpFmt->nSamplesPerSec<=22050)
				DivSizeBuf*=2;		// buffer twice smaller
			if (lpFmt->nSamplesPerSec<=11025)
				DivSizeBuf*=2;		// buffer twice smaller
            // Let's free the port if needed
            /*if (FreeMpuPort())
            	return MMSYSERR_ALLOCATED;*/  
            
          	//IntUsed++;	
            dn = ((LPWAVEOPENDESC) dwParam1) -> dnDevNode ;

	         if (NULL == 
	               (phwi = DevNodeToHardwareInstance( dn )))
	         {
	            D1("devnode not associated with hardware instance???" ) ;
	            //IntUsed--;
				return MMSYSERR_BADDEVICEID ;
	         }    
			 
            
            /* attempt to 'acquire' the Wave output hardware */  
            // first, let's allocate buffer in card memory
			SizeBuffer[nWave]=((WORD) (WaveBufferSize/DivSizeBuf)) & 0xfffe;	//always even
           if (SizeBuffer[nWave] < 0x400)
			   SizeBuffer[nWave]=0x400;
	/* if (!memAlloc(SizeBuffer[nWave]  + 16,0x0020+(nWave<<8)))
				{              
				D1("no mem");  
				//ReleaseMPU401( phwi ) ;
				//IntUsed--;	
				return MMSYSERR_NOMEM;
				}*/

			if (!AcquireMPU401( phwi ))
			{
				//IntUsed--;
				 return MMSYSERR_ALLOCATED ;
			}
            
			 /* attempt to 'acquire' the Wave output hardware */  
            // first, let's allocate buffer in card memory
            if ((MemMapAdd=GetMemMapAddress())==0xffffffff)				//API Dream called to Get Memory Mapping Table address
				{        
				ReleaseMPU401( phwi ) ;
				//IntUsed--;	 
				return MMSYSERR_NOTENABLED;
				}
			if (UpLoad(MemoryBlock,(WORD) (MemMapAdd>>16),(WORD) (MemMapAdd & 0xffff),NbMemBlocks*3))	//API Dream called to Get Memory block definition
				{    
				ReleaseMPU401( phwi ) ;
				//IntUsed--;	
				return MMSYSERR_NOTENABLED;        
				}
			n=0;  // index on first block 
			Found=FALSE;
			do
				{ 
				n++;  
				D2("    n++");
				while ((n<NbMemBlocks) && ((MemoryBlock[n].Type!=1) ||           // not free
					(MemoryBlock[n+1].Address-MemoryBlock[n].Address < SizeBuffer[nWave]+16)))  //too small
					n++; 
				StartAdd=MemoryBlock[n].Address;
				if (StartAdd & 1)			// odd address   
					StartAdd++;     
				if (((StartAdd+SizeBuffer[nWave]+16)>>16)==(StartAdd>>16))  // not cross page 
		        	{
		        	Found=TRUE;                     
		        	}
		        else
		        	{
		        	StartAdd=(StartAdd & 0xffff0000)+0x10000; // beginning of the next page
		        	if (StartAdd+SizeBuffer[nWave]+16 <= MemoryBlock[n+1].Address)
		        		Found=TRUE;
		        	}
		        }              
		    while ((n<NbMemBlocks) && (!Found));
			if (n==NbMemBlocks) 
				{              
				D1("no mem");  
				ReleaseMPU401( phwi ) ;
				//IntUsed--;	
				return MMSYSERR_NOMEM;
				}
			D1("block ok");
			// block n attribute for wave 
			if (StartAdd!=MemoryBlock[n].Address)  
				{		// remaining free block at the beginning
				for (nn=NbMemBlocks-1; nn>n; nn--)
					MemoryBlock[nn]=MemoryBlock[nn-1];
				MemoryBlock[n+1].Address=StartAdd;
				n++;
				}
			if (MemoryBlock[n+1].Address-MemoryBlock[n].Address == SizeBuffer[nWave]+16) 
				MemoryBlock[n].Type=0x0020+(nWave<<8);	// no free block remaining; the block gets in wave state
			else
				{		// free block remaining
				if (MemoryBlock[NbMemBlocks-1].Type==0xffff) 
					{
					D1("no mem2"); 
					ReleaseMPU401( phwi ) ;  
					//IntUsed--;	
					return MMSYSERR_NOMEM; //no more block in memory mapping table
					}
				else
					{
					for (nn=NbMemBlocks-1; nn>n; nn--)
						MemoryBlock[nn]=MemoryBlock[nn-1];
					MemoryBlock[n].Type=0x0020+(nWave<<8);  // wave block
					MemoryBlock[n].Address=MemoryBlock[n+1].Address; 
					MemoryBlock[n+1].Address+=SizeBuffer[nWave]+16;
					}	                                     
				} 
			D1("mmt change");
			// now, let's return the memory mapping table
			if (DownLoad(MemoryBlock,(WORD) (MemMapAdd>>16),(WORD) (MemMapAdd & 0xffff),NbMemBlocks*3,0))	//API Dream called to Get Memory block definition
				{              
				//IntUsed--;	 
				ReleaseMPU401( phwi ) ;
				return MMSYSERR_NOTENABLED;  
				}   


			// Initialize the buffer
			zAddress=StartAdd;
			for (n=0; n< (int) SizeBuffer[nWave]/0x400; n++)
			{
				DownLoad(Zeros,(WORD) (zAddress>>16),(WORD) (zAddress & 0xffff),0x400,0);	
				zAddress+=0x400;
			}
			DownLoad(Zeros,(WORD) (zAddress>>16),(WORD) (zAddress & 0xffff),SizeBuffer[nWave]-n*0x400,0);

			
			gdwPitch[id]=0x00010000; 
			PitchValue[nWave]=((WORD) lpFmt->nSamplesPerSec);
            if ( wAcquireHardware(nWave,(WORD) lpFmt->nSamplesPerSec) ) {
                D1("Wave output hardware is not available!");
                //IntUsed--;	  
                ReleaseMPU401( phwi ) ;
                return MMSYSERR_ALLOCATED;
            }
         
         IdNb[nWave]=id;         // device allocated

            D1("HardWare available");   
            /* and fill it with info */
            pOutClient[nWave].dwCallback  = ((LPWAVEOPENDESC)dwParam1)->dwCallback;
            pOutClient[nWave].dwInstance  = ((LPWAVEOPENDESC)dwParam1)->dwInstance;
           	pOutClient[nWave].hWave       = ((LPWAVEOPENDESC)dwParam1)->hWave;
            pOutClient[nWave].dwFlags     = dwParam2;
            pOutClient[nWave].dwByteCount = 0L;
            pOutClient[nWave].pcmwf       = *((LPPCMWAVEFORMAT)lpFmt) ;

            /* give the client my driver dw */
            *((LPDWORD)dwUser) = MAKELONG(nWave, nWave);
            D1("client filled");                         
            
            /* sent client his OPEN callback message */
            waveCallback(&(pOutClient[nWave]), WOM_OPEN, 0L);   
            gdwPitch[nWave]=0x00010000;		// Pitch is init to 1
            WaveState[nWave]=ENDIT;		// No interrupt are expected
            NextXFCount[nWave]=SizeBuffer[nWave]/2;    // init the first xfer at half buffer   
            SetVolume(nWave,(WORD) (gdwVol[id] & 0xffff),(WORD) ((gdwVol[id]>> 16) & 0xffff));
            SetAuxVolume(nWave,wVolAuxL[id],wVolAuxR[id]); 
            waveSetFilter(id,W_FILT_FC,wFiltFc[id]); // default : no filter   
            waveSetFilter(id,W_FILT_Q,wFiltQ[id]);   //		"		" 
            BRFlag[nWave]=0;			// init : no remain byte
            D1("End open");
            return 0L;
        }	//	end switch    
        noChannel=HIWORD(dwUser);		//Client id 
             
  	switch (msg) {    
        case WODM_CLOSE:
	        D1("WODM_CLOSE");   
	        if (lpWOQueue[noChannel])
                return WAVERR_STILLPLAYING;                
            if (WaveState[noChannel]==FREE) 
            	{
            	D1("Wave output hardware already free!");
            	waveCallback(&(pOutClient[noChannel]), WOM_CLOSE, 0L); 
            	return 0;
            	}  
            // mask it 
            __asm cli   
            if ((WaveState[noChannel]==WSTART) || 
				(WaveState[noChannel]==ASK_PAUSE)  ||
				(WaveState[noChannel]==RESET))
	            {                  
	            WaveState[noChannel]=ASK_CLOSE; 
	            ll=0;  
	             // free it
	        	__asm  sti
	            // wait until the pause is made	
	            while ((WaveState[noChannel]!=CLOSE_RQ) && (ll<65536*20))  //global tempo=2s
	            	{
	            	_inp(gwPort+1);			//just for tempo
	            	ll++; 
	            	}
	            if (WaveState[noChannel]!=CLOSE_RQ)
	            	{       // we haven't yet receive it  
	            			// the pitch must be very low... let's increase it
	            	 // silence
			       	SetVolume(noChannel,0,0);
			       	SetAuxVolume(noChannel,0,0); 
			       	// tempo 5ms
			       	ll=0; 
			       	while (ll++<3300)
			       		_inp(gwPort+1);			//just for tempo  1.5us
			       	//set up the pitch to minimize the waiting time       
			       	SendCommand(W_PITCH,0,0);
		       		SendParam((BYTE) noChannel,0,0);
		       		SendParam(0xf0,0,0);
		       		SendParam(0xff,1,0);          
			       	ll=0;
			       	while ((WaveState[noChannel]!=CLOSE_RQ) && (ll<65536*5))  //global tempo=0.5s
		            	{
		            	_inp(gwPort+1);			//just for tempo
		            	ll++; 
		            	}  
		            if (WaveState[noChannel]!=CLOSE_RQ)    
		            	return WAVERR_STILLPLAYING;   
		            }
	            }        
	        else	
	       		{
	       		 __asm  sti   	// free it   
	       		 }   
	       	
            WaveState[noChannel]=CLOSE_RQ;  
            wClose(noChannel);                
            ll=0;
            do  
            	{
            	ll++; 
            	_inp(gwPort+1);			//just for tempo
            	if (CloseChannel[noChannel]==TRUE)          // is there a channel to close	
					{  
					CloseChannel[noChannel]=FALSE; 
				    WaveClose(noChannel);         
				    break;
				    }
				 }   
			while (ll<65536*20);
            
            if (ll==65536*20)
            	{
            	D1("TimeOut");    
            	 // silence
		       	SetVolume(noChannel,0,0);
		       	SetAuxVolume(noChannel,0,0); 
		       	// tempo 5ms
		       	ll=0; 
		       	while (ll++<3300)
		       		_inp(gwPort+1);			//just for tempo  1.5us
		       	//set up the pitch to minimize the waiting time       
		       	SendCommand(W_PITCH,0,0);
	       		SendParam((BYTE) noChannel,0,0);
	       		SendParam(0xf0,0,0);
	       		SendParam(0xff,1,0); 
	       		ll=0;
	            do  
	            	{
	            	ll++; 
	            	_inp(gwPort+1);			//just for tempo
	            	if (CloseChannel[noChannel]==TRUE)          // is there a channel to close	
						{  
						CloseChannel[noChannel]=FALSE; 
					    WaveClose(noChannel);         
					    break;
					    }
					 }   
				while (ll<65536*5);
				if (ll==65536*5)
					D1("fatal time out!!!");
				}    

			
			IdNb[noChannel]=0xff;		//free the device id 
			/* call client's callback */
            waveCallback(&(pOutClient[noChannel]), WOM_CLOSE, 0L);  
               
	        ReleaseMPU401( phwi ) ;  
            //IntUsed--;  
            return 0L;

        case WODM_WRITE:
            D1("WODM_WRITE");
            AssertF(dwParam1 != NULL); 
           // AssertF(!(((LPWAVEHDR)dwParam1)->dwFlags & ~(WHDR_INQUEUE|WHDR_DONE|WHDR_PREPARED|WHDR_BEGINLOOP|WHDR_ENDLOOP)));

            ((LPWAVEHDR)dwParam1)->dwFlags &= (WHDR_INQUEUE|WHDR_DONE|WHDR_PREPARED|WHDR_BEGINLOOP|WHDR_ENDLOOP);

            AssertF(((LPWAVEHDR)dwParam1)->dwFlags & WHDR_PREPARED);

            /* check if it's been prepared */
            if (!(((LPWAVEHDR)dwParam1)->dwFlags & WHDR_PREPARED))
                return WAVERR_UNPREPARED;

            AssertF(!(((LPWAVEHDR)dwParam1)->dwFlags & WHDR_INQUEUE));

            /* if it is already in our Q, then we cannot do this */
            if ( ((LPWAVEHDR)dwParam1)->dwFlags & WHDR_INQUEUE )
                return ( WAVERR_STILLPLAYING );

            /* store the pointer to my WAVEALLOC structure in the wavehdr */
            ((LPWAVEHDR)dwParam1)->reserved = (DWORD)(LPSTR)(&pOutClient[noChannel]);

            /* add the buffer to our queue */
            ((LPWAVEHDR)dwParam1)->dwFlags |= WHDR_INQUEUE;
            ((LPWAVEHDR)dwParam1)->dwFlags &= ~WHDR_DONE;

            wodWrite((LPWAVEHDR)dwParam1,noChannel); // put wave datas in FIFO
            
			if (WaveState[noChannel]==RESET) 
			{
				NextXFCount[noChannel]=MemXFCount[noChannel];
				WaveState[noChannel]=WSTART;
			}
			if (WaveState[noChannel]==ENDIT) 
            	{ 
            	D1("*******  Start made *******");  
            	wStart(noChannel);                                              
            	WaveState[noChannel]=WSTART;
            	}
            return 0L;

        case WODM_PAUSE:
            D1("WODM_PAUSE");  
			if (WaveState[noChannel]==RESET)
				WaveState[noChannel]=ASK_PAUSE;
            if (WaveState[noChannel]==WSTART)
	            { 
	            D1("pause");
	            MemXFCount[noChannel]=NextXFCount[noChannel];   // memorize count for xfer after resume
	            NextXFCount[noChannel]=0;    //next xfer : 0 data will be sent  
            	WaveState[noChannel]=ASK_PAUSE;
            	}  
            if (WaveState[noChannel]==ENDIT)		// just open 
            	{
            	MemXFCount[noChannel]=NextXFCount[noChannel];
            	WaveState[noChannel]=PAUSE;
            	}
            return 0L;

        case WODM_RESTART:
            D1("WODM_RESTART"); 
            if (WaveState[noChannel]==PAUSE)
            	{  
            	D1("restart");
            	NextXFCount[noChannel]=MemXFCount[noChannel];   // restore number of datas to send
            	wStart(noChannel); 
            	WaveState[noChannel]=WSTART;
            	} 
            if (WaveState[noChannel]==ASK_PAUSE)      
            	{
            	NextXFCount[noChannel]=MemXFCount[noChannel];   // restore number of datas to send
            	WaveState[noChannel]=WSTART;
            	}
            return 0L;

        case WODM_RESET:
            D1("WODM_RESET");

            if (WaveState[noChannel]==WSTART) 
            	{
	            MemXFCount[noChannel]=NextXFCount[noChannel];   // memorize count for xfer after resume
	            NextXFCount[noChannel]=0;    //next xfer : 0 data will be sent  
            	WaveState[noChannel]=RESET;
           		}

			 if (WaveState[noChannel]==ASK_PAUSE) 
				 WaveState[noChannel]=RESET;
			 
           	//if (WaveState[noChannel]!=ENDIT)
				wodFreeQ(noChannel);          // free all buffers 
			
				
				// MODIF : may 98
			/*if (WaveState[noChannel]==PAUSE)	
				 WaveState[noChannel]=ENDIT;*/

        	bBreakLoop[noChannel] = 0;

        		// reset byte count 
       		pOutClient[noChannel].dwByteCount = 0L;
            return 0L;

        case WODM_BREAKLOOP:
            D1("WODM_BREAKLOOP");
            if (lpWOQueue[noChannel])
                bBreakLoop[noChannel] = 1;
            return 0L;

        case WODM_GETPOS:
           // D1("WODM_GETPOS");
            return waveGetPos(&(pOutClient[noChannel]), (LPMMTIME)dwParam1, (WORD)dwParam2, gbSize[noChannel],gbStereo[noChannel]);

       	case WODM_GETPLAYBACKRATE:
       	case WODM_GETPITCH:
       		D1("get pitch");
       		*((LPDWORD) dwParam1)=gdwPitch[id]; 
       		return 0L; 
       	case WODM_GETVOLUME:
       	    D1("get volume");  
       		*((LPDWORD) dwParam1)=gdwVol[id]; 
       		return 0L; 
       	case WODM_SETPLAYBACKRATE:
       	case WODM_SETPITCH: 
       		D1("WODM_SETPITCH");
			{
			DWORD NewPitch;

       		gdwPitch[id]=dwParam1;
       		NewPitch=PitchValue[noChannel]*((WORD) (gdwPitch[id]>>16)) +
       			PitchValue[noChannel]*( (WORD) (gdwPitch[id] & 0xffff))/10;
       		SendCommand(W_PITCH,0,0); 
       		SendParam((BYTE) noChannel,0,0);
       		SendParam((BYTE) NewPitch,0,0);
       		SendParam((BYTE) NewPitch>>8),1,0);
       		return 0L;
       		
       	case WODM_SETVOLUME: 
       		D1("WODM_SETVOLUME");
       		 gdwVol[id]=dwParam1; 
       		 // Is the device openned ?
       		 nWave=0;
       		 while ((nWave<8) && (IdNb[nWave]!=id))
				nWave++;
			if (nWave<8) 
			{
				WORD VLeft, VRight;
				VLeft=(WORD) (gdwVol[id] & 0xffff);
				VRight=(WORD) ((gdwVol[id]>> 16) & 0xffff);
				SetVolume(nWave,VLeft, VRight);
       			if (id==0)
					DirectSoundVolumeCheck(VLeft/2+VRight/2, gwPort);
			}
			return 0;
       		 
            default:
            return MMSYSERR_NOTSUPPORTED;
    }

    /* should never get here... */
    AssertF(0);
    return MMSYSERR_NOTSUPPORTED;
}
 

/****************************************************************************
 * @doc INTERNAL
 *
 * @api void FAR PASCAL WaveClose(BYTE noChannel) 
 *
 * The close is now effective. This function is called when the close acknowledge
 *	is received. It clears the memory and return the callback WOM_CLOSE message
 *
 * @rdesc There is no return value.
 ***************************************************************************/
void FAR PASCAL WaveClose(WORD noChannel) 
{    
WORD WaveBlockType;
DWORD MemMapAdd;   
int n,nn;        
                       
D1("waveclose");
// verify if we are waiting for a close
if ((noChannel>7) || (WaveState[noChannel]!=CLOSE_RQ))
	return;
	            
D1("begin close wave");	     		
/* now 'release' the Wave output hardware */
WaveState[noChannel]=FREE;		// free the wave channel
	             
// free the card memory
if ((MemMapAdd=GetMemMapAddress())==0xffffffff)				//API Dream called to Get Memory Mapping Table address
	{
	D1("MMADD error .................");
	return ;
	}
if (UpLoad(MemoryBlock,(WORD) (MemMapAdd>>16),(WORD) (MemMapAdd & 0xffff),NbMemBlocks*3))	//API Dream called to Get Memory block definition
	return ; 
WaveBlockType=0x20+(noChannel<<8);  
D1("Search");
n=1;  // index on first block
while ((n<NbMemBlocks) && (MemoryBlock[n].Type!=WaveBlockType))  
	n++; 
if (n==NbMemBlocks) 
	{
	D1("not find"); 
	return ;    
	}		// block record not find 
D1("find");
// block n attribute for wave
if (MemoryBlock[n+1].Type == 1) // next block is free 
	{
	MemoryBlock[n+1].Address=MemoryBlock[n].Address;	// set its new address
    for (nn=n; nn<NbMemBlocks-1; nn++)             // remove old wave block
		MemoryBlock[nn]=MemoryBlock[nn+1];
	}
else  
	MemoryBlock[n].Type =1;            // next block not free. Just free the wave block
if (MemoryBlock[n-1].Type==1)
	{				// previous block is free. enlarge it and remove block n
	for (nn=n; nn<NbMemBlocks-1; nn++)             // remove old wave block
		MemoryBlock[nn]=MemoryBlock[nn+1];
	}
// now, let's return the memory mapping table
if (DownLoad(MemoryBlock,(WORD) (MemMapAdd>>16),(WORD) (MemMapAdd & 0xffff),NbMemBlocks*3,0))	//API Dream called to Get Memory block definition
	return ;  
                                                         
}


/****************************************************************************

    API dream - memWrite(LPVOID lpSrc,DWORD dwDestAddress,WORD wCount)  
    Transfert a memory bloc from Pc memory to dream card
    lpSrc	:	Pointer to memory bloc to transfer
    dwDestAddress 	: address (page|offset) of destination   
    wCount	 	: nb of word to copy
   
    Return : 0 if successfull
    		 error code if failed (see documentation)
****************************************************************************/ 
WORD FAR PASCAL _loadds memWrite(LPVOID lpSrc,DWORD dwDestAddress,WORD wCount)
{    
if (dwDestAddress+wCount>(DWORD)MemSize)   
	return DREAMERR_OUTOFMEM;
return (DownLoad(lpSrc,(WORD) (dwDestAddress >> 16),(WORD) dwDestAddress,wCount,0));
}


WORD FAR PASCAL _loadds DownLoad(LPVOID lpSrc,WORD wDestPage,WORD wDestOffset,WORD wCount,WORD File) 
{            

D1("DownLoad API");   

if (wCount==0) 
	return 0;
if (wCount>=0x8000)  						// wCount>32Kwords  error
	{
	D1("wCount too large");
	return DREAMERR_INVCOUNT;             
	}

if (!AcquireMPU401( phwi ))
	return MMSYSERR_ALLOCATED ;   
if ((wDestOffset!=0) && (wDestOffset+(wCount-1) < wCount))      // last address in the next page
	{								// Page change  
	D1("Cross page in card memory"); 
	if(!MemCopySrc(wDestPage,wDestOffset,lpSrc,(WORD) (0x10000-wDestOffset),File))
		{
		ReleaseMPU401( phwi ) ;		
		return DREAMERR_ABORT;
		}
	(LPBYTE) lpSrc+=(0x10000-wDestOffset)*2;		//new pointer on source
	
	if (!(MemCopySrc(wDestPage+1,0,lpSrc,wCount+wDestOffset,File)))
		{
		ReleaseMPU401( phwi ) ;		
		return DREAMERR_ABORT;   
		}
	}
else
	{								// no page change
	if (!(MemCopySrc(wDestPage,wDestOffset,lpSrc,wCount,File)))
		{
		ReleaseMPU401( phwi ) ;		
		return DREAMERR_ABORT;      
		}                                     
	} 
ReleaseMPU401( phwi ) ;		//release interrupt
return 0;
}  

/****************************************************************************

    API dream - memRead(LPVOID lpDst,DWORD dwSrcAddress,WORD wCount)  
    Transfert a memory bloc from dream card memory to PC.
    lpDst	:	Pointer to memory bloc to receive bytes.
    dwSrcAddress	: Address (Page|offset) of source
    wCount	 	: nb of word to copy
    
    Return : 0 if successfull
    		 error code if failed (see documentation)
****************************************************************************/
WORD FAR PASCAL _loadds memRead(LPVOID lpDst,DWORD dwSrcAddress,WORD wCount) 
{    
if (dwSrcAddress+wCount>(DWORD)MemSize)   
	return DREAMERR_OUTOFMEM;
return (UpLoad(lpDst,(WORD) (dwSrcAddress>>16),(WORD) dwSrcAddress,wCount));
}

WORD FAR PASCAL _loadds UpLoad(LPVOID lpDst,WORD wSrcPage,WORD wSrcOffset,WORD wCount) 
{

D1("UpLoad API");

if (wCount==0) 
	return 0;
	
if (wCount>=0x8000)  						// wCount>32Kwords  error
	{
	D1("wCount too large");
	return DREAMERR_INVCOUNT;             
	}
if ((wSrcOffset!=0) && (wSrcOffset+(wCount-1) < wCount))
	{								// Page change  
	D1("Cross page in card memory");
	return DREAMERR_INVADD;
	}
else
	{	
	// no page change 
	if (!AcquireMPU401( phwi ))
		return MMSYSERR_ALLOCATED ; 

	if (!(MemCopyDst(wSrcPage,wSrcOffset,lpDst,wCount)))
		{
		ReleaseMPU401( phwi ) ;	
		return DREAMERR_ABORT;
		}

	ReleaseMPU401( phwi ) ;	
	} 
D1("return upload");
return 0;
}


/****************************************************************************

    API dream - memGetMapAddress 
    Return 32 bit Address of the Memory Mapping Table
    (FFFFFFFF if failed)

****************************************************************************/ 
DWORD FAR PASCAL _loadds memGetMapAddress(void)
{
return (GetMemMapAddress());
}

DWORD FAR PASCAL _loadds GetMemMapAddress(void)
{
DWORD add=0;
BYTE err=0;
WORD n;
long ll;

D1("GetMem Add API");
    

gwModAnsNb=4;        // 4 bytes expected    
//IntUsed++;	// we use it 
D2("go to acq"); 

if (!AcquireMPU401( phwi ))
{
	//IntUsed--;
	return 0xffffffff ;    
}

D1("Get MMT");
GetMMTAdd();  
// Now, wait for interrupt to get answer


ll=0;
while ((gwModAnsNb!=0) && (ll<65535*20))
	{
	_inp(gwPort+1);	//tempo
	ll++;
	}
if (gwModAnsNb!=0)
	err=1;
//IntUsed--;		
ReleaseMPU401( phwi ) ;
// Data ready
if (err)
{
	D1("get mmt fail");
	return 0xffffffff;
}
for (n=0;n<4; n++)
	add+=(DWORD) gbModAnsLong[n] << (8*n);
return add;
}
 
/****************************************************************************
*
*    API dream - mpuMessage(WORD wCommand,LPBYTE lpParam, WORD wCount)
*    Send MPU command via the driver
*    
*		wCommand - mpu command to send
*       lpParam	 - pointer to parameters table
*		wCount	 - parameter count
*    		
*    Return : 0 if successfull
*    		 1 if fail
*			MMSYSERR_ALLOCATED if mpu port already allocated
****************************************************************************/
WORD FAR PASCAL _loadds mpuMessage(WORD wCommand,LPBYTE lpParam, WORD wCount)
{  
WORD n;
  
D1("mpuCommand API"); 
SendCommand(CMD_MODE,1,COM_OFFSET);
if (wCount==0) 
	{
	SendCommand((BYTE) (wCommand & 0xff),1,COM_OFFSET);
	return 0;
	}      
SendCommand((BYTE) (wCommand & 0xff),0,COM_OFFSET);
for (n=0; n<wCount-1; n++)
	{ 
	SendParam(*(lpParam++),0,COM_OFFSET);
	} 
SendParam(*(lpParam),1,COM_OFFSET);
return 0;
}    

/****************************************************************************
*
*    API dream - mpuMessageAc(WORD wCommand,LPBYTE lpParam, WORD wCount)
*    Send MPU command via the driver, AND wait for acknowledge Ack to be returned
*    
*		wCommand - mpu command to send
*       lpParam	 - pointer to parameters table
*		wCount	 - parameter count
*    		
*    Return : 0 if successfull
*    		 1 if fail
*				MMSYSERR_ALLOCATED if mpu port already allocated
****************************************************************************/
WORD FAR PASCAL _loadds mpuMessageAc(WORD wCommand,LPBYTE lpParam, WORD wCount,BYTE Ack)
{  
WORD n;
  
D1("mpuCommand API");  
//IntUsed++;
           
if (!AcquireMPU401( phwi ))
	return MMSYSERR_ALLOCATED ; 
__asm cli			// mask it   
if (wCount==0) 
	{
	SendCommand((BYTE) (wCommand & 0xff),0,0);
	}
else
	{           
	SendCommand((BYTE) (wCommand & 0xff),0,0);
	for (n=0; n<wCount-1; n++)
		{ 
		SendParam(*(lpParam++),0,0);
		} 
	SendParam(*(lpParam),0,0);
	}
// Wait for acknowledge
if (!WaitAcknowledge(Ack))  
	{
	_asm sti        
	//IntUsed--;	 
	ReleaseMPU401( phwi ) ;
	 return 0;            // Ok, acknowledge arrived 
	 }
else  
	{
	_asm sti  
	//IntUsed--;	
	ReleaseMPU401( phwi ) ;
	return 1;
	}
} 


/****************************************************************************
*
*    API dream -  equalizerSetBand(WORD wBand, WORD wChannel,WORD wVolume)
*    Set new state of equalizer 
*    wVolume - 0 (Band cut) 127 (Max)
*    wBand	0->Low
*    		1->Medium low
*    		2->Medium high
*    		3->High
*    wChannel 0->Left & Right
*    		1->Left
*    		2->Right
*    		
*    Return : 0 if successfull   
****************************************************************************/ 
WORD FAR PASCAL _loadds equalizerSetBand(WORD wBand, WORD wChannel,WORD wVolume)
{
return (Equalizer(wVolume,wBand, wChannel));
}    

WORD FAR PASCAL _loadds Equalizer(WORD Value,WORD Band, WORD Channel)
{
BOOL Left=FALSE,Right=FALSE;

D1("Equalizer API");
if (Channel==0) Left=Right=TRUE;
if (Channel==1) Left=TRUE;
if (Channel==2) Right=TRUE; 
  
if (Left)  
	{
	SendCommand(CMD_MODE,1,COM_OFFSET); 
	SendCommand((BYTE) (EQ_LBL+Band),0,COM_OFFSET);
	SendParam((BYTE) Value,1,COM_OFFSET);          
	}
if (Right)
	{
	SendCommand(CMD_MODE,1,COM_OFFSET); 
	SendCommand((BYTE) (EQ_LBL+Band+4),0,COM_OFFSET);
	SendParam((BYTE) Value,1,COM_OFFSET);          
	}     
return 0;
}

/****************************************************************************
*
*    API dream - waveSetAuxVolume(WORD Id,WORD AuxLeft,WORD AuxRight)
*    Set aux volume
*    Value - 0 (Band) 65535 (Max)
*    
*    Return : 	0 if ok
*				1 if bad Id
*				MMSYSERR_ALLOCATED if mpu port already allocated
*
****************************************************************************/
WORD FAR PASCAL _loadds waveSetAuxVolume(WORD Id,WORD AuxLeft,WORD AuxRight)
{              
WORD Channel;   
wVolAuxL[Id]=AuxLeft;
wVolAuxR[Id]=AuxRight;  

Channel=0;       
while ((Channel<8) && (IdNb[Channel]!=Id)) 
	Channel++;
	
if (Channel==8)
	return 1;    

if (!AcquireMPU401( phwi ))
	return MMSYSERR_ALLOCATED ;    
SetAuxVolume(Channel,AuxLeft,AuxRight);  
ReleaseMPU401( phwi ) ;     
return 0;
}     

/****************************************************************************
*
*    API dream -  waveSetMainVolume(WORD Id,WORD AuxLeft,WORD AuxRight)
*    Set aux volume
*    Value - 0 (Band) 65535 (Max)
*    
*    Return : 	0 if ok
*				1 if bad Id
*				MMSYSERR_ALLOCATED if mpu port already allocated
*
****************************************************************************/
WORD FAR PASCAL _loadds waveSetMainVolume(WORD Id,WORD AuxLeft,WORD AuxRight)
{            
WORD Channel;
gdwVol[Id]=(DWORD) AuxLeft + (((DWORD) AuxRight)<<16) ;

Channel=0;
while ((Channel<8) && (IdNb[Channel]!=Id))
	Channel++;
if (Channel==8)   
	return 1;

if (!AcquireMPU401( phwi ))
	return MMSYSERR_ALLOCATED ;    
SetVolume(Channel,(WORD) (gdwVol[Id] & 0xffff),(WORD) ((gdwVol[Id]>> 16) & 0xffff)); 
ReleaseMPU401( phwi ) ;

return 0;
} 


/****************************************************************************
*
*    API dream -  waveSetPitch(WORD Id,WORD AbsolutePitch)
*    Set the sample rate for a device id ( no effect on the waveOutGetPitch
*		Windows API)
*    Value - 0 (Band) 65535 (Max)
*    
*    Return : 	0 if ok
*				1 if bad Id
*				MMSYSERR_ALLOCATED if mpu port already allocated
*
****************************************************************************/
WORD FAR PASCAL _loadds waveSetPitch(WORD Id,WORD AbsolutePitch)
{            
WORD Channel;

Channel=0;
while ((Channel<8) && (IdNb[Channel]!=Id))
	Channel++;
if (Channel==8)  
	return 1;  
PitchValue[Channel]=AbsolutePitch;
SendCommand(W_PITCH,0,COM_OFFSET); 
SendParam((BYTE) Channel,0,COM_OFFSET);
SendParam((BYTE) PitchValue[Channel],0,COM_OFFSET);
SendParam((BYTE) (PitchValue[Channel]>>8),1,COM_OFFSET);
return 0;
}                   

/****************************************************************************
*
*    API dream - WORD FAR PASCAL _loadds waveSetBufferSize(WORD wSize,BOOL ForPlay)
*    Set the size of the wave buffers for every next opennings
*    Size : in word
*    ForPlay : 	TRUE ->change the play buffer size
*				FALSE -> change the record buffer size
*    Return : 0 
*  
****************************************************************************/
WORD FAR PASCAL _loadds waveSetBufferSize(WORD wSize,BOOL ForPlay)
{    
if (ForPlay)
	WaveBufferSize=(DWORD)wSize;
else
	WaveBufferSizeIn=(DWORD)wSize;
return 0;
}

/****************************************************************************
*
*    API dream - waveSetFilter(WORD Id,WORD Type,WORD Value)
*    Set filter parameters
*    Type	: 	Fc=0x4a  
*				Q=0x4b
*	 Value	: 0xffff : cut				
*    Return : 0 
*             1 if bad type  
*			  2 if bad id
****************************************************************************/  
WORD FAR PASCAL _loadds waveSetFilter(WORD Id,WORD Type,WORD Value)
{              
WORD Channel;
	
if ((Type!=WAVE_FC) && (Type!=WAVE_Q))
	return 1;                         // bad type  
	
if (Type==WAVE_FC)
	 wFiltFc[Id]=Value;
else
	 wFiltQ[Id]=Value;
	 	 
Channel=0;
while ((Channel<8) && (IdNb[Channel]!=Id))
	Channel++;
if (Channel==8)  
	return 1;   

if (!AcquireMPU401( phwi ))
	return MMSYSERR_ALLOCATED ;    
SendCommand((BYTE) (Type & 0xff),0,COM_OFFSET);  
SendParam((BYTE) Channel,0,COM_OFFSET);  
SendParam((BYTE) Value,0,COM_OFFSET);  
SendParam((BYTE) (Value>>8),1,COM_OFFSET); 
ReleaseMPU401( phwi ) ;    
return 0; 
}

/****************************************************************************
*
*    API dream - surroundSetVolume(WORD Value) 
*    Set 3D effect
*    Value - 0 (Band cut) 255 (Max)
*    
*    Return : 0 if successfull  
****************************************************************************/ 
WORD FAR PASCAL _loadds surroundSetVolume(WORD Value)
{
return (WideEffect(Value));
}

WORD FAR PASCAL _loadds WideEffect(WORD Value)
{    
D1("mpuCommand API");
SendCommand(CMD_MODE,1,COM_OFFSET);     
SendCommand(SUR_VOL,0,COM_OFFSET);
SendParam((BYTE) Value,1,COM_OFFSET);  
return 0;
} 


/****************************************************************************

    API dream - memSetMapAddress 
    Called to inform card that client have modify the Memory Mapping Table
    address.
    
    return 	0 if succeed  

****************************************************************************/ 
WORD FAR PASCAL _loadds memSetMapAddress(DWORD address)
{
return (SetMemMapAddress(address));
}    

WORD FAR PASCAL _loadds SetMemMapAddress(DWORD address)
{
D1("SetMem Add API"); 

if (!AcquireMPU401( phwi ))
	return MMSYSERR_ALLOCATED ;    
SetMMTAdd(address);  
ReleaseMPU401( phwi ) ;
return 0;
}  

/****************************************************************************

    API dream - modOpen()
    	 
    acquire mpu port for mod
    	
    return 	0 if succeed  , MMSYSERR_ALLOCATED if fail                     
****************************************************************************/  
WORD FAR PASCAL _loadds modOpen()
{
D1("ModOpen API"); 

if (!AcquireMPU401( phwi ))
	return MMSYSERR_ALLOCATED ; 
return 0;
}

  
/****************************************************************************

    API dream - modClose()
    	 
    release mpu port after mod
    	                    
****************************************************************************/  
void FAR PASCAL _loadds modClose()
{
D1("ModOpen API"); 

ReleaseMPU401( phwi ) ;	
}


/****************************************************************************

    API dream - modOpenVoice(WORD Voice, BYTE Vol, WORD VMain, WORD VAux,
		WORD Pitch, WORD Filt)
    	 
    Open a channel for playing a voice (MOD PLAYER) and init volume, pan pitch
    		effect, filter.
    		
    
    Vol - 	0-ff
    VMain - 	LSB-->Right (0-ff)
    						MSB-->Left (0-ff)
    Pitch - 400h=nominal frequency and linearly scalled (200h = 1/2 nom. freq.)
    VAux	-  Aux-Fx	-   MSB->Aux-Left (0-ff) 	
    						LSB->Right  (0-7f) 
    Filt	MSB-> Fc 	0(open)-ff(close)
            LSB->Q      0(resonnance max.)-ff(no resonnance )
    
    return 	0 if succeed                       
****************************************************************************/  
WORD FAR PASCAL _loadds modOpenVoice(WORD Voice, BYTE Vol, WORD VMain, WORD VAux,
		WORD Pitch, WORD Filt)
{
D1("ModOpenVoice API"); 
// Send Command an data to open voice 
//		as described in Mod Player documentation

/*if (!AcquireMPU401( phwi ))
	return MMSYSERR_ALLOCATED ; */  
SendCommand(VOI_OPEN,0,0);
SendParam((BYTE) Voice,1,0);
//ReleaseMPU401( phwi ) ;	
                             
modChangeParam(Voice, VOI_VOL, (WORD) Vol);
modChangeParam(Voice, VOI_MAIN , VMain);
modChangeParam(Voice, VOI_PITCH,Pitch); 
modChangeParam(Voice, VOI_AUX ,VAux); 
modChangeParam(Voice, VOI_FILT,Filt);
return 0;               // no error
}

/****************************************************************************

    API dream - modChangeParam(WORD wVoice,WORD wType, WORD wValue)
    	 
    Modify the value of one parameters on the voice (MOD PLAYER)
    
    Voice : voice number
    
    According to Type the Value is :
    if wType=VOI_VOL				Vol - 	0-ff          
    if wType=VOI_MAIN		LSB-->Right (0-ff)
    						MSB-->Left (0-ff)
    if wType=PITCH				Pitch - 400h=nominal frequency and linearly 
    						scalled (200h = 1/2 nom. freq.)
    if wType=VOI_AUX				Aux-Fx	-   MSB->Aux-Left (0-ff) 	
    						LSB->Right  (0-7f) 	
    if wType=VOI_FILT				Filt	MSB-> Fc 	0(open)-ff(close)
          							LSB->Q      0(resonnance max.)-ff(no resonnance )
	return 	0 if succeed
			1 if any error occurs

****************************************************************************/  
WORD FAR PASCAL _loadds modChangeParam(WORD wVoice,BYTE bType, WORD wValue) 
{ 
BYTE NbParm=3;

/*if (!AcquireMPU401( phwi ))
	return MMSYSERR_ALLOCATED ; */ 
if (bType==VOI_VOL)
	NbParm=2;
SendCommand(bType,0,0); 
SendParam((BYTE) wVoice,0,0);
if (NbParm==3)
	{
	SendParam((BYTE) wValue,0,0);
	SendParam((BYTE) (wValue>>8),1,0); 
	}
else
	SendParam((BYTE) wValue,1,0);
//ReleaseMPU401( phwi ) ;
return 0;
}  

/****************************************************************************

    API dream - ModGetVoiceNumber()
    	 
    Return the number of Available voices (MOD PLAYER)


****************************************************************************/  
WORD FAR PASCAL _loadds modGetVoiceNumber() 
{ 
long ll;

gwModAnsNb=1;   
//IntUsed++;
/*if (!AcquireMPU401( phwi ))
{
	//IntUsed--;
	return MMSYSERR_ALLOCATED ; 
}*/

SendCommand(GET_VOI,0,0);
SendParam(0,1,0); 
/*;
; Now, we are waiting for answer
;  Let's fill the Mod_Answer structure with :
;		- ModAnsNb=1	(GET_VOI->1 byte expected)
;	Loop until ModAnsNb=0 (set by interrupt routine)
;	then read byte in  ModAnsByte   */

// Now, wait for interrupt to get answer
ll=0;
while ((gwModAnsNb!=0) && (ll<65535*20))
	{
	_inp(gwPort+1);	//tempo
	ll++;
	}
//ReleaseMPU401( phwi ) ;	
//IntUsed--;
return (WORD) gbModAnsByte;
}     
 
/****************************************************************************

    API dream - modDefineVoiceMemory(WORD Voice, WORD Format,
    				DWORD Start, DWORD Loop, DWORD End)
    	 
    Define the memory format for voice buffer (MOD PLAYER)
    define start,loop, and end point and define the sample format
    Format : 	bit 7	: 0->16 bits ; 1->8 bits
    		    bit 6	: used if bit 7=1. 	0->Sample in low byte
    		    							1->Sample in high byte  
    		    bit 0-5 : loop type
    		    			0 : forward loop
    		    			1 : reverse loop
    		    			2 : reverse loop with sign inversion
    		    			(See Notice)							
    
    Voice : voice number

  	Start, Loop, End, 	: absolute address (32 bits) 
****************************************************************************/  
WORD FAR PASCAL _loadds modDefineVoiceMemory(WORD Voice, WORD Format, DWORD Start, 
						DWORD Loop, DWORD End) 
{
BYTE Bank,BkLoop,BkEnd;  
//Retreive 256K Pages number
Bank=(BYTE) (Start>>18);
BkEnd=(BYTE) (End>>18);
BkLoop=(BYTE) (Loop>>18);
//Retreive offset in 256K Page number (just keep 18 bits)
Start&=0x0003FFFF; 
Loop&=0x0003FFFF; 
End&=0x0003FFFF;
/*if (!AcquireMPU401( phwi ))
	return MMSYSERR_ALLOCATED ;  */ 
VoiceMemory((BYTE) (Voice & 0xff), (BYTE) (Format & 0xff), Bank,Start,BkLoop,Loop,BkEnd,End);
//ReleaseMPU401( phwi ) ;
return 0;
}   

/****************************************************************************

    API dream - modCommand(WORD wVoice,BYTE bCommand) 
    	 
    Do the corresponding command (MOD PLAYER)
    
    Command	=	MOD_START
    			MOD_STOP
    			MOD_CLOSE
	return 	0 if succeed
			1 if any error occurs

****************************************************************************/  
WORD FAR PASCAL _loadds modCommand(WORD Voice,BYTE Command) 
{           
/*if (!AcquireMPU401( phwi ))
	return MMSYSERR_ALLOCATED ; */  
SendCommand(Command ,0,0);
SendParam((BYTE) Voice,1,0);    
//ReleaseMPU401( phwi ) ;
return 0;
} 


/****************************************************************************

    API dream - modSetNewPos(WORD Voice, DWORD offset)
    	 
   	Add offset to current position		(MOD_PLAYER)	
    and give the (new) current position
    
    Voice	: voice number
    offset	: absolute offset (32bits) to add at actual position 
    
  	return 0, error msg if failed
  
****************************************************************************/  
WORD FAR PASCAL _loadds modSetNewPos(WORD Voice, DWORD offset) 
{ 
BYTE bank;
          // let's add the offset to current position
bank=(BYTE) (offset>>18);
offset&=0x0003ffff;
/*if (!AcquireMPU401( phwi ))
{
	return MMSYSERR_ALLOCATED ;  
}*/
SetModPosition((BYTE) (Voice & 0xff), bank, offset);
//ReleaseMPU401( phwi ) ;	
return 0;
}



/****************************************************************************

    API dream - modGetPos(WORD Voice)
    	 
   	 give the (new) current position
    
    Voice	: voice number
    
  	return new absolute address, FFFFFFFF if failed
  	
****************************************************************************/  
DWORD FAR PASCAL _loadds modGetPos(WORD Voice) 
{ 
long add=0,ll;
int n;

gwModAnsNb=4;                 // 4 bytes expected
//IntUsed++; 
/*if (!AcquireMPU401( phwi ))
{
	//IntUsed--;
	return MMSYSERR_ALLOCATED ;  
}*/

SendCommand(GET_POS,0,0);
SendParam((BYTE) Voice,1,0);
// Now, wait for interrupt to get answer
ll=0;
while ((gwModAnsNb!=0) && (ll<65535*20))
	{
	_inp(gwPort+1);	//tempo
	ll++;
	}
//ReleaseMPU401( phwi ) ;	
if (gwModAnsNb!=0)
{
	//IntUsed--;
	return 0xffffffff;
}
else
{
	for (n=0;n<3; n++)
		add+=((DWORD) gbModAnsLong[n+1] << (8*n));
	add+=((DWORD) gbModAnsLong[0] << 18);
}
//IntUsed--;
return add;
}
      
/****************************************************************************

    API dream - genControlRead(BYTE *Value, BYTE bCommand)
    	 
	bCommand : -(0-7f) The control nb for which the value is returned in Value
				-if noCommand=0xff, Value is assumed to be a 128 BYTE table
				and is filled whith 128 control values. (Value[n] is the value 
				for the control nb n.
	Value	: Pointer on a location filled by the returned control value
				(one BYTE if bCommand<7f) or with every control values
				(128 BYTE if bCommand=0xff)

  	return 0 if succesfull
			error code if failed
  	
****************************************************************************/  
WORD FAR PASCAL _loadds genControlRead(LPBYTE Value, BYTE bCommand)
{
int n;
DWORD	MemMapAdd; 

if ((bCommand>0x7f) && (bCommand !=0xff))
	return DREAMERR_INVCOM;
	

/* attempt to 'acquire' the Wave output hardware */  
// first, let's allocate buffer in card memory
if ((MemMapAdd=memGetMapAddress())==0xffffffff)				//API Dream called to Get Memory Mapping Table address
	{        
	return DREAMERR_ABORT;
	}
if (memRead(MemoryBlock,MemMapAdd,NbMemBlocks*3))	//API Dream called to Get Memory block definition
	{    
	return DREAMERR_ABORT;        
	}
// let's search for  Controle Value block (type=6)
n=0;
while ((MemoryBlock[n].Type!=6) && (n<NbMemBlocks))
	n++;
if (n==NbMemBlocks)
	return DREAMERR_NOTSUPPORTED;

if (memRead(ControleValue,MemoryBlock[n].Address,64))	//API Dream called to Get Memory block definition
{    
	return DREAMERR_ABORT;        
}

if (bCommand==0xff)
{			// load the whole table in Value
	int nn;
	for (nn=0; nn<64; nn++)
		((LPWORD) Value)[nn]=ControleValue[nn];
	return 0;
}
// just load the BYTE desired
*Value=((BYTE*) ControleValue)[bCommand];
return 0;
}
      
BOOL CheckFreeSize()
{   
long FreeSize, MemMapAdd;
int nbl;
MemBlDefTyp MemoryBlock[NbMemBlocks];
 
    // check free size 
if ((MemMapAdd=GetMemMapAddress())==0xffffffff)				//API Dream called to Get Memory Mapping Table address
	{
	return FALSE;           
	}
if (UpLoad(MemoryBlock,(WORD) (MemMapAdd>>16),(WORD) (MemMapAdd & 0xffff),NbMemBlocks*3))	//API Dream called to Get Memory block definition
	{
	return FALSE;
	}		
MemSize=MemoryBlock[0].Address;				
FreeSize=0;
for (nbl=0; nbl<NbMemBlocks; nbl++)
	{
	if (MemoryBlock[nbl].Type==1)
		FreeSize+=MemoryBlock[nbl+1].Address-MemoryBlock[nbl].Address;  
	}   
if (FreeSize>=(0x12000))
	{    
	WaveBufferSize=0x2000;
	WaveBufferSizeIn=0x1000;  
	SizeMem=2;                   
	}
else if (FreeSize>0x3440)
	{
	WaveBufferSize=0xD00;		
	WaveBufferSizeIn=0xD00;
	SizeMem=1;  
	}
else
   {
	D1("no waves");
	WaveBufferSize=0;		
	WaveBufferSizeIn=0;
	SizeMem=0;  
	}    
D1("check free size made");                       
return TRUE;
}   