
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
;   KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
;   IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR
;   PURPOSE.
;
;   Copyright (c) 1993 - 1995  Microsoft Corporation.  All Rights Reserved.
;
;   mpu401.inc
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   equates.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 

TRUE          equ 1
FALSE         equ 0    

;
; DREAM 
;
TOT_CHANNEL	equ 1			; Max nb of wave channel  8 in the future 
WI_CHAN		equ	4			; channel for wave input
DMA_RQ		equ	1			; Request DMA
DMA_AQ		equ 0acH			; Acqnowledgement for DMA    
ACKNOW		equ 0acH			; ""    
MEM_ABORT		equ	0abh			; abort write or read mem
ACQ_GI		equ	88h			; Acqnowledgement : Receive GEN_IN message
MPX			equ 4			; nb of shift to have MPX 0-1 
WRT_MEM		equ	1			; Write memory command 
READ_MEM	equ	2			; Read memory command
GET_MMT		equ	3			; Get Memory mapping table address   
SET_MMT		equ	4			; Set Memory mapping table address 
EQU_LL		equ	10h			; Set Equalizer  
EN_MIDIOUT		equ	3dh			; Driver-P16 message  
W_OPEN		equ	40h			; Driver-P16 message
W_START		equ 42h
END_XFER	equ	43h			; Driver-P16 message
W_VOLLEFT		equ	45h			; Driver-P16 message 
W_VOLRIGHT		equ	46h			; Driver-P16 message       
W_VOLAUXLEFT		equ	47h			; Driver-P16 message 
W_VOLAUXRIGHT		equ	49h			; Driver-P16 message
W_PITCH		equ	44h			; Driver-P16 message
W_CLOSE		equ	41h			; Driver-P16 message
GEN_INT		equ	48h			; Driver-P16 message   
DMA_REG		equ	2			; dma register

; MOD PLAYER
VOI_MEM		equ 5bh			; Define memory command
SET_POS		equ	5dh			; Add an offset to current reading

DSR           equ 80H       ; data set ready 0 = ready
DRR           equ 40H       ; data receive ready 0 = ready


PIC_EOI_MASTER      equ 20h             ; where to send master EOI
PIC_EOI_SLAVE       equ 0A0h            ; where to send slave EOI

PIC_IMR_MASTER      equ 21h
PIC_IMR_SLAVE       equ 0A1h   

; index MPU-401 registers

MPU401_REG_DATA         equ     00h
MPU401_REG_STATUS       equ     01h
MPU401_REG_COMMAND      equ     01h

MPU401_DSR              equ     80h     ; data set ready, 0 = ready
MPU401_DRR              equ     40h     ; data receive ready, 0 = ready

MPU401_CMD_UART_MODE    equ     3fh     ; put card in 'UART' mode
MPU401_CMD_RESET        equ     0ffh    ; reset command

;
;   MIDI input and output state flags...
;

MIF_ALLOCATED       equ 00000001b
MIF_STARTED         equ 00000010b
MIF_INISR           equ 10000000b

MOF_ALLOCATED       equ 00000001b

;
;   For InitResetAdapter.  _POWERON is 'power on' state; _UART is what
;   this driver requires the adapter to be set to.
;

IRA_MODE_POWERON    equ 0
IRA_MODE_UART       equ 1

HARDWAREINSTANCE struc

   hwi_pVxDEntry                dd      ?
   hwi_cAcquire                 dd      ?

   hwi_wHardwareOptions         dw      ?
   hwi_wIOAddressMPU401         dw      ?
   hwi_bIRQ                     db      ?
   hwi_bReserved                db      ?
   hwi_dn                       dd      ?

   hwi_uVxDId                   dw      ?
   hwi_cReference               dw      ?
   hwi_cEnable                  dw      ?
   hwi_fEnabled                 dw      ?

   ; IRQ stuff

   hwi_uISRDataSel              dw      ?
   hwi_uISRCodeSel              dw      ?

   hwi_bIntVector               db      ?
   hwi_bOrigIntMask             db      ?
   hwi_dwOldISR                 dd      ?
   hwi_wEOICommands             dw      ?
   hwi_fISRCanReadData          dw      ?

   ; isr pipe storage

   hwi_hpisr                    dd      ?
   hwi_fnisrPipe                dd      ?

   ; midi flags

   hwi_bMidiInFlags             db      ?
   hwi_bMidiOutFlags            db      ?
   hwi_wMidiInPersistence       dw      ?

   ;
   ; Allocated MIDI output/input clients, for this hardware
   ; instance... if any.
   ;
   ; NOTE! These are used by the interrupt handler and 
   ; output data functions to send/receive full-duplex data
   ; when processing the MIDI stream.
   ;

   hwi_pmic                     dw      ?
   hwi_pmoc                     dw      ?

   ; link to next instance

   hwi_pNext                    dw      ?

   ; midi streams info (ifdef MIDI_STREAMS)
   ;

  ;hwi_msd                      db (SIZE MIDISTREAMDATA) dup (?)
   ;

HARDWAREINSTANCE ends

PORTALLOC struc

   pa_phwi              dw      ?
   pa_hMidi             dw      ?
   pa_dwCallback        dd      ?
   pa_dwInstance        dd      ?
   pa_dwFlags           dd      ?

PORTALLOC ends

MIDIIN_QUEUE_SIZE  equ  64 

MIDIINCLIENT struc

   mic_pa               db      (SIZE PORTALLOC) dup (?)
   mic_wDataQHead       dw      ?
   mic_wDataQTail       dw      ?
   mic_abDataQueue      db      (MIDIIN_QUEUE_SIZE) dup (?)

   mic_fSysEx           db      ?
   mic_bStatus          db      ?
   mic_bBytesLeft       db      ?
   mic_bBytePos         db      ?

   mic_dwShortMsg       dd      ?
   mic_dwMsgTime        dd      ?
   mic_dwRefTime        dd      ?

   mic_dwCurData        dd      ?
   mic_lpmhQueue        dd      ?

MIDIINCLIENT ends



