/* ----------------------------------------------------------------------------------------

														EDIT94FX.C
														
														 
 ----------------------------------------------------------------------------------------*/
//#define NODAPI
//#include "edit94fx.h" 
#define DRIMIX
#include "dreamdef.h"
#include "resource.h"
#include "windows.h" 
#include "c:\msdev\include\mmsystem.h"
#include <string.h>
#include <math.h>
#include <stdio.h>
#include <conio.h>
//#include "msmixmgr.h"
#ifdef NODAPI //if No Dream API
	#include "dummy.c"
#else
	#include "dream.h" 	
#endif

#if _MSC_VER >= 700
#pragma warning (disable:4028)
#endif

#define PI 3.141592654
#define POTNB 29
#define SLYNB 13
#define BUTNB 30
#define LCDNB 2
#define WAVENB 8
#define REVCHRS 4
#define FRANB 12
#define TXTNB 45

char szAppName[]="94mix16";
char szIniName[25];
char MicTxt[20]="Mic";
char LineTxt[20]="Line";
char CDTxt[20]="CD";

char szBoard[]="Board";
char szName[]="Name";
char szPreset[]="Preset";
char szExtMixer[]="ExtMixer";
char szCodecInput[]="CodInput";
char szCodec[]="Codec";
char szInputs[]="Inputs";
char szMaster[]="Master";
char szWaves[]="Waves";
char szSynth[]="Synth";
char szFx[]="Fx";
char szEcho[]="Echo";
char szEq[]="Eq";
char szSurrnd[]="Surrnd";
char szRecord[]="Record";
char szMain[]="Main";
char szInChrs[]="InChrs";
int InChrs=0;

		

char szBoardName[255];
BOOL bExtMixer=FALSE;
char szExtMixName[255];
char szDreamMixName[]="DREAM SOUND";

HFONT hNewFont;
WORD  widIcon = ID_ICON;
HWND hMainWnd;   
HANDLE  hInst;
HDC hLeMemoryDC ;
HBITMAP	hLeBmp;  
RECT rFly;
struct MyFrame {
	int left;
	int top;
	int right;
	int bottom;
	int width;
	int height;
	char name[20];
	BOOL visible;
	int offset;
}
Frame[12];

int FrameStatus[12]={1,1,1,1, 1,1,1,1, 1,1,1,1};


POINT Origine;
void CalcFrames(int FrameNb);
void InitFrame(struct MyFrame *fra,int width,int height,int offset,LPSTR name,BOOL visible);

void RedrawFrame(RECT *rect,struct MyFrame *fra,PAINTSTRUCT *ps,HDC *hDC);

struct MyTxt {
	int left;
	int top;
	int right;
	int bottom;
	LPSTR ptxt;
	COLORREF color;
	BOOL visible;
	struct MyTxt *ptNxtTxt;
}
Texte[TXTNB];

char cMic[]="MIC";
char cLine[]="LINE";
char cCD[]="CD";
char cMaster[]="MASTER INPUTS";
char cMain[]="MASTER";
char cWaves[]="WAVES";
char cSynth[]="SYNTH";
char cReverb[]="REVERB";
char cChorus[]="CHORUS";
char cEqualizer[]="EQUALIZER";
char cSurrnd[]="SURRND";
char cRecord[]="RECORD";
char cRev[]="REV.";
char cEcho[]="ECHO";
char cChrs[]="CHRS";
char cFilter[]="FILTER";
char cVol[]="VOL";
char cPitch[]="PITCH";
char cPan[]="PAN";
char cTime[]="TIME";
char cFb[]="FB";
char cRate[]="RATE";
char cDelay[]="DELAY";
char cDepth[]="DEPTH";
char cLow[]="LOW";
char cMidL[]="MIDL";
char cMidH[]="MIDH";
char cHigh[]="HIGH";
char cSel[]="SEL";
char cOn[]="ON";





void InitText(struct MyTxt *txt,int left,int top,LPSTR ptxt,COLORREF color, struct MyFrame *fra);
void RedrawTxt(RECT *rect,struct MyTxt *txt,PAINTSTRUCT *ps,HDC *hDC);
struct MyBackGnd
{
	RECT GlobRect;	
	HDC  hDC;	
};
struct MyBackGnd Back;

struct MyLCD
{
RECT GlobRect;
HDC hDC[8];
HDC hDc;
int curt;
int bmp;
BOOL visible;
LPSTR ptxt;
};
struct MyLCD Lcd[2];

unsigned char ChorusTxt[8][10]={"CHORUS 1","CHORUS 2","CHORUS 3","CHORUS 4","FBCHRS","FLANGER","SHORTDL","FBDEL"};
unsigned char ReverbTxt[8][10]={"ROOM 1","ROOM 2","ROOM 3","HALL 1","HALL 2","PLATE","DELAY","PANDEL"};

struct MySlider
{
	RECT GlobRect;
	RECT FlyRect;
	int yOffset;
	int xOffset;
	HDC  hDCfly;
	HDC  hDCback;
	int bmpfly;
	int bmpback;
	unsigned int min;
	unsigned int max;
	unsigned int curt;
	int orient;//use SB_HORZ, and SB_VERT
	BOOL bSel;//Selected or not (WM_LBUTTONDOWN)
	BOOL visible;
};
struct MySlider Sly[SLYNB];

int CurSlyId=0;
int minAngle=0;
int maxAngle=300;

struct MyPot
{
	RECT GlobRect;
	POINT OffsetPt;	
	POINT Center;
	POINT Border;
	int Radius;
	unsigned int min;
	unsigned int max;
	unsigned int curt;
	float minAngle;
	float maxAngle;
	float curAngle;	
	POINT Click;
	int ClickVal;
	float OffsetAngle;
	BOOL bSel;//Selected or not (WM_LBUTTONDOWN)
	HDC  hDC;
	int bmp;
	BOOL visible;
	//int skatemax;
	//int skatemin;
	int dec;//dec =0 if we are decrementig value
	//int neg;//neg=0 if positive, =1 if negative
	int zerocross;//count number of times curangle has crossed zero
};
struct MyPot Pot[POTNB]; //Don't touch to MyPot
int CurPotId=0;



struct MyButton
{
	RECT GlobRect;
	unsigned int curt;
	int statenb;	//when 1 ,look of button only changes when mouse is pressed 
					//and comes back when button is released
					// when 2, look toggles between 2 bitmaps
	
	HDC  hDC1;
	HDC  hDC2;
	int bmp1;
	int bmp2;
	BOOL visible;
};
struct MyButton But[BUTNB];
int CurButId=0;

int ret;
#include "mix.c"


//--------- Master In --------------
unsigned int MstInVol[2]={255,255};
unsigned int MstInPan[2]={0,127};
unsigned int MstInFx[3]={0,0,0};

//--------- Waves --------------
unsigned int WaveFL[8]={65535,65535,65535,65535, 65535,65535,65535,65535};
unsigned int WaveFR[8]={65535,65535,65535,65535, 65535,65535,65535,65535};

unsigned int WaveVol[8]={65535,65535,65535,65535, 65535,65535,65535,65535};
unsigned int WavePan[8]={   64,   64,   64,   64,    64,   64,   64,   64};

unsigned int WaveRL[8]={    0,    0,    0,    0,     0,    0,    0,    0};
unsigned int WaveRR[8]={    0,    0,    0,    0,     0,    0,    0,    0};
unsigned int WavePt[8]={44100,44100,44100,44100, 44100,44100,44100,44100};
unsigned int WaveFc[8]={65535,65535,65535,65535, 65535,65535,65535,65535};
unsigned int WaveOn[8]={    1,    1,    1,    1,     1,    1,    1,    1};//for mute    
int FirstDreamWaveId=0;
int CurtWave=0; //Current selected wave which parameters are displayed
int WaveMuted[WAVENB]={0,0,0,0, 0,0,0,0};
int SoloOn=0;
//--------- Synth --------------
unsigned int SynPan=63;
unsigned int SynVol=255;
unsigned int SynRev=128;
unsigned int SynChr=128;
//--------- Reverb --------------
unsigned int RevVal[2]={64,64};
unsigned int RevType=4;
//--------- Echo --------------
unsigned int EchoVal[2]={43,64};
//--------- Chorus --------------
unsigned int ChrVal[4]={64,64,64,64};
unsigned int ChrType=2;
//--------- Equalizer --------------
int EqVol[4]={0x60,0x40,0x40,0x60};
int EqFreq[4]={0x0c,0x1b,0x72,0x40};
int FlatVol[4]={0x60,0x40,0x40,0x60};
int FlatFreq[4]={0x0c,0x1b,0x72,0x40};
//--------- 3D --------------
unsigned int SurRnd[2]={64,0};
unsigned char SurSel[2]={0,0};
unsigned char RecSel=0;
unsigned char Ass[4]={127,127,127,127};
unsigned int MainVol=255;


BOOL FAR PASCAL DialogProc ( HWND, unsigned, WORD, LONG);

BOOL DialogbxInit ( HANDLE );
long FAR PASCAL DialogbxWndProc( HWND, unsigned, WORD, LONG);
char txt[160];
#include "pot.c"
#include "slider.c"

void InitMyScreen(HWND hWnd,HANDLE hInst);

int InitBackGrnd(struct MyBackGnd *bak,int left,int top,HDC hdc,HANDLE hInst);
void RedrawBackGrnd(RECT *rect,struct MyBackGnd *bak,PAINTSTRUCT *ps,HDC *hDC);

int InitButton(struct MyButton *but,int left,int top,int val,int stateNb,LPCSTR but1,LPCSTR but2,HDC hdc,HANDLE hInst,RECT *fra);
int InButton(struct MyButton *but,POINT *pt);
void RedrawButton(RECT *rect,struct MyButton *but,PAINTSTRUCT *ps,HDC hDC);
void PressButton(struct MyButton *but,HWND hwnd);
void ReleaseButton(struct MyButton *but,HWND hwnd);
void ToggleButton(struct MyButton *but,HWND hwnd);
void SetButtonVal(struct MyButton *but,int val,HWND hwnd);
int SetSolo(int SelWave,HWND hWnd);
void MuteWave(struct MyButton *but,int WaveId,HWND hwnd);
void RedrawLCD(RECT *rect,struct MyLCD *lcd,PAINTSTRUCT *ps,HDC hDC);
void RedrawLCD2(struct MyLCD *lcd,HWND hWnd);
//int InitLCD(struct MyLCD *lcd,int left,int top,int width,int height,int xoff,int yoff,char* txt,int txtid,int charnb);
int InitLCD(struct MyLCD *lcd,int left,int top,int curt,LPSTR ptxt,HDC hdc,HANDLE hInst,struct MyFrame *fra);

int IncLCD(struct MyLCD *lcd,int Inc,HWND hwnd);

void UpdateFromPot(int i,unsigned int val);
void UpdateFromSlider(int i,unsigned int val);
void UpdateFromLCD(int i,unsigned int Val);
void UpdateWaveVol(int WaveId);
void ResizeMainWnd(HWND hWnd,int FrameNb);
void FlatEQ(HWND hWnd);
void XferAll(void);
int ReadIniFile(LPSTR apname);
int ReleaseBut(struct MyButton *but,HWND hwnd);
int ReleaseLCD(struct MyLCD *lcd,HWND hwnd);
void ReleaseAll(HWND hwnd); 

/** ReadBack **/
unsigned char SamTable[128];
int idtimer=5;
BOOL ReadSamConfig(LPBYTE Table);
int RefreshChorus(LPBYTE Table);
int RefreshReverb(LPBYTE Table);
int UpdateControls(HWND hWnd);
int first=0;
int ReadBackPresent=TRUE;

/* ----------------------------------------------------------------------------------------
														WinMain
 ----------------------------------------------------------------------------------------*/
int PASCAL WinMain(hInstance, hPrevInstance, lpszCmdLine, cmdShow)
HANDLE hInstance, hPrevInstance;
LPSTR lpszCmdLine;
int cmdShow;
{
   MSG msg;
	HWND hWnd;
    int wid,hei,i,lastframe;
    RECT desiredRect;
    
	
	if (!hPrevInstance)
    {
         if (!DialogbxInit( hInstance ))
              return FALSE;
    }
    hInst=hInstance;
	strcpy(szIniName,szAppName);
	strcat(szIniName,".ini");
	ReadIniFile(szIniName);
	//SamTable[129]=45;
	//SamTable=LocalAlloc(LPTR,128); 
	ReadBackPresent=ReadSamConfig((LPBYTE)SamTable);
	//=LocalFree(SamTable);
	Origine.x=6;
	Origine.y=8;
	InitFrame(&Frame[0],74,134,0,"INPUTS",FrameStatus[0]);
InitFrame(&Frame[1],83,134,0,"MASTER IN",FrameStatus[1]);
InitFrame(&Frame[2],110,134,2,"WAVES",FrameStatus[2]);
InitFrame(&Frame[3],57,134,2,"SYNTH",FrameStatus[3]);
InitFrame(&Frame[4],112,134,2,"FX",FrameStatus[4]);
InitFrame(&Frame[5],56,72,0,"REVERB",FrameStatus[5]);
InitFrame(&Frame[6],56,41,0,"ECHO",FrameStatus[6]);
InitFrame(&Frame[7],56,113,0,"CHORUS",FrameStatus[7]);
InitFrame(&Frame[8],96,134,2,"EQUALIZER",FrameStatus[8]);
InitFrame(&Frame[9],35,134,2,"SURRND",FrameStatus[9]);
//InitFrame(&Frame[10],36,134,2,"RECORD",FrameStatus[10]);
InitFrame(&Frame[10],36,49,2,"RECORD",FrameStatus[10]);
InitFrame(&Frame[11],36,85,2,"MAIN",FrameStatus[11]);
CalcFrames(FRANB);

	
	lastframe=-1;
	for(i=0;i<FRANB;i++)
	{
		if(Frame[i].visible)
			lastframe=i;
	}

	if(lastframe==-1)
		{
		wid=0;
		hei=0;
		}
	else
		{
		wid=Frame[lastframe].right+Origine.x;
		hei=Frame[3].bottom+Origine.y;
		}
	//i=SetWindowPos(hWnd,NULL,0,0,wid,hei,SWP_NOZORDER);
	desiredRect.top=50;
	desiredRect.bottom=50+hei;
	desiredRect.left=50;
	desiredRect.right=50+wid;
     AdjustWindowRect((LPRECT)&desiredRect,WS_OVERLAPPED|WS_CAPTION|
			  WS_SYSMENU|//WS_THICKFRAME|WS_MAXIMIZEBOX|
			  WS_MINIMIZEBOX,FALSE);
     
     hWnd= CreateWindow((LPSTR)"Dialogbx",               /* Window class name           */
                szAppName,     
              //WS_OVERLAPPEDWINDOW,
			  WS_OVERLAPPED|WS_CAPTION|
			  WS_SYSMENU|//WS_THICKFRAME|WS_MAXIMIZEBOX|
			  WS_MINIMIZEBOX,
			  desiredRect.left,
              desiredRect.top, 
              //630, 150+20,
			  desiredRect.right-desiredRect.left,
			  desiredRect.bottom-desiredRect.top,
              NULL, NULL, hInstance, NULL);
    hMainWnd=hWnd;
    

    ShowWindow( hWnd, cmdShow );
    UpdateWindow( hWnd );    

    while (GetMessage(&msg, NULL, 0, 0))
    {
         TranslateMessage(&msg);
         DispatchMessage(&msg);
    }

    return (int)msg.wParam;
}

/* ----------------------------------------------------------------------------------------
														DialogbxInit
 ----------------------------------------------------------------------------------------*/
BOOL DialogbxInit( hInstance )
HANDLE hInstance;
{
    WNDCLASS wcDialogbxClass;

    wcDialogbxClass.hCursor        =  LoadCursor( NULL, IDC_ARROW );
//    wcDialogbxClass.hIcon          =  LoadIcon( NULL, IDI_HAND);
    wcDialogbxClass.hIcon          =  LoadIcon( hInstance, MAKEINTRESOURCE(ID_ICON));
    wcDialogbxClass.lpszMenuName   = NULL;
    wcDialogbxClass.lpszClassName  =  "Dialogbx";
    wcDialogbxClass.hbrBackground  =  GetStockObject(LTGRAY_BRUSH );
    // wcDialogbxClass.hbrBackground  =  GetStockObject(WHITE_BRUSH );
    wcDialogbxClass.hInstance      =  hInstance;
    wcDialogbxClass.style          =  CS_VREDRAW | CS_HREDRAW;
    wcDialogbxClass.lpfnWndProc    =  DialogbxWndProc;
    wcDialogbxClass.cbClsExtra     =  0;
    wcDialogbxClass.cbWndExtra     =  0;

    if (!RegisterClass( &wcDialogbxClass ) )
         return FALSE;

    return TRUE;
}


/* ----------------------------------------------------------------------------------------
														DialogbxWndProc  hWnd
  unvisible screen procedure
 ----------------------------------------------------------------------------------------*/
long FAR PASCAL DialogbxWndProc( hWnd, message, wParam, lParam )
HWND            hWnd;
unsigned        message;
WORD            wParam;
LONG            lParam; 

{
    HDC hDC;
    PAINTSTRUCT ps;
	RECT rect;
	int val;
	int curX,curY;
	POINT curPt;
	int i;
	MMRESULT mmres;
	char txt[255];
	long lpar;
	MIXERCONTROLDETAILS mxcd;

    switch (message)
    
    {
         case WM_CREATE:
			//ReadIniFile();
			    if(GetDreamMixerValues(hWnd))
				    {
				    if(DVolId!=-1)
						{
						MainVol=DVolVol;
						}
					else
						{
						 Frame[11].visible=FALSE;
						 }
				    
				    
				    if(DWaveInId!=-1)
				    {
				    if(DWISel!=0)
							RecSel=0;// rec src =audio
							
						else 
							RecSel=0x7f;// rec src =line
					}
					if(DWaveId!=-1)
					{
					for(i=0;i<8;i++)
						{
						WaveVol[i]=DWaveVol;
						WavePan[i]=DWavePan;
						}					
					}
					if(DLineId!=-1)
					{
					    MstInVol[0]=(BYTE)((DLineVolL>>8)&0xff);					
					    MstInVol[1]=(BYTE)((DLineVolR>>8)&0xff);
					}
					if(DMidiId!=-1)
					{
					    SynVol=((DMidiVol>>8)&0xff);
						if(DMidiPan!=-1)
							SynPan=DMidiPan;			    						
					}
				}
				
				if(bExtMixer)
					GetMixerValues(hWnd);  
		
			InitMyScreen(hWnd,hInst);
			
			XferAll();
			//SetTimer(hWnd,idtimer,40,NULL);
			break;

		 case MM_MIXM_LINE_CHANGE:
			 i=wParam;
			 lpar=lParam;
			  #ifdef DEBUGMIX
				wsprintf((LPSTR)txt,"MixLineChge wPar %x ,lPar = %lx )\n\r",wParam,lParam);
				OutputDebugString((LPSTR)txt);
			#endif	

//wParam = (WPARAM) hMixer      
//lParam = (LPARAM) dwLineID  
			 break;

		 case MM_MIXM_CONTROL_CHANGE:
//wParam = (WPARAM) hMixer       
//lParam = (LPARAM) dwControlID
			 i=wParam;
			 lpar=lParam;
			 if(wParam==hmx[0])
			 {
				 if((lParam==dwMicId)&& (!Sly[0].bSel)&&(!Pot[0].bSel))
				 {  
				 
					GetLineDetails(hmx[0],&mxLine[0],&mxLCtrl[0],&mxCtrl[0],&mxCtrlD[0],&detVal[0][0]);
					MicVol=detVal[MicId][0].dwValue;
					#ifdef DEBUGMIX
					wsprintf((LPSTR)txt,"Mic vol = %d )\n\r",MicVol);
					OutputDebugString((LPSTR)txt);
					#endif
					SetSliderVal(&Sly[0],MicVol,hWnd);
				 }
				 else if ((lParam==dwLineId)&& (!Sly[1].bSel)&&(!Pot[1].bSel))
				 {
					GetLineDetails(hmx[0],&mxLine[0],&mxLCtrl[0],&mxCtrl[0],&mxCtrlD[0],&detVal[0][0]);
					LineVol=GetMSMixVol(LineId,2);
					LinePan=GetMSMixPan(LineId);
					#ifdef DEBUGMIX
					wsprintf((LPSTR)txt,"MixCtrlChge Pan %d ,vol = %d )\n\r",LinePan,LineVol);
					OutputDebugString((LPSTR)txt);
					#endif
					SetSliderVal(&Sly[1],LineVol,hWnd);
					if(LinePan!=-1)
						SetPotVal(&Pot[1],LinePan,hWnd);
	
				 }
				 else if ((lParam==dwCDId)&& (!Sly[2].bSel)&&(!Pot[2].bSel))
				 {
					GetLineDetails(hmx[0],&mxLine[0],&mxLCtrl[0],&mxCtrl[0],&mxCtrlD[0],&detVal[0][0]);
					CDVol=GetMSMixVol(CDId,2);
					CDPan=GetMSMixPan(CDId);
					#ifdef DEBUGMIX
					wsprintf((LPSTR)txt,"MixCtrlChge Pan %d ,vol = %d )\n\r",CDPan,CDVol);
					OutputDebugString((LPSTR)txt);
					#endif
					SetSliderVal(&Sly[2],CDVol,hWnd);
					if(CDPan!=-1)
						SetPotVal(&Pot[2],CDPan,hWnd);
	
	
				 }
				 else
				 {
				 
				#ifdef DEBUGMIX
					wsprintf((LPSTR)txt,"MixCtrlChge wPar %x ,lPar = %lx )\n\r",wParam,lParam);
					OutputDebugString((LPSTR)txt);
				#endif	
				 }
			}
			if(wParam==hmx[1])      //DWISel
			 { 			 
				 if((lParam==dwDVolId)&& (!Sly[12].bSel))
				 {  
				    GetMasterVol(hmx[1],&mxLine[0],&mxLCtrl[0],&mxCtrl[0],&mxCtrlD[0],&detVal[0][0],DVolId);
					DVolVol=detVal[DVolId][0].dwValue;
					MainVol=(BYTE)((DVolVol>>8)&0xff);					
					#ifdef DEBUGMIX
					wsprintf((LPSTR)txt,"Dream vol = %d )\n\r",DVolVol);
					OutputDebugString((LPSTR)txt);
					#endif
					SetSliderVal(&Sly[12],MainVol,hWnd);
				 }
				 else if ((lParam==dwDWaveInId)&& (CurButId!=28)&&(CurButId!=29))
				 {  
					GetRecordStatus(hmx[1],&RLine[0],&RLCtrl[0],&RCtrl[0],&RCtrlD[0],&bdetVal[0][0],DWaveInId);
	
					DWISel=bdetVal[0][0].fValue;
					//GetMasterVol(hmx[1],&mxLine[0],&mxLCtrl[0],&mxCtrl[0],&mxCtrlD[0],&detVal[0][0],cbDreamDest);
					//DWISel=detVal[DWaveInId][0].dwValue;
					if(DWISel!=0)
						{
						RecSel=0;// rec src =audio
						SetButtonVal(&But[28],1,hWnd);
						SetButtonVal(&But[29],0,hWnd);
	                    }
					else
						{
						RecSel=0x7f;// rec src =audio
						SetButtonVal(&But[28],0,hWnd);
						SetButtonVal(&But[29],1,hWnd);					
						}				
					#ifdef DEBUGMIX
					wsprintf((LPSTR)txt,"Dream Rec Src = %d )\n\r",DWISel);
					OutputDebugString((LPSTR)txt);
					#endif
				}
				 else if ((lParam==dwDLineId)&& (!Sly[3].bSel)&&(!Sly[4].bSel))
				 {
					GetLineDetails(hmx[1],&mxLine[0],&mxLCtrl[0],&mxCtrl[0],&mxCtrlD[0],&detVal[0][0]);
					DLineVolL=detVal[DLineId][0].dwValue;
				    MstInVol[0]=(BYTE)((DLineVolL>>8)&0xff);
					DLineVolR=detVal[DLineId][1].dwValue;
				    MstInVol[1]=(BYTE)((DLineVolR>>8)&0xff);
					
					#ifdef DEBUGMIX
					wsprintf((LPSTR)txt,"Dream Line In left %d ,right = %d )\n\r",MstInVol[0],MstInVol[1]);
					OutputDebugString((LPSTR)txt);
					#endif
					SetSliderVal(&Sly[3],MstInVol[0],hWnd);
					SetSliderVal(&Sly[4],MstInVol[1],hWnd);
					
	
				 }
				 else if ((lParam==dwDWaveId)&& (!Sly[5].bSel)&&(!Pot[7].bSel))
				 {
					GetLineDetails(hmx[1],&mxLine[0],&mxLCtrl[0],&mxCtrl[0],&mxCtrlD[0],&detVal[0][0]);
					DWaveVol=GetMSMixVol(DWaveId,2);
					DWavePan=GetMSMixPan(DWaveId);
					#ifdef DEBUGMIX
					wsprintf((LPSTR)txt,"Dream Wave In Pan %d ,vol = %d )\n\r",DWavePan,DWaveVol);
					OutputDebugString((LPSTR)txt);
					#endif
					SetSliderVal(&Sly[5],DWaveVol,hWnd);
					if(DWavePan!=-1)
						SetPotVal(&Pot[7],DWavePan,hWnd);
	
				 }
				 else if ((lParam==dwDMidiId)&& (!Sly[7].bSel)&&(!Pot[11].bSel))
				 {
					GetLineDetails(hmx[1],&mxLine[0],&mxLCtrl[0],&mxCtrl[0],&mxCtrlD[0],&detVal[0][0]);
					DMidiVol=GetMSMixVol(DMidiId,2);
					DMidiPan=GetMSMixPan(DMidiId);
					SynVol=((DMidiVol>>8)&0xff);
					if(DMidiPan!=-1)
						SynPan=DMidiPan;
					#ifdef DEBUGMIX
					wsprintf((LPSTR)txt,"Dream Midi In Pan %d ,vol = %d )\n\r",DMidiPan,DMidiVol);
					OutputDebugString((LPSTR)txt);
					#endif
					SetSliderVal(&Sly[7],SynVol,hWnd);
					if(DMidiPan!=-1)
						SetPotVal(&Pot[11],SynPan,hWnd);	
				 }
				 
				 
				 else
				 {
				 
				#ifdef DEBUGMIX
					wsprintf((LPSTR)txt,"MixCtrlChge wPar %x ,lPar = %lx )\n\r",wParam,lParam);
					OutputDebugString((LPSTR)txt);
				#endif	
				 }
			}      
			break;
             

			
		case WM_PAINT:
		   
			memset(&ps, 0x00, sizeof(PAINTSTRUCT));
			hDC = BeginPaint(hWnd, &ps);
			//SetBkMode(hDC, TRANSPARENT);
			//RedrawBackGrnd(&rect,&Back,&ps,&hDC);
			for(i=0;i<FRANB;i++)
				RedrawFrame(&rect,&Frame[i],&ps,hDC);
			for(i=0;i<TXTNB;i++)
				RedrawTxt(&rect,&Texte[i],&ps,hDC);
			
			for(i=0;i<SLYNB;i++)
				{                
				RedrawSlider(&rect,&Sly[i],&ps,hDC);
				}
			//RedrawPotCur(&rect,&Pot[0],&ps,&hDC);
			// if(!Pot->bSel)
			for(i=0;i<POTNB;i++)
				{
				RedrawPot(&rect,&Pot[i],&ps,hDC);
				}
			for(i=0;i<BUTNB;i++)
				{
				RedrawButton(&rect,&But[i],&ps,hDC);
				}
			RedrawLCD(&rect,&Lcd[0],&ps,hDC);
			RedrawLCD(&rect,&Lcd[1],&ps,hDC);
			EndPaint(hWnd, &ps);
			break;       /*  End of WM_PAINT                               */

              
         
	/*	case WM_TIMER:
			RefreshValues(hWnd);
			break;  */
		case WM_LBUTTONDOWN:
			
			curX=LOWORD(lParam);
			curY=HIWORD(lParam);
			curPt.x=curX;
			curPt.y=curY;
			
			for(i=0;i<SLYNB;i++)
			{
		    if(InSlider(&Sly[i],&curPt)!=0)
		    	{
		    	SetCapture(hWnd);
				CurSlyId=i;
		    	break;
		    	}		    
		    }
			for(i=0;i<POTNB;i++)
			{
			if(InPot2(&Pot[i],&curPt)!=0)
		    	{
				SetCapture(hWnd);
		    	CurPotId=i;
				break;
		    	}
			}
			for(i=0;i<8;i++)
			{
			if(InButton(&But[i],&curPt)!=0)
		    	{
				SetCapture(hWnd);
		    	CurButId=i;
				MuteWave(&But[i],i,hWnd);				
				break;
		    	}
			}
			for(i=8;i<16;i++)
			{
			if(InButton(&But[i],&curPt)!=0)
		    	{
				SetCapture(hWnd);
				if(SoloOn==0)
					{
		    		CurButId=i;
					ToggleButton(&But[CurtWave+8],hWnd);					
					PressButton(&But[i],hWnd);	
					CurtWave=i-8;
					}
				else
					{
					CurButId=i;
					ToggleButton(&But[CurtWave+8],hWnd);					
					PressButton(&But[i],hWnd);	
					CurtWave=i-8;					
					But[16].curt=0;//just to flare the SetSolo function
					SetSolo(CurtWave,hWnd);
					}
				//current wave Id has changed :Set Sliders to Position according to value 
				SetSliderVal(&Sly[5],WaveVol[CurtWave],hWnd);				
				SetSliderVal(&Sly[6],WavePt[CurtWave],hWnd);
				SetPotVal(&Pot[7],WavePan[CurtWave],hWnd);
				SetPotVal(&Pot[8],WaveFc[CurtWave],hWnd);
				SetPotVal(&Pot[9],WaveRL[CurtWave],hWnd);
				SetPotVal(&Pot[10],WaveRR[CurtWave],hWnd);
				
				}
			}
			if(InButton(&But[16],&curPt)!=0)
			{				
				SetCapture(hWnd);
				CurButId=16;
				SetSolo(CurtWave,hWnd);			
			}
			if(InButton(&But[17],&curPt)!=0)// Mono/stereo for 3D
			{
				SetCapture(hWnd);
				CurButId=17;
				if (SurSel[0]==0)
					SurSel[0]=127;
				else
					SurSel[0]=0;
				mpuMessage(SUR_INP,&SurSel[0],1);
				PressButton(&But[17],hWnd);
			}

			if(InButton(&But[18],&curPt)!=0)// 2 / 4 speakers for 3D
			{
				SetCapture(hWnd);
				CurButId=18;
				if (SurSel[1]==0)
					SurSel[1]=127;
				else
					SurSel[1]=0;
				mpuMessage(SUR_24,&SurSel[1],1);
				PressButton(&But[18],hWnd);
			}

			if(InButton(&But[19],&curPt)!=0)// - button for LCD1
			{
				SetCapture(hWnd);
				CurButId=19;
				val=IncLCD(&Lcd[0],-1,hWnd);
				UpdateFromLCD(0,val);
				PressButton(&But[19],hWnd);
				RefreshReverb((LPBYTE)SamTable);
				SetPotVal(&Pot[14],RevVal[0],hWnd);
				SetPotVal(&Pot[15],RevVal[1],hWnd);				
			}

			if(InButton(&But[20],&curPt)!=0)// + button for LCD1
			{
				SetCapture(hWnd);
				CurButId=20;
				val=IncLCD(&Lcd[0],1,hWnd);
				UpdateFromLCD(0,val);
				PressButton(&But[20],hWnd);
				RefreshReverb((LPBYTE)SamTable);
				SetPotVal(&Pot[14],RevVal[0],hWnd);
				SetPotVal(&Pot[15],RevVal[1],hWnd);
			}

			if(InButton(&But[21],&curPt)!=0)// - button for LCD2
			{
				SetCapture(hWnd);
				CurButId=21;
				val=IncLCD(&Lcd[1],-1,hWnd);
				UpdateFromLCD(1,val);
				PressButton(&But[21],hWnd);
				if(ReadBackPresent)
					RefreshChorus((LPBYTE)SamTable);
				SetPotVal(&Pot[18],ChrVal[0],hWnd);
				SetPotVal(&Pot[19],ChrVal[1],hWnd);
				SetPotVal(&Pot[20],ChrVal[2],hWnd);
				SetPotVal(&Pot[21],ChrVal[3],hWnd);
			}

			if(InButton(&But[22],&curPt)!=0)// + Button for LCD2
			{
				SetCapture(hWnd);
				CurButId=22;
				val=IncLCD(&Lcd[1],1,hWnd);
				UpdateFromLCD(1,val);
				PressButton(&But[22],hWnd);
				if(ReadBackPresent)
					RefreshChorus((LPBYTE)SamTable);
				SetPotVal(&Pot[18],ChrVal[0],hWnd);
				SetPotVal(&Pot[19],ChrVal[1],hWnd);
				SetPotVal(&Pot[20],ChrVal[2],hWnd);
				SetPotVal(&Pot[21],ChrVal[3],hWnd);
			}			

			if(InButton(&But[23],&curPt)!=0)// master in -> post
			{
				SetCapture(hWnd);
				CurButId=23;
				if (Ass[0]==0)
					Ass[0]=127;
				else
					Ass[0]=0;
				mpuMessage(AUDECH_POST,&Ass[0],1);
				PressButton(&But[23],hWnd);
			}
			if(InButton(&But[24],&curPt)!=0)// waves -> post
			{
				SetCapture(hWnd);
				CurButId=24;
				if (Ass[1]==0)
					Ass[1]=127;
				else
					Ass[1]=0;
				mpuMessage(WAVE_POST,&Ass[1],1);
				PressButton(&But[24],hWnd);
			}
			if(InButton(&But[25],&curPt)!=0)// synth -> Post
			{
				SetCapture(hWnd);
				CurButId=25;
				if (Ass[2]==0)
					Ass[2]=127;
				else
					Ass[2]=0;
				mpuMessage(GM_POST,&Ass[2],1);
				PressButton(&But[25],hWnd);
			}
			if(InButton(&But[26],&curPt)!=0)// fx -> Post
			{
				SetCapture(hWnd);
				CurButId=26;
				if (Ass[3]==0)
					Ass[3]=127;
				else
					Ass[3]=0;
				mpuMessage(EFF_POST,&Ass[3],1);
				PressButton(&But[26],hWnd);
			}
			if(InButton(&But[27],&curPt)!=0)// Flat Eq
			{
				SetCapture(hWnd);
				CurButId=27;
				FlatEQ(hWnd);
				PressButton(&But[27],hWnd);
			}
			if(InButton(&But[28],&curPt)!=0)// rec src = bus
			{
				SetCapture(hWnd);
				CurButId=28;
				RecSel=127;
			#ifdef DRIMIX			
				RCtrlD[0].cbStruct=sizeof(mxcd);
				RCtrlD[0].cbDetails=sizeof(MIXERCONTROLDETAILS_UNSIGNED);
				RCtrlD[0].cbDetails=sizeof(bdetVal[0][0].fValue);
				RCtrlD[0].dwControlID=dwDWaveInId;
				RCtrlD[0].cChannels=1;
				RCtrlD[0].hwndOwner=0;
				RCtrlD[0].cMultipleItems=2;			
				RCtrlD[0].paDetails=&bdetVal[0][0];
				bdetVal[0][0].fValue=0;
				bdetVal[0][1].fValue=1;  
				mmres=mixerSetControlDetails(hmx[1],(LPMIXERCONTROLDETAILS)&RCtrlD[0],MIXER_SETCONTROLDETAILSF_VALUE);
			
		
			#else
				mpuMessage(REC_SEL,&RecSel,1);
			#endif
				PressButton(&But[28],hWnd);
				PressButton(&But[29],hWnd);
			}
			if(InButton(&But[29],&curPt)!=0)// rec src =audio
			{
				SetCapture(hWnd);
				CurButId=29;
				RecSel=0;
			#ifdef DRIMIX 
				RCtrlD[0].cbStruct=sizeof(mxcd);
				RCtrlD[0].cbDetails=sizeof(MIXERCONTROLDETAILS_UNSIGNED);
				RCtrlD[0].cbDetails=sizeof(bdetVal[0][0].fValue);
				RCtrlD[0].dwControlID=dwDWaveInId;
				RCtrlD[0].cChannels=1;
				RCtrlD[0].hwndOwner=0;
				RCtrlD[0].cMultipleItems=2;			
				RCtrlD[0].paDetails=&bdetVal[0][0];
				bdetVal[0][0].fValue=1;
				bdetVal[0][1].fValue=0; 
				mmres=mixerSetControlDetails(hmx[1],(LPMIXERCONTROLDETAILS)&RCtrlD[0],MIXER_SETCONTROLDETAILSF_VALUE);
			#else
				mpuMessage(REC_SEL,&RecSel,1);
			#endif
				PressButton(&But[28],hWnd);
				PressButton(&But[29],hWnd);				
			}
			


			break; 
		case WM_SETFOCUS:
			if(first==0)
				first=1;
			else
				{
				if(ReadBackPresent)
					{
					if(ReadSamConfig((LPBYTE) SamTable)==TRUE)
						UpdateControls(hWnd);
					}
				}
			break;
			
		case WM_LBUTTONUP:
			if(Sly[CurSlyId].bSel)
				ReleaseCapture();
			if(Pot[CurPotId].bSel)
				ReleaseCapture();
			Sly[CurSlyId].bSel=FALSE;
			Pot[CurPotId].bSel=FALSE;
			if(CurButId!=-1)
				ReleaseButton(&But[CurButId],hWnd);
			
			break;
	/*	case WM_RBUTTONUP:
			RefreshValues(hWnd);
			break;  */
	/*	case WM_SIZE:
			ResizeMainWnd(hWnd,FRANB);
			break;*/

		case WM_MOUSEMOVE:
			curX=LOWORD(lParam);
			curY=HIWORD(lParam);
			curPt.x=curX;
			curPt.y=curY;
			/*#ifdef _DEBUG
				wsprintf((LPSTR)txt,"WM_MOUSEMOVE ( x = %d ,y = %d )\n\r",curX,curY);
				OutputDebugString((LPSTR)txt);
			#endif	*/
			for(i=0;i<POTNB;i++)
			{
				if(Pot[i].bSel)
				{
					//val=MovePot3(&Pot[i],&curPt,hWnd);
					val=MovePot4(&Pot[i],&curPt,hWnd);
					UpdateFromPot(i,val);
				}
			}
			for(i=0;i<SLYNB;i++)
				{
		    
				if(Sly[i].bSel)
					{		
					val=MoveSlider(&Sly[i],&curPt,hWnd);
					Sly[i].curt=val;
					UpdateFromSlider(i,val);
					if (val!=Sly[i].curt)
						{
/*						Mess.Chan=i;
						Mess.Value=65535-(((unsigned int)val)*512);
						Sly[i].curt=val;						
						mpuMessage(W_VOLLEFT,&Mess,3);
						mpuMessage(W_VOLRIGHT,&Mess,3);	*/
			/*		mxCtrlD[0].paDetails=&detVal[0];
						mxCtrlD[0].cbDetails=sizeof(MIXERCONTROLDETAILS_UNSIGNED);
						mxCtrlD[0].cbStruct=sizeof(MIXERCONTROLDETAILS);
						mxCtrlD[0].dwControlID=mxCtrl[0].dwControlID;
						detVal[0].dwValue=val;
						mmres=mixeSetControlDetailsr(hmx[0],(LPMIXERCONTROLDETAILS)&mxCtrlD[0],MIXER_SETCONTROLDETAILSF_VALUE);

						wsprintf((LPCSTR)txt,"mmres = %d\n\r",(unsigned int)mmres);

						OutputDebugString((LPCSTR)txt);*/
						}				    
					break;
					}
				}
			break;
         			
         case WM_DESTROY:
			 if(bExtMixer)
			 	{			 	
				mmres=mixerClose(hmx[0]);
				
				}
			 mmres=mixerClose(hmx[1]);
			 ReleaseAll(hWnd);
			 //SetMapMode(hDC,MapModePrevious);
			  //KillTimer(hWnd,idtimer);
              PostQuitMessage(0);
              break;

         default:
              return (DefWindowProc( hWnd, message, wParam, lParam ));
              break;
    }
    return(0L);
}
//*****************************************************
int InitBackGrnd(struct MyBackGnd *bak,int left,int top,HDC hdc,HANDLE hInst)
{
HBITMAP hBmp;
BITMAP Bm;
int bakwidth;
int bakheight;	
/*
bak->GlobRect.left=left;
bak->GlobRect.top=top;
bak->hDC = CreateCompatibleDC(hdc);
hBmp=LoadBitmap(hInst,(LPCSTR)IDB_GENERAL);
SelectObject(bak->hDC,hBmp);
GetObject(hBmp,sizeof(BITMAP),&Bm);
bakwidth=Bm.bmWidth;
bakheight=Bm.bmHeight;
bak->GlobRect.bottom=bak->GlobRect.top+bakheight;
bak->GlobRect.right=bak->GlobRect.left+bakwidth;*/
return(1);
}
//*****************************************************
void RedrawBackGrnd(RECT *rect,struct MyBackGnd *bak,PAINTSTRUCT *ps,HDC *hDC)
{
	/*
if(IntersectRect(rect, &(bak->GlobRect), &(ps->rcPaint)))
	BitBlt(*hDC,bak->GlobRect.left,bak->GlobRect.top,bak->GlobRect.right-bak->GlobRect.left,bak->GlobRect.bottom-bak->GlobRect.top,bak->hDC,0,0,SRCCOPY);  
*/
}

//*****************************************************
int InitButton(struct MyButton *but,int left,int top,int val,int stateNb,LPCSTR but1,LPCSTR but2,HDC hdc,HANDLE hInst,struct MyFrame *fra)
{
HBITMAP hBmp;
BITMAP Bm;
//BITMAPINFO bmi;
//HGDIOBJ oldobj;
int butwidth;
int butheight;
//int bmres,bibc;	
if(fra==NULL)
{
	but->GlobRect.left=left;
	but->GlobRect.top=top;
	but->visible=TRUE;
}
else
{
	but->GlobRect.left=left+fra->left;
	but->GlobRect.top=top+fra->top;
	but->visible=fra->visible;
}
//but->hDC1 = CreateCompatibleDC(hdc);
//but->hDC2 = CreateCompatibleDC(hdc);
but->curt=val;
but->bmp1=but1;
but->bmp2=but2;
but->statenb=stateNb;
hBmp=LoadBitmap(hInst,(LPCSTR)(but1));
//hBmp=LoadBitmap(hInst,(LPCSTR)IDB_SOLON);

GetObject(hBmp,sizeof(BITMAP),&Bm);
butwidth=Bm.bmWidth;
butheight=Bm.bmHeight;

//oldobj=SelectObject(but->hDC1,hBmp);
DeleteObject(hBmp);

//hBmp=LoadBitmap(hInst,(LPCSTR)(but2));
//SelectObject(but->hDC2,hBmp);
//DeleteObject(hBmp);
but->GlobRect.bottom=but->GlobRect.top+butheight;
but->GlobRect.right=but->GlobRect.left+butwidth;
return(1);
}
//*****************************************************
void RedrawButton(RECT *rect,struct MyButton *but,PAINTSTRUCT *ps,HDC hDC)
{ 
int i;
HDC hdc;
//HBITMAP oldobj;
HBITMAP hBmp;
if((IntersectRect(rect, &(but->GlobRect), &(ps->rcPaint)))&&(but->visible))
	if(but->curt==0)//FALSE
		{ 		
		hBmp=LoadBitmap(hInst,(MAKEINTRESOURCE(but->bmp1)));
		}
	else
		{	
		hBmp=LoadBitmap(hInst,(MAKEINTRESOURCE(but->bmp2))); 
		}
	hdc = CreateCompatibleDC(hDC);
	SelectObject(hdc,hBmp);
	i=BitBlt(hDC,but->GlobRect.left,but->GlobRect.top,but->GlobRect.right-but->GlobRect.left,but->GlobRect.bottom-but->GlobRect.top,hdc,0,0,SRCCOPY);  
	i=DeleteDC(hdc);	
	i=DeleteObject(hBmp);
	
}
//*****************************************************
void PressButton(struct MyButton *but,HWND hwnd)
{

	if(but->curt==0)//FALSE
		but->curt=1;
	else
		but->curt=0;		
	InvalidateRect(hwnd, &but->GlobRect, TRUE);
}
//*****************************************************
void ReleaseButton(struct MyButton *but,HWND hwnd)
{
	if (but->statenb==1)
		ToggleButton(but,hwnd);
	ReleaseCapture();
CurButId=-1;
}
//*****************************************************
void ToggleButton(struct MyButton *but,HWND hwnd)
{	
	if(but->curt==0)//FALSE
		but->curt=1;
	else
		but->curt=0;
	InvalidateRect(hwnd, &but->GlobRect, TRUE);
}
//*****************************************************
void SetButtonVal(struct MyButton *but,int val,HWND hwnd)
{
	but->curt=val;
	InvalidateRect(hwnd, &but->GlobRect, TRUE);
}
//*****************************************************
int InButton(struct MyButton *but,POINT *pt)
{
	if (!but->visible)
	return 0;
	if (pt->x < but->GlobRect.left)
		return 0;
	if (pt->x > but->GlobRect.right)
		return 0;
	if (pt->y < but->GlobRect.top)
		return 0;
	if (pt->y > but->GlobRect.bottom)
		return 0;
	return 1;
}
//*****************************************************
int SetSolo(int SelWave,HWND hWnd)
{
int j;
if(But[16].curt==0)
{//Mute all waves except the one selected
	SoloOn=1;
	for(j=0;j<8;j++)
	{
		if(j==SelWave)
		{
			WaveOn[j]=1;
			UpdateWaveVol(j);
			SetButtonVal(&But[j],1,hWnd);
		}
		else
		{
			WaveOn[j]=0;
			UpdateWaveVol(j);
			SetButtonVal(&But[j],0,hWnd);
		}
	}
}
else
{//demute waves that were not muted before Solo
	SoloOn=0;
	for(j=0;j<8;j++)
	{
		if(WaveMuted[j]==1)
		{
			WaveOn[j]=0;
			UpdateWaveVol(j);
			SetButtonVal(&But[j],0,hWnd);
		}
		else
		{
			WaveOn[j]=1;
			UpdateWaveVol(j);
			SetButtonVal(&But[j],1,hWnd);
		}
	}
}
PressButton(&But[16],hWnd);
}

//*****************************************************
void MuteWave(struct MyButton *but,int WaveId,HWND hwnd)
{
int i=0;
	if(but->curt==0)//if button is Off
	{
		
			but->curt=1;// set it on
			WaveMuted[WaveId]=0;//this wave is not muted
			WaveOn[WaveId]=1;
			UpdateWaveVol(WaveId);
	}
	else
	{
		but->curt=0;//set it off
		WaveMuted[WaveId]=1;// mark wave as muted
		WaveOn[WaveId]=0;
		UpdateWaveVol(WaveId);
	}
	InvalidateRect(hwnd, &but->GlobRect, TRUE);
}
//**************************************************************************
/*
void RedrawLCD(RECT *rect,struct MyLCD *lcd,PAINTSTRUCT *ps,HDC *hDC)
{
LPCSTR strptr;
HFONT hOldFont;
HPEN hpen,hpenOld,hp;
LPSTR txtpt; 
if((IntersectRect(rect, &(lcd->GlobRect), &(ps->rcPaint)))&&(lcd->visible))
	{
	hOldFont=SelectObject(*hDC,hNewFont);
	hpen = CreatePen(PS_SOLID,1,RGB(0,0,0));
	hpenOld = SelectObject(*hDC, hpen);
	BitBlt(*hDC,lcd->GlobRect.left,lcd->GlobRect.top,lcd->GlobRect.right-lcd->GlobRect.left,lcd->GlobRect.bottom-lcd->GlobRect.top,lcd->hDc,0,0,SRCCOPY);  
	SetBkMode(*hDC,TRANSPARENT);
	txtpt=lcd->ptxt+(unsigned long)(10*lcd->curt);
	TextOut(*hDC, lcd->GlobRect.left+2, lcd->GlobRect.top+2,txtpt, strlen(txtpt));
	SelectObject(*hDC, hpenOld);
	SelectObject(*hDC,hOldFont);
	}
}*/
//**************************************************************************
void RedrawLCD(RECT *rect,struct MyLCD *lcd,PAINTSTRUCT *ps,HDC hDC)
{
//LPCSTR strptr;
HFONT hOldFont;
HPEN hpen,hpenOld;
LPSTR txtpt;
HDC hdc;
HBITMAP hBmp;
HBITMAP oldobj;
COLORREF OldColor;
int i; 
if((IntersectRect(rect, &(lcd->GlobRect), &(ps->rcPaint)))&&(lcd->visible))
	{
	//hDC=GetDC(hWnd);
	hBmp=LoadBitmap(hInst,(MAKEINTRESOURCE(lcd->bmp)));
	hdc = CreateCompatibleDC(hDC);
	oldobj=SelectObject(hdc,hBmp);
	i=BitBlt(hDC,lcd->GlobRect.left,lcd->GlobRect.top,lcd->GlobRect.right-lcd->GlobRect.left,lcd->GlobRect.bottom-lcd->GlobRect.top,hdc,0,0,SRCCOPY);  
	//SelectObject(hdc,oldobj);
	DeleteDC(hdc);
	DeleteObject(hBmp);
	OldColor=SetTextColor(hDC,RGB(0,0,0));
	
	hOldFont=SelectObject(hDC,hNewFont);
	//hpen = CreatePen(PS_SOLID,1,RGB(0,0,0));
	hpenOld = SelectObject(hDC, hpen);
	i=SetBkMode(hDC,TRANSPARENT);
	txtpt=lcd->ptxt+10*(lcd->curt);
	i=TextOut(hDC, lcd->GlobRect.left+2, lcd->GlobRect.top+2,txtpt, strlen(txtpt));
	
	//i=SelectObject(hDC, hpenOld);
	i=SelectObject(hDC,hOldFont);
	//DeleteObject(hpen);
	SetTextColor(hDC,OldColor);
	}
}

//**************************************************************************
void RedrawLCD2(struct MyLCD *lcd,HWND hWnd)
{
HFONT hOldFont;
HPEN hpen,hpenOld;
LPSTR txtpt;
HDC hdc;
HBITMAP hBmp;
HBITMAP oldobj;
COLORREF OldColor;
HDC hDC;
int i; 

	hDC=GetDC(hWnd);
	hBmp=LoadBitmap(hInst,(MAKEINTRESOURCE(lcd->bmp)));
	hdc = CreateCompatibleDC(hDC);
	oldobj=SelectObject(hdc,hBmp);
	i=BitBlt(hDC,lcd->GlobRect.left,lcd->GlobRect.top,lcd->GlobRect.right-lcd->GlobRect.left,lcd->GlobRect.bottom-lcd->GlobRect.top,hdc,0,0,SRCCOPY);  
	//SelectObject(hdc,oldobj);
	DeleteDC(hdc);
	DeleteObject(hBmp);
	OldColor=SetTextColor(hDC,RGB(0,0,0));
	
	hOldFont=SelectObject(hDC,hNewFont);
	//hpen = CreatePen(PS_SOLID,1,RGB(0,0,0));
	//hpenOld = SelectObject(hDC, hpen);
	i=SetBkMode(hDC,TRANSPARENT);
	txtpt=lcd->ptxt;
	i=TextOut(hDC, lcd->GlobRect.left+2, lcd->GlobRect.top+2,txtpt, strlen(txtpt));
	
	//i=SelectObject(hDC, hpenOld);
	i=SelectObject(hDC,hOldFont);
	//DeleteObject(hpen);
	SetTextColor(hDC,OldColor);
	ReleaseDC(hWnd,hDC);
	
}
//*****************************************************
int InitLCD(struct MyLCD *lcd,int left,int top,int curt,LPSTR ptxt,HDC hdc,HANDLE hInst,struct MyFrame *fra)
{

HBITMAP hBmp;
BITMAP Bm;
int lcdwidth;
int lcdheight;
	
if(fra==NULL)
{
	lcd->GlobRect.left=left;
	lcd->GlobRect.top=top;
	lcd->visible=TRUE;
}
else
{
	lcd->GlobRect.left=fra->left+left;
	lcd->GlobRect.top=fra->top+top;
	lcd->visible=fra->visible;
}
//lcd->hDc = CreateCompatibleDC(hdc);
hBmp=LoadBitmap(hInst,(LPCSTR)IDB_LCD);
lcd->bmp=IDB_LCD;
GetObject(hBmp,sizeof(BITMAP),&Bm);
lcdwidth=Bm.bmWidth;
lcdheight=Bm.bmHeight;
lcd->GlobRect.right=lcd->GlobRect.left+lcdwidth;
lcd->GlobRect.bottom=lcd->GlobRect.top+lcdheight;
//SelectObject(lcd->hDc,hBmp);
DeleteObject(hBmp);
lcd->curt=curt;
lcd->ptxt=ptxt;
return(1);
}

//*****************************************************
int IncLCD(struct MyLCD *lcd,int Inc,HWND hwnd)
{
int temp;
temp=lcd->curt + Inc;
if (temp<0)
	temp+=8;
temp=temp%8;
lcd->curt=temp;
InvalidateRect(hwnd, &lcd->GlobRect, TRUE);
return(temp);
}
//*****************************************************
void InitMyScreen(HWND hWnd,HANDLE hInst)
{
HDC hDC;
int i;
int MapModePrevious,iPtSize=7;
			

			hDC = GetDC(hWnd);
			
			MapModePrevious=SetMapMode(hDC,MM_TWIPS);
			hNewFont = CreateFont(-iPtSize,0,0,0,0,0,0,0,0,0,0,0,0, "Small Fonts");
			
			InitBackGrnd(&Back,0,0,hDC,hInst);
		  //InitPot2(*pot,left,top,centerx,centery,radius,min,max,cur,minTeta,maxTeta,hdc,hInst);
//--------- Inputs --------------
			InitText(&Texte[0], 9, 4,(LPSTR) cMic,RGB(0,0,0), &Frame[0]);
			InitText(&Texte[1],30, 4,(LPSTR) cLine,RGB(0,0,0), &Frame[0]);
			InitText(&Texte[2],54, 4,(LPSTR) cCD,RGB(0,0,0), &Frame[0]);
			InitText(&Texte[3],30,20,(LPSTR) cPan,RGB(0,0,128), &Frame[0]);
			InitText(&Texte[4],52,20,(LPSTR) cPan,RGB(0,0,128), &Frame[0]);
			InitPot2(&Pot[0], 5,28,9,9,6,0,0,0,0,5.24,hDC,hInst,&Frame[0]);
			InitPot2(&Pot[1],27,28,9,9,6,0,127,LinePan,0,5.24,hDC,hInst,&Frame[0]);
			InitPot2(&Pot[2],49,28,9,9,6,0,127,CDPan,0,5.24,hDC,hInst,&Frame[0]);
		  //InitSlider(*sly,left, top,size,orient, min, max, cur, hdc, hInst)  SB_VERT or SB_HORZ
			InitSlider2(&Sly[0],5,48,19,63,SB_VERT,MicMin,MicMax, MicVol,(LPCSTR)IDB_VFLY,(LPCSTR)IDB_SLOT,hDC,hInst,&Frame[0]);
			InitSlider2(&Sly[1],27,48,19,63,SB_VERT,LineMin,LineMax, LineVol,(LPCSTR)IDB_VFLY,(LPCSTR)IDB_SLOT,hDC,hInst,&Frame[0]);
			InitSlider2(&Sly[2],49,48,19,63,SB_VERT,CDMin,CDMax, CDVol,(LPCSTR)IDB_VFLY,(LPCSTR)IDB_SLOT,hDC,hInst,&Frame[0]);
//--------- Master In --------------
			InitText(&Texte[5],10, 4,(LPSTR) cMaster,RGB(0,0,0), &Frame[1]);
			InitText(&Texte[6], 8,20,(LPSTR) cPan,RGB(0,0,128), &Frame[1]);
			InitText(&Texte[7],30,20,(LPSTR) cPan,RGB(0,0,128), &Frame[1]);
			if(InChrs==1)
			{
				InitText(&Texte[ 8],56,20,(LPSTR) cRev,RGB(0,0,0), &Frame[1]);
				InitText(&Texte[43],53,48,(LPSTR) cChrs,RGB(0,0,0), &Frame[1]);
				InitText(&Texte[ 9],53,76,(LPSTR) cEcho,RGB(0,0,0), &Frame[1]);			
			}
			else
			{		
				InitText(&Texte[8],56,37,(LPSTR) cRev,RGB(0,0,0), &Frame[1]);
				if(DVolId!=-1)
					InitText(&Texte[9],53,69,(LPSTR) cEcho,RGB(0,0,0), &Frame[1]);
			}
			
			InitPot2(&Pot[3], 5,28,9,9,6,0,127,MstInPan[0],0,5.24,hDC,hInst,&Frame[1]);
			InitPot2(&Pot[4],27,28,9,9,6,0,127,MstInPan[1],0,5.24,hDC,hInst,&Frame[1]);
		//	InitPot2(&Pot[5],53,45,9,9,6,0,127,MstInFx[0],0,5.24,hDC,hInst,&Frame[1]);
		//	InitPot2(&Pot[6],53,77,9,9,6,0,127,MstInFx[1],0,5.24,hDC,hInst,&Frame[1]);
		if(InChrs==1)
			{ 
				InitPot2(&Pot[ 5],53,28,9,9,6,0,127,MstInFx[0],0,5.24,hDC,hInst,&Frame[1]);
				InitPot2(&Pot[28],53,57,9,9,6,0,127,MstInFx[2],0,5.24,hDC,hInst,&Frame[1]);  //new: chorus
				InitPot2(&Pot[ 6],53,84,9,9,6,0,127,MstInFx[1],0,5.24,hDC,hInst,&Frame[1]);
			}
		else
			{
			 	InitPot2(&Pot[5],53,45,9,9,6,0,127,MstInFx[0],0,5.24,hDC,hInst,&Frame[1]);
			 	if(DVolId!=-1)
					InitPot2(&Pot[6],53,77,9,9,6,0,127,MstInFx[1],0,5.24,hDC,hInst,&Frame[1]);
			}
			InitSlider2(&Sly[3], 5,48,19,63,SB_VERT,0,255, MstInVol[0],(LPCSTR)IDB_VFLY,(LPCSTR)IDB_SLOT,hDC,hInst,&Frame[1]);
			InitSlider2(&Sly[4],27,48,19,63,SB_VERT,0,255, MstInVol[1],(LPCSTR)IDB_VFLY,(LPCSTR)IDB_SLOT,hDC,hInst,&Frame[1]);
//--------- Waves --------------
			InitText(&Texte[10],33, 4,(LPSTR) cWaves,RGB(0,0,0), &Frame[2]);
			InitText(&Texte[11], 7,13,(LPSTR) cPan,RGB(0,0,128), &Frame[2]);
			InitText(&Texte[12],26,13,(LPSTR) cFilter,RGB(0,0,128), &Frame[2]);
			InitText(&Texte[13], 8,40,(LPSTR) cVol,RGB(0,0,128), &Frame[2]);
			InitText(&Texte[14],27,40,(LPSTR) cPitch,RGB(0,0,128), &Frame[2]);
			InitText(&Texte[15],55,37,(LPSTR) cRev,RGB(0,0,0), &Frame[2]);
			InitText(&Texte[16],52,69,(LPSTR) cChrs,RGB(0,0,0), &Frame[2]);
			InitText(&Texte[41],77,4,(LPSTR) cOn,RGB(0,0,0), &Frame[2]);
			InitText(&Texte[42],89,4,(LPSTR) cSel,RGB(0,0,127), &Frame[2]);
			InitPot2(&Pot[ 7], 5,21,9,9,6,0,127,WavePan[0],0,5.24,hDC,hInst,&Frame[2]);
			InitPot2(&Pot[ 8],27,21,9,9,6,0,65535,WaveFc[0],0,5.24,hDC,hInst,&Frame[2]);
			InitPot2(&Pot[ 9],52,45,9,9,6,0,65535,WaveRL[0],0,5.24,hDC,hInst,&Frame[2]);
/**/		InitPot2(&Pot[10],52,77,9,9,6,0,65535,WaveRR[0],0,5.24,hDC,hInst,&Frame[2]);
			InitSlider2(&Sly[5], 5,48,19,63,SB_VERT,0,65535, WaveVol[0],(LPCSTR)IDB_VFLY,(LPCSTR)IDB_SLOT,hDC,hInst,&Frame[2]);
			InitSlider2(&Sly[6],27,48,19,63,SB_VERT,0,65535, WavePt[0],(LPCSTR)IDB_VFLY,(LPCSTR)IDB_SLOT,hDC,hInst,&Frame[2]);
/**/		//InitSlider2(&Sly[7],231,34,19,63,SB_VERT,0,65535, WavePt[0],hDC,hInst,&Frame[2]);
			i=0;
			InitButton(&But[  i],76,11+11*i,1,2,(LPCSTR)(IDB_OFF1+i*4),(LPCSTR)(IDB_ON1+i*4),hDC,hInst,&Frame[2]);
			InitButton(&But[8+i],89,11+11*i,1,2,(LPCSTR)(IDB_UN1+i*4),(LPCSTR)(IDB_SEL1+i*4),hDC,hInst,&Frame[2]);
			for(i=1;i<8;i++)
				{
				InitButton(&But[  i],76,11+11*i,1,2,(LPCSTR)(IDB_OFF1+i*4),(LPCSTR)(IDB_ON1+i*4),hDC,hInst,&Frame[2]);
				InitButton(&But[8+i],89,11+11*i,0,2,(LPCSTR)(IDB_UN1+i*4),(LPCSTR)(IDB_SEL1+i*4),hDC,hInst,&Frame[2]);
				}
			InitButton(&But[16],76,100,0,2,(LPCSTR)IDB_SOLOOFF,(LPCSTR)IDB_SOLOON,hDC,hInst,&Frame[2]);
//--------- Synth --------------
			InitText(&Texte[17],19, 4,(LPSTR) cSynth,RGB(0,0,0), &Frame[3]);
			InitText(&Texte[18], 6,20,(LPSTR) cPan,RGB(0,0,128), &Frame[3]);
			InitText(&Texte[19],32,37,(LPSTR) cRev,RGB(0,0,0), &Frame[3]);
			InitText(&Texte[20],29,69,(LPSTR) cChrs,RGB(0,0,0), &Frame[3]);
			InitPot2(&Pot[11], 3,29,9,9,6,0,127,SynPan,0,5.24,hDC,hInst,&Frame[3]);
			InitPot2(&Pot[12],29,45,9,9,6,0,255,SynRev,0,5.24,hDC,hInst,&Frame[3]);
			InitPot2(&Pot[13],29,77,9,9,6,0,255,SynChr,0,5.24,hDC,hInst,&Frame[3]);
			InitSlider2(&Sly[7],3,48,19,63,SB_VERT,0,255, SynVol,(LPCSTR)IDB_VFLY,(LPCSTR)IDB_SLOT,hDC,hInst,&Frame[3]);
//--------- Reverb --------------
			InitText(&Texte[21],15, 4,(LPSTR) cReverb,RGB(0,0,0), &Frame[4]);
			InitText(&Texte[22], 7,42,(LPSTR) cTime,RGB(0,0,0), &Frame[4]);
			InitText(&Texte[23],36,42,(LPSTR) cFb,RGB(0,0,0), &Frame[4]);
			InitText(&Texte[24],18,76,(LPSTR) cEcho,RGB(0,0,0), &Frame[4]);
			InitText(&Texte[25], 7,85,(LPSTR) cTime,RGB(0,0,0), &Frame[4]);
			InitText(&Texte[26],36,85,(LPSTR) cFb,RGB(0,0,0), &Frame[4]);
			InitText(&Texte[27],68, 4,(LPSTR) cChorus,RGB(0,0,0), &Frame[4]);
			InitText(&Texte[28],63,42,(LPSTR) cRate,RGB(0,0,0), &Frame[4]);
			InitText(&Texte[29],85,42,(LPSTR) cDelay,RGB(0,0,0), &Frame[4]);
			InitText(&Texte[30],60,85,(LPSTR) cDepth,RGB(0,0,0), &Frame[4]);
			InitText(&Texte[31],92,85,(LPSTR) cFb,RGB(0,0,0), &Frame[4]);
			
			InitPot2(&Pot[14], 6,50,9,9,6,0,127,RevVal[0],0,5.24,hDC,hInst,&Frame[4]);
			InitPot2(&Pot[15],30,50,9,9,6,0,127,RevVal[1],0,5.24,hDC,hInst,&Frame[4]);
			InitButton(&But[19], 5,28,0,1,(LPCSTR)IDB_MINUSUP,(LPCSTR)IDB_MINUSDWN,hDC,hInst,&Frame[4]);
			InitButton(&But[20],29,28,0,1,(LPCSTR)IDB_PLUSUP,(LPCSTR)IDB_PLUSDWN,hDC,hInst,&Frame[4]);
		  //InitLCD(&lcd,left,top,width,height,xoff,yoff,char* txt,txtid,charnb)
			InitLCD(&Lcd[0], 5,14,RevType,(LPSTR)ReverbTxt,hDC,hInst,&Frame[4]);

//--------- Echo --------------
			InitPot2(&Pot[16], 6,93,9,9,6,0,127,EchoVal[0],0,5.24,hDC,hInst,&Frame[4]);
			InitPot2(&Pot[17],30,93,9,9,6,0,127,EchoVal[1],0,5.24,hDC,hInst,&Frame[4]);
//--------- Chorus --------------
			InitPot2(&Pot[18],62,50,9,9,6,0,127,ChrVal[0],0,5.24,hDC,hInst,&Frame[4]);
			InitPot2(&Pot[19],86,50,9,9,6,0,127,ChrVal[1],0,5.24,hDC,hInst,&Frame[4]);
			InitPot2(&Pot[20],62,93,9,9,6,0,127,ChrVal[2],0,5.24,hDC,hInst,&Frame[4]);
			InitPot2(&Pot[21],86,93,9,9,6,0,127,ChrVal[3],0,5.24,hDC,hInst,&Frame[4]);
			InitButton(&But[21],61,28,0,1,(LPCSTR)IDB_MINUSUP,(LPCSTR)IDB_MINUSDWN,hDC,hInst,&Frame[4]);
			InitButton(&But[22],85,28,0,1,(LPCSTR)IDB_PLUSUP,(LPCSTR)IDB_PLUSDWN,hDC,hInst,&Frame[4]);
			InitLCD(&Lcd[1],61,14,ChrType,(LPSTR)ChorusTxt,hDC,hInst,&Frame[4]);
//--------- Equalizer --------------
			InitText(&Texte[32],28, 4,(LPSTR) cEqualizer,RGB(0,0,0), &Frame[8]);
			InitText(&Texte[33], 8,17,(LPSTR) cLow,RGB(0,0,128), &Frame[8]);
			InitText(&Texte[34],28,17,(LPSTR) cMidL,RGB(0,0,128), &Frame[8]);
			InitText(&Texte[35],49,17,(LPSTR) cMidH,RGB(0,0,128), &Frame[8]);
			InitText(&Texte[36],72,17,(LPSTR) cHigh,RGB(0,0,128), &Frame[8]);
			
			
			InitPot2(&Pot[22], 5,27,9,9,6,0,127,EqFreq[0],0,5.24,hDC,hInst,&Frame[8]);
			InitPot2(&Pot[23],27,27,9,9,6,0,127,EqFreq[1],0,5.24,hDC,hInst,&Frame[8]);
			InitPot2(&Pot[24],49,27,9,9,6,0,127,EqFreq[2],0,5.24,hDC,hInst,&Frame[8]);
			InitPot2(&Pot[25],71,27,9,9,6,0,127,EqFreq[3],0,5.24,hDC,hInst,&Frame[8]);
			InitSlider2(&Sly[ 8], 5,48,19,63,SB_VERT,0,127, EqVol[0],(LPCSTR)IDB_VFLY,(LPCSTR)IDB_SLOTC,hDC,hInst,&Frame[8]);
			InitSlider2(&Sly[ 9],27,48,19,63,SB_VERT,0,127, EqVol[1],(LPCSTR)IDB_VFLY,(LPCSTR)IDB_SLOTC,hDC,hInst,&Frame[8]);
			InitSlider2(&Sly[10],49,48,19,63,SB_VERT,0,127, EqVol[2],(LPCSTR)IDB_VFLY,(LPCSTR)IDB_SLOTC,hDC,hInst,&Frame[8]);
			InitSlider2(&Sly[11],71,48,19,63,SB_VERT,0,127, EqVol[3],(LPCSTR)IDB_VFLY,(LPCSTR)IDB_SLOTC,hDC,hInst,&Frame[8]);
//--------- 3D --------------
			InitText(&Texte[37],2,4,(LPSTR) cSurrnd,RGB(0,0,0), &Frame[9]);
			InitText(&Texte[38],7,25,(LPSTR) cDelay,RGB(0,0,127), &Frame[9]);
			InitText(&Texte[39],7,62,(LPSTR) cDepth,RGB(0,0,127), &Frame[9]);
			InitPot2(&Pot[26], 8,33,9,9,6,0,127,SurRnd[0],0,5.24,hDC,hInst,&Frame[9]);
			InitPot2(&Pot[27], 8,70,9,9,6,0,255,SurRnd[1],0,5.24,hDC,hInst,&Frame[9]);
			if (SurSel[0]==0)
				InitButton(&But[17],5,95,0,2,(LPCSTR)IDB_MONOOFF,(LPCSTR)IDB_MONOON,hDC,hInst,&Frame[9]);
			else
				InitButton(&But[17],5,95,1,2,(LPCSTR)IDB_MONOOFF,(LPCSTR)IDB_MONOON,hDC,hInst,&Frame[9]);
			if (SurSel[1]==0)	
				InitButton(&But[18],5,110,0,2,(LPCSTR)IDB_4OUTOFF,(LPCSTR)IDB_4OUTON,hDC,hInst,&Frame[9]);
			else
				InitButton(&But[18],5,110,1,2,(LPCSTR)IDB_4OUTOFF,(LPCSTR)IDB_4OUTON,hDC,hInst,&Frame[9]);
			
			//InitSlider(&Sly,100,100,100,SB_VERT,0,100, 50,hDC,hInst);						            
			
			
			if (Ass[0]==0)
					InitButton(&But[23],26,118,0,2,(LPCSTR)IDB_RECOFF,(LPCSTR)IDB_RECON,hDC,hInst,&Frame[1]);
				else
					InitButton(&But[23],26,118,1,2,(LPCSTR)IDB_RECOFF,(LPCSTR)IDB_RECON,hDC,hInst,&Frame[1]);
			
			if (Ass[1]==0)
					InitButton(&But[24],38,118,0,2,(LPCSTR)IDB_RECOFF,(LPCSTR)IDB_RECON,hDC,hInst,&Frame[2]);
				else					
					InitButton(&But[24],38,118,1,2,(LPCSTR)IDB_RECOFF,(LPCSTR)IDB_RECON,hDC,hInst,&Frame[2]);
			if (Ass[2]==0)
					InitButton(&But[25],10,118,0,2,(LPCSTR)IDB_RECOFF,(LPCSTR)IDB_RECON,hDC,hInst,&Frame[3]);
				else					
					InitButton(&But[25],10,118,1,2,(LPCSTR)IDB_RECOFF,(LPCSTR)IDB_RECON,hDC,hInst,&Frame[3]);
			if (Ass[3]==0)
					InitButton(&But[26],38,118,0,2,(LPCSTR)IDB_RECOFF,(LPCSTR)IDB_RECON,hDC,hInst,&Frame[4]);
				else
					InitButton(&But[26],38,118,1,2,(LPCSTR)IDB_RECOFF,(LPCSTR)IDB_RECON,hDC,hInst,&Frame[4]);
					
			InitButton(&But[27],29,118,0,1,(LPCSTR)IDB_FLATUP,(LPCSTR)IDB_FLATDWN,hDC,hInst,&Frame[8]);
			
			//----------------- Record ----------------
			InitText(&Texte[40],3,4,(LPSTR) cRecord,RGB(0,0,0), &Frame[10]);
			if(RecSel==0)// rec src =audio
				{
				//InitButton(&But[28], 4,95,1,2,(LPCSTR)IDB_BUSON,(LPCSTR)IDB_BUSOFF,hDC,hInst,&Frame[10]);
				//InitButton(&But[29], 4,110,0,2,(LPCSTR)IDB_AUDIOON,(LPCSTR)IDB_AUDIOOFF,hDC,hInst,&Frame[10]);								
				InitButton(&But[28], 4,14,1,2,(LPCSTR)IDB_BUSON,(LPCSTR)IDB_BUSOFF,hDC,hInst,&Frame[10]);
				InitButton(&But[29], 4,29,0,2,(LPCSTR)IDB_AUDIOON,(LPCSTR)IDB_AUDIOOFF,hDC,hInst,&Frame[10]);
				}
			else
				{
				InitButton(&But[28], 4,14,0,2,(LPCSTR)IDB_BUSON,(LPCSTR)IDB_BUSOFF,hDC,hInst,&Frame[10]);
				InitButton(&But[29], 4,29,1,2,(LPCSTR)IDB_AUDIOON,(LPCSTR)IDB_AUDIOOFF,hDC,hInst,&Frame[10]);			
				}
			//----------------- Main ----------------
			InitText(&Texte[44],3,4,(LPSTR) cMain,RGB(0,0,0), &Frame[11]); 
            InitSlider2(&Sly[12],8,17,19,63,SB_VERT,0,255, MainVol,(LPCSTR)IDB_VFLY,(LPCSTR)IDB_SLOT,hDC,hInst,&Frame[11]);

			
			ReleaseDC(hWnd, hDC);
}
//****************************************************************
void UpdateFromPot(int i,unsigned int Val)
{
unsigned char cVal;
//unsigned int iVal;
WORD uVal1,uVal2;
//unsigned long lVal;
float lVal1,lVal2;
unsigned int pan,vol;
MIXERCONTROLDETAILS mxcd;
MIXERCONTROLDETAILS_UNSIGNED dwDetails[2];
MMRESULT mmres; 
	switch(i)
	{
	case 0://Mic Pan
		break;

	case 1://Line Pan
		pan=Val;
		vol=Sly[1].curt;
		if(pan<64)
		{
			lVal1=(float)vol;
			lVal2=((float)vol*(float)pan)/63;
		}
		else
		{
			lVal1=((float)vol*(float)(127-pan))/63;
			lVal2=(float)vol;
		}
		detVal[LineId][0].dwValue=(UINT)lVal1;
		detVal[LineId][1].dwValue=(UINT)lVal2;
		mmres=mixerSetControlDetails(hmx[0],(LPMIXERCONTROLDETAILS)&mxCtrlD[LineId],MIXER_SETCONTROLDETAILSF_VALUE);
		#ifdef _DEBUG
			wsprintf((LPCSTR)txt,"LinePan mmres = %d\n\r",(unsigned int)mmres);
			OutputDebugString((LPCSTR)txt);
		#endif
		break;

	case 2://CD Pan
		pan=Val;
		vol=Sly[2].curt;
		if(pan<64)
		{
			lVal1=vol;
			lVal2=((float)vol*(float)pan)/63;
		}
		else
		{
			lVal1=((float)vol*(float)(127-pan))/63;
			lVal2=vol;
		}
		detVal[CDId][0].dwValue=(UINT)lVal1;
		detVal[CDId][1].dwValue=(UINT)lVal2;
		mmres=mixerSetControlDetails(hmx[0],(LPMIXERCONTROLDETAILS)&mxCtrlD[CDId],MIXER_SETCONTROLDETAILSF_VALUE);
		#ifdef _DEBUG
			wsprintf((LPCSTR)txt,"CDPan mmres = %d\n\r",(unsigned int)mmres);
			OutputDebugString((LPCSTR)txt);
		#endif
		break;

	case 3://Master L Pan
		MstInPan[0]=Val;
		cVal=(unsigned char)Val;			 
		mpuMessage(AUDL_PAN,&cVal,1);	
		break;

	case 4://Master R Pan
		MstInPan[1]=Val;
		cVal=(unsigned char)Val;			 
		mpuMessage(AUDR_PAN,&cVal,1);	
		break;

	case 5://Master Rev Send
		MstInFx[0]=Val;
		cVal=(unsigned char)Val;			 
		mpuMessage(AUDREV_SEND,&cVal,1);	
		break;

	case 6://Master Echo Send
		MstInFx[1]=Val;
		cVal=(unsigned char)Val;			 
		mpuMessage(ECH_LEV,&cVal,1);	
		break;
		
	case 28://Master Chrs Send
		MstInFx[2]=Val;
		cVal=(unsigned char)Val;		 
		mpuMessage(AUDCHR_SEND,&cVal,1);
		break;

	case 7://Wave Pan
		pan=Val;
		vol=Sly[5].curt;
		
		if(pan<64)
		{
			lVal1=(float)vol;
			lVal2=((float)vol*(float)pan)/63;
		}
		else
		{
			lVal1=((float)vol*(float)(127-pan))/63;
			lVal2=vol;
		}
		WaveVol[CurtWave]=vol;
		WavePan[CurtWave]=pan;
		WaveFL[CurtWave]=(UINT)lVal1;
		WaveFR[CurtWave]=(UINT)lVal2;
		uVal1=(WaveOn[CurtWave])*(WaveFL[CurtWave]);			
		uVal2=(WaveOn[CurtWave])*(WaveFR[CurtWave]);
		waveSetMainVolume((WORD)(FirstDreamWaveId+CurtWave),uVal1,uVal2);			
	
		break;

	case 8://Wave Filter
		WaveFc[CurtWave]=Val;
		uVal1=WaveFc[CurtWave];
		waveSetFilter((WORD)(FirstDreamWaveId+CurtWave),WAVE_FC,uVal1);			
		break;

	case 9://wave reverb
		WaveRL[CurtWave]=Val;
		uVal1=(WaveOn[CurtWave])*(WaveRL[CurtWave]);			
		uVal2=(WaveOn[CurtWave])*(WaveRR[CurtWave]); 			
		waveSetAuxVolume((WORD)(FirstDreamWaveId+CurtWave),uVal1,uVal2);			
		break;

	case 10://Wave chorus
		WaveRR[CurtWave]=Val;
		uVal1=(WaveOn[CurtWave])*(WaveRL[CurtWave]);			
		uVal2=(WaveOn[CurtWave])*(WaveRR[CurtWave]); 			
		waveSetAuxVolume((WORD)(FirstDreamWaveId+CurtWave),uVal1,uVal2);	
		break;

	

	case 11://Synth Pan
		SynPan=Val;
	#ifdef DRIMIX
	    pan=SynPan;
		vol=SynVol;
		if(pan<64)
		{
			lVal1=(float)vol;
			lVal2=((float)vol*(float)pan)/63;
		}
		else
		{
			lVal1=((float)vol*(float)(127-pan))/63;
			lVal2=(float)vol;
		}
		
		    mxcd.cbStruct=sizeof(mxcd);
			mxcd.cbDetails=sizeof(MIXERCONTROLDETAILS_UNSIGNED);
			mxcd.dwControlID=dwDMidiId;
			mxcd.cChannels=2;
			mxcd.cMultipleItems=0;
			mxcd.hwndOwner=0;
			mxcd.paDetails=(LPDWORD)dwDetails;
			dwDetails[0].dwValue=((WORD)((BYTE)lVal1)<<8);
			dwDetails[1].dwValue=((WORD)((BYTE)lVal2)<<8);    
			mmres=mixerSetControlDetails(hmx[1],(LPMIXERCONTROLDETAILS)&mxcd,MIXER_SETCONTROLDETAILSF_VALUE);
		
	
	#else
		SynPan=Val;
		cVal=(unsigned char)Val;			 
		mpuMessage(GM_PAN,&cVal,1);
	#endif
		break;

	case 12://Synth Rev Send
		SynRev=Val;
		cVal=(unsigned char)Val;			 
		mpuMessage(GMREV_SEND,&cVal,1);
		break;

	case 13://Synth Chorus Send
		SynChr=Val;
		cVal=(unsigned char)Val;			 
		mpuMessage(GMCHR_SEND,&cVal,1);
		break;

	case 14://Reverb time
		RevVal[0]=Val;
		cVal=(unsigned char)Val;			 
		mpuMessage(REV_TIME,&cVal,1);
		break;

	case 15://Reverb Feedback
		RevVal[1]=Val;
		cVal=(unsigned char)Val;			 
		mpuMessage(REV_FEED,&cVal,1);
		break;

	case 16://Echo Time
		EchoVal[0]=Val;
		cVal=(unsigned char)Val;			 
		mpuMessage(ECH_TIM,&cVal,1);
		break;

	case 17://Echo Feedback
		EchoVal[1]=Val;
		cVal=(unsigned char)Val;			 
		mpuMessage(ECH_FEED,&cVal,1);
		break;

	case 18://Chorus Rate
		ChrVal[0]=Val;
		cVal=(unsigned char)Val;			 
		mpuMessage(CHR_RATE,&cVal,1);
		break;

	case 19://Chorus Delay
		ChrVal[1]=Val;
		cVal=(unsigned char)Val;			 
		mpuMessage(CHR_DEL,&cVal,1);
		break;

	case 20://Chorus Depth
		ChrVal[2]=Val;
		cVal=(unsigned char)Val;			 
		mpuMessage(CHR_DEPTH,&cVal,1);
		break;

	case 21://Chorus Feedback
		ChrVal[3]=Val;
		cVal=(unsigned char)Val;			 
		mpuMessage(CHR_FEED,&cVal,1);
		break;

	case 22://Equalizer low freq
		EqFreq[0]=Val;
		cVal=(unsigned char)Val;			 
		mpuMessage(EQF_LB,&cVal,1);
		break;

	case 23://Equalizer low-mid freq
		EqFreq[1]=Val;
		cVal=(unsigned char)Val;			 
		mpuMessage(EQF_MLB,&cVal,1);
		break;

	case 24://Equalizer hi-mid freq
		EqFreq[2]=Val;
		cVal=(unsigned char)Val;			 
		mpuMessage(EQF_MHB,&cVal,1);			
		break;

	case 25://Equalizer hi freq
		EqFreq[3]=Val;
		cVal=(unsigned char)Val;			 
		mpuMessage(EQF_HB,&cVal,1);
		break;

	case 26://3D Delay
		SurRnd[0]=Val;
		cVal=(unsigned char)Val;			 
		mpuMessage(SUR_DEL,&cVal,1);
		break;

	case 27://3D depth
		SurRnd[1]=Val;
		cVal=(unsigned char)Val;		 
		mpuMessage(SUR_VOL,&cVal,1);
		break;
	
	
	
	default:
		break;
	}
}
//****************************************************************
void UpdateFromSlider(int i,unsigned int Val)
{
unsigned char cVal;
//unsigned int iVal;
WORD uVal1,uVal2;
//unsigned long lVal;
float lVal1,lVal2;
unsigned int pan,vol;
MIXERCONTROLDETAILS mxcd;
MIXERCONTROLDETAILS_UNSIGNED dwDetails[2];
MMRESULT mmres; 
	switch(i)
	{
	case 0://Mic Vol		
		mxcd.cbStruct=sizeof(mxcd);
		mxcd.cbDetails=sizeof(MIXERCONTROLDETAILS_UNSIGNED);
		mxcd.dwControlID=dwMicId;
		mxcd.cChannels=1;
		mxcd.cMultipleItems=0;
		mxcd.hwndOwner=0;
		mxcd.paDetails=(LPDWORD)dwDetails;
		dwDetails[0].dwValue=(UINT)Val;
		dwDetails[1].dwValue=(UINT)Val;
		mmres=mixerSetControlDetails(hmx[0],(LPMIXERCONTROLDETAILS)&mxcd,MIXER_SETCONTROLDETAILSF_VALUE);
	    		
		#ifdef _DEBUG
			wsprintf((LPCSTR)txt,"MicVol mmres = %d\n\r",(unsigned int)mmres);
			OutputDebugString((LPCSTR)txt);
		#endif
		break;

	case 1://Line Vol
		pan=Pot[1].curt;
		vol=Val;
		if(pan<64)
		{
			lVal1=(float)vol;
			lVal2=((float)vol*(float)pan)/63;
		}
		else
		{
			lVal1=((float)vol*(float)(127-pan))/63;
			lVal2=vol;
		}
		
		mxcd.cbStruct=sizeof(mxcd);
		mxcd.cbDetails=sizeof(MIXERCONTROLDETAILS_UNSIGNED);
		mxcd.dwControlID=dwLineId;
		mxcd.cChannels=2;
		mxcd.cMultipleItems=0;
		mxcd.hwndOwner=0;
		mxcd.paDetails=(LPDWORD)dwDetails;
		dwDetails[0].dwValue=(UINT)lVal1;
		dwDetails[1].dwValue=(UINT)lVal2;
		mmres=mixerSetControlDetails(hmx[0],(LPMIXERCONTROLDETAILS)&mxcd,MIXER_SETCONTROLDETAILSF_VALUE);
	    
		
		
		#ifdef _DEBUG
			wsprintf((LPCSTR)txt,"LineVol mmres = %d\n\r",(unsigned int)mmres);
			OutputDebugString((LPCSTR)txt);
		#endif
		break;

	case 2://CD Vol
		pan=Pot[2].curt;
		vol=Val;
		if(pan<64)
		{
			lVal1=(float)vol;
			lVal2=((float)vol*(float)pan)/63;
		}
		else
		{
			lVal1=((float)vol*(float)(127-pan))/63;
			lVal2=(float)vol;
		}
		
		mxcd.cbStruct=sizeof(mxcd);
		mxcd.cbDetails=sizeof(MIXERCONTROLDETAILS_UNSIGNED);
		mxcd.dwControlID=dwCDId;
		mxcd.cChannels=2;
		mxcd.cMultipleItems=0;
		mxcd.hwndOwner=0;
		mxcd.paDetails=(LPDWORD)dwDetails;
		dwDetails[0].dwValue=(UINT)lVal1;
		dwDetails[1].dwValue=(UINT)lVal2;
		mmres=mixerSetControlDetails(hmx[0],(LPMIXERCONTROLDETAILS)&mxcd,MIXER_SETCONTROLDETAILSF_VALUE);
	    				
		#ifdef _DEBUG
			wsprintf((LPCSTR)txt,"CDVol mmres = %d\n\r",(unsigned int)mmres);
			OutputDebugString((LPCSTR)txt);
		#endif
		break;

	case 3://Master L Vol
		MstInVol[0]=Val;
	#ifdef DRIMIX
		mxcd.cbStruct=sizeof(mxcd);
		mxcd.cbDetails=sizeof(MIXERCONTROLDETAILS_UNSIGNED);
		mxcd.dwControlID=dwDLineId;
		mxcd.cChannels=2;
		mxcd.cMultipleItems=0;
		mxcd.hwndOwner=0;
		mxcd.paDetails=(LPDWORD)dwDetails;
		dwDetails[0].dwValue=MstInVol[0]<<8;
		dwDetails[1].dwValue=MstInVol[1]<<8;    
		mmres=mixerSetControlDetails(hmx[1],(LPMIXERCONTROLDETAILS)&mxcd,MIXER_SETCONTROLDETAILSF_VALUE);
	#else		
		cVal=(unsigned char)Val;			 
		mpuMessage(AUDL_VOL,&cVal,1);
	#endif
		break;

	case 4://Master R Vol
		MstInVol[1]=Val;
	#ifdef DRIMIX
		mxcd.cbStruct=sizeof(mxcd);
		mxcd.cbDetails=sizeof(MIXERCONTROLDETAILS_UNSIGNED);
		mxcd.dwControlID=dwDLineId;
		mxcd.cChannels=2;
		mxcd.cMultipleItems=0;
		mxcd.hwndOwner=0;
		mxcd.paDetails=(LPDWORD)dwDetails;
		dwDetails[0].dwValue=MstInVol[0]<<8;
		dwDetails[1].dwValue=MstInVol[1]<<8;    
		mmres=mixerSetControlDetails(hmx[1],(LPMIXERCONTROLDETAILS)&mxcd,MIXER_SETCONTROLDETAILSF_VALUE);
	
	#else		
		cVal=(unsigned char)Val;			 
		mpuMessage(AUDR_VOL,&cVal,1);
	#endif
		break;	

	case 5://Wave Level
		pan=Pot[7].curt;
		vol=Val;
		if(pan<64)
		{
			lVal1=(float)vol;
			lVal2=((float)vol*(float)pan)/63;
		}
		else
		{
			lVal1=((float)vol*(float)(127-pan))/63;
			lVal2=(float)vol;
		}
		
			WaveVol[CurtWave]=vol;
			WavePan[CurtWave]=pan;
			WaveFL[CurtWave]=(UINT)lVal1;
			WaveFR[CurtWave]=(UINT)lVal2;
			uVal1=(WaveOn[CurtWave])*(WaveFL[CurtWave]);			
			uVal2=(WaveOn[CurtWave])*(WaveFR[CurtWave]);
			waveSetMainVolume((WORD)(FirstDreamWaveId+CurtWave),uVal1,uVal2);			
		
		break;

	

	case 6://Wave Pitch
		WavePt[CurtWave]=Val;		
		waveSetPitch((WORD)CurtWave,(WORD)WavePt[CurtWave]);
		break;

	case 7://Synth Vol
		SynVol=Val;
	  #ifdef DRIMIX
	    pan=SynPan;
		vol=SynVol;
		if(pan<64)
		{
			lVal1=(float)vol;
			lVal2=((float)vol*(float)pan)/63;
		}
		else
		{
			lVal1=((float)vol*(float)(127-pan))/63;
			lVal2=(float)vol;
		}
		
		    mxcd.cbStruct=sizeof(mxcd);
			mxcd.cbDetails=sizeof(MIXERCONTROLDETAILS_UNSIGNED);
			mxcd.dwControlID=dwDMidiId;
			mxcd.cChannels=2;
			mxcd.cMultipleItems=0;
			mxcd.hwndOwner=0;
			mxcd.paDetails=(LPDWORD)dwDetails;
			dwDetails[0].dwValue=((WORD)((BYTE)lVal1)<<8);
			dwDetails[1].dwValue=((WORD)((BYTE)lVal2)<<8);    
			mmres=mixerSetControlDetails(hmx[1],(LPMIXERCONTROLDETAILS)&mxcd,MIXER_SETCONTROLDETAILSF_VALUE);
		
	  #else
		
		cVal=(unsigned char)Val;			 
		mpuMessage(GM_VOL,&cVal,1);
	  #endif
		break;	

	case 8://Equalizer low freq
		EqVol[0]=Val;
		cVal=(unsigned char)Val;	 
		mpuMessage(EQ_LBL,&cVal,1);
		mpuMessage(EQ_LBR,&cVal,1);
		break;

	case 9://Equalizer low-mid freq
		EqVol[1]=Val;
		cVal=(unsigned char)Val;			 
		mpuMessage(EQ_MLBL,&cVal,1);
		mpuMessage(EQ_MLBR,&cVal,1);
		break;

	case 10://Equalizer hi-mid freq
		EqVol[2]=Val;
		cVal=(unsigned char)Val;			 
		mpuMessage(EQ_MHBL,&cVal,1);
		mpuMessage(EQ_MHBR,&cVal,1);		
		break;

	case 11://Equalizer hi freq
		EqVol[3]=Val;
		cVal=(unsigned char)Val;			 
		mpuMessage(EQ_HBL,&cVal,1);
		mpuMessage(EQ_HBR,&cVal,1);
		break;
	
	case 12://Main Vol
		MainVol=Val;
	  #ifdef DRIMIX	  
	        mxcd.cbStruct=sizeof(mxcd);
			mxcd.cbDetails=sizeof(MIXERCONTROLDETAILS_UNSIGNED);
			mxcd.dwControlID=dwDVolId;
			mxcd.cChannels=1;
			mxcd.cMultipleItems=0;
			mxcd.hwndOwner=0;
			mxcd.paDetails=(LPDWORD)dwDetails;
			dwDetails[0].dwValue=((WORD)(MainVol)<<8);
			
			mmres=mixerSetControlDetails(hmx[1],(LPMIXERCONTROLDETAILS)&mxcd,MIXER_SETCONTROLDETAILSF_VALUE);
	  #else
		cVal=(unsigned char)Val;			 
		mpuMessage(MAIN_VOL,&cVal,1);
	  #endif
		break;


	default:
		break;
	}
}
//****************************************************************
void UpdateFromLCD(int i,unsigned int Val)
{
unsigned char cVal;
if (i==0)//Reverb
{
	RevType=Val;
	cVal=(unsigned char)RevType;
	mpuMessage(REV_TYPE,&cVal,1);
}
else//Chorus
{
	ChrType=Val;
	cVal=(unsigned char)ChrType;
	mpuMessage(CHR_TYPE,&cVal,1);
}

} 
//****************************************************************
void UpdateWaveVol(int WaveId)
{
	WORD uVal1,uVal2;
	
	uVal1=(WaveOn[WaveId])*(WaveFL[WaveId]);			
	uVal2=(WaveOn[WaveId])*(WaveFR[WaveId]);
	waveSetMainVolume((WORD)(FirstDreamWaveId+WaveId),uVal1,uVal2);	
	uVal1=(WaveOn[WaveId])*(WaveRL[WaveId]);			
	uVal2=(WaveOn[WaveId])*(WaveRR[WaveId]); 			
	waveSetAuxVolume((WORD)(FirstDreamWaveId+WaveId),uVal1,uVal2);			
		
}

//************************************************************
void RedrawFrame(RECT *rect,struct MyFrame *fra,PAINTSTRUCT *ps,HDC hDC)
{
HBRUSH hbr,hbrOld;
HPEN hpen,hpenOld;
HFONT hOldFont;
//int i;
if((IntersectRect(rect, fra, &(ps->rcPaint)))&&(fra->visible))
	{
	hOldFont=SelectObject(hDC,hNewFont);
	//SetTextColor(*hDC,blue);
	hbr = GetStockObject(LTGRAY_BRUSH);
	hbrOld = SelectObject(hDC, hbr);
	hpen = CreatePen(PS_SOLID,1,RGB(128,128,128));
	hpenOld = SelectObject(hDC, hpen);
	Rectangle(hDC,fra->left,fra->top,fra->right+1,fra->bottom+1);
	SetBkMode(hDC,TRANSPARENT);
	//TextOut(*hDC, fra->left+4, fra->top+4,(LPSTR)(fra->name ), strlen((LPSTR)(fra->name )));
	SelectObject(hDC, hbrOld);
	SelectObject(hDC, hpenOld);
	SelectObject(hDC,hOldFont);
	DeleteObject(hpen);	
	}		
}
//************************************************************
void CalcFrames(int FrameNb)
{
//POINT Origine;
int i;
int lastVisible=-1;
for(i=0;i<FrameNb;i++)
{
	if(Frame[i].visible)
	{
		if(lastVisible==-1)//Frame[i]=first frame to display
		{
			Frame[i].left=Origine.x;
			Frame[i].top=Origine.y;
			Frame[i].right=Frame[i].left+Frame[i].width;
			Frame[i].bottom=Frame[i].top+Frame[i].height;
			lastVisible=i;
		}
		else
		{
			Frame[i].left=Frame[lastVisible].right+Frame[i].offset;
			Frame[i].top=Frame[lastVisible].top;
			Frame[i].right=Frame[i].left+Frame[i].width;
			Frame[i].bottom=Frame[i].top+Frame[i].height;
			lastVisible=i;
			if(i==REVCHRS)
			{
				i++;
				Frame[i].left=Frame[REVCHRS].left;
				Frame[i].top=Frame[REVCHRS].top;
				Frame[i].right=Frame[i].left+Frame[i].width;
				Frame[i].bottom=Frame[i].top+Frame[i].height;
				Frame[i].visible=Frame[REVCHRS].visible;
				i++;
				Frame[i].left=Frame[REVCHRS].left;
				Frame[i].top=Frame[REVCHRS+1].bottom;
				Frame[i].right=Frame[i].left+Frame[i].width;
				Frame[i].bottom=Frame[i].top+Frame[i].height;
				Frame[i].visible=Frame[REVCHRS].visible;
				i++;
				Frame[i].left=Frame[REVCHRS+1].right;
				Frame[i].top=Frame[REVCHRS].top;
				Frame[i].right=Frame[i].left+Frame[i].width;
				Frame[i].bottom=Frame[i].top+Frame[i].height;
				Frame[i].visible=Frame[REVCHRS].visible;
			}
			if(i==10)
			{
			i++;
				Frame[i].left=Frame[10].left;
				Frame[i].top=Frame[10].bottom;
				Frame[i].right=Frame[i].left+Frame[i].width;
				Frame[i].bottom=Frame[i].top+Frame[i].height;
							
			}
		}
	}

}
}

//************************************************************
void InitFrame(struct MyFrame *fra,int width,int height,int offset,LPSTR name,BOOL visible)
{
fra->width=width;
fra->height=height;
fra->offset=offset;
strcpy(fra->name,name);
fra->visible=visible;
}
//****************************************************************
void ResizeMainWnd(HWND hWnd,int FrameNb)
{
	int wid,hei,i,lastframe;
	for(i=0;i<FrameNb;i++)
	{
		if(Frame[i].visible)
			lastframe=i;
	}
	wid=Frame[lastframe].right+Origine.x+10;
	hei=Frame[lastframe].bottom+Origine.y+25;
	i=SetWindowPos(hWnd,NULL,0,0,wid,hei,SWP_NOZORDER);
}

//****************************************************************
void InitText(struct MyTxt *txt,int left,int top,LPSTR ptxt,COLORREF color, struct MyFrame *fra)
{
	if(fra==NULL)
{
	txt->left=left;
	txt->top=top;
	txt->visible=TRUE;
}
else
{
	txt->left=fra->left + left;
	txt->top=fra->top + top-1;
	txt->visible=fra->visible;
} 
txt->ptxt=ptxt;
txt->color=color;
}
//*************************************************************************
void RedrawTxt(RECT *rect,struct MyTxt *txt,PAINTSTRUCT *ps,HDC hDC)
{
HFONT hOldFont;
//HPEN hpen,hpenOld,hp;
LPSTR txtpt;
COLORREF OldColor;
SIZE size;
hOldFont=SelectObject(hDC,hNewFont);
txtpt=txt->ptxt;
//GetTextExtentPoint32(hDC,txtpt, strlen(txtpt),(LPSIZE)&size);
size.cx=5* strlen(txtpt);
size.cy=6;
txt->right=txt->left+size.cx;
txt->bottom=txt->top+size.cy;
if((IntersectRect(rect, (LPRECT)txt, &(ps->rcPaint)))&&(txt->visible))
	{	
	//hpen = CreatePen(PS_SOLID,1,txt->color);
	OldColor=SetTextColor(hDC,txt->color);
	//hpenOld = SelectObject(*hDC, hpen);
	SetBkMode(hDC,TRANSPARENT);
	TextOut(hDC, txt->left, txt->top,txtpt, strlen(txtpt));
	SetTextColor(hDC,OldColor);
	//SelectObject(*hDC, hpenOld);	
	}
SelectObject(hDC,hOldFont);
}
//***********************************************
void FlatEQ(HWND hWnd)
{
	int i;
	unsigned char cVal;
	for (i=0;i<4;i++)
	{
	EqVol[i]= FlatVol[i];
	EqFreq[i]=FlatFreq[i];
	SetSliderVal(&Sly[8+i],EqVol[i],hWnd);
	SetPotVal(&Pot[22+i],EqFreq[i],hWnd);
	cVal=(unsigned char)EqVol[i];	 
	mpuMessage((WORD)(EQ_LBL+i),&cVal,1);
	mpuMessage((WORD)(EQ_LBR+i),&cVal,1);
	cVal=(unsigned char)EqFreq[i];			 
	mpuMessage((WORD)(EQF_LB+i),&cVal,1);
	}
}
//***********************************************
void XferAll(void)
{
unsigned char cVal;
//unsigned int iVal;
WORD uVal1,uVal2;
int i;
//unsigned long lVal;

		
cVal=(unsigned char)MstInPan[0];			 
mpuMessage(AUDL_PAN,&cVal,1);	

cVal=(unsigned char)MstInPan[1];			 
mpuMessage(AUDR_PAN,&cVal,1);	

cVal=(unsigned char)MstInFx[0];			 
mpuMessage(AUDREV_SEND,&cVal,1);

cVal=(unsigned char)MstInFx[1];			 
mpuMessage(ECH_LEV,&cVal,1);
	
for(i=0;i<8;i++)
	{
	uVal1=(WaveOn[i])*(WaveRL[i]);			
	uVal2=(WaveOn[i])*(WaveRR[i]); 			
	waveSetAuxVolume((WORD)(FirstDreamWaveId+i),uVal1,uVal2);
	
	uVal1=WaveFc[i];
	waveSetFilter((WORD)(FirstDreamWaveId+i),WAVE_FC,uVal1);					
	
	uVal1=(WaveOn[i])*(WaveFL[i]);			
	uVal2=(WaveOn[i])*(WaveFR[i]);	
	waveSetMainVolume((WORD)(FirstDreamWaveId+i),uVal1,uVal2);
		
	waveSetPitch((WORD)i,(WORD)WavePt[i]);
	}
cVal=(unsigned char)SynPan;			 
mpuMessage(GM_PAN,&cVal,1);

cVal=(unsigned char)SynRev;			 
mpuMessage(GMREV_SEND,&cVal,1);

cVal=(unsigned char)SynChr;			 
mpuMessage(GMCHR_SEND,&cVal,1);

cVal=(unsigned char)RevVal[0];			 
mpuMessage(REV_TIME,&cVal,1);

cVal=(unsigned char)RevVal[1];			 
mpuMessage(REV_FEED,&cVal,1);		

cVal=(unsigned char)EchoVal[0];			 
mpuMessage(ECH_TIM,&cVal,1);

cVal=(unsigned char)EchoVal[1];			 
mpuMessage(ECH_FEED,&cVal,1);
		
cVal=(unsigned char)ChrVal[0];			 
mpuMessage(CHR_RATE,&cVal,1);		

cVal=(unsigned char)ChrVal[1];			 
mpuMessage(CHR_DEL,&cVal,1);

cVal=(unsigned char)ChrVal[2];			 
mpuMessage(CHR_DEPTH,&cVal,1);

cVal=(unsigned char)ChrVal[3];			 
mpuMessage(CHR_FEED,&cVal,1);		

cVal=(unsigned char)EqFreq[0];			 
mpuMessage(EQF_LB,&cVal,1);

cVal=(unsigned char)EqFreq[1];			 
mpuMessage(EQF_MLB,&cVal,1);

cVal=(unsigned char)EqFreq[2];			 
mpuMessage(EQF_MHB,&cVal,1);	

cVal=(unsigned char)EqFreq[3];			 
mpuMessage(EQF_HB,&cVal,1);

cVal=(unsigned char)SurRnd[0];			 
mpuMessage(SUR_DEL,&cVal,1);		

cVal=(unsigned char)SurRnd[1];			 
mpuMessage(SUR_VOL,&cVal,1);

cVal=(unsigned char)MstInVol[0];			 
mpuMessage(AUDL_VOL,&cVal,1);

cVal=(unsigned char)MstInVol[1];			 
mpuMessage(AUDR_VOL,&cVal,1);	

cVal=(unsigned char)SynVol;			 
mpuMessage(GM_VOL,&cVal,1);

cVal=(unsigned char)EqVol[0];	 
mpuMessage(EQ_LBL,&cVal,1);
mpuMessage(EQ_LBR,&cVal,1);

cVal=(unsigned char)EqVol[1];			 
mpuMessage(EQ_MLBL,&cVal,1);
mpuMessage(EQ_MLBR,&cVal,1);

cVal=(unsigned char)EqVol[2];			 
mpuMessage(EQ_MHBL,&cVal,1);
mpuMessage(EQ_MHBR,&cVal,1);		

cVal=(unsigned char)EqVol[3];			 
mpuMessage(EQ_HBL,&cVal,1);
mpuMessage(EQ_HBR,&cVal,1);

cVal=(unsigned char)RevType;
mpuMessage(REV_TYPE,&cVal,1);

cVal=(unsigned char)ChrType;
mpuMessage(CHR_TYPE,&cVal,1);
mpuMessage(SUR_INP,&SurSel[0],1);
mpuMessage(SUR_24,&SurSel[1],1);
mpuMessage(AUDECH_POST,&Ass[0],1);
mpuMessage(WAVE_POST,&Ass[1],1);
mpuMessage(GM_POST,&Ass[2],1);
mpuMessage(EFF_POST,&Ass[3],1);
mpuMessage(REC_SEL,&RecSel,1);
}
//****************************************************
int ReadIniFile(LPSTR apname)
{
char Text[50],Text2[50];

if(GetPrivateProfileString(szBoard,szName,NULL,Text,50,apname)!=0)
	{
	strupr(Text);
	strcpy(szBoardName,Text);
	}


	
if(GetPrivateProfileString(szBoardName,szInputs,NULL,Text,50,apname)!=0)
	{
	strupr(Text);
	if(strstr(Text,"ON"))
	{
		FrameStatus[0]=1;
		bExtMixer=TRUE;
		strcpy(Text2,szCodecInput);
		strcat(Text2,"1");
		if(GetPrivateProfileString(szBoardName,Text2,"Mic",Text,50,apname)!=0)
			{
			strupr(Text);
			strcpy(MicTxt,Text);			
			}
		else
			strcpy(MicTxt,"MIC");

		strcpy(Text2,szCodecInput);
		strcat(Text2,"2");
		if(GetPrivateProfileString(szBoardName,Text2,"Line",Text,50,apname)!=0)
			{
			strupr(Text);
			strcpy(LineTxt,Text);			
			}
		else
			strcpy(LineTxt,"LINE");
		strcpy(Text2,szCodecInput);
		strcat(Text2,"3");
		if(GetPrivateProfileString(szBoardName,Text2,"CD",Text,50,apname)!=0)
			{
			strupr(Text);
			strcpy(CDTxt,Text);			
			}
		else
			strcpy(CDTxt,"CD");
	}
	else
		{
		FrameStatus[0]=0;	
		bExtMixer=FALSE;
		}
	}

if(GetPrivateProfileString(szBoardName,szExtMixer,"No",Text,50,apname)!=0)
	{
	strupr(Text);
	if(strstr(Text,"NO"))
		{
		FrameStatus[0]=0;
		bExtMixer=FALSE;
		strcpy(szExtMixName,"NO");
		}
	else
		{
		FrameStatus[0]=1;
		bExtMixer=TRUE;
		strcpy(szExtMixName,Text);
		}
	}
else
	{
	bExtMixer=FALSE;
	FrameStatus[0]=0;
	strcpy(szExtMixName,"NO");
	}

if(GetPrivateProfileString(szBoardName,szMaster,NULL,Text,50,apname)!=0)
	{
	strupr(Text);
	if(strstr(Text,"ON"))
		FrameStatus[1]=1;
	else
		FrameStatus[1]=0;

	}
if(GetPrivateProfileString(szBoardName,szWaves,NULL,Text,50,apname)!=0)
	{
	strupr(Text);
	if(strstr(Text,"ON"))
		FrameStatus[2]=1;
	else
		FrameStatus[2]=0;

	}
if(GetPrivateProfileString(szBoardName,szSynth,NULL,Text,50,apname)!=0)
	{
	strupr(Text);
	if(strstr(Text,"ON"))
		FrameStatus[3]=1;
	else
		FrameStatus[3]=0;

	}
if(GetPrivateProfileString(szBoardName,szFx,NULL,Text,50,apname)!=0)
	{
	strupr(Text);
	if(strstr(Text,"ON"))
		FrameStatus[4]=1;
	else
		FrameStatus[4]=0;

	}
if(GetPrivateProfileString(szBoardName,szEcho,NULL,Text,50,apname)!=0)
	{
	strupr(Text);
	if(strstr(Text,"ON"))
		FrameStatus[6]=1;
	else
		FrameStatus[6]=0;

	}
if(GetPrivateProfileString(szBoardName,szEq,NULL,Text,50,apname)!=0)
	{
	strupr(Text);
	if(strstr(Text,"ON"))
		FrameStatus[8]=1;
	else
		FrameStatus[8]=0;

	}
if(GetPrivateProfileString(szBoardName,szSurrnd,NULL,Text,50,apname)!=0)
	{
	strupr(Text);
	if(strstr(Text,"ON"))
		FrameStatus[9]=1;
	else
		FrameStatus[9]=0;

	}
if(GetPrivateProfileString(szBoardName,szRecord,NULL,Text,50,apname)!=0)
	{
	strupr(Text);
	if(strstr(Text,"ON"))
		FrameStatus[10]=1;
	else
		FrameStatus[10]=0;

	}
if(GetPrivateProfileString(szBoardName,szMain,NULL,Text,50,apname)!=0)
	{
	strupr(Text);
	if(strstr(Text,"ON"))
		FrameStatus[11]=1;
	else
		FrameStatus[11]=0;

	}
if(GetPrivateProfileString(szBoardName,szInChrs,NULL,Text,50,apname)!=0)
	{
	strupr(Text);
	if(strstr(Text,"ON"))
		InChrs=1;
	else
		InChrs=0;

	}
return(1);
}
/*************************************************/
BOOL ReadSamConfig(LPBYTE Table)
{
int asw;
//LPBYTE lpFixedTab;
//lpFixedTab=LocalAlloc(LPTR,128); 

	
if( (asw=genControlRead(Table,0xff))!=0) //SamTable
	{
	//LocalFree(lpFixedTab);
	return(FALSE);
	}                        
	
//memcpy(Table,lpFixedTab,128);
//LocalFree(lpFixedTab);

//return(0);
if(SamTable[AUD_ONOFF]==0) 
	FrameStatus[1]=0;
else
	FrameStatus[1]=1;
	
if(SamTable[REV_ONOFF]==0)
	FrameStatus[6]=0;
else
	FrameStatus[6]=1;

if(SamTable[ECH_ONOFF]==0)
	FrameStatus[7]=0;
else
	FrameStatus[7]=1;
	
if(SamTable[CHR_ONOFF]==0)
	FrameStatus[8]=0;
else
	FrameStatus[8]=1;
	
if(SamTable[EQU_TYPE]==2) //EQ off ?
	FrameStatus[9]=0;
else
	FrameStatus[9]=1;

if(SamTable[SUR_ONOFF]==0) //Surround off ?
	FrameStatus[10]=0;
else
	FrameStatus[10]=1;
/**************************************/ 
Ass[0]=SamTable[AUDECH_POST];
Ass[1]=SamTable[WAVE_POST];
Ass[2]=SamTable[GM_POST];
Ass[3]=SamTable[EFF_POST];

MstInVol[0]=SamTable[AUDL_VOL];
MstInVol[1]=SamTable[AUDR_VOL];
MstInPan[0]=SamTable[AUDL_PAN];
MstInPan[1]=SamTable[AUDR_PAN];
MstInFx[0]=SamTable[AUDREV_SEND];
MstInFx[1]=SamTable[ECH_LEV];
MstInFx[2]=SamTable[AUDCHR_SEND];

//--------- Synth --------------
SynPan=SamTable[GM_PAN];
SynVol=SamTable[GM_VOL];
SynRev=SamTable[GMREV_SEND];
SynChr=SamTable[GMCHR_SEND];
//--------- Equalizer --------------
EqVol[0]=SamTable[EQ_LBL];
EqVol[1]=SamTable[EQ_MLBL];
EqVol[2]=SamTable[EQ_MHBL];
EqVol[3]=SamTable[EQ_HBL];

EqFreq[0]=SamTable[EQF_LB];
EqFreq[1]=SamTable[EQF_MLB];
EqFreq[2]=SamTable[EQF_MHB];
EqFreq[3]=SamTable[EQF_HB];

SurRnd[0]=SamTable[SUR_DEL];
SurRnd[1]=SamTable[SUR_VOL];
SurSel[0]=SamTable[SUR_INP];
SurSel[1]=SamTable[SUR_24];
RecSel=SamTable[REC_SEL];
//--------- Echo --------------
EchoVal[0]=SamTable[ECH_TIM];
EchoVal[1]=SamTable[ECH_FEED];
//--------- Reverb --------------
RevType=SamTable[REV_TYPE];
RevVal[0]=SamTable[REV_TIME];
RevVal[1]=SamTable[REV_FEED];
//--------- Chorus --------------
ChrType=SamTable[CHR_TYPE];
ChrVal[0]=SamTable[CHR_RATE];
ChrVal[1]=SamTable[CHR_DEL];
ChrVal[2]=SamTable[CHR_DEPTH];
ChrVal[3]=SamTable[CHR_FEED];

MainVol=SamTable[MAIN_VOL];

return(TRUE); 
}
//******************
int RefreshChorus(LPBYTE Table)
{
int asw;
//LPBYTE lpFixedTab;
//lpFixedTab=LocalAlloc(LPTR,128); 

	
if( (asw=genControlRead(Table,0xff))!=0) //SamTable
	{
	//LocalFree(lpFixedTab);
	return(asw);
	}
//memcpy(Table,lpFixedTab,128);
//LocalFree(lpFixedTab);
/*if( (asw=genControlRead(Table,0xff))!=0) //SamTable
	return(asw); */
ChrVal[0]=SamTable[CHR_RATE];
ChrVal[1]=SamTable[CHR_DEL];
ChrVal[2]=SamTable[CHR_DEPTH];
ChrVal[3]=SamTable[CHR_FEED];


return(0);
}
//******************
int RefreshReverb(LPBYTE Table)
{
int asw;
//LPBYTE lpFixedTab;
//lpFixedTab=LocalAlloc(LPTR,128); 

	
if( (asw=genControlRead(Table,0xff))!=0) //SamTable
	{
	//LocalFree(lpFixedTab);
	return(asw);
	}
//memcpy(Table,lpFixedTab,128);
//LocalFree(lpFixedTab);
/*if( (asw=genControlRead(Table,0xff))!=0) //SamTable
	return(asw);*/
RevVal[0]=SamTable[REV_TIME];
RevVal[1]=SamTable[REV_FEED];
return(0);
}
//**************************
int UpdateControls(HWND hWnd)
{
//--------- Audio In -----------------
SetPotVal(&Pot[3],MstInPan[0],hWnd);
SetPotVal(&Pot[4],MstInPan[1],hWnd);
SetPotVal(&Pot[5],MstInFx[0],hWnd);
SetPotVal(&Pot[6],MstInFx[1],hWnd);
SetPotVal(&Pot[28],MstInFx[2],hWnd);
SetSliderVal(&Sly[3],MstInVol[0],hWnd);
SetSliderVal(&Sly[4],MstInVol[1],hWnd);
//--------- Waves --------------
//--------- Synth --------------
SetPotVal(&Pot[11],SynPan,hWnd);
SetPotVal(&Pot[12],SynRev,hWnd);
SetPotVal(&Pot[13],SynChr,hWnd);
SetSliderVal(&Sly[7],SynVol,hWnd);
//--------- Reverb --------------
SetPotVal(&Pot[14],RevVal[0],hWnd);
SetPotVal(&Pot[15],RevVal[1],hWnd); 
//InitLCD(&Lcd[0], 5,14,4,(LPSTR)ReverbTxt,hDC,hInst,&Frame[4]); 
Lcd[0].curt=RevType;
InvalidateRect(hWnd, &Lcd[0].GlobRect, TRUE);

//--------- Echo --------------
SetPotVal(&Pot[16],EchoVal[0],hWnd);
SetPotVal(&Pot[17],EchoVal[1],hWnd);
//--------- Chorus --------------
SetPotVal(&Pot[18],ChrVal[0],hWnd);
SetPotVal(&Pot[19],ChrVal[1],hWnd);
SetPotVal(&Pot[20],ChrVal[2],hWnd);
SetPotVal(&Pot[21],ChrVal[3],hWnd);
//InitLCD(&Lcd[1],61,14,2,(LPSTR)ChorusTxt,hDC,hInst,&Frame[4]);
Lcd[1].curt=ChrType;
InvalidateRect(hWnd, &Lcd[1].GlobRect, TRUE);
//--------- Equalizer --------------
SetPotVal(&Pot[22],EqFreq[0],hWnd);
SetPotVal(&Pot[23],EqFreq[1],hWnd);
SetPotVal(&Pot[24],EqFreq[2],hWnd);
SetPotVal(&Pot[25],EqFreq[3],hWnd);
SetSliderVal(&Sly[ 8],EqVol[0],hWnd);
SetSliderVal(&Sly[ 9],EqVol[1],hWnd);
SetSliderVal(&Sly[10],EqVol[2],hWnd);
SetSliderVal(&Sly[11],EqVol[3],hWnd);
//--------- 3D --------------
SetPotVal(&Pot[26],SurRnd[0],hWnd);
SetPotVal(&Pot[27],SurRnd[1],hWnd);			
if (SurSel[0]==0)
	SetButtonVal(&But[17],0,hWnd);
else
	SetButtonVal(&But[17],1,hWnd);
if (SurSel[1]==0)
	SetButtonVal(&But[18],0,hWnd);	
else
	SetButtonVal(&But[18],1,hWnd);
			
if (Ass[0]==0)
	SetButtonVal(&But[23],0,hWnd);
else
	SetButtonVal(&But[23],1,hWnd);
			
if (Ass[1]==0)
	SetButtonVal(&But[24],0,hWnd);
else
	SetButtonVal(&But[24],1,hWnd);					
if (Ass[2]==0)
	SetButtonVal(&But[25],0,hWnd);
else
	SetButtonVal(&But[25],1,hWnd);					
if (Ass[3]==0)
	SetButtonVal(&But[26],0,hWnd);
else
	SetButtonVal(&But[26],1,hWnd);
			
if(RecSel==0)// rec src =audio
	{
	SetButtonVal(&But[28],1,hWnd);
	SetButtonVal(&But[29],0,hWnd);
	}
else
	{
	SetButtonVal(&But[28],0,hWnd);
	SetButtonVal(&But[29],1,hWnd);
	}
SetSliderVal(&Sly[12],MainVol,hWnd);
return(0);
}
//***********************************************************
int ReleaseBut(struct MyButton *but,HWND hwnd)
{
	//DeleteDC(but->hDC1);
	//DeleteDC(but->hDC2);
	return(1);
}
//***********************************************************
int ReleaseLCD(struct MyLCD *lcd,HWND hwnd)
{
	//DeleteDC(lcd->hDc);
	return(1);
}
//***********************************************************
void ReleaseAll(HWND hwnd)
{
	int i;
	for(i=0;i<POTNB;i++)
		ReleasePot(&Pot[i],hwnd);

	for(i=0;i<SLYNB;i++)
		ReleaseSlider(&Sly[i],hwnd);

	for(i=0;i<BUTNB;i++)
		ReleaseBut(&But[i],hwnd);

	for(i=0;i<LCDNB;i++)
		ReleaseLCD(&Lcd[i],hwnd);
}



