/*
 *  gdsupport.h      header file for Gameduino support code
 *
 *  This code is a C rewrite of the C++ Gameduino library code suppled by the
 *  Gameduino website.
 *
 *  This code is target-non-specific in that you do not need to alter this
 *  code simply because you develop for a different MCU or for a different
 *  board.
 *
 *  This non-specific nature is created by using callback functions supplied
 *  by your application.  This code uses your callback functions to access
 *  the SPI when data needs to be exchanged with the Gameduino.
 *
 *  Your code must provide pointers to these three functions by invoking the
 *  GD_register() function below.
 */
#ifndef  GDSUPPORT_H
#define  GDSUPPORT_H



/*
 *  Define some named literals for controlling sprite operations.
 */
#define  MASK_ROTATE_X			2
#define  MASK_ROTATE_Y			4
#define  MASK_EXCHANGE_XY		1


/*
 *  Define some named literals for setting colors.
 */
#define  RGB_WHITE				RGB(255,255,255)
#define  RGB_RED				RGB(255,0,0)
#define  RGB_GREEN				RGB(0,255,0)
#define  RGB_BLUE				RGB(0,0,255)
#define  RGB_YELLOW				RGB(255,255,0)


/*
 *  Define some named literals for describing the text area.
 */
#define  MAX_TEXT_COLS			64
#define  MAX_TEXT_ROWS			64

/*
 *  Define literals for pixel-based constants
 */
#define  MAX_PIXELS_X			512
#define  MAX_PIXELS_Y			512
#define  CHAR_HEIGHT_PIXELS		8
#define  CHAR_WIDTH_PIXELS		8



/*
 *  If necessary, define named literals for common ASCII chars.
 */
#ifndef  FF
#define  FF						'\f'
#endif

#ifndef  CR
#define  CR						'\r'
#endif

#ifndef  LF
#define  LF						'\n'
#endif



/*
 *  With the exception of GD_register(), the following functions are derived from
 *  the Gameduion C++ library code and use the same calling conventions as their
 *  namesakes.
 */

/*
 *  GD_register      register SPI callback functions with this module
 *
 *  Your code must use GD_register() to supply three different callback functions:
 *
 *  _select points to a function in your code that is called by this routine
 *  to enable the SPI connection to the Gameduino.
 *
 *  _xchg points to a function in your code that is called by this routine
 *  to exchange a byte of data with the Gameduino.
 *
 *  _deselect points to a function in your code that is called by this routine
 *  to disable the SPI connection to the Gameduino.
 *
 *  Your code MUST call GD_register() before invoking ANY other function in this
 *  module!
 */
void					GD_register(void(* _select)(void),
 				   					unsigned char(* _xchg)(unsigned char  val),
				   					void(* _deselect)(void));

void					GD_begin(void);
void					GD_fill(unsigned int  addr, unsigned char  v, unsigned int  count);
void					GD_xhide(void);
unsigned char			GD_rd(unsigned int  addr);
unsigned int			GD_rd16(unsigned int  addr);
void					GD_wr(unsigned int  addr, unsigned char  v);
void					GD_wr16(unsigned int  addr, unsigned int  v);
void					GD_setpal(int  pal, unsigned int  rgb);
void					GD_copy(unsigned int  addr, unsigned char  *src, int  count);
void					GD_microcode(unsigned char  *src, int  count);
void					GD_ascii(void);
void					GD_cls(void);
void					GD_outch(char  c);

void					GD_putstr(unsigned int  x, unsigned int  y, const char  *s);
void					GD_putstr_P(unsigned int  x, unsigned int  y, const char  *s);

void					GD_sprite(int  spr, int  x, int  y, unsigned char  image,
									unsigned char  palette, unsigned char  rot, unsigned char  jk);

void					GD_xsprite(int  ox, int  oy, char  x, char  y, unsigned char  image,
									unsigned char  palette, unsigned char  rot, unsigned char  jk);

void					GD_sprite2x2(int  spr, int  x, int  y, unsigned char  image,
									unsigned char  palette, unsigned char  rot, unsigned char  jk);

void					GD_voice(int  v, unsigned char  wave, unsigned int  freq,
									unsigned char  lamp, unsigned char  ramp);

void					GD__start(unsigned int  addr);
void					GD__wstart(unsigned int  addr);
void					GD__wstartspr(unsigned int  sprnum);
void					GD__end(void);




#endif					// #ifndef  GDSUPPORT_H



