#include "LPC17xx.h"



/*
 *  Global variables
 */
uint32_t				SystemCoreClock;		// not used in the spin-loop version but need to define anyway





void init(void)
{
	/* Based on CMSIS SystemInit() for LPC17xx */
	/* Also see chapters 3 and 4 of LPC17xx User Manual, UM10360 */

/*
 *  Clock initialization for the Mbed development board.  This board
 *  uses a 12 MHz oscillator as the main clock source.
 */
	LPC_SC->SCS = 0x20;					// enable external oscillator (12 MHz crystal)
	while (!(LPC_SC->SCS & (1<<6))) ;	// wait for main oscillator to stablilize
	
	LPC_SC->CLKSRCSEL = 0x01;			// set main oscillator (12 MHz crystal) as PLL source
	LPC_SC->CCLKCFG = 0x03;				// set CPU clock (CCLK) to PLL0 output / 4
	
	LPC_SC->PCLKSEL0 = 0x0;				// peripherals use CPU clock / 4
	LPC_SC->PCLKSEL1 = 0x0;				// peripherals use CPU clock / 4

/*
 *  The following code sets up the Mbed board to 96 MHz.
 *  This code sets PLL0 output to 384 MHz.  The CPU clock
 *  configuration above (CCLKCFG) divides this value by 4
 *  to get a final CPU clock of 96 MHz.
 */
	LPC_SC->PLL0CFG = (0<<16) | (15<<0);	// PPL0 config, M=16, N=1, Fout=384
	LPC_SC->PLL0FEED = 0xAA;			// feed the PLL
	LPC_SC->PLL0FEED = 0x55;

	LPC_SC->PLL0CON = 0x01;				// enable PLL0
	LPC_SC->PLL0FEED = 0xAA;			// feed the PLL
	LPC_SC->PLL0FEED = 0x55;

	while (!(LPC_SC->PLL0STAT & (1<<26)))	;		// wait for PLL0 lock

	LPC_SC->PLL0CON = 0x03;				// enable and connect PLL0
	LPC_SC->PLL0FEED = 0xAA;			// feed the PLL
	LPC_SC->PLL0FEED = 0x55;

	while (!(LPC_SC->PLL0STAT & ((1<<25) | (1<<24))))  ;	// wait for PLL0 enable and connect

	SystemCoreClock = 96000000;			// need to make this value available globally
	
/*
 *  Set up PLL1 for use as a USB clock.  The output must be set to 48 MHz, based
 *  on an oscillator of 12 MHz.
 */
	LPC_SC->PLL1CFG = 0x00000023;		// PLL1 config, M=4 (bits 4:0=3), P=2 (bits 6:5=1)
	LPC_SC->PLL1FEED = 0xAA;			// feed the PLL
	LPC_SC->PLL1FEED = 0x55;

	LPC_SC->PLL1CON = 0x01;				// enable PLL1
	LPC_SC->PLL1FEED = 0xAA;
	LPC_SC->PLL1FEED = 0x55;

	while (!(LPC_SC->PLL1STAT & (1<<10)))  ;		// wait for PLL1 lock

	LPC_SC->PLL1CON = 0x03;				// enable and connect PLL1
	LPC_SC->PLL1FEED = 0xAA;			// feed the PLL
	LPC_SC->PLL1FEED = 0x55;

	while (!(LPC_SC->PLL1STAT & ((1<<9) | (1<<8))))  ;  // wait for PLL1 enable and connect

	/* Additional settings */
	//LPC_SC->USBCLKCFG = ...;
	//LPC_SC->PCONP = ...;
	//LPC_SC->CLKOUTCFG = ...;
	//LPC_SC->FLASHCFG = ...;
}





int main(void) 
{
	int					n;

	init();										// set up the hardware
	
	LPC_GPIO1->FIODIR = 0xFFFFFFFF;

	while(1)
	{
		LPC_GPIO1->FIOSET = (1<<18);			// turn on LED1
		for (n=0; n<1000000; n++)  ;			// delay
		LPC_GPIO1->FIOCLR = (1<<18);			// turn off LED1
		for (n=0; n<1000000; n++)  ;			// delay
	}

}

