#ifndef  IOREGS12_H
#define  IOREGS12_H

#ifndef  IOREGS_BASE
#define  IOREGS_BASE    0x0000
#endif

#define _IO8(off)       *(unsigned char  volatile *)(IOREGS_BASE + off)
#define _IO16(off)      *(unsigned short volatile *)(IOREGS_BASE + off)

#define  PORTA      _IO8(0x00)      /* i/o port a */
#define  PORTB      _IO8(0x01)      /* i/o port b */
#define  DDRA       _IO8(0x02)      /* data direction reg a */
#define  DDRB       _IO8(0x03)      /* data direction reg b */
#define  PORTE      _IO8(0x08)      /* i/o port e */
#define  DDRE       _IO8(0x09)      /* data direction reg e */
#define  PEAR       _IO8(0x0a)      /* pear */
#define  MODE       _IO8(0x0b)      /* mode */
#define  PUCR       _IO8(0x0c)      /* pucr */
#define  RDRIV      _IO8(0x0d)      /* rdriv */
#define  INITRM     _IO8(0x10)      /* initrm */
#define  INITRG     _IO8(0x11)      /* initrg */
#define  INITEE     _IO8(0x12)      /* initee */
#define  MISC       _IO8(0x13)      /* misc */
#define  RTICTL     _IO8(0x14)      /* rtictl */
#define  RTIFLG     _IO8(0x15)      /* rtiflg */
#define  COPCTL     _IO8(0x16)      /* copctl */
#define  COPRST     _IO8(0x17)      /* coprst */
#define  ITST0      _IO8(0x18)      /* itst0 */
#define  ITST1      _IO8(0x19)      /* itst1 */
#define  ITST2      _IO8(0x1a)      /* itst2 */
#define  ITST3      _IO8(0x1b)      /* itst3 */

#define  INTCR      _IO8(0x1e)      /* intcr */
#define  HPRIO      _IO8(0x1f)      /* hprio */
#define  BRKCT0     _IO8(0x20)      /* brkct0 */
#define  BRKCT1     _IO8(0x21)      /* brkct1 */
#define  BRKAH      _IO8(0x22)      /* brkah */
#define  BRKAL      _IO8(0x23)      /* brkal */
#define  BRKDH      _IO8(0x24)      /* brkdh */
#define  BRKDL      _IO8(0x25)      /* brkdl */

#define  KWIED      _IO8(0x20)      /* kwied ('a4) */
#define  KWIFD      _IO8(0x21)      /* kwifd ('a4) */
#define  PORTH      _IO8(0x24)      /* porth ('a4) */
#define  DDRH       _IO8(0x25)      /* ddrh ('a4) */
#define  KWIEH      _IO8(0x26)      /* kwieh ('a4) */
#define  KWIFH      _IO8(0x27)      /* kwifh ('a4) */
#define  PORTJ      _IO8(0x28)      /* portj ('a4) */
#define  DDRJ       _IO8(0x29)      /* ddrj ('a4) */
#define  KWIEJ      _IO8(0x2a)      /* kwiej ('a4) */
#define  KWIFJ      _IO8(0x2b)      /* kwifj ('a4) */
#define  KPOLJ      _IO8(0x2c)      /* kpolj ('a4) */
#define  PUPSJ      _IO8(0x2d)      /* pupsj ('a4) */
#define  PULEJ      _IO8(0x2e)      /* pulej ('a4) */

#define  PWCLK      _IO8(0x40)      /* pwclk */
#define  PWPOL      _IO8(0x41)      /* pwpol */
#define  PWEN       _IO8(0x42)      /* pwen */
#define  PWPRES     _IO8(0x43)      /* pwpres */
#define  PWSCAL0    _IO8(0x44)      /* pwscal0 */
#define  PWSCNT0    _IO8(0x45)      /* pwscnt0 */
#define  PWSCAL1    _IO8(0x46)      /* pwscal1 */
#define  PWSCNT1    _IO8(0x47)      /* pwscnt1 */
#define  PWSCAL2    _IO8(0x48)      /* pwscal2 */
#define  PWSCNT2    _IO8(0x49)      /* pwscnt2 */
#define  PWSCAL3    _IO8(0x4a)      /* pwscal3 */
#define  PWSCNT3    _IO8(0x4b)      /* pwscnt3 */
#define  PWPER0     _IO8(0x4c)      /* pwper0 */
#define  PWPER1     _IO8(0x4d)      /* pwper1 */
#define  PWPER2     _IO8(0x4e)      /* pwper2 */
#define  PWPER3     _IO8(0x4f)      /* pwper3 */
#define  PWDTY0     _IO8(0x50)      /* pwdty0 */
#define  PWDTY1     _IO8(0x51)      /* pwdty1 */
#define  PWDTY2     _IO8(0x52)      /* pwdty2 */
#define  PWDTY3     _IO8(0x53)      /* pwdty3 */
#define  PWCTL      _IO8(0x54)      /* pwctl */
#define  PWTST      _IO8(0x55)      /* pwtst */
#define  PORTP      _IO8(0x56)      /* portp */
#define  DDRP       _IO8(0x57)      /* ddrp */

#define  ATDCTL0    _IO8(0x60)      /* atdctl0 */
#define  ATDCTL1    _IO8(0x61)      /* atdctl1 */
#define  ATDCTL2    _IO8(0x62)      /* atdctl2 */
#define  ATDCTL3    _IO8(0x63)      /* atdctl3 */
#define  ATDCTL4    _IO8(0x64)      /* atdctl4 */
#define  ATDCTL5    _IO8(0x65)      /* atdctl5 */
#define  ATDSTAT    _IO16(0x66)     /* atdstat (word) */

#define  ATDTSTH    _IO8(0x68)      /* atdtsth */
#define  ATDTSTL    _IO8(0x69)      /* atdtstl */

#define  PORTAD     _IO8(0x6f)      /* portad */

#define  ADR0H      _IO16(0x70)     /* adr0h (word) */
#define  ADR1H      _IO16(0x72)     /* adr1h (word) */
#define  ADR2H      _IO16(0x74)     /* adr2h (word) */
#define  ADR3H      _IO16(0x76)     /* adr3h (word) */
#define  ADR4H      _IO16(0x78)     /* adr4h (word) */
#define  ADR5H      _IO16(0x7a)     /* adr5h (word) */
#define  ADR6H      _IO16(0x7c)     /* adr6h (word) */
#define  ADR7H      _IO16(0x7e)     /* adr7h (word) */

#define  ADR0L      _IO8(0x71)      /* adr0l (byte) */
#define  ADR1L      _IO8(0x73)      /* adr1l (byte) */
#define  ADR2L      _IO8(0x75)      /* adr2l (byte) */
#define  ADR3L      _IO8(0x77)      /* adr3l (byte) */
#define  ADR4L      _IO8(0x79)      /* adr4l (byte) */
#define  ADR5L      _IO8(0x7b)      /* adr5l (byte) */
#define  ADR6L      _IO8(0x7d)      /* adr6l (byte) */
#define  ADR7L      _IO8(0x7f)      /* adr7l (byte) */
#define  TIOS       _IO8(0x80)      /* tios */
#define  CFORC      _IO8(0x81)      /* cforc */
#define  OC7M       _IO8(0x82)      /* oc7m */
#define  OC7D       _IO8(0x83)      /* oc7d */
#define  TCNT       _IO16(0x84)     /* tcnt (word) */

#define  TSCR       _IO8(0x86)      /* tscr */
#define  TQCR       _IO8(0x87)      /* tqcr */
#define  TCTL1      _IO8(0x88)      /* tctl1 */
#define  TCTL2      _IO8(0x89)      /* tctl2 */
#define  TCTL3      _IO8(0x8a)      /* tctl3 */
#define  TCTL4      _IO8(0x8b)      /* tctl4 */
#define  TMSK1      _IO8(0x8c)      /* tmsk1 */
#define  TMSK2      _IO8(0x8d)      /* tmsk2 */
#define  TFLG1      _IO8(0x8e)      /* tflg1 */
#define  TFLG2      _IO8(0x8f)      /* tflg2 */

#define  TC0        _IO16(0x90)     /* tc0 (word) */
#define  TC1        _IO16(0x92)     /* tc1 (word) */
#define  TC2        _IO16(0x94)     /* tc2 (word) */
#define  TC3        _IO16(0x96)     /* tc3 (word) */
#define  TC4        _IO16(0x98)     /* tc4 (word) */
#define  TC5        _IO16(0x9a)     /* tc5 (word) */
#define  TC6        _IO16(0x9c)     /* tc6 (word) */
#define  TC7        _IO16(0x9e)     /* tc7 (word) */

#define  PACTL      _IO8(0xa0)      /* pulse accum control */
#define  PAFLG      _IO8(0xa1)      /* pulse accum flags */
#define  PACNT      _IO16(0xa2)     /* pulse accum count (word) */

#define  TIMTST     _IO8(0xad)      /* timtst */
#define  PORTT      _IO8(0xae)      /* portt */
#define  DDRT       _IO8(0xaf)      /* ddrt */

#define  SC0BDH     _IO8(0xc0)      /* sc0bdh */
#define  SC0BDL     _IO8(0xc1)      /* sc0bdl */
#define  SC0CR1     _IO8(0xc2)      /* sc0cr1 */
#define  SC0CR2     _IO8(0xc3)      /* sc0cr2 */
#define  SC0SR1     _IO8(0xc4)      /* sc0sr1 */
#define  SC0SR2     _IO8(0xc5)      /* sc0sr2 */
#define  SC0DRH     _IO8(0xc6)      /* sc0drh */
#define  SC0DRL     _IO8(0xc7)      /* sc0drl */

#define  SC1BDH     _IO8(0xc8)      /* sc1bdh ('a4) */
#define  SC1BDL     _IO8(0xc9)      /* sc1bdl ('a4) */
#define  SC1CR1     _IO8(0xca)      /* sc1cr1 ('a4) */
#define  SC1CR2     _IO8(0xcb)      /* sc1cr2 ('a4) */
#define  SC1SR1     _IO8(0xcc)      /* sc1sr1 ('a4) */
#define  SC1SR2     _IO8(0xcd)      /* sc1sr2 ('a4) */
#define  SC1DRH     _IO8(0xce)      /* sc1drh ('a4) */
#define  SC1DRL     _IO8(0xcf)      /* sc1drl ('a4) */

#define  SP0CR1     _IO8(0xd0)      /* sp0cr1 */
#define  SP0CR2     _IO8(0xd1)      /* sp0cr2 */
#define  SP0BR      _IO8(0xd2)      /* sp0br */
#define  SP0SR      _IO8(0xd3)      /* sp0sr */

#define  SP0DR      _IO8(0xd5)      /* sp0dr */
#define  PORTS      _IO8(0xd6)      /* ports */
#define  DDRS       _IO8(0xd7)      /* ddrs */

#define  PURDS      _IO8(0xdb)      /* purds */

#define  EEMCR      _IO8(0xf0)      /* eemcr */
#define  EEPROT     _IO8(0xf1)      /* eeprot */
#define  EETST      _IO8(0xf2)      /* eetst */
#define  EEPROG     _IO8(0xf3)      /* eeprog */
#define  FEELCK     _IO8(0xf4)      /* feelck */
#define  FEEMCR     _IO8(0xf5)      /* feemcr */
#define  FEETST     _IO8(0xf6)      /* feetst */
#define  FEECTL     _IO8(0xf7)      /* feectl */
#define  BCR1       _IO8(0xf8)      /* bcr1 */
#define  BSVR       _IO8(0xf9)      /* bsvr */
#define  BCR2       _IO8(0xfa)      /* bcr2 */
#define  BDR        _IO8(0xfb)      /* bdr */
#define  BARD       _IO8(0xfc)      /* bard */
#define  DLSCR      _IO8(0xfd)      /* dlcsr */
#define  PORTDLC    _IO8(0xfe)      /* portdlc */
#define  DDRDLC     _IO8(0xff)      /* ddrdlc */

#endif


